/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import processing.app.Base;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.mode.java.Compiler;
import processing.mode.java.preproc.PdePreprocessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBuild {
    public static final String SIZE_REGEX = "(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+),?\\s*([^\\)]*)\\s*\\)\\s*\\;";
    public static final String PACKAGE_REGEX = "(?:^|\\s|;)package\\s+(\\S+)\\;";
    protected Sketch sketch;
    protected Mode mode;
    protected File srcFolder;
    protected File binFolder;
    private boolean foundMain = false;
    private String classPath;
    protected String sketchClassName;
    private String javaLibraryPath;
    private ArrayList<Library> importedLibraries;

    public JavaBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public String build() throws SketchException {
        return this.build(this.sketch.makeTempFolder(), this.sketch.makeTempFolder());
    }

    public String build(File srcFolder, File binFolder) throws SketchException {
        this.srcFolder = srcFolder;
        this.binFolder = binFolder;
        String classNameFound = this.preprocess(srcFolder);
        if (Compiler.compile(this)) {
            this.sketchClassName = classNameFound;
            return classNameFound;
        }
        return null;
    }

    public String getSketchClassName() {
        return this.sketchClassName;
    }

    public String preprocess(File srcFolder) throws SketchException {
        return this.preprocess(srcFolder, null, new PdePreprocessor(this.sketch.getName()));
    }

    /*
     * Unable to fully structure code
     */
    public String preprocess(File srcFolder, String packageName, PdePreprocessor preprocessor) throws SketchException {
        block35: {
            block36: {
                this.sketch.ensureExistence();
                this.classPath = this.binFolder.getAbsolutePath();
                codeFolderPackages = null;
                if (this.sketch.hasCodeFolder()) {
                    codeFolder = this.sketch.getCodeFolder();
                    this.javaLibraryPath = codeFolder.getAbsolutePath();
                    codeFolderClassPath = Base.contentsToClassPath(codeFolder);
                    this.classPath = String.valueOf(this.classPath) + File.pathSeparator + codeFolderClassPath;
                    codeFolderPackages = Base.packageListFromClassPath(codeFolderClassPath);
                } else {
                    this.javaLibraryPath = "";
                }
                bigCode = new StringBuffer();
                bigCount = 0;
                var10_8 = this.sketch.getCode();
                var9_12 = var10_8.length;
                var8_16 = 0;
                while (var8_16 < var9_12) {
                    sc = var10_8[var8_16];
                    if (sc.isExtension("pde")) {
                        sc.setPreprocOffset(bigCount);
                        bigCode.append(sc.getProgram());
                        bigCode.append('\n');
                        bigCount += sc.getLineCount();
                    }
                    ++var8_16;
                }
                try {
                    outputFolder = packageName == null ? srcFolder : new File(srcFolder, packageName.replace('.', '/'));
                    outputFolder.mkdirs();
                    java = new File(outputFolder, String.valueOf(this.sketch.getName()) + ".java");
                    stream = new PrintWriter(new FileWriter(java));
                    try {
                        result = preprocessor.write(stream, bigCode.toString(), codeFolderPackages);
                        break block35;
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                    msg = "Build folder disappeared or could not be written";
                    throw new SketchException(msg);
                }
                catch (RecognitionException re) {
                    errorLine = re.getLine() - 1;
                    errorFile = this.findErrorFile(errorLine);
                    errorLine -= this.sketch.getCode(errorFile).getPreprocOffset();
                    msg = re.getMessage();
                    if (msg.equals("expecting RCURLY, found 'null'")) {
                        throw new SketchException("Found one too many { characters without a } to match it.", errorFile, errorLine, re.getColumn());
                    }
                    if (msg.indexOf("expecting RBRACK") != -1) {
                        System.err.println(msg);
                        throw new SketchException("Syntax error, maybe a missing ] character?", errorFile, errorLine, re.getColumn());
                    }
                    if (msg.indexOf("expecting SEMI") != -1) {
                        System.err.println(msg);
                        throw new SketchException("Syntax error, maybe a missing semicolon?", errorFile, errorLine, re.getColumn());
                    }
                    if (msg.indexOf("expecting RPAREN") != -1) {
                        System.err.println(msg);
                        throw new SketchException("Syntax error, maybe a missing right parenthesis?", errorFile, errorLine, re.getColumn());
                    }
                    if (msg.indexOf("preproc.web_colors") != -1) {
                        throw new SketchException("A web color (such as #ffcc00) must be six digits.", errorFile, errorLine, re.getColumn(), false);
                    }
                    throw new SketchException(msg, errorFile, errorLine, re.getColumn());
                }
                catch (TokenStreamRecognitionException tsre) {
                    mess = "^line (\\d+):(\\d+):\\s";
                    matches = PApplet.match((String)tsre.toString(), (String)mess);
                    if (matches == null) break block36;
                    errorLine = Integer.parseInt(matches[1]) - 1;
                    errorColumn = Integer.parseInt(matches[2]);
                    errorFile = 0;
                    i = 1;
                    ** while (i < this.sketch.getCodeCount())
                }
lbl-1000:
                // 1 sources

                {
                    sc = this.sketch.getCode(i);
                    if (sc.isExtension("pde") && sc.getPreprocOffset() < errorLine) {
                        errorFile = i;
                    }
                    ++i;
                    continue;
                }
lbl77:
                // 1 sources

                throw new SketchException(tsre.getMessage(), errorFile, errorLine -= this.sketch.getCode(errorFile).getPreprocOffset(), errorColumn);
            }
            msg = tsre.toString();
            throw new SketchException(msg, 0, -1, -1);
            catch (SketchException pe) {
                throw pe;
            }
            catch (Exception ex) {
                System.err.println("Uncaught exception type:" + ex.getClass());
                ex.printStackTrace();
                throw new SketchException(ex.toString());
            }
        }
        this.importedLibraries = new ArrayList<E>();
        for (String item : result.extraImports) {
            dot = item.lastIndexOf(46);
            entry = dot == -1 ? item : item.substring(0, dot);
            library = this.mode.getLibrary(entry);
            if (library != null) {
                if (this.importedLibraries.contains(library)) continue;
                this.importedLibraries.add(library);
                this.classPath = String.valueOf(this.classPath) + library.getClassPath();
                this.javaLibraryPath = String.valueOf(this.javaLibraryPath) + File.pathSeparator + library.getNativePath();
                continue;
            }
            found = false;
            if (codeFolderPackages != null) {
                itemPkg = item.substring(0, item.lastIndexOf(46));
                var18_44 = codeFolderPackages;
                var17_43 = codeFolderPackages.length;
                var16_40 = 0;
                while (var16_40 < var17_43) {
                    pkg = var18_44[var16_40];
                    if (pkg.equals(itemPkg)) {
                        found = true;
                        break;
                    }
                    ++var16_40;
                }
            }
            if (this.ignorableImport(item)) {
                found = true;
            }
            if (found) continue;
            System.err.println("No library found for " + entry);
        }
        javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath.startsWith("\"") && javaClassPath.endsWith("\"")) {
            javaClassPath = javaClassPath.substring(1, javaClassPath.length() - 1);
        }
        this.classPath = String.valueOf(this.classPath) + File.pathSeparator + javaClassPath;
        var12_31 = this.sketch.getCode();
        var11_29 = var12_31.length;
        var10_11 = 0;
        while (var10_11 < var11_29) {
            sc = var12_31[var10_11];
            if (sc.isExtension("java")) {
                filename = sc.getFileName();
                try {
                    javaCode = sc.getProgram();
                    packageMatch = PApplet.match((String)javaCode, (String)"(?:^|\\s|;)package\\s+(\\S+)\\;");
                    if (packageMatch == null && packageName == null) {
                        sc.copyTo(new File(srcFolder, filename));
                    }
                    if (packageMatch == null) {
                        packageMatch = new String[]{packageName};
                        javaCode = "package " + packageName + ";" + javaCode;
                    }
                    packageFolder = new File(srcFolder, packageMatch[0].replace('.', '/'));
                    packageFolder.mkdirs();
                    Base.saveFile(javaCode, new File(packageFolder, filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    msg = "Problem moving " + filename + " to the build folder";
                    throw new SketchException(msg);
                }
            } else if (sc.isExtension("pde")) {
                sc.addPreprocOffset(result.headerOffset);
            }
            ++var10_11;
        }
        this.foundMain = preprocessor.getFoundMain();
        return result.className;
    }

    protected boolean ignorableImport(String pkg) {
        if (pkg.startsWith("java.")) {
            return true;
        }
        return pkg.startsWith("javax.");
    }

    protected int findErrorFile(int errorLine) {
        int i = 1;
        while (i < this.sketch.getCodeCount()) {
            SketchCode sc = this.sketch.getCode(i);
            if (sc.isExtension("pde") && sc.getPreprocOffset() < errorLine) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public String getSketchPath() {
        return this.sketch.getFolder().getAbsolutePath();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getJavaLibraryPath() {
        return this.javaLibraryPath;
    }

    public boolean getFoundMain() {
        return this.foundMain;
    }

    public ArrayList<Library> getImportedLibraries() {
        return this.importedLibraries;
    }

    public SketchException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        SketchCode code;
        int codeIndex = 0;
        int codeLine = -1;
        int i = 0;
        while (i < this.sketch.getCodeCount()) {
            code = this.sketch.getCode(i);
            if (code.isExtension("java") && dotJavaFilename.equals(code.getFileName())) {
                codeIndex = i;
                codeLine = dotJavaLine;
                return new SketchException(message, codeIndex, codeLine);
            }
            ++i;
        }
        if (!dotJavaFilename.equals(String.valueOf(this.sketch.getName()) + ".java")) {
            return null;
        }
        codeIndex = 0;
        i = 0;
        while (i < this.sketch.getCodeCount()) {
            code = this.sketch.getCode(i);
            if (code.isExtension("pde") && code.getPreprocOffset() <= dotJavaLine) {
                codeIndex = i;
                codeLine = dotJavaLine - code.getPreprocOffset();
            }
            ++i;
        }
        return new SketchException(message, codeIndex, codeLine, -1, false);
    }

    protected boolean exportApplet() throws SketchException, IOException {
        return this.exportApplet(new File(this.sketch.getFolder(), "applet"));
    }

    public boolean exportApplet(File appletFolder) throws SketchException, IOException {
        File bagelJar;
        File exportFile;
        int n;
        int n2;
        File[] fileArray;
        SketchCode code;
        int n3;
        this.mode.prepareExportFolder(appletFolder);
        this.srcFolder = this.sketch.makeTempFolder();
        this.binFolder = this.sketch.makeTempFolder();
        String foundName = this.build(this.srcFolder, this.binFolder);
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getName().equals(foundName)) {
            Base.showWarning("Error during export", "Sketch name is " + this.sketch.getName() + " but the\n" + "name found in the code was " + foundName + ".", null);
            return false;
        }
        int wide = 100;
        int high = 100;
        String renderer = "";
        String scrubbed = JavaBuild.scrubComments(this.sketch.getCode(0).getProgram());
        String[] matches = PApplet.match((String)scrubbed, (String)SIZE_REGEX);
        if (matches != null) {
            try {
                wide = Integer.parseInt(matches[1]);
                high = Integer.parseInt(matches[2]);
                if (matches.length == 4) {
                    renderer = matches[3].trim();
                }
            }
            catch (NumberFormatException e) {
                String message = "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.";
                Base.showWarning("Could not find applet size", "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.", null);
            }
        }
        String description = "";
        String[] javadoc = PApplet.match((String)this.sketch.getCode(0).getProgram(), (String)"/\\*{2,}(.*)\\*+/");
        if (javadoc != null) {
            String[] pieces;
            StringBuffer dbuffer = new StringBuffer();
            String[] stringArray = pieces = PApplet.split((String)javadoc[1], (char)'\n');
            int n4 = pieces.length;
            n3 = 0;
            while (n3 < n4) {
                String line = stringArray[n3];
                String[] m = PApplet.match((String)line, (String)"^\\s*\\*+(.*)");
                dbuffer.append(m != null ? m[1] : line);
                dbuffer.append('\n');
                ++n3;
            }
            description = dbuffer.toString();
        }
        StringBuffer sources = new StringBuffer();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        n3 = sketchCodeArray.length;
        int line = 0;
        while (line < n3) {
            code = sketchCodeArray[line];
            sources.append("<a href=\"" + code.getFileName() + "\">" + code.getPrettyName() + "</a> ");
            ++line;
        }
        sketchCodeArray = this.sketch.getCode();
        n3 = sketchCodeArray.length;
        line = 0;
        while (line < n3) {
            code = sketchCodeArray[line];
            try {
                File exportedSource = new File(appletFolder, code.getFileName());
                code.copyTo(exportedSource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++line;
        }
        String preprocFilename = String.valueOf(this.sketch.getName()) + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            preprocFile.renameTo(new File(appletFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        boolean separateJar = Preferences.getBoolean("export.applet.separate_jar_files") || this.sketch.hasCodeFolder() || this.javaLibraryPath.length() != 0;
        String LOADING_IMAGE = "loading.gif";
        File loadingImage = new File(this.sketch.getFolder(), LOADING_IMAGE);
        if (!loadingImage.exists()) {
            File skeletonFolder = this.mode.getContentFile("applet");
            loadingImage = new File(skeletonFolder, LOADING_IMAGE);
        }
        Base.copyFile(loadingImage, new File(appletFolder, LOADING_IMAGE));
        FileOutputStream zipOutputFile = new FileOutputStream(new File(appletFolder, String.valueOf(this.sketch.getName()) + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        StringBuffer archives = new StringBuffer();
        archives.append(String.valueOf(this.sketch.getName()) + ".jar");
        this.addManifest(zos);
        boolean openglApplet = false;
        HashMap<String, Object> zipFileContents = new HashMap<String, Object>();
        for (Library library : this.importedLibraries) {
            if (library.getName().equals("OpenGL")) {
                openglApplet = true;
            }
            fileArray = library.getAppletExports();
            n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                exportFile = fileArray[n];
                String exportName = exportFile.getName();
                if (!exportFile.exists()) {
                    System.err.println("File " + exportFile.getAbsolutePath() + " does not exist");
                } else if (exportFile.isDirectory()) {
                    System.out.println("Ignoring sub-folder \"" + exportFile.getAbsolutePath() + "\"");
                } else if (exportName.toLowerCase().endsWith(".zip") || exportName.toLowerCase().endsWith(".jar")) {
                    if (separateJar) {
                        Base.copyFile(exportFile, new File(appletFolder, exportName));
                        archives.append("," + exportName);
                    } else {
                        String path = exportFile.getAbsolutePath();
                        this.packClassPathIntoZipFile(path, zos, zipFileContents);
                    }
                } else {
                    Base.copyFile(exportFile, new File(appletFolder, exportName));
                }
                ++n;
            }
        }
        File file = bagelJar = Base.isMacOS() ? Base.getContentFile("core.jar") : Base.getContentFile("lib/core.jar");
        if (separateJar) {
            Base.copyFile(bagelJar, new File(appletFolder, "core.jar"));
            archives.append(",core.jar");
        } else {
            String bagelJarPath = bagelJar.getAbsolutePath();
            this.packClassPathIntoZipFile(bagelJarPath, zos, zipFileContents);
        }
        if (this.sketch.hasCodeFolder()) {
            File[] codeJarFiles = this.sketch.getCodeFolder().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.charAt(0) == '.') {
                        return false;
                    }
                    if (name.toLowerCase().endsWith(".jar")) {
                        return true;
                    }
                    return name.toLowerCase().endsWith(".zip");
                }
            });
            fileArray = codeJarFiles;
            n2 = codeJarFiles.length;
            n = 0;
            while (n < n2) {
                exportFile = fileArray[n];
                String name = exportFile.getName();
                Base.copyFile(exportFile, new File(appletFolder, name));
                archives.append("," + name);
                ++n;
            }
        }
        this.addDataFolder(zos);
        this.addClasses(zos, this.binFolder);
        zos.flush();
        zos.close();
        File htmlOutputFile = new File(appletFolder, "index.html");
        PrintWriter htmlWriter = PApplet.createWriter((File)htmlOutputFile);
        InputStream is = null;
        File customHtml = new File(this.sketch.getFolder(), "applet.html");
        if (customHtml.exists()) {
            is = new FileInputStream(customHtml);
        }
        if (renderer.equals("OPENGL")) {
            openglApplet = true;
        }
        if (is == null) {
            is = openglApplet ? this.mode.getContentStream("applet/template-opengl.html") : this.mode.getContentStream("applet/template.html");
        }
        BufferedReader reader = PApplet.createReader((InputStream)is);
        String line2 = null;
        while ((line2 = reader.readLine()) != null) {
            if (line2.indexOf("@@") != -1) {
                StringBuffer sb = new StringBuffer(line2);
                int index = 0;
                while ((index = sb.indexOf("@@sketch@@")) != -1) {
                    sb.replace(index, index + "@@sketch@@".length(), this.sketch.getName());
                }
                while ((index = sb.indexOf("@@source@@")) != -1) {
                    sb.replace(index, index + "@@source@@".length(), sources.toString());
                }
                while ((index = sb.indexOf("@@archive@@")) != -1) {
                    sb.replace(index, index + "@@archive@@".length(), archives.toString());
                }
                while ((index = sb.indexOf("@@width@@")) != -1) {
                    sb.replace(index, index + "@@width@@".length(), String.valueOf(wide));
                }
                while ((index = sb.indexOf("@@height@@")) != -1) {
                    sb.replace(index, index + "@@height@@".length(), String.valueOf(high));
                }
                while ((index = sb.indexOf("@@description@@")) != -1) {
                    sb.replace(index, index + "@@description@@".length(), description);
                }
                line2 = sb.toString();
            }
            htmlWriter.println(line2);
        }
        reader.close();
        htmlWriter.flush();
        htmlWriter.close();
        return true;
    }

    public static String scrubComments(String what) {
        char[] p = what.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    p[index++] = 32;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            ++index;
        }
        return new String(p);
    }

    protected boolean exportApplication() throws IOException, SketchException {
        String foundName = this.build();
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getName().equals(foundName)) {
            Base.showWarning("Error during export", "Sketch name is " + this.sketch.getName() + " but the sketch\n" + "name in the code was " + foundName, null);
            return false;
        }
        File folder = null;
        String[] stringArray = PConstants.platformNames;
        int n = PConstants.platformNames.length;
        int n2 = 0;
        while (n2 < n) {
            String platformName = stringArray[n2];
            int platform = Base.getPlatformIndex(platformName);
            if (Preferences.getBoolean("export.application.platform." + platformName)) {
                if (Library.hasMultipleArch(platform, this.importedLibraries)) {
                    folder = new File(this.sketch.getFolder(), "application." + platformName + "32");
                    if (!this.exportApplication(folder, platform, 32)) {
                        return false;
                    }
                    folder = new File(this.sketch.getFolder(), "application." + platformName + "64");
                    if (!this.exportApplication(folder, platform, 64)) {
                        return false;
                    }
                } else {
                    folder = new File(this.sketch.getFolder(), "application." + platformName);
                    if (!this.exportApplication(folder, platform, 0)) {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean exportApplication(File destFolder, int exportPlatform, int exportBits) throws IOException, SketchException {
        PrintWriter pw;
        int i;
        this.mode.prepareExportFolder(destFolder);
        File jarFolder = new File(destFolder, "lib");
        File dotAppFolder = null;
        if (exportPlatform == 2) {
            dotAppFolder = new File(destFolder, String.valueOf(this.sketch.getName()) + ".app");
            File dotAppSkeleton = this.mode.getContentFile("application/template.app");
            Base.copyDir(dotAppSkeleton, dotAppFolder);
            String stubName = "Contents/MacOS/JavaApplicationStub";
            if (Base.isWindows()) {
                File warningFile = new File(destFolder, "readme.txt");
                PrintWriter pw2 = PApplet.createWriter((File)warningFile);
                pw2.println("This application was created on Windows, which does not");
                pw2.println("properly support setting files as \"executable\",");
                pw2.println("a necessity for applications on Mac OS X.");
                pw2.println();
                pw2.println("To fix this, use the Terminal on Mac OS X, and from this");
                pw2.println("directory, type the following:");
                pw2.println();
                pw2.println("chmod +x " + dotAppFolder.getName() + "/" + stubName);
                pw2.flush();
                pw2.close();
            } else {
                File stubFile = new File(dotAppFolder, stubName);
                String stubPath = stubFile.getAbsolutePath();
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", stubPath});
            }
            jarFolder = new File(dotAppFolder, "Contents/Resources/Java");
        }
        if (!jarFolder.exists()) {
            jarFolder.mkdirs();
        }
        if (exportPlatform == 1) {
            Base.copyFile(this.mode.getContentFile("application/template.exe"), new File(destFolder, String.valueOf(this.sketch.getName()) + ".exe"));
        }
        Vector<String> jarListVector = new Vector<String>();
        HashMap<String, Object> zipFileContents = new HashMap<String, Object>();
        FileOutputStream zipOutputFile = new FileOutputStream(new File(jarFolder, String.valueOf(this.sketch.getName()) + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        this.addManifest(zos);
        this.addClasses(zos, this.binFolder);
        this.addDataFolder(zos);
        if (this.sketch.hasCodeFolder()) {
            String includes = Base.contentsToClassPath(this.sketch.getCodeFolder());
            String[] codeList = PApplet.splitTokens((String)includes, (String)File.pathSeparator);
            Object cp = "";
            int i2 = 0;
            while (i2 < codeList.length) {
                if (codeList[i2].toLowerCase().endsWith(".jar") || codeList[i2].toLowerCase().endsWith(".zip")) {
                    File exportFile = new File(codeList[i2]);
                    String exportFilename = exportFile.getName();
                    Base.copyFile(exportFile, new File(jarFolder, exportFilename));
                    jarListVector.add(exportFilename);
                } else {
                    cp = String.valueOf(cp) + codeList[i2] + File.pathSeparator;
                }
                ++i2;
            }
            this.packClassPathIntoZipFile((String)cp, zos, zipFileContents);
        }
        zos.flush();
        zos.close();
        jarListVector.add(String.valueOf(this.sketch.getName()) + ".jar");
        File bagelJar = Base.isMacOS() ? Base.getContentFile("core.jar") : Base.getContentFile("lib/core.jar");
        Base.copyFile(bagelJar, new File(jarFolder, "core.jar"));
        jarListVector.add("core.jar");
        for (Library library : this.importedLibraries) {
            File[] fileArray = library.getApplicationExports(exportPlatform, exportBits);
            int exportFilename = fileArray.length;
            int exportFile = 0;
            while (exportFile < exportFilename) {
                File exportFile2 = fileArray[exportFile];
                String exportName = exportFile2.getName();
                if (!exportFile2.exists()) {
                    System.err.println("File " + exportFile2.getName() + " does not exist");
                } else if (exportFile2.isDirectory()) {
                    if (exportPlatform == 2) {
                        Base.copyDir(exportFile2, new File(jarFolder, exportName));
                    } else {
                        Base.copyDir(exportFile2, new File(destFolder, exportName));
                    }
                } else if (exportFile2.getName().toLowerCase().endsWith(".zip") || exportFile2.getName().toLowerCase().endsWith(".jar")) {
                    Base.copyFile(exportFile2, new File(jarFolder, exportName));
                    jarListVector.add(exportName);
                } else if (exportPlatform == 2 && exportFile2.getName().toLowerCase().endsWith(".jnilib")) {
                    Base.copyFile(exportFile2, new File(jarFolder, exportName));
                } else {
                    Base.copyFile(exportFile2, new File(destFolder, exportName));
                }
                ++exportFile;
            }
        }
        Object[] jarList = new String[jarListVector.size()];
        jarListVector.copyInto(jarList);
        StringBuffer exportClassPath = new StringBuffer();
        if (exportPlatform == 2) {
            i = 0;
            while (i < jarList.length) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$JAVAROOT/" + (String)jarList[i]);
                ++i;
            }
        } else if (exportPlatform == 1) {
            i = 0;
            while (i < jarList.length) {
                if (i != 0) {
                    exportClassPath.append(",");
                }
                exportClassPath.append((String)jarList[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < jarList.length) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$APPDIR/lib/" + (String)jarList[i]);
                ++i;
            }
        }
        String runOptions = Preferences.get("run.options");
        if (Preferences.getBoolean("run.options.memory")) {
            runOptions = String.valueOf(runOptions) + " -Xms" + Preferences.get("run.options.memory.initial") + "m";
            runOptions = String.valueOf(runOptions) + " -Xmx" + Preferences.get("run.options.memory.maximum") + "m";
        }
        if (exportPlatform == 2) {
            String PLIST_TEMPLATE = "template.plist";
            File plistTemplate = new File(this.sketch.getFolder(), PLIST_TEMPLATE);
            if (!plistTemplate.exists()) {
                plistTemplate = this.mode.getContentFile("application/template.plist");
            }
            File plistFile = new File(dotAppFolder, "Contents/Info.plist");
            PrintWriter pw3 = PApplet.createWriter((File)plistFile);
            String[] lines = PApplet.loadStrings((File)plistTemplate);
            int i3 = 0;
            while (i3 < lines.length) {
                if (lines[i3].indexOf("@@") != -1) {
                    StringBuffer sb = new StringBuffer(lines[i3]);
                    int index = 0;
                    while ((index = sb.indexOf("@@vmoptions@@")) != -1) {
                        sb.replace(index, index + "@@vmoptions@@".length(), runOptions);
                    }
                    while ((index = sb.indexOf("@@sketch@@")) != -1) {
                        sb.replace(index, index + "@@sketch@@".length(), this.sketch.getName());
                    }
                    while ((index = sb.indexOf("@@classpath@@")) != -1) {
                        sb.replace(index, index + "@@classpath@@".length(), exportClassPath.toString());
                    }
                    while ((index = sb.indexOf("@@lsuipresentationmode@@")) != -1) {
                        sb.replace(index, index + "@@lsuipresentationmode@@".length(), Preferences.getBoolean("export.application.fullscreen") ? "4" : "0");
                    }
                    lines[i3] = sb.toString();
                }
                pw3.print(String.valueOf(lines[i3]) + "\n");
                ++i3;
            }
            pw3.flush();
            pw3.close();
        } else if (exportPlatform == 1) {
            File argsFile = new File(destFolder + "/lib/args.txt");
            pw = PApplet.createWriter((File)argsFile);
            pw.println(runOptions);
            pw.println(this.sketch.getName());
            pw.println(exportClassPath);
            pw.flush();
            pw.close();
        } else {
            File shellScript = new File(destFolder, this.sketch.getName());
            pw = PApplet.createWriter((File)shellScript);
            pw.print("#!/bin/sh\n\n");
            pw.print("APPDIR=$(dirname \"$0\")\n");
            pw.print("java " + Preferences.get("run.options") + " -Djava.library.path=\"$APPDIR\"" + " -cp \"" + exportClassPath + "\"" + " " + this.sketch.getName() + "\n");
            pw.flush();
            pw.close();
            String shellPath = shellScript.getAbsolutePath();
            if (!Base.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", shellPath});
            }
        }
        File sourceFolder = new File(destFolder, "source");
        sourceFolder.mkdirs();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int shellPath = 0;
        while (shellPath < n) {
            SketchCode code = sketchCodeArray[shellPath];
            try {
                code.copyTo(new File(sourceFolder, code.getFileName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++shellPath;
        }
        String preprocFilename = String.valueOf(this.sketch.getName()) + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            preprocFile.renameTo(new File(sourceFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        return true;
    }

    protected void addManifest(ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zos.putNextEntry(entry);
        String contents = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.VERSION_NAME + "\n" + "Main-Class: " + this.sketch.getName() + "\n";
        zos.write(contents.getBytes());
        zos.closeEntry();
    }

    protected void addClasses(ZipOutputStream zos, File dir) throws IOException {
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = String.valueOf(path) + '/';
        }
        this.addClasses(zos, dir, path);
    }

    protected void addClasses(ZipOutputStream zos, File dir, String rootPath) throws IOException {
        File[] files;
        File[] fileArray = files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.charAt(0) != '.';
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File sub = fileArray[n2];
            String relativePath = sub.getAbsolutePath().substring(rootPath.length());
            if (sub.isDirectory()) {
                this.addClasses(zos, sub, rootPath);
            } else if (sub.getName().endsWith(".class")) {
                ZipEntry entry = new ZipEntry(relativePath);
                zos.putNextEntry(entry);
                zos.write(Base.loadBytesRaw(sub));
                zos.closeEntry();
            }
            ++n2;
        }
    }

    protected void addDataFolder(ZipOutputStream zos) throws IOException {
        if (this.sketch.hasDataFolder()) {
            String[] dataFiles = Base.listFiles(this.sketch.getDataFolder(), false);
            int offset = this.sketch.getFolder().getAbsolutePath().length() + 1;
            String[] stringArray = dataFiles;
            int n = dataFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dataFile;
                String path = stringArray[n2];
                if (Base.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if (!(dataFile = new File(path)).isDirectory() && dataFile.getName().charAt(0) != '.') {
                    ZipEntry entry = new ZipEntry(path.substring(offset));
                    zos.putNextEntry(entry);
                    zos.write(Base.loadBytesRaw(dataFile));
                    zos.closeEntry();
                }
                ++n2;
            }
        }
    }

    protected void packClassPathIntoZipFile(String path, ZipOutputStream zos, HashMap<String, Object> zipFileContents) throws IOException {
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        int i = 0;
        while (i < pieces.length) {
            if (pieces[i].length() != 0) {
                if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                    try {
                        ZipFile file = new ZipFile(pieces[i]);
                        Enumeration<? extends ZipEntry> entries = file.entries();
                        while (entries.hasMoreElements()) {
                            String entryName;
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory() || (entryName = entry.getName()).indexOf("META-INF") == 0 || zipFileContents.get(entryName) != null) continue;
                            zipFileContents.put(entryName, new Object());
                            ZipEntry entree = new ZipEntry(entryName);
                            zos.putNextEntry(entree);
                            byte[] buffer = new byte[(int)entry.getSize()];
                            InputStream is = file.getInputStream(entry);
                            int offset = 0;
                            int remaining = buffer.length;
                            while (remaining > 0) {
                                int count = is.read(buffer, offset, remaining);
                                offset += count;
                                remaining -= count;
                            }
                            zos.write(buffer);
                            zos.flush();
                            zos.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Error in file " + pieces[i]);
                        e.printStackTrace();
                    }
                } else {
                    File dir = new File(pieces[i]);
                    if (dir.exists()) {
                        JavaBuild.packClassPathIntoZipFileRecursive(dir, null, zos);
                    }
                }
            }
            ++i;
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].charAt(0) != '.') {
                String nowfar;
                File sub = new File(dir, files[i]);
                String string = nowfar = sofar == null ? files[i] : String.valueOf(sofar) + "/" + files[i];
                if (sub.isDirectory()) {
                    JavaBuild.packClassPathIntoZipFileRecursive(sub, nowfar, zos);
                } else if (!files[i].toLowerCase().endsWith(".jar") && !files[i].toLowerCase().endsWith(".zip") && files[i].charAt(0) != '.') {
                    ZipEntry entry = new ZipEntry(nowfar);
                    zos.putNextEntry(entry);
                    zos.write(Base.loadBytesRaw(sub));
                    zos.closeEntry();
                }
            }
            ++i;
        }
    }
}

