/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorToolbar;
import processing.app.Formatter;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.mode.java.AutoFormat;
import processing.mode.java.JavaMode;
import processing.mode.java.JavaToolbar;
import processing.mode.java.PdeKeyListener;
import processing.mode.java.runner.Runner;

public class JavaEditor
extends Editor {
    JavaMode jmode;
    PdeKeyListener listener;
    private Runner runtime;

    protected JavaEditor(Base base, String path, int[] location, Mode mode) {
        super(base, path, location, mode);
        this.listener = new PdeKeyListener(this, this.textarea);
        this.jmode = (JavaMode)mode;
    }

    public EditorToolbar createToolbar() {
        return new JavaToolbar(this, this.base);
    }

    public Formatter createFormatter() {
        return new AutoFormat();
    }

    public JMenu buildFileMenu() {
        String appletTitle = JavaToolbar.getTitle(5, false);
        JMenuItem exportApplet = Base.newJMenuItem(appletTitle, 69);
        exportApplet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleExportApplet();
            }
        });
        String appTitle = JavaToolbar.getTitle(5, true);
        JMenuItem exportApplication = Base.newJMenuItemShift(appTitle, 69);
        exportApplication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleExportApplication();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportApplet, exportApplication});
    }

    public JMenu buildSketchMenu() {
        JMenuItem runItem = Base.newJMenuItem(JavaToolbar.getTitle(0, false), 82);
        runItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleRun();
            }
        });
        JMenuItem presentItem = Base.newJMenuItemShift(JavaToolbar.getTitle(0, true), 82);
        presentItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handlePresent();
            }
        });
        JMenuItem stopItem = new JMenuItem(JavaToolbar.getTitle(1, false));
        stopItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.handleStop();
            }
        });
        return this.buildSketchMenu(new JMenuItem[]{runItem, presentItem, stopItem});
    }

    public JMenu buildHelpMenu() {
        JMenuItem item;
        JMenu menu = new JMenu("Help ");
        if (!Base.isMacOS()) {
            menu.addSeparator();
            item = new JMenuItem("About Processing");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaEditor.this.base.handleAbout();
                }
            });
            menu.add(item);
        }
        item = new JMenuItem("Environment");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.showReference("environment" + File.separator + "index.html");
            }
        });
        menu.add(item);
        item = new JMenuItem("Reference");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaEditor.this.showReference("index.html");
            }
        });
        menu.add(item);
        item = Base.newJMenuItemShift("Find in Reference", 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JavaEditor.this.textarea.isSelectionActive()) {
                    JavaEditor.this.handleFindReference();
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Online");
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem("Getting Started");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processing.org/learning/gettingstarted/");
            }
        });
        menu.add(item);
        item = new JMenuItem("Troubleshooting");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://wiki.processing.org/w/Troubleshooting");
            }
        });
        menu.add(item);
        item = new JMenuItem("Frequently Asked Questions");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://wiki.processing.org/w/FAQ");
            }
        });
        menu.add(item);
        item = new JMenuItem("Visit Processing.org");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processing.org/");
            }
        });
        menu.add(item);
        return menu;
    }

    public String getCommentPrefix() {
        return "//";
    }

    public void handleExportApplet() {
        if (this.handleExportCheckModified()) {
            this.toolbar.activate(5);
            try {
                boolean success = this.jmode.handleExportApplet(this.sketch);
                if (success) {
                    File appletFolder = new File(this.sketch.getFolder(), "applet");
                    Base.openFolder(appletFolder);
                    this.statusNotice("Done exporting.");
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
            this.toolbar.deactivate(5);
        }
    }

    public void handleExportApplication() {
        this.toolbar.activate(5);
        if (this.handleExportCheckModified()) {
            this.statusNotice("Exporting application...");
            try {
                if (this.exportApplicationPrompt()) {
                    Base.openFolder(this.sketch.getFolder());
                    this.statusNotice("Done exporting.");
                }
            }
            catch (Exception e) {
                this.statusNotice("Error during export.");
                e.printStackTrace();
            }
        }
        this.toolbar.deactivate(5);
    }

    protected boolean exportApplicationPrompt() throws IOException, SketchException {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(6));
        String line1 = "Export to Application creates double-clickable,";
        String line2 = "standalone applications for the selected plaforms.";
        JLabel label1 = new JLabel(line1, 0);
        JLabel label2 = new JLabel(line2, 0);
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        panel.add(label1);
        panel.add(label2);
        int wide = label2.getPreferredSize().width;
        panel.add(Box.createVerticalStrut(12));
        final JCheckBox windowsButton = new JCheckBox("Windows");
        windowsButton.setSelected(Preferences.getBoolean("export.application.platform.windows"));
        windowsButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.platform.windows", windowsButton.isSelected());
            }
        });
        final JCheckBox macosxButton = new JCheckBox("Mac OS X");
        macosxButton.setSelected(Preferences.getBoolean("export.application.platform.macosx"));
        macosxButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.platform.macosx", macosxButton.isSelected());
            }
        });
        final JCheckBox linuxButton = new JCheckBox("Linux");
        linuxButton.setSelected(Preferences.getBoolean("export.application.platform.linux"));
        linuxButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.platform.linux", linuxButton.isSelected());
            }
        });
        JPanel platformPanel = new JPanel();
        platformPanel.add(windowsButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(macosxButton);
        platformPanel.add(Box.createHorizontalStrut(6));
        platformPanel.add(linuxButton);
        platformPanel.setBorder(new TitledBorder("Platforms"));
        wide = Math.max(wide, platformPanel.getPreferredSize().width);
        platformPanel.setAlignmentX(0.0f);
        panel.add(platformPanel);
        final JCheckBox showStopButton = new JCheckBox("Show a Stop button");
        showStopButton.setSelected(Preferences.getBoolean("export.application.stop"));
        showStopButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Preferences.setBoolean("export.application.stop", showStopButton.isSelected());
            }
        });
        showStopButton.setEnabled(Preferences.getBoolean("export.application.fullscreen"));
        showStopButton.setBorder(new EmptyBorder(3, 13, 6, 13));
        final JCheckBox fullScreenButton = new JCheckBox("Full Screen (Present mode)");
        fullScreenButton.setSelected(Preferences.getBoolean("export.application.fullscreen"));
        fullScreenButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean sal = fullScreenButton.isSelected();
                Preferences.setBoolean("export.application.fullscreen", sal);
                showStopButton.setEnabled(sal);
            }
        });
        fullScreenButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        optionPanel.add(fullScreenButton);
        optionPanel.add(showStopButton);
        optionPanel.setBorder(new TitledBorder("Options"));
        wide = Math.max(wide, platformPanel.getPreferredSize().width);
        optionPanel.setAlignmentX(0.0f);
        panel.add(optionPanel);
        Dimension good = new Dimension(wide, label1.getPreferredSize().height);
        label1.setMaximumSize(good);
        good = new Dimension(wide, label2.getPreferredSize().height);
        label2.setMaximumSize(good);
        good = new Dimension(wide, platformPanel.getPreferredSize().height);
        platformPanel.setMaximumSize(good);
        good = new Dimension(wide, optionPanel.getPreferredSize().height);
        optionPanel.setMaximumSize(good);
        Object[] options = new String[]{"Export", "Cancel"};
        final JOptionPane optionPane = new JOptionPane(panel, -1, 0, null, options, options[0]);
        final JDialog dialog = new JDialog(this, "Export Options", true);
        dialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        Rectangle bounds = this.getBounds();
        dialog.setLocation(bounds.x + (bounds.width - dialog.getSize().width) / 2, bounds.y + (bounds.height - dialog.getSize().height) / 2);
        dialog.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(options[0])) {
            return this.jmode.handleExportApplication(this.sketch);
        }
        if (value.equals(options[1]) || value.equals(new Integer(-1))) {
            this.statusNotice("Export to Application canceled.");
        }
        return false;
    }

    protected boolean handleExportCheckModified() {
        if (this.sketch.isModified()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            int result = JOptionPane.showOptionDialog(this, "Save changes before export?", "Save", 2, 3, null, options, options[0]);
            if (result == 0) {
                this.handleSaveRequest(true);
            } else {
                this.statusNotice("Export canceled, changes must first be saved.");
                return false;
            }
        }
        return true;
    }

    public void handleRun() {
        this.toolbar.activate(0);
        new Thread(new Runnable(){

            public void run() {
                JavaEditor.this.prepareRun();
                try {
                    JavaEditor.this.runtime = JavaEditor.this.jmode.handleRun(JavaEditor.this.sketch, JavaEditor.this);
                }
                catch (Exception e) {
                    JavaEditor.this.statusError(e);
                }
            }
        }).start();
    }

    public void handlePresent() {
        this.toolbar.activate(0);
        new Thread(new Runnable(){

            public void run() {
                JavaEditor.this.prepareRun();
                try {
                    JavaEditor.this.runtime = JavaEditor.this.jmode.handlePresent(JavaEditor.this.sketch, JavaEditor.this);
                }
                catch (Exception e) {
                    JavaEditor.this.statusError(e);
                }
            }
        }).start();
    }

    public void handleStop() {
        this.toolbar.activate(1);
        try {
            if (this.runtime != null) {
                this.runtime.close();
                this.runtime = null;
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
        this.toolbar.deactivate(0);
        this.toolbar.deactivate(1);
        this.toFront();
    }

    public void handleSave() {
        this.toolbar.activate(4);
        super.handleSave();
        this.toolbar.deactivate(4);
    }

    public boolean handleSaveAs() {
        this.toolbar.activate(4);
        boolean result = super.handleSaveAs();
        this.toolbar.deactivate(4);
        return result;
    }

    public void handleImportLibrary(String jarPath) {
        this.sketch.ensureExistence();
        if (this.mode.isDefaultExtension(this.sketch.getCurrentCode())) {
            this.sketch.setCurrentCode(0);
        }
        String[] list = Base.packageListFromClassPath(jarPath);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            buffer.append("import ");
            buffer.append(list[i]);
            buffer.append(".*;\n");
            ++i;
        }
        buffer.append('\n');
        buffer.append(this.getText());
        this.setText(buffer.toString());
        this.setSelection(0, 0);
        this.sketch.setModified(true);
    }

    public void statusError(String what) {
        super.statusError(what);
        this.toolbar.deactivate(0);
    }

    public void deactivateRun() {
        this.toolbar.deactivate(0);
    }

    public void deactivateExport() {
        this.toolbar.deactivate(5);
    }

    public void internalCloseRunner() {
        this.handleStop();
    }
}

