/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorToolbar;
import processing.mode.java.JavaEditor;

public class JavaToolbar
extends EditorToolbar {
    protected static final int RUN = 0;
    protected static final int STOP = 1;
    protected static final int NEW = 2;
    protected static final int OPEN = 3;
    protected static final int SAVE = 4;
    protected static final int EXPORT = 5;

    public JavaToolbar(Editor editor, Base base) {
        super(editor, base);
    }

    public void init() {
        Image[][] images = this.loadImages();
        int i = 0;
        while (i < 6) {
            this.addButton(JavaToolbar.getTitle(i, false), JavaToolbar.getTitle(i, true), images[i], i == 2);
            ++i;
        }
    }

    public static String getTitle(int index, boolean shift) {
        switch (index) {
            case 0: {
                return !shift ? "Run" : "Present";
            }
            case 1: {
                return "Stop";
            }
            case 2: {
                return !shift ? "New" : "New Editor Window";
            }
            case 3: {
                return !shift ? "Open" : "Open in Another Window";
            }
            case 4: {
                return "Save";
            }
            case 5: {
                return !shift ? "Export Applet" : "Export Application";
            }
        }
        return null;
    }

    public void handlePressed(MouseEvent e, int sel) {
        boolean shift = e.isShiftDown();
        JavaEditor jeditor = (JavaEditor)this.editor;
        switch (sel) {
            case 0: {
                if (shift) {
                    jeditor.handlePresent();
                    break;
                }
                jeditor.handleRun();
                break;
            }
            case 1: {
                jeditor.handleStop();
                break;
            }
            case 3: {
                JPopupMenu popup = this.editor.getMode().getToolbarMenu().getPopupMenu();
                popup.show(this, e.getX(), e.getY());
                break;
            }
            case 2: {
                if (shift) {
                    this.base.handleNew();
                    break;
                }
                this.base.handleNewReplace();
                break;
            }
            case 4: {
                jeditor.handleSaveRequest(false);
                break;
            }
            case 5: {
                if (shift) {
                    jeditor.handleExportApplication();
                    break;
                }
                jeditor.handleExportApplet();
            }
        }
    }
}

