/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.syntax.JEditTextArea;

public class PdeKeyListener {
    private Editor editor;
    private JEditTextArea textarea;
    static final int CTRL_ALT = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public PdeKeyListener(Editor editor, JEditTextArea textarea) {
        this.editor = editor;
        this.textarea = textarea;
        textarea.editorListener = this;
    }

    public boolean keyPressed(KeyEvent event) {
        if (Preferences.getBoolean("editor.external")) {
            return false;
        }
        char c = event.getKeyChar();
        int code = event.getKeyCode();
        Sketch sketch = this.editor.getSketch();
        if ((event.getModifiers() & CTRL_ALT) == CTRL_ALT) {
            if (code == 37) {
                sketch.handlePrevCode();
                return true;
            }
            if (code == 39) {
                sketch.handleNextCode();
                return true;
            }
        }
        if ((event.getModifiers() & 4) != 0) {
            return false;
        }
        if (code == 8 || code == 9 || code == 10 || c >= ' ' && c < '\u0080') {
            sketch.setModified(true);
        }
        if (code == 38 && (event.getModifiers() & 2) != 0) {
            char[] contents = this.textarea.getText().toCharArray();
            int caretIndex = this.textarea.getCaretPosition();
            int index = this.calcLineStart(caretIndex - 1, contents);
            index -= 2;
            boolean onlySpaces = true;
            while (index > 0) {
                if (contents[index] == '\n') {
                    if (onlySpaces) {
                        ++index;
                        break;
                    }
                    onlySpaces = true;
                } else if (contents[index] != ' ') {
                    onlySpaces = false;
                }
                --index;
            }
            if (index < 0) {
                index = 0;
            }
            if ((event.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(caretIndex);
                this.textarea.setSelectionEnd(index);
            } else {
                this.textarea.setCaretPosition(index);
            }
            event.consume();
            return true;
        }
        if (code == 40 && (event.getModifiers() & 2) != 0) {
            int caretIndex;
            char[] contents = this.textarea.getText().toCharArray();
            int index = caretIndex = this.textarea.getCaretPosition();
            int lineStart = 0;
            boolean onlySpaces = false;
            while (index < contents.length) {
                if (contents[index] == '\n') {
                    if (onlySpaces) {
                        index = lineStart;
                        break;
                    }
                    lineStart = index + 1;
                    onlySpaces = true;
                } else if (contents[index] != ' ') {
                    onlySpaces = false;
                }
                ++index;
            }
            if ((event.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(caretIndex);
                this.textarea.setSelectionEnd(index);
            } else {
                this.textarea.setCaretPosition(index);
            }
            event.consume();
            return true;
        }
        switch (c) {
            case '\t': {
                if ((event.getModifiers() & 1) != 0) {
                    this.editor.handleOutdent();
                    break;
                }
                if (this.textarea.isSelectionActive()) {
                    this.editor.handleIndent();
                    break;
                }
                if (!Preferences.getBoolean("editor.tabs.expand")) break;
                int tabSize = Preferences.getInteger("editor.tabs.size");
                this.textarea.setSelectedText(PdeKeyListener.spaces(tabSize));
                event.consume();
                return true;
            }
            case '\n': 
            case '\r': {
                if (Preferences.getBoolean("editor.indent")) {
                    int sel;
                    char[] contents = this.textarea.getText().toCharArray();
                    int tabSize = Preferences.getInteger("editor.tabs.size");
                    int origIndex = this.textarea.getCaretPosition() - 1;
                    int spaceCount = this.calcSpaceCount(origIndex, contents);
                    int index2 = origIndex;
                    while (index2 >= 0 && Character.isWhitespace(contents[index2])) {
                        --index2;
                    }
                    if (index2 != -1 && contents[index2] == '{') {
                        spaceCount = this.calcSpaceCount(index2, contents);
                        spaceCount += tabSize;
                    }
                    int index = origIndex + 1;
                    int extraCount = 0;
                    while (index < contents.length && contents[index] == ' ') {
                        ++extraCount;
                        ++index;
                    }
                    int braceCount = 0;
                    while (index < contents.length && contents[index] != '\n') {
                        if (contents[index] == '}') {
                            ++braceCount;
                        }
                        ++index;
                    }
                    if ((spaceCount -= extraCount) < 0) {
                        this.textarea.setSelectionEnd(this.textarea.getSelectionStop() - spaceCount);
                        this.textarea.setSelectedText("\n");
                    } else {
                        String insertion = "\n" + PdeKeyListener.spaces(spaceCount);
                        this.textarea.setSelectedText(insertion);
                    }
                    if (braceCount > 0 && (sel = this.textarea.getSelectionStart()) - tabSize >= 0) {
                        this.textarea.select(sel - tabSize, sel);
                        String s = PdeKeyListener.spaces(tabSize);
                        if (this.textarea.getSelectedText().equals(s)) {
                            this.textarea.setSelectedText("");
                        } else {
                            this.textarea.select(sel, sel);
                        }
                    }
                } else {
                    this.textarea.setSelectedText(String.valueOf(c));
                }
                event.consume();
                return true;
            }
            case '}': {
                int prevCharIndex;
                if (!Preferences.getBoolean("editor.indent")) break;
                if (this.textarea.getSelectionStart() != this.textarea.getSelectionStop()) {
                    this.textarea.setSelectedText("");
                }
                char[] contents = this.textarea.getText().toCharArray();
                int index = prevCharIndex = this.textarea.getCaretPosition() - 1;
                boolean finished = false;
                while (index != -1 && !finished) {
                    if (contents[index] == '\n') {
                        finished = true;
                        ++index;
                        continue;
                    }
                    if (contents[index] != ' ') {
                        return false;
                    }
                    --index;
                }
                if (!finished) {
                    return false;
                }
                int lineStartIndex = index;
                int pairedSpaceCount = this.calcBraceIndent(prevCharIndex, contents);
                if (pairedSpaceCount == -1) {
                    return false;
                }
                this.textarea.setSelectionStart(lineStartIndex);
                this.textarea.setSelectedText(PdeKeyListener.spaces(pairedSpaceCount));
                event.consume();
                return true;
            }
        }
        return false;
    }

    public boolean keyTyped(KeyEvent event) {
        char c = event.getKeyChar();
        if ((event.getModifiers() & 2) != 0 && c == ',') {
            event.consume();
            return true;
        }
        return false;
    }

    protected int calcLineStart(int index, char[] contents) {
        boolean finished = false;
        while (index != -1 && !finished) {
            if (contents[index] == '\n' || contents[index] == '\r') {
                finished = true;
                continue;
            }
            --index;
        }
        return index + 1;
    }

    protected int calcSpaceCount(int index, char[] contents) {
        index = this.calcLineStart(index, contents);
        int spaceCount = 0;
        while (index < contents.length && index >= 0 && contents[index++] == ' ') {
            ++spaceCount;
        }
        return spaceCount;
    }

    protected int calcBraceIndent(int index, char[] contents) {
        int braceDepth = 1;
        boolean finished = false;
        while (index != -1 && !finished) {
            if (contents[index] == '}') {
                ++braceDepth;
                --index;
                continue;
            }
            if (contents[index] == '{') {
                if (--braceDepth == 0) {
                    finished = true;
                }
                --index;
                continue;
            }
            --index;
        }
        if (!finished) {
            return -1;
        }
        return this.calcSpaceCount(index, contents);
    }

    static String spaces(int count) {
        char[] c = new char[count];
        Arrays.fill(c, ' ');
        return new String(c);
    }
}

