/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.runner;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.ExceptionEvent;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.SketchException;
import processing.app.exec.StreamRedirectThread;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.mode.java.runner.EventThread;
import processing.mode.java.runner.MessageConsumer;
import processing.mode.java.runner.MessageSiphon;

public class Runner
implements MessageConsumer {
    private boolean presenting;
    protected RunnerListener listener;
    protected VirtualMachine vm;
    protected Thread errThread = null;
    protected Thread outThread = null;
    protected int debugTraceMode = 0;
    protected boolean watchFields = false;
    protected String[] excludes = new String[]{"java.*", "javax.*", "sun.*", "com.sun.*", "apple.*", "processing.*"};
    protected SketchException exception;
    protected Editor editor;
    protected JavaBuild build;

    public Runner(JavaBuild build, RunnerListener listener) {
        this.listener = listener;
        this.build = build;
        if (listener instanceof Editor) {
            this.editor = (Editor)listener;
        }
    }

    public void launch(boolean presenting) {
        this.presenting = presenting;
        String[] machineParamList = this.getMachineParams();
        String[] sketchParamList = this.getSketchParams();
        this.vm = this.launchVirtualMachine(machineParamList, sketchParamList);
        if (this.vm != null) {
            this.generateTrace(null);
        }
    }

    protected String[] getMachineParams() {
        ArrayList<String> params = new ArrayList<String>();
        String options = Preferences.get("run.options");
        if (options.length() > 0) {
            String[] pieces = PApplet.split((String)options, (char)' ');
            int i = 0;
            while (i < pieces.length) {
                String p = pieces[i].trim();
                if (p.length() > 0) {
                    params.add(p);
                }
                ++i;
            }
        }
        if (Preferences.getBoolean("run.options.memory")) {
            params.add("-Xms" + Preferences.get("run.options.memory.initial") + "m");
            params.add("-Xmx" + Preferences.get("run.options.memory.maximum") + "m");
        }
        if (Base.isMacOS()) {
            params.add("-Xdock:name=" + this.build.getSketchClassName());
        }
        params.add("-Djava.library.path=" + this.build.getJavaLibraryPath() + File.pathSeparator + System.getProperty("java.library.path"));
        params.add("-cp");
        params.add(this.build.getClassPath());
        params.add("-ea");
        String[] outgoing = new String[params.size()];
        params.toArray(outgoing);
        return outgoing;
    }

    protected String[] getSketchParams() {
        ArrayList<String> params = new ArrayList<String>();
        if (this.build.getFoundMain()) {
            params.add(this.build.getSketchClassName());
        } else {
            params.add("processing.core.PApplet");
            if (this.editor != null) {
                Point windowLocation = this.editor.getSketchLocation();
                if (windowLocation != null) {
                    params.add("--location=" + windowLocation.x + "," + windowLocation.y);
                } else {
                    Point editorLocation = this.editor.getLocation();
                    params.add("--editor-location=" + editorLocation.x + "," + editorLocation.y);
                }
                params.add("--external");
            }
            params.add("--display=" + Preferences.get("run.display"));
            params.add("--sketch-path=" + this.build.getSketchPath());
            if (this.presenting) {
                params.add("--present");
                if (Preferences.getBoolean("run.present.exclusive")) {
                    params.add("--exclusive");
                }
                params.add("--stop-color=" + Preferences.get("run.present.stop.color"));
                params.add("--bgcolor=" + Preferences.get("run.present.bgcolor"));
            }
            params.add(this.build.getSketchClassName());
        }
        return params.toArray(new String[0]);
    }

    protected VirtualMachine launchVirtualMachine(String[] vmParams, String[] classParams) {
        LaunchingConnector connector = (LaunchingConnector)this.findConnector("com.sun.jdi.RawCommandLineLaunch");
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        Connector.Argument commandArg = arguments.get("command");
        String addr = "127.0.0.1:" + (8000 + (int)(Math.random() * 1000.0));
        String commandArgs = "java -Xrunjdwp:transport=dt_socket,address=" + addr + ",suspend=y ";
        if (Base.isWindows()) {
            commandArgs = "java -Xrunjdwp:transport=dt_shmem,address=" + addr + ",suspend=y ";
        } else if (Base.isMacOS()) {
            commandArgs = System.getProperty("os.version").startsWith("10.4") ? "java -Xrunjdwp:transport=dt_socket,address=" + addr + ",suspend=y " : "java -d32 -Xrunjdwp:transport=dt_socket,address=" + addr + ",suspend=y ";
        }
        int i = 0;
        while (i < vmParams.length) {
            commandArgs = Runner.addArgument(commandArgs, vmParams[i], ' ');
            ++i;
        }
        if (classParams != null) {
            i = 0;
            while (i < classParams.length) {
                commandArgs = Runner.addArgument(commandArgs, classParams[i], ' ');
                ++i;
            }
        }
        commandArg.setValue(commandArgs);
        Connector.Argument addressArg = arguments.get("address");
        addressArg.setValue(addr);
        try {
            return connector.launch(arguments);
        }
        catch (IOException exc) {
            throw new Error("Unable to launch target VM: " + exc);
        }
        catch (IllegalConnectorArgumentsException exc) {
            throw new Error("Internal error: " + exc);
        }
        catch (VMStartException exc) {
            Process p = exc.process();
            String[] errorStrings = PApplet.loadStrings((InputStream)p.getErrorStream());
            PApplet.loadStrings((InputStream)p.getInputStream());
            if (errorStrings != null && errorStrings.length > 1) {
                if (errorStrings[0].indexOf("Invalid maximum heap size") != -1) {
                    Base.showWarning("Way Too High", "Please lower the value for \u201cmaximum available memory\u201d in the\nPreferences window. For more information, read Help \u2192 Troubleshooting.", exc);
                } else {
                    PApplet.println((Object)errorStrings);
                    System.err.println("Using startup command:");
                    PApplet.println(arguments);
                }
            } else {
                exc.printStackTrace();
                System.err.println("Could not run the sketch (Target VM failed to initialize).");
                if (Preferences.getBoolean("run.options.memory")) {
                    System.err.println("Make sure that you haven't set the maximum available memory too high.");
                }
                System.err.println("For more information, read revisions.txt and Help \u2192 Troubleshooting.");
            }
            this.listener.statusError("Could not run the sketch.");
            return null;
        }
    }

    private static boolean hasWhitespace(String string) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            if (Character.isWhitespace(string.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String addArgument(String string, String argument, char sep) {
        if (Runner.hasWhitespace(argument) || argument.indexOf(44) != -1) {
            StringBuffer buffer = new StringBuffer(string);
            buffer.append('\"');
            int i = 0;
            while (i < argument.length()) {
                char c = argument.charAt(i);
                if (c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
                ++i;
            }
            buffer.append('\"');
            buffer.append(sep);
            return buffer.toString();
        }
        return String.valueOf(string) + argument + String.valueOf(sep);
    }

    protected void generateTrace(PrintWriter writer) {
        this.vm.setDebugTraceMode(this.debugTraceMode);
        EventThread eventThread = null;
        eventThread = new EventThread(this, this.vm, this.excludes, writer);
        eventThread.setEventRequests(this.watchFields);
        eventThread.start();
        Process process = this.vm.process();
        MessageSiphon ms = new MessageSiphon(process.getErrorStream(), this);
        this.errThread = ms.getThread();
        this.outThread = new StreamRedirectThread("output reader", process.getInputStream(), System.out);
        this.errThread.start();
        this.outThread.start();
        this.vm.resume();
        try {
            if (eventThread != null) {
                eventThread.join();
            }
            this.errThread.join();
            this.outThread.join();
            if (this.editor != null) {
                this.editor.deactivateRun();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (writer != null) {
            writer.close();
        }
    }

    protected Connector findConnector(String connectorName) {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : connectors) {
            if (!connector.name().equals(connectorName)) continue;
            return connector;
        }
        throw new Error("No connector");
    }

    public void exception(ExceptionEvent event) {
        ObjectReference or = event.exception();
        ReferenceType rt = or.referenceType();
        String exceptionName = rt.name();
        Field messageField = rt.fieldByName("detailMessage");
        Value messageValue = or.getValue(messageField);
        int last = exceptionName.lastIndexOf(46);
        String message = exceptionName.substring(last + 1);
        if (messageValue != null) {
            String messageStr = messageValue.toString();
            if (messageStr.startsWith("\"")) {
                messageStr = messageStr.substring(1, messageStr.length() - 1);
            }
            message = String.valueOf(message) + ": " + messageStr;
        }
        if (!Runner.handleCommonErrors(exceptionName, message, this.listener)) {
            this.reportException(message, event.thread());
        }
        if (this.editor != null) {
            this.editor.deactivateRun();
        }
    }

    public static boolean handleCommonErrors(String exceptionClass, String message, RunnerListener listener) {
        if (exceptionClass.equals("java.lang.OutOfMemoryError")) {
            if (message.contains("exceeds VM budget")) {
                listener.statusError("OutOfMemoryError: This code attempts to use more memory than available.");
                System.err.println("An OutOfMemoryError means that your code is either using up too much memory");
                System.err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
                System.err.println("loading thousands of images), or simply that it's trying to use more memory");
                System.err.println("than what is supported by the current device.");
            } else {
                listener.statusError("OutOfMemoryError: You may need to increase the memory setting in Preferences.");
                System.err.println("An OutOfMemoryError means that your code is either using up too much memory");
                System.err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
                System.err.println("loading thousands of images), or that your sketch may need more memory to run.");
                System.err.println("If your sketch uses a lot of memory (for instance if it loads a lot of data files)");
                System.err.println("you can increase the memory available to your sketch using the Preferences window.");
            }
        } else if (exceptionClass.equals("java.lang.StackOverflowError")) {
            listener.statusError("StackOverflowError: This sketch is attempting too much recursion.");
            System.err.println("A StackOverflowError means that you have a bug that's causing a function");
            System.err.println("to be called recursively (it's calling itself and going in circles),");
            System.err.println("or you're intentionally calling a recursive function too much,");
            System.err.println("and your code should be rewritten in a more efficient manner.");
        } else if (exceptionClass.equals("java.lang.UnsupportedClassVersionError")) {
            listener.statusError("UnsupportedClassVersionError: A library is using code compiled with an unsupported version of Java.");
            System.err.println("This version of Processing only supports libraries and JAR files compiled for Java 1.5.");
            System.err.println("A library used by this sketch was compiled for Java 1.6 or later, ");
            System.err.println("and needs to be recompiled to be compatible with Java 1.5.");
        } else if (exceptionClass.equals("java.lang.NoSuchMethodError") || exceptionClass.equals("java.lang.NoSuchFieldError")) {
            listener.statusError(String.valueOf(exceptionClass.substring(10)) + ": " + "You may be using a library that's incompatible " + "with this version of Processing.");
        } else if (message != null && message.equals("ClassNotFoundException: quicktime.std.StdQTException")) {
            listener.statusError("Could not find QuickTime, please reinstall QuickTime 7 or later.");
        } else {
            return false;
        }
        return true;
    }

    protected void reportException(String message, ThreadReference thread) {
        this.listener.statusError(this.findException(message, thread));
    }

    SketchException findException(String message, ThreadReference thread) {
        try {
            List<StackFrame> frames = thread.frames();
            for (StackFrame frame : frames) {
                try {
                    Location location = frame.location();
                    String filename = null;
                    filename = location.sourceName();
                    int lineNumber = location.lineNumber() - 1;
                    SketchException rex = this.build.placeException(message, filename, lineNumber);
                    if (rex == null) continue;
                    return rex;
                }
                catch (AbsentInformationException e) {
                    this.exception = new SketchException(message);
                    this.exception.hideStackTrace();
                    this.listener.statusError(this.exception);
                }
            }
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        SketchException rex = new SketchException(message);
        rex.hideStackTrace();
        return rex;
    }

    public void close() {
        if (this.vm != null) {
            try {
                this.vm.exit(0);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            this.vm = null;
        }
    }

    public synchronized void message(String s) {
        if (s.indexOf("__STOP__") == 0) {
            if (this.editor != null) {
                this.editor.internalCloseRunner();
            }
            return;
        }
        if (s.indexOf("__MOVE__") == 0) {
            String nums = s.substring(s.indexOf(32) + 1).trim();
            int space = nums.indexOf(32);
            int left = Integer.parseInt(nums.substring(0, space));
            int top = Integer.parseInt(nums.substring(space + 1));
            this.editor.setSketchLocation(new Point(left, top));
            return;
        }
        System.err.print(s);
        System.err.flush();
    }
}

