/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.javascript;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptBuild {
    protected Sketch sketch;
    protected Mode mode;
    protected File binFolder;

    public static String getDocString(String s) {
        String[] javadoc = PApplet.match((String)s, (String)"/\\*{2,}(.*?)\\*+/");
        if (javadoc != null) {
            String[] pieces;
            StringBuffer dbuffer = new StringBuffer();
            String[] stringArray = pieces = PApplet.split((String)javadoc[1], (char)'\n');
            int n = pieces.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] m = PApplet.match((String)line, (String)"^\\s*\\*+(.*)");
                dbuffer.append(m != null ? m[1] : line);
                dbuffer.append('\n');
                ++n2;
            }
            return dbuffer.toString().trim();
        }
        return "";
    }

    public static void writeTemplate(File template, File output, Map<String, String> fields) throws IOException {
        BufferedReader reader = PApplet.createReader((File)template);
        PrintWriter theOutWriter = PApplet.createWriter((File)output);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("@@") != -1) {
                StringBuffer sb = new StringBuffer(line);
                int start = 0;
                int end2 = 0;
                while ((start = sb.indexOf("@@")) != -1) {
                    end2 = sb.indexOf("@@", start + 1);
                    if (end2 != -1) {
                        String value = fields.get(sb.substring(start + 2, end2));
                        sb.replace(start, end2 + 2, value == null ? "" : value);
                        continue;
                    }
                    Base.showWarning("Problem writing file from template", "The template appears to have an unterminated field. The output may look a little funny.", null);
                }
                line = sb.toString();
            }
            theOutWriter.println(line);
        }
        theOutWriter.close();
    }

    public JavaScriptBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public boolean build(File bin) {
        this.sketch.ensureExistence();
        this.binFolder = bin;
        if (bin.exists()) {
            Base.removeDescendants(bin);
        }
        try {
            this.preprocess(bin);
        }
        catch (IOException e) {
            String msg = "A problem occured while writing to the output folder.";
            Base.showWarning("Could not build the sketch", "A problem occured while writing to the output folder.", e);
            return false;
        }
        if (this.sketch.hasDataFolder()) {
            try {
                Base.copyDir(this.sketch.getDataFolder(), bin);
            }
            catch (IOException e) {
                String msg = "An exception occured while trying to copy the data folder. You may have to manually move the contents of sketch/data to the applet_js/ folder. Processing.js doesn't look for a data folder, so lump them together.";
                Base.showWarning("Problem building the sketch", "An exception occured while trying to copy the data folder. You may have to manually move the contents of sketch/data to the applet_js/ folder. Processing.js doesn't look for a data folder, so lump them together.", e);
            }
        }
        int wide = 100;
        int high = 100;
        String scrubbed = JavaBuild.scrubComments(this.sketch.getCode(0).getProgram());
        String[] matches = PApplet.match((String)scrubbed, (String)"(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+),?\\s*([^\\)]*)\\s*\\)\\s*\\;");
        if (matches != null) {
            try {
                wide = Integer.parseInt(matches[1]);
                high = Integer.parseInt(matches[2]);
            }
            catch (NumberFormatException e) {
                String message = "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.";
                Base.showWarning("Could not find applet size", "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.", null);
            }
        }
        File templateFile = this.sketch.getMode().getContentFile("applet_js/template.html");
        File htmlOutputFile = new File(bin, "index.html");
        HashMap<String, String> templateFields = new HashMap<String, String>();
        templateFields.put("width", String.valueOf(wide));
        templateFields.put("height", String.valueOf(high));
        templateFields.put("sketch", this.sketch.getName());
        templateFields.put("description", this.getSketchDescription());
        templateFields.put("source", "<a href=\"" + this.sketch.getName() + ".pde\">" + this.sketch.getName() + "</a>");
        try {
            JavaScriptBuild.writeTemplate(templateFile, htmlOutputFile, templateFields);
        }
        catch (IOException ioe) {
            String msg = "There was a problem writing the html template to the build folder.";
            Base.showWarning("A problem occured during the build", "There was a problem writing the html template to the build folder.", ioe);
            return false;
        }
        try {
            Base.copyFile(this.sketch.getMode().getContentFile("applet_js/processing.js"), new File(bin, "processing.js"));
        }
        catch (IOException ioe) {
            String msg = "There was a problem copying processing.js to the build folder. You will have to manually add processing.js to the build folder before the sketch will run.";
            Base.showWarning("There was a problem writing to the build folder", "There was a problem copying processing.js to the build folder. You will have to manually add processing.js to the build folder before the sketch will run.", ioe);
        }
        return true;
    }

    public void preprocess(File bin) throws IOException {
        StringBuffer bigCode = new StringBuffer();
        SketchCode[] sketchCodeArray = this.sketch.getCode();
        int n = sketchCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode sc = sketchCodeArray[n2];
            if (sc.isExtension("pde")) {
                bigCode.append(sc.getProgram());
                bigCode.append("\n");
            }
            ++n2;
        }
        if (!bin.exists()) {
            bin.mkdirs();
        }
        File bigFile = new File(bin, String.valueOf(this.sketch.getName()) + ".pde");
        Base.saveFile(bigCode.toString(), bigFile);
    }

    public String getSketchDescription() {
        return JavaScriptBuild.getDocString(this.sketch.getCode(0).getProgram());
    }

    public boolean export() throws IOException {
        File applet_js = new File(this.sketch.getFolder(), "applet_js");
        return this.exportApplet_js(applet_js);
    }

    public boolean exportApplet_js(File appletfolder) throws IOException {
        return this.build(appletfolder);
    }
}

