/*
 * Decompiled with CFR 0.152.
 */
package test.processing.mode.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.processing.mode.java.ProcessingTestUtil;

public class AutoFormatTests {
    @BeforeClass
    public static void init() {
        ProcessingTestUtil.init();
    }

    static void expectGood(String id) {
        try {
            String formattedProgram = ProcessingTestUtil.format(ProcessingTestUtil.res(String.valueOf(id) + ".pde"));
            File goldenFile = ProcessingTestUtil.res(String.valueOf(id) + ".expected");
            AutoFormatTests.checkGolden(formattedProgram, goldenFile);
            AutoFormatTests.checkGolden(ProcessingTestUtil.format(formattedProgram), goldenFile);
        }
        catch (Exception e) {
            if (!e.equals(e.getCause()) && e.getCause() != null) {
                Assert.fail((String)e.getCause().toString());
            } else {
                e.printStackTrace(System.err);
            }
            Assert.fail((String)e.toString());
        }
    }

    private static void checkGolden(String expectedText, File goldenFile) throws IOException {
        if (goldenFile.exists()) {
            String expected = ProcessingTestUtil.read(goldenFile);
            Assert.assertEquals((Object)expected, (Object)expectedText);
        } else {
            System.err.println("WARN: golden file " + goldenFile + " does not exist. Generating.");
            FileWriter sug = new FileWriter(goldenFile);
            sug.write(ProcessingTestUtil.normalize(expectedText));
            sug.close();
        }
    }

    @Test
    public void bug109() {
        AutoFormatTests.expectGood("bug109");
    }

    @Test
    public void bug405() {
        AutoFormatTests.expectGood("bug405");
    }

    @Test
    public void bug420() {
        AutoFormatTests.expectGood("bug420");
    }
}

