/*
 * Decompiled with CFR 0.152.
 */
package test.processing.mode.java;

import antlr.RecognitionException;
import java.io.File;
import java.io.FileWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import processing.app.SketchException;
import processing.app.exec.ProcessResult;
import test.processing.mode.java.ProcessingTestUtil;

public class ParserTests {
    @BeforeClass
    public static void init() {
        ProcessingTestUtil.init();
    }

    static void expectRecognitionException(String id, String expectedMessage, int expectedLine) {
        try {
            ProcessingTestUtil.preprocess(id, ProcessingTestUtil.res(String.valueOf(id) + ".pde"));
            Assert.fail((String)("Expected to fail with \"" + expectedMessage + "\" on line " + expectedLine));
        }
        catch (RecognitionException e) {
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
            Assert.assertEquals((long)expectedLine, (long)e.getLine());
        }
        catch (Exception e) {
            if (!e.equals(e.getCause()) && e.getCause() != null) {
                Assert.fail((String)e.getCause().toString());
            }
            Assert.fail((String)e.toString());
        }
    }

    static void expectRunnerException(String id, String expectedMessage, int expectedLine) {
        try {
            ProcessingTestUtil.preprocess(id, ProcessingTestUtil.res(String.valueOf(id) + ".pde"));
            Assert.fail((String)("Expected to fail with \"" + expectedMessage + "\" on line " + expectedLine));
        }
        catch (SketchException e) {
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
            Assert.assertEquals((long)expectedLine, (long)e.getCodeLine());
        }
        catch (Exception e) {
            if (!e.equals(e.getCause()) && e.getCause() != null) {
                Assert.fail((String)e.getCause().toString());
            }
            Assert.fail((String)e.toString());
        }
    }

    static void expectCompilerException(String id, String expectedMessage, int expectedLine) {
        try {
            String program = ProcessingTestUtil.preprocess(id, ProcessingTestUtil.res(String.valueOf(id) + ".pde"));
            ProcessResult compilerResult = ProcessingTestUtil.COMPILER.compile(id, program);
            if (compilerResult.succeeded()) {
                Assert.fail((String)("Expected to fail with \"" + expectedMessage + "\" on line " + expectedLine));
            }
            String e = compilerResult.getStderr().split("\n")[0];
            Matcher m = Pattern.compile(":(\\d+):\\s+(.+)$").matcher(e);
            m.find();
            Assert.assertEquals((Object)expectedMessage, (Object)m.group(2));
            Assert.assertEquals((Object)String.valueOf(expectedLine), (Object)m.group(1));
        }
        catch (Exception e) {
            if (!e.equals(e.getCause()) && e.getCause() != null) {
                Assert.fail((String)e.getCause().toString());
            }
            Assert.fail((String)e.toString());
        }
    }

    static void expectGood(String id) {
        try {
            File expectedFile;
            String program = ProcessingTestUtil.preprocess(id, ProcessingTestUtil.res(String.valueOf(id) + ".pde"));
            ProcessResult compilerResult = ProcessingTestUtil.COMPILER.compile(id, program);
            if (!compilerResult.succeeded()) {
                System.err.println(program);
                System.err.println("----------------------------");
                System.err.println(compilerResult.getStderr());
                Assert.fail((String)("Compilation failed with status " + compilerResult.getResult()));
            }
            if ((expectedFile = ProcessingTestUtil.res(String.valueOf(id) + ".expected")).exists()) {
                String expected = ProcessingTestUtil.read(expectedFile);
                Assert.assertEquals((Object)expected, (Object)program);
            } else {
                System.err.println("WARN: " + id + " does not have an expected output file. Generating.");
                FileWriter sug = new FileWriter(ProcessingTestUtil.res(String.valueOf(id) + ".expected"));
                sug.write(ProcessingTestUtil.normalize(program));
                sug.close();
            }
        }
        catch (Exception e) {
            if (!e.equals(e.getCause()) && e.getCause() != null) {
                Assert.fail((String)e.getCause().toString());
            }
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void bug4() {
        ParserTests.expectGood("bug4");
    }

    @Test
    public void bug5a() {
        ParserTests.expectGood("bug5a");
    }

    @Test
    public void bug5b() {
        ParserTests.expectGood("bug5b");
    }

    @Test
    public void bug6() {
        ParserTests.expectRecognitionException("bug6", "expecting EOF, found '/'", 1);
    }

    @Test
    public void bug16() {
        ParserTests.expectRunnerException("bug16", "Unclosed /* comment */", 2);
    }

    @Test
    public void bug136() {
        ParserTests.expectGood("bug136");
    }

    @Test
    public void bug196() {
        ParserTests.expectRecognitionException("bug196", "Web colors must be exactly 6 hex digits. This looks like 5.", 4);
    }

    @Test
    public void bug281() {
        ParserTests.expectGood("bug281");
    }

    @Test
    public void bug481() {
        ParserTests.expectGood("bug481");
    }

    @Test
    public void bug507() {
        ParserTests.expectRecognitionException("bug507", "expecting EOF, found 'else'", 5);
    }

    @Test
    public void bug598() {
        ParserTests.expectGood("bug598");
    }

    @Test
    public void bug631() {
        ParserTests.expectGood("bug631");
    }

    @Test
    public void bug763() {
        ParserTests.expectRunnerException("bug763", "Unterminated string constant", 6);
    }

    @Test
    public void bug820() {
        ParserTests.expectCompilerException("bug820", "x1 is already defined in setup()", 21);
    }

    @Test
    public void bug1064() {
        ParserTests.expectGood("bug1064");
    }

    @Test
    public void bug1145() {
        ParserTests.expectCompilerException("bug1145", "'.' expected", 4);
    }

    @Test
    public void bug1362() {
        ParserTests.expectGood("bug1362");
    }

    @Test
    public void bug1442() {
        ParserTests.expectGood("bug1442");
    }

    @Test
    public void bug1511() {
        ParserTests.expectGood("bug1511");
    }

    @Test
    public void bug1512() {
        ParserTests.expectGood("bug1512");
    }

    @Test
    public void bug1514a() {
        ParserTests.expectGood("bug1514a");
    }

    @Test
    public void bug1514b() {
        ParserTests.expectGood("bug1514b");
    }

    @Test
    public void bug1515() {
        ParserTests.expectGood("bug1515");
    }

    @Test
    public void bug1516() {
        ParserTests.expectGood("bug1516");
    }

    @Test
    public void bug1517() {
        ParserTests.expectGood("bug1517");
    }

    @Test
    public void bug1518a() {
        ParserTests.expectGood("bug1518a");
    }

    @Test
    public void bug1518b() {
        ParserTests.expectGood("bug1518b");
    }

    @Test
    public void bug1519() {
        ParserTests.expectRecognitionException("bug1519", "Maybe too many > characters?", 7);
    }

    @Test
    public void bug1525() {
        ParserTests.expectGood("bug1525");
    }

    @Test
    public void bug1532() {
        ParserTests.expectRecognitionException("bug1532", "unexpected token: break", 50);
    }

    @Test
    public void bug1534() {
        ParserTests.expectGood("bug1534");
    }

    @Test
    public void bug315g() {
        ParserTests.expectGood("bug315g");
    }

    @Test
    public void bug400g() {
        ParserTests.expectGood("bug400g");
    }

    @Test
    public void bug427g() {
        ParserTests.expectGood("bug427g");
    }

    @Test
    public void annotations() {
        ParserTests.expectGood("annotations");
    }
}

