/*
 * Decompiled with CFR 0.152.
 */
package test.processing.mode.java;

import antlr.ANTLRException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.mode.java.AutoFormat;
import processing.mode.java.preproc.PdePreprocessor;
import test.processing.mode.java.UTCompiler;

public class ProcessingTestUtil {
    private static final String RESOURCES = "test/resources/";
    static final UTCompiler COMPILER;

    static {
        try {
            Base.initPlatform();
            COMPILER = new UTCompiler(new File("bin"), new File("../core/bin"));
            Preferences.load(new FileInputStream(ProcessingTestUtil.res("preferences.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void init() {
    }

    static String normalize(Object s) {
        return String.valueOf(s).replace("\r", "");
    }

    static String preprocess(String name, File resource) throws SketchException, ANTLRException {
        String program = ProcessingTestUtil.read(resource);
        StringWriter out = new StringWriter();
        new PdePreprocessor(name, 4).write(out, program);
        return ProcessingTestUtil.normalize(out);
    }

    static String format(File resource) {
        return ProcessingTestUtil.format(ProcessingTestUtil.read(resource));
    }

    static String format(String programText) {
        return ProcessingTestUtil.normalize(new AutoFormat().format(programText));
    }

    static File res(String resourceName) {
        return new File(RESOURCES, resourceName);
    }

    static String read(File f) {
        String string;
        FileInputStream fin = new FileInputStream(f);
        InputStreamReader in = new InputStreamReader((InputStream)fin, "UTF-8");
        try {
            int len;
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[4096];
            while ((len = in.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
            string = ProcessingTestUtil.normalize(sb);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected", e);
            }
        }
        in.close();
        return string;
    }
}

