/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class QuaquaPopupFactory
extends PopupFactory {
    static final int LIGHT_WEIGHT_POPUP = 0;
    static final int MEDIUM_WEIGHT_POPUP = 1;
    static final int HEAVY_WEIGHT_POPUP = 2;
    private int popupType = 2;
    private static final int MAX_CACHE_SIZE = 5;

    int getPopupType(Component owner) {
        if (owner instanceof JComponent) {
            JComponent c = (JComponent)owner;
            Float alpha = (Float)c.getClientProperty("Quaqua.PopupMenu.alpha");
            if (alpha == null) {
                alpha = new Float(0.75f);
            }
            if (alpha.floatValue() == 1.0f) {
                return 2;
            }
        }
        return UIManager.getBoolean("PopupMenu.enableHeavyWeightPopup") ? 2 : 1;
    }

    private int getPopupType(Component owner, Component contents, int ownerX, int ownerY) {
        return this.getPopupType(owner);
    }

    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        if (contents == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        int pType = this.getPopupType(owner, contents, x, y);
        Popup popup = this.getPopup(owner, contents, x, y, pType);
        if (popup == null) {
            popup = this.getPopup(owner, contents, x, y, 2);
        }
        return popup;
    }

    private Popup getPopup(Component owner, Component contents, int ownerX, int ownerY, int popupType) {
        switch (popupType) {
            case 0: {
                return this.getLightWeightPopup(owner, contents, ownerX, ownerY);
            }
            case 1: {
                return this.getMediumWeightPopup(owner, contents, ownerX, ownerY);
            }
            case 2: {
                return this.getHeavyWeightPopup(owner, contents, ownerX, ownerY);
            }
        }
        return this.getLightWeightPopup(owner, contents, ownerX, ownerY);
    }

    private Popup getLightWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
        return LightWeightPopup.getLightWeightPopup(owner, contents, ownerX, ownerY);
    }

    private Popup getMediumWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
        return MediumWeightPopup.getMediumWeightPopup(owner, contents, ownerX, ownerY);
    }

    private Popup getHeavyWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
        return HeavyWeightPopup.getHeavyWeightPopup(owner, contents, ownerX, ownerY);
    }

    static Point convertScreenLocationToParent(Container parent, int x, int y) {
        for (Container p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            Point point = new Point(x, y);
            SwingUtilities.convertPointFromScreen(point, parent);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    private static class HeavyWeightPopup
    extends ContainerPopup {
        private HeavyWeightPopup() {
        }

        static Popup getHeavyWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
            HeavyWeightPopup popup = new HeavyWeightPopup();
            boolean focusPopup = false;
            if (contents.isFocusable() && contents instanceof JPopupMenu) {
                JPopupMenu jpm = (JPopupMenu)contents;
                Component[] popComps = jpm.getComponents();
                for (int i = 0; i < popComps.length; ++i) {
                    if (popComps[i] instanceof MenuElement || popComps[i] instanceof JSeparator) continue;
                    focusPopup = true;
                    break;
                }
            }
            popup.reset(owner, contents, ownerX, ownerY);
            if (focusPopup) {
                JWindow wnd = (JWindow)popup.getComponent();
                wnd.setFocusableWindowState(true);
                wnd.setName("###focusableSwingPopup###");
            }
            return popup;
        }

        Component createComponent(Component owner) {
            Object value;
            JWindow wnd;
            JWindow c = wnd = new JWindow(SwingUtilities.getWindowAncestor(owner));
            wnd.setName("###focusableSwingPopup###");
            wnd.getRootPane().putClientProperty("Window.shadow", Boolean.TRUE);
            wnd.setAlwaysOnTop(true);
            Float windowAlpha = new Float(0.948);
            if (this.contents instanceof JComponent && (value = ((JComponent)this.contents).getClientProperty("Quaqua.PopupMenu.windowAlpha")) instanceof Float) {
                windowAlpha = (Float)value;
            }
            wnd.getRootPane().putClientProperty("Window.alpha", windowAlpha);
            wnd.setBackground(new Color(0xFFFFFF, true));
            wnd.addComponentListener(new ComponentListener(){

                private void updateShadow() {
                    Object oldValue = wnd.getRootPane().getClientProperty("apple.awt.windowShadow.revalidateNow");
                    wnd.getRootPane().putClientProperty("apple.awt.windowShadow.revalidateNow", oldValue instanceof Integer ? (Integer)oldValue + 1 : 1);
                }

                public void componentResized(ComponentEvent e) {
                    this.updateShadow();
                }

                public void componentMoved(ComponentEvent e) {
                }

                public void componentShown(ComponentEvent e) {
                    this.updateShadow();
                }

                public void componentHidden(ComponentEvent e) {
                }
            });
            return c;
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            super.reset(owner, contents, ownerX, ownerY);
            JWindow window = (JWindow)this.getComponent();
            window.setLocation(ownerX, ownerY);
            window.getContentPane().add(contents, "Center");
            contents.invalidate();
            this.pack();
        }

        public void show() {
            Component c = this.getComponent();
            if (c != null) {
                c.show();
            }
        }

        public void hide() {
            Component c = this.getComponent();
            if (c instanceof JWindow) {
                c.hide();
                ((JWindow)c).getContentPane().removeAll();
            }
            this.dispose();
        }

        void dispose() {
            Component c = this.getComponent();
            if (c instanceof JWindow) {
                ((Window)c).dispose();
                c = null;
            }
        }
    }

    private static class MediumWeightPopup
    extends ContainerPopup {
        private static final Object mediumWeightPopupCacheKey = new StringBuffer("PopupFactory.mediumPopupCache");
        private JRootPane rootPane;

        private MediumWeightPopup() {
        }

        static Popup getMediumWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
            MediumWeightPopup popup = new MediumWeightPopup();
            if (popup == null) {
                popup = new MediumWeightPopup();
            }
            popup.reset(owner, contents, ownerX, ownerY);
            return popup;
        }

        public void hide() {
            super.hide();
            this.rootPane.getContentPane().removeAll();
        }

        public void show() {
            Component c = this.getComponent();
            Container parent = null;
            if (this.owner != null) {
                parent = this.owner.getParent();
            }
            while (!(parent instanceof Window) && !(parent instanceof Applet) && parent != null) {
                parent = parent.getParent();
            }
            if (parent instanceof RootPaneContainer) {
                parent = ((RootPaneContainer)((Object)parent)).getLayeredPane();
                Point p = QuaquaPopupFactory.convertScreenLocationToParent(parent, this.x, this.y);
                c.setVisible(false);
                c.setLocation(p.x, p.y);
                ((JLayeredPane)parent).add(c, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point p = QuaquaPopupFactory.convertScreenLocationToParent(parent, this.x, this.y);
                c.setLocation(p.x, p.y);
                c.setVisible(false);
                if (parent != null) {
                    parent.add(c);
                }
            }
            c.setVisible(true);
        }

        Component createComponent(Component owner) {
            Panel c = new Panel(new BorderLayout());
            this.rootPane = new JRootPane();
            c.add((Component)this.rootPane, "Center");
            return c;
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            super.reset(owner, contents, ownerX, ownerY);
            Component c = this.getComponent();
            c.setLocation(ownerX, ownerY);
            this.rootPane.getContentPane().add(contents, "Center");
            contents.invalidate();
            c.validate();
            this.pack();
        }
    }

    private static class LightWeightPopup
    extends ContainerPopup {
        private LightWeightPopup() {
        }

        static Popup getLightWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
            LightWeightPopup popup = new LightWeightPopup();
            popup.reset(owner, contents, ownerX, ownerY);
            return popup;
        }

        public void hide() {
            super.hide();
            Container c = (Container)this.getComponent();
            c.removeAll();
        }

        public void show() {
            Serializable p;
            Serializable parent = null;
            if (this.owner != null) {
                parent = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
            }
            for (p = parent; p != null; p = ((Component)p).getParent()) {
                if (p instanceof JRootPane) {
                    if (((Component)p).getParent() instanceof JInternalFrame) continue;
                    parent = ((JRootPane)p).getLayeredPane();
                    continue;
                }
                if (p instanceof Window) {
                    if (parent != null) break;
                    parent = p;
                    break;
                }
                if (p instanceof JApplet) break;
            }
            p = QuaquaPopupFactory.convertScreenLocationToParent((Container)parent, this.x, this.y);
            Component c = this.getComponent();
            c.setLocation(((Point)p).x, ((Point)p).y);
            if (parent instanceof JLayeredPane) {
                ((JLayeredPane)parent).add(c, JLayeredPane.POPUP_LAYER, 0);
            } else {
                ((Container)parent).add(c);
            }
        }

        Component createComponent(Component owner) {
            JPanel c = new JPanel(new BorderLayout(), true);
            c.setBorder(new LineBorder(new Color(0xB2B2B2)));
            c.setOpaque(true);
            return c;
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            super.reset(owner, contents, ownerX, ownerY);
            JComponent c = (JComponent)this.getComponent();
            c.setLocation(ownerX, ownerY);
            c.add(contents, "Center");
            contents.invalidate();
            this.pack();
        }
    }

    private static class ContainerPopup
    extends Popup {
        Component owner;
        int x;
        int y;
        Component component;
        Component contents;

        private ContainerPopup() {
        }

        Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent(this.owner);
            }
            return this.component;
        }

        Component createComponent(Component owner) {
            return null;
        }

        public void hide() {
            Container parent;
            Component c = this.getComponent();
            if (c != null && (parent = c.getParent()) != null) {
                Rectangle bounds = c.getBounds();
                parent.remove(c);
                parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            this.owner = null;
        }

        public void pack() {
            Component c = this.getComponent();
            if (c != null) {
                c.setSize(c.getPreferredSize());
            }
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            if (owner instanceof JFrame || owner instanceof JDialog || owner instanceof JWindow) {
                owner = ((RootPaneContainer)((Object)owner)).getLayeredPane();
            }
            this.x = ownerX;
            this.y = ownerY;
            this.owner = owner;
            this.contents = contents;
        }

        boolean overlappedByOwnedWindow() {
            Component c = this.getComponent();
            if (this.owner != null && c != null) {
                Window w = SwingUtilities.getWindowAncestor(this.owner);
                if (w == null) {
                    return false;
                }
                Window[] ownedWindows = w.getOwnedWindows();
                if (ownedWindows != null) {
                    Rectangle bnd = c.getBounds();
                    for (int i = 0; i < ownedWindows.length; ++i) {
                        Window owned = ownedWindows[i];
                        if (!owned.isVisible() || !bnd.intersects(owned.getBounds())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        boolean fitsOnScreen() {
            Component c = this.getComponent();
            if (this.owner != null && c != null) {
                int width = c.getWidth();
                int height = c.getHeight();
                for (Container parent = this.owner.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow) {
                        Rectangle r = parent.getBounds();
                        Insets i = parent.getInsets();
                        r.x += i.left;
                        r.y += i.top;
                        r.width -= i.left + i.right;
                        r.height -= i.top + i.bottom;
                        return SwingUtilities.isRectangleContainingRectangle(r, new Rectangle(this.x, this.y, width, height));
                    }
                    if (parent instanceof JApplet) {
                        Rectangle r = parent.getBounds();
                        Point p = parent.getLocationOnScreen();
                        r.x = p.x;
                        r.y = p.y;
                        return SwingUtilities.isRectangleContainingRectangle(r, new Rectangle(this.x, this.y, width, height));
                    }
                    if (parent instanceof Window || parent instanceof Applet) break;
                }
            }
            return false;
        }
    }
}

