/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaArrowButton;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.Debug;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class QuaquaScrollBarUI
extends BasicScrollBarUI {
    protected Dimension smallMinimumThumbSize;
    protected boolean isPlaceButtonsTogether;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.smallMinimumThumbSize = (Dimension)UIManager.get("ScrollBar.smallMinimumThumbSize");
        this.updatePlaceButtonsTogether();
        LookAndFeel.installColorsAndFont(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground", "ScrollBar.font");
        this.scrollbar.setFocusable(UIManager.getBoolean("ScrollBar.focusable"));
    }

    private void updatePlaceButtonsTogether() {
        Object value = this.scrollbar.getClientProperty("Quaqua.ScrollBar.placeButtonsTogether");
        this.isPlaceButtonsTogether = value == null ? UIManager.getBoolean("ScrollBar.placeButtonsTogether") : value.equals(Boolean.TRUE);
    }

    private boolean isPlaceButtonsTogether() {
        return this.isPlaceButtonsTogether;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new QuaquaTrackListener();
    }

    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new QuaquaArrowButtonListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new QuaquaPropertyChangeHandler();
    }

    protected JButton createDecreaseButton(int orientation) {
        return new QuaquaArrowButton(this.scrollbar);
    }

    protected JButton createIncreaseButton(int orientation) {
        return new QuaquaArrowButton(this.scrollbar);
    }

    protected BasicScrollBarUI.ScrollListener createScrollListener() {
        return new QuaquaScrollListener();
    }

    private boolean isSmall() {
        if (this.scrollbar.getParent() instanceof JScrollPane) {
            return QuaquaUtilities.isSmallSizeVariant((JScrollPane)this.scrollbar.getParent()) || QuaquaUtilities.isSmallSizeVariant(this.scrollbar);
        }
        return QuaquaUtilities.isSmallSizeVariant(this.scrollbar);
    }

    protected Dimension getMinimumThumbSize() {
        return this.isSmall() ? this.smallMinimumThumbSize : this.minimumThumbSize;
    }

    public Dimension getMaximumSize(JComponent c) {
        if (this.isSmall()) {
            return this.scrollbar.getOrientation() == 1 ? new Dimension(11, Integer.MAX_VALUE) : new Dimension(Integer.MAX_VALUE, 11);
        }
        return this.scrollbar.getOrientation() == 1 ? new Dimension(15, Integer.MAX_VALUE) : new Dimension(Integer.MAX_VALUE, 15);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.isSmall()) {
            return this.scrollbar.getOrientation() == 1 ? new Dimension(11, 24) : new Dimension(24, 11);
        }
        return this.scrollbar.getOrientation() == 1 ? new Dimension(15, 32) : new Dimension(32, 15);
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Debug.paint(g, c, this);
    }

    protected void paintThumb(Graphics gr, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)gr;
        boolean isSmall = this.isSmall();
        if (!this.scrollbar.isEnabled() || !QuaquaUtilities.isOnActiveWindow(this.scrollbar)) {
            if (this.scrollbar.getOrientation() == 1) {
                Border trackAndButtons = UIManager.getBorder(isSmall ? "ScrollBar.small.ivThumb" : "ScrollBar.ivThumb");
                trackAndButtons.paintBorder(c, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            } else {
                Border trackAndButtons = UIManager.getBorder(isSmall ? "ScrollBar.small.ihThumb" : "ScrollBar.ihThumb");
                trackAndButtons.paintBorder(c, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            }
        } else if (this.scrollbar.getOrientation() == 1) {
            Icon thumbBegin = ((Icon[])UIManager.get(isSmall ? "ScrollBar.small.vThumbTop" : "ScrollBar.vThumbTop"))[thumbBounds.y % 5];
            thumbBegin.paintIcon(c, g, thumbBounds.x, thumbBounds.y);
            Icon thumbEnd = ((Icon[])UIManager.get(isSmall ? "ScrollBar.small.vThumbBottom" : "ScrollBar.vThumbBottom"))[(thumbBounds.y + thumbBounds.height) % 5];
            thumbEnd.paintIcon(c, g, thumbBounds.x, thumbBounds.y + thumbBounds.height - thumbEnd.getIconHeight());
            BufferedImage img = (BufferedImage)UIManager.get(isSmall ? "ScrollBar.small.vThumbBody" : "ScrollBar.vThumbBody");
            TexturePaint paint = new TexturePaint(img, new Rectangle(thumbBounds.x, 0, img.getWidth(), img.getHeight()));
            g.setPaint(paint);
            g.fillRect(thumbBounds.x, thumbBounds.y + thumbBegin.getIconHeight(), this.getPreferredSize((JComponent)c).width, thumbBounds.height - thumbBegin.getIconHeight() - thumbEnd.getIconHeight());
        } else {
            Icon thumbBegin = ((Icon[])UIManager.get(isSmall ? "ScrollBar.small.hThumbLeft" : "ScrollBar.hThumbLeft"))[thumbBounds.x % 5];
            thumbBegin.paintIcon(c, g, thumbBounds.x, thumbBounds.y);
            Icon thumbEnd = ((Icon[])UIManager.get(isSmall ? "ScrollBar.small.hThumbRight" : "ScrollBar.hThumbRight"))[(thumbBounds.x + thumbBounds.width) % 5];
            thumbEnd.paintIcon(c, g, thumbBounds.x + thumbBounds.width - thumbEnd.getIconWidth(), thumbBounds.y);
            BufferedImage img = (BufferedImage)UIManager.get(isSmall ? "ScrollBar.small.hThumbBody" : "ScrollBar.hThumbBody");
            TexturePaint paint = new TexturePaint(img, new Rectangle(0, thumbBounds.y, img.getWidth(), img.getHeight()));
            g.setPaint(paint);
            g.fillRect(thumbBounds.x + thumbBegin.getIconWidth(), thumbBounds.y, thumbBounds.width - thumbBegin.getIconWidth() - thumbEnd.getIconWidth(), this.getPreferredSize((JComponent)c).height);
        }
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Dimension sbSize = this.scrollbar.getSize();
        Insets sbInsets = this.scrollbar.getInsets();
        Rectangle contentBounds = new Rectangle(sbInsets.left, sbInsets.top, sbSize.width - sbInsets.left - sbInsets.right, sbSize.height - sbInsets.top - sbInsets.bottom);
        Border trackAndButtons = this.getTrackAndButtonsBorder();
        if (trackAndButtons == null) {
            return;
        }
        Insets tbInsets = trackAndButtons.getBorderInsets(this.scrollbar);
        if (this.scrollbar.getOrientation() == 1) {
            if (this.isPlaceButtonsTogether() && contentBounds.height < tbInsets.top + tbInsets.bottom) {
                Graphics clipped = g.create(contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
                int buttonsH = this.incrButton.getPreferredSize().height * 2;
                trackAndButtons.paintBorder(c, g, contentBounds.x, contentBounds.y + contentBounds.height - tbInsets.top - tbInsets.bottom + Math.max(0, (buttonsH - contentBounds.height) / 2), contentBounds.width, tbInsets.top + tbInsets.bottom);
                clipped.dispose();
            } else {
                trackAndButtons.paintBorder(c, g, contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
            }
        } else if (this.isPlaceButtonsTogether() && contentBounds.width < tbInsets.left + tbInsets.right) {
            Graphics clipped = g.create(contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
            int buttonsW = this.incrButton.getPreferredSize().width * 2;
            trackAndButtons.paintBorder(c, g, contentBounds.x + contentBounds.width - tbInsets.left - tbInsets.right + Math.max(0, (buttonsW - contentBounds.width) / 2), contentBounds.y, tbInsets.left + tbInsets.right, contentBounds.height);
            clipped.dispose();
        } else {
            trackAndButtons.paintBorder(c, g, contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
        }
    }

    protected Border getTrackAndButtonsBorder() {
        char vh = this.scrollbar.getOrientation() == 1 ? (char)'v' : 'h';
        boolean isSmall = this.isSmall();
        if (this.scrollbar.getMinimum() + this.scrollbar.getVisibleAmount() == this.scrollbar.getMaximum()) {
            return UIManager.getBorder(isSmall ? "ScrollBar.small." + vh + "Track" : "ScrollBar." + vh + "Track");
        }
        int buttonsIndex = this.scrollbar.isEnabled() ? (this.incrButton.getModel().isArmed() && this.incrButton.getModel().isPressed() ? 1 : (this.decrButton.getModel().isArmed() && this.decrButton.getModel().isPressed() ? 3 : 0)) : 2;
        Border[] borders = this.isPlaceButtonsTogether() ? (Border[])UIManager.get(isSmall ? "ScrollBar.smallTog." + vh + "Buttons" : "ScrollBar.tog." + vh + "Buttons") : (Border[])UIManager.get(isSmall ? "ScrollBar.smallSep." + vh + "Buttons" : "ScrollBar.sep." + vh + "Buttons");
        return borders == null ? null : borders[buttonsIndex];
    }

    public boolean getSupportsAbsolutePositioning() {
        return UIManager.getBoolean("ScrollBar.supportsAbsolutePositioning");
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int trackH;
        int trackY;
        int decrButtonY;
        int incrButtonY;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        if (sb.getMinimum() + sb.getVisibleAmount() == sb.getMaximum()) {
            this.trackRect.setBounds(sbInsets.left, sbInsets.top, itemW, sbSize.height - (sbInsets.top + sbInsets.bottom));
            this.decrButton.setBounds(0, 0, 0, 0);
            this.incrButton.setBounds(0, 0, 0, 0);
            this.setThumbBounds(0, 0, 0, 0);
            return;
        }
        boolean isSmall = this.isSmall();
        int decrButtonH = isSmall ? 12 : 16;
        int incrButtonH = decrButtonH;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        int sbAvailButtonH = sbSize.height - sbInsetsH;
        if (this.isPlaceButtonsTogether()) {
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
            decrButtonY = incrButtonY - decrButtonH;
            if (sbAvailButtonH < sbButtonsH) {
                incrButtonH = sbAvailButtonH / 2;
                decrButtonH = sbAvailButtonH - incrButtonH;
                incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
                decrButtonY = sbInsets.top;
            }
            trackY = sbInsets.top + (isSmall ? 4 : 5);
            trackH = decrButtonY - trackY + (isSmall ? 0 : 3);
        } else {
            decrButtonY = sbInsets.top;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
            if (sbAvailButtonH < sbButtonsH) {
                incrButtonH = decrButtonH = sbAvailButtonH / 2;
                incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
            }
            trackY = decrButtonY + decrButtonH + (isSmall ? 0 : -1);
            trackH = incrButtonY - trackY + (isSmall ? 2 : 3);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.trackRect.setBounds(itemX, trackY, itemW, trackH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        float ftrackH = trackH;
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(ftrackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = trackY + trackH - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = ftrackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += trackY;
        }
        if (thumbH >= trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        int trackW;
        int trackX;
        int leftButtonX;
        int rightButtonX;
        boolean ltr;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        if (sb.getMinimum() + sb.getVisibleAmount() == sb.getMaximum()) {
            this.trackRect.setBounds(sbInsets.left, sbInsets.top, sbSize.width - (sbInsets.left + sbInsets.right), itemH);
            this.decrButton.setBounds(0, 0, 0, 0);
            this.incrButton.setBounds(0, 0, 0, 0);
            this.setThumbBounds(0, 0, 0, 0);
            return;
        }
        boolean isSmall = this.isSmall();
        int rightButtonW = isSmall ? 12 : 16;
        int leftButtonW = rightButtonW;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = leftButtonW + rightButtonW;
        int sbAvailButtonW = sbSize.width - sbInsetsW;
        if (this.isPlaceButtonsTogether()) {
            ltr = true;
            rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
            leftButtonX = rightButtonX - leftButtonW;
            if (sbAvailButtonW < sbButtonsW) {
                leftButtonW = sbAvailButtonW / 2;
                rightButtonW = sbAvailButtonW - leftButtonW;
                leftButtonX = sbInsets.left;
                rightButtonX = leftButtonX + leftButtonW;
            }
            trackX = sbInsets.left + 5;
            trackW = leftButtonX - trackX;
            if (!isSmall) {
                ++trackW;
            }
        } else {
            ltr = sb.getComponentOrientation().isLeftToRight();
            if (!ltr) {
                int helper = leftButtonW;
                leftButtonW = rightButtonW;
                rightButtonW = helper;
            }
            leftButtonX = sbInsets.left;
            rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
            if (sbAvailButtonW < sbButtonsW) {
                rightButtonW = leftButtonW = sbAvailButtonW / 2;
                rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
            }
            trackX = leftButtonX + leftButtonW - 1;
            trackW = rightButtonX - trackX + 1;
        }
        (ltr ? this.decrButton : this.incrButton).setBounds(leftButtonX, itemY, leftButtonW, itemH);
        (ltr ? this.incrButton : this.decrButton).setBounds(rightButtonX, itemY, rightButtonW, itemH);
        this.trackRect.setBounds(trackX, itemY, trackW, itemH);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        float ftrackW = trackW;
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(ftrackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int thumbX = trackX + trackW - thumbW;
        if ((float)sb.getValue() < max - (float)sb.getVisibleAmount()) {
            float thumbRange = ftrackW - (float)thumbW;
            thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbX += trackX;
        }
        if (thumbW >= trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void scrollByUnit(int direction) {
        QuaquaScrollBarUI.scrollByUnits(this.scrollbar, direction, 1, false);
    }

    static void scrollByUnits(JScrollBar scrollbar, int direction, int units, boolean limitToBlock) {
        int limit = -1;
        if (limitToBlock) {
            limit = direction < 0 ? scrollbar.getValue() - scrollbar.getBlockIncrement(direction) : scrollbar.getValue() + scrollbar.getBlockIncrement(direction);
        }
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            if (limitToBlock && i > 0) {
                assert (limit != -1);
                if (direction < 0 && newValue < limit || direction > 0 && newValue > limit) break;
            }
            scrollbar.setValue(newValue);
        }
    }

    protected void scrollByBlock(int direction) {
        QuaquaScrollBarUI.scrollByBlock(this.scrollbar, direction);
        this.trackHighlight = direction > 0 ? 2 : 1;
        Rectangle dirtyRect = this.getTrackBounds();
        this.scrollbar.repaint(dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
    }

    static void scrollByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }

    public class QuaquaPropertyChangeHandler
    extends BasicScrollBarUI.PropertyChangeHandler {
        public QuaquaPropertyChangeHandler() {
            super(QuaquaScrollBarUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("Frame.active".equals(name)) {
                QuaquaScrollBarUI.this.scrollbar.repaint();
            } else if ("Quaqua.ScrollBar.placeButtonsTogether".equals(name)) {
                QuaquaScrollBarUI.this.updatePlaceButtonsTogether();
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant(QuaquaScrollBarUI.this.scrollbar);
            }
            super.propertyChange(e);
        }
    }

    protected class QuaquaScrollListener
    extends BasicScrollBarUI.ScrollListener {
        int direction;
        boolean useBlockIncrement;

        public QuaquaScrollListener() {
            super(QuaquaScrollBarUI.this);
            this.direction = 1;
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public QuaquaScrollListener(int dir, boolean block) {
            super(QuaquaScrollBarUI.this);
            this.direction = 1;
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        public void actionPerformed(ActionEvent e) {
            QuaquaTrackListener trackListener = (QuaquaTrackListener)QuaquaScrollBarUI.this.trackListener;
            if (this.useBlockIncrement) {
                QuaquaScrollBarUI.this.scrollByBlock(this.direction);
                if (QuaquaScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().y + ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().height >= trackListener.getCurrentMouseY()) {
                            ((Timer)e.getSource()).stop();
                        }
                    } else if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().y <= trackListener.getCurrentMouseY()) {
                        ((Timer)e.getSource()).stop();
                    }
                } else if (this.direction > 0) {
                    if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().x + ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().width >= trackListener.getCurrentMouseX()) {
                        ((Timer)e.getSource()).stop();
                    }
                } else if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().x <= trackListener.getCurrentMouseX()) {
                    ((Timer)e.getSource()).stop();
                }
            } else {
                QuaquaScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && QuaquaScrollBarUI.this.scrollbar.getValue() + QuaquaScrollBarUI.this.scrollbar.getVisibleAmount() >= QuaquaScrollBarUI.this.scrollbar.getMaximum()) {
                ((Timer)e.getSource()).stop();
            } else if (this.direction < 0 && QuaquaScrollBarUI.this.scrollbar.getValue() <= QuaquaScrollBarUI.this.scrollbar.getMinimum()) {
                ((Timer)e.getSource()).stop();
            }
        }
    }

    protected class QuaquaArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        protected QuaquaArrowButtonListener() {
            super(QuaquaScrollBarUI.this);
        }

        public void mousePressed(MouseEvent evt) {
            super.mousePressed(evt);
            this.repaintButtons();
        }

        public void mouseReleased(MouseEvent evt) {
            super.mouseReleased(evt);
            this.repaintButtons();
        }

        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            if ((evt.getModifiers() & 0x1C) != 0) {
                this.repaintButtons();
            }
        }

        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            if ((evt.getModifiers() & 0x1C) != 0) {
                this.repaintButtons();
            }
        }

        protected void repaintButtons() {
            Dimension sbSize = QuaquaScrollBarUI.this.scrollbar.getSize();
            Insets sbInsets = QuaquaScrollBarUI.this.scrollbar.getInsets();
            Rectangle contentBounds = new Rectangle(sbInsets.left, sbInsets.top, sbSize.width - sbInsets.left - sbInsets.right, sbSize.height - sbInsets.top - sbInsets.bottom);
            if (QuaquaScrollBarUI.this.isPlaceButtonsTogether()) {
                Border trackAndButtonsBorder = QuaquaScrollBarUI.this.getTrackAndButtonsBorder();
                Insets tbInsets = trackAndButtonsBorder.getBorderInsets(QuaquaScrollBarUI.this.scrollbar);
                if (QuaquaScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    QuaquaScrollBarUI.this.scrollbar.repaint(contentBounds.x, contentBounds.y + contentBounds.height - tbInsets.bottom, contentBounds.width, tbInsets.bottom);
                } else {
                    QuaquaScrollBarUI.this.scrollbar.repaint(contentBounds.x + contentBounds.width - tbInsets.right, contentBounds.y, tbInsets.right, contentBounds.height);
                }
            } else {
                QuaquaScrollBarUI.this.scrollbar.repaint();
            }
        }
    }

    protected class QuaquaTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected transient int direction;

        protected QuaquaTrackListener() {
            super(QuaquaScrollBarUI.this);
            this.direction = 1;
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !QuaquaScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!QuaquaScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle r = QuaquaScrollBarUI.this.getTrackBounds();
            QuaquaScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
            QuaquaScrollBarUI.this.trackHighlight = 0;
            QuaquaScrollBarUI.this.isDragging = false;
            this.offset = 0;
            QuaquaScrollBarUI.this.scrollTimer.stop();
            QuaquaScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !QuaquaScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!QuaquaScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!QuaquaScrollBarUI.this.scrollbar.hasFocus() && QuaquaScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                QuaquaScrollBarUI.this.scrollbar.requestFocus();
            }
            QuaquaScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (QuaquaScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (QuaquaScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().x;
                    }
                }
                QuaquaScrollBarUI.this.isDragging = true;
                return;
            }
            if (QuaquaScrollBarUI.this.getSupportsAbsolutePositioning() || SwingUtilities.isMiddleMouseButton(e)) {
                switch (QuaquaScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().width / 2;
                    }
                }
                QuaquaScrollBarUI.this.isDragging = true;
                this.setValueFrom(e);
                return;
            }
            QuaquaScrollBarUI.this.isDragging = false;
            Dimension sbSize = QuaquaScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (QuaquaScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (QuaquaScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.height / 2;
                        this.direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().y;
                    this.direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    if (QuaquaScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.width / 2;
                        this.direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                    } else {
                        int thumbX = ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().x;
                        int n = this.direction = this.currentMouseX < thumbX ? -1 : 1;
                    }
                    if (QuaquaScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            QuaquaScrollBarUI.this.scrollByBlock(this.direction);
            QuaquaScrollBarUI.this.scrollTimer.stop();
            QuaquaScrollBarUI.this.scrollListener.setDirection(this.direction);
            QuaquaScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !QuaquaScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!QuaquaScrollBarUI.this.scrollbar.isEnabled() || QuaquaScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (QuaquaScrollBarUI.this.isDragging) {
                this.setValueFrom(e);
            } else {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            BoundedRangeModel model = QuaquaScrollBarUI.this.scrollbar.getModel();
            Rectangle thumbR = QuaquaScrollBarUI.this.getThumbBounds();
            Rectangle trackR = QuaquaScrollBarUI.this.getTrackBounds();
            if (QuaquaScrollBarUI.this.scrollbar.getOrientation() == 1) {
                thumbMin = trackR.y;
                thumbMax = trackR.y + trackR.height - thumbR.height;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                QuaquaScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                thumbMin = trackR.x;
                thumbMax = trackR.x + trackR.width - thumbR.width;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                QuaquaScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                if (QuaquaScrollBarUI.this.scrollbar.getOrientation() == 1 || QuaquaScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    QuaquaScrollBarUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
                } else {
                    QuaquaScrollBarUI.this.scrollbar.setValue(model.getMinimum());
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = QuaquaScrollBarUI.this.scrollbar.getOrientation() == 1 || QuaquaScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                QuaquaScrollBarUI.this.scrollbar.setValue(value + model.getMinimum());
            }
        }

        private void startScrollTimerIfNecessary() {
            if (QuaquaScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (QuaquaScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().y + ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().height >= ((QuaquaTrackListener)((QuaquaScrollBarUI)QuaquaScrollBarUI.this).trackListener).currentMouseY) break;
                        QuaquaScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().y <= ((QuaquaTrackListener)((QuaquaScrollBarUI)QuaquaScrollBarUI.this).trackListener).currentMouseY) break;
                    QuaquaScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().x + ((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().width >= ((QuaquaTrackListener)((QuaquaScrollBarUI)QuaquaScrollBarUI.this).trackListener).currentMouseX) break;
                        QuaquaScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((QuaquaScrollBarUI)QuaquaScrollBarUI.this).getThumbBounds().x <= ((QuaquaTrackListener)((QuaquaScrollBarUI)QuaquaScrollBarUI.this).trackListener).currentMouseX) break;
                    QuaquaScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        private int getCurrentMouseX() {
            return this.currentMouseX;
        }

        private int getCurrentMouseY() {
            return this.currentMouseY;
        }
    }
}

