/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.leopard.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.base64.Base64;
import ch.randelshofer.quaqua.ext.nanoxml.XMLElement;
import ch.randelshofer.quaqua.ext.nanoxml.XMLParseException;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileSystemTreeModel;
import ch.randelshofer.quaqua.osx.OSXFile;
import ch.randelshofer.quaqua.util.BinaryPListParser;
import ch.randelshofer.quaqua.util.SequentialDispatcher;
import ch.randelshofer.quaqua.util.Worker;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SidebarTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    private static final File sidebarFile = new File(QuaquaManager.getProperty("user.home"), "Library/Preferences/com.apple.sidebarlists.plist");
    private TreePath volumesPath;
    private TreeModel model;
    private DefaultMutableTreeNode devicesNode;
    private DefaultMutableTreeNode placesNode;
    private static final long VALIDATION_TTL = 60000L;
    private long bestBefore;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private HashMap systemItemsMap = new HashMap();
    private static final File[] defaultUserItems = QuaquaManager.isOSX() || QuaquaManager.getOS() == -3 ? new File[]{new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File(QuaquaManager.getProperty("user.home"), "Documents"), new File(QuaquaManager.getProperty("user.home"))} : (QuaquaManager.getOS() == -2 ? new File[]{new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File(QuaquaManager.getProperty("user.home"), "\u684c\u9762"), new File(QuaquaManager.getProperty("user.home"), "My Documents"), new File(QuaquaManager.getProperty("user.home"))} : (QuaquaManager.getOS() == -4 ? new File[]{new File(QuaquaManager.getProperty("user.home"), "Desktop"), new File("/media"), new File(QuaquaManager.getProperty("user.home"), "Documents"), new File(QuaquaManager.getProperty("user.home"))} : new File[]{new File(QuaquaManager.getProperty("user.home"))}));

    public SidebarTreeModel(JFileChooser fileChooser, TreePath path, TreeModel model) {
        super(new DefaultMutableTreeNode(), true);
        this.fileChooser = fileChooser;
        this.volumesPath = path;
        this.model = model;
        this.devicesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.devices"));
        this.devicesNode.setAllowsChildren(true);
        this.placesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.places"));
        this.placesNode.setAllowsChildren(true);
        DefaultMutableTreeNode r = (DefaultMutableTreeNode)this.getRoot();
        r.add(this.devicesNode);
        r.add(this.placesNode);
        this.validate();
        this.updateDevicesNode();
        model.addTreeModelListener(this);
    }

    public void lazyValidate() {
    }

    private void validate() {
        this.bestBefore = Long.MAX_VALUE;
        this.dispatcher.dispatch(new Worker<Object[]>(){

            @Override
            public Object[] construct() throws IOException {
                return SidebarTreeModel.this.read();
            }

            @Override
            public void done(Object[] value) {
                SidebarTreeModel.this.systemItemsMap = (HashMap)value[0];
                ArrayList freshUserItems = (ArrayList)value[1];
                this.update(freshUserItems);
            }

            @Override
            public void failed(Throwable value) {
                System.err.println("Warning: SidebarTreeModel uses default user items.");
                ArrayList<FileNode> freshUserItems = new ArrayList<FileNode>(defaultUserItems.length);
                for (int i = 0; i < defaultUserItems.length; ++i) {
                    if (defaultUserItems[i] == null) {
                        freshUserItems.add(null);
                        continue;
                    }
                    if (!defaultUserItems[i].exists()) continue;
                    freshUserItems.add(new FileNode(defaultUserItems[i]));
                }
                this.update(freshUserItems);
            }

            private void update(ArrayList freshUserItems) {
                int i;
                int oldUserItemsSize = SidebarTreeModel.this.placesNode.getChildCount();
                if (oldUserItemsSize > 0) {
                    int[] removedIndices = new int[oldUserItemsSize];
                    Object[] removedChildren = new Object[oldUserItemsSize];
                    for (i = 0; i < oldUserItemsSize; ++i) {
                        removedIndices[i] = i;
                        removedChildren[i] = SidebarTreeModel.this.placesNode.getChildAt(i);
                    }
                    SidebarTreeModel.this.placesNode.removeAllChildren();
                    SidebarTreeModel.this.fireTreeNodesRemoved(SidebarTreeModel.this, SidebarTreeModel.this.placesNode.getPath(), removedIndices, removedChildren);
                }
                if (freshUserItems.size() > 0) {
                    int[] insertedIndices = new int[freshUserItems.size()];
                    Object[] insertedChildren = new Object[freshUserItems.size()];
                    for (i = 0; i < freshUserItems.size(); ++i) {
                        insertedIndices[i] = i;
                        insertedChildren[i] = freshUserItems.get(i);
                        if (freshUserItems.get(i) == null) {
                            SidebarTreeModel.this.placesNode.add(new DefaultMutableTreeNode("null?"));
                            continue;
                        }
                        SidebarTreeModel.this.placesNode.add((DefaultMutableTreeNode)freshUserItems.get(i));
                    }
                    SidebarTreeModel.this.fireTreeNodesInserted(SidebarTreeModel.this, SidebarTreeModel.this.placesNode.getPath(), insertedIndices, insertedChildren);
                }
                SidebarTreeModel.this.bestBefore = System.currentTimeMillis() + 60000L;
            }
        });
    }

    private void updateDevicesNode() {
        int i;
        FileSystemTreeModel.Node modelDevicesNode = (FileSystemTreeModel.Node)this.volumesPath.getLastPathComponent();
        for (i = this.devicesNode.getChildCount() - 1; i >= 0; --i) {
            SidebarViewToModelNode viewNode = (SidebarViewToModelNode)this.devicesNode.getChildAt(i);
            if (viewNode.getTarget().getParent() == modelDevicesNode) continue;
            this.removeNodeFromParent(viewNode);
        }
        int n = modelDevicesNode.getChildCount();
        for (i = 0; i < n; ++i) {
            int insertionIndex;
            FileSystemTreeModel.Node modelNode = (FileSystemTreeModel.Node)modelDevicesNode.getChildAt(i);
            if (modelNode.isLeaf()) continue;
            boolean isInView = false;
            int m = this.devicesNode.getChildCount();
            for (int j = 0; j < m; ++j) {
                SidebarViewToModelNode viewNode = (SidebarViewToModelNode)this.devicesNode.getChildAt(j);
                if (viewNode.getTarget() != modelNode) continue;
                isInView = true;
                break;
            }
            if (isInView) continue;
            SidebarViewToModelNode newNode = new SidebarViewToModelNode(modelNode);
            for (insertionIndex = 0; insertionIndex < this.devicesNode.getChildCount() && ((SidebarViewToModelNode)this.devicesNode.getChildAt(insertionIndex)).compareTo(newNode) < 0; ++insertionIndex) {
            }
            this.insertNodeInto(newNode, this.devicesNode, insertionIndex);
        }
        if (this.devicesNode.getChildCount() > 0) {
            int[] childIndices = new int[this.devicesNode.getChildCount()];
            Object[] childNodes = new Object[this.devicesNode.getChildCount()];
            for (int i2 = 0; i2 < childIndices.length; ++i2) {
                childIndices[i2] = i2;
                childNodes[i2] = this.devicesNode.getChildAt(i2);
            }
            this.fireTreeNodesChanged(this, this.devicesNode.getPath(), childIndices, childNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] read() throws IOException {
        if (!OSXFile.canWorkWithAliases()) {
            throw new IOException("Unable to work with aliases");
        }
        HashMap<String, SystemItemInfo> sysItemsMap = new HashMap<String, SystemItemInfo>();
        ArrayList<Node> userItems = new ArrayList<Node>();
        FileReader reader = null;
        try {
            reader = new FileReader(sidebarFile);
            XMLElement xml = new XMLElement(new HashMap(), false, false);
            try {
                xml.parseFromReader(reader);
            }
            catch (XMLParseException e) {
                xml = new BinaryPListParser().parse(sidebarFile);
            }
            String key2 = "";
            String key3 = "";
            String key5 = "";
            Iterator i0 = xml.iterateChildren();
            while (i0.hasNext()) {
                XMLElement xml1 = (XMLElement)i0.next();
                Iterator i1 = xml1.iterateChildren();
                while (i1.hasNext()) {
                    XMLElement xml4;
                    Iterator i3;
                    XMLElement xml3;
                    Iterator i2;
                    XMLElement xml2 = (XMLElement)i1.next();
                    if (xml2.getName().equals("key")) {
                        key2 = xml2.getContent();
                    }
                    if (xml2.getName().equals("dict") && key2.equals("systemitems")) {
                        i2 = xml2.iterateChildren();
                        while (i2.hasNext()) {
                            xml3 = (XMLElement)i2.next();
                            if (xml3.getName().equals("key")) {
                                key3 = xml3.getContent();
                            }
                            if (!xml3.getName().equals("array") || !key3.equals("VolumesList")) continue;
                            i3 = xml3.iterateChildren();
                            while (i3.hasNext()) {
                                xml4 = (XMLElement)i3.next();
                                if (!xml4.getName().equals("dict")) continue;
                                SystemItemInfo info = new SystemItemInfo();
                                Iterator i4 = xml4.iterateChildren();
                                while (i4.hasNext()) {
                                    XMLElement xml5 = (XMLElement)i4.next();
                                    if (xml5.getName().equals("key")) {
                                        key5 = xml5.getContent();
                                    }
                                    info.sequenceNumber = sysItemsMap.size();
                                    if (xml5.getName().equals("string") && key5.equals("Name")) {
                                        info.name = xml5.getContent();
                                    }
                                    if (!xml5.getName().equals("string") || !key5.equals("Visibility")) continue;
                                    info.isVisible = xml5.getContent().equals("AlwaysVisible");
                                }
                                if (info.name == null) continue;
                                sysItemsMap.put(info.name, info);
                            }
                        }
                    }
                    if (!xml2.getName().equals("dict") || !key2.equals("useritems")) continue;
                    i2 = xml2.iterateChildren();
                    while (i2.hasNext()) {
                        xml3 = (XMLElement)i2.next();
                        i3 = xml3.iterateChildren();
                        while (i3.hasNext()) {
                            xml4 = (XMLElement)i3.next();
                            String aliasName = null;
                            byte[] serializedAlias = null;
                            Iterator i4 = xml4.iterateChildren();
                            while (i4.hasNext()) {
                                XMLElement xml5 = (XMLElement)i4.next();
                                if (xml5.getName().equals("key")) {
                                    key5 = xml5.getContent();
                                }
                                if (xml5.getName().equals("string") && key5.equals("Name")) {
                                    aliasName = xml5.getContent();
                                }
                                if (xml5.getName().equals("key") || !key5.equals("Alias")) continue;
                                serializedAlias = Base64.decode(xml5.getContent());
                            }
                            if (serializedAlias == null || aliasName == null) continue;
                            File f = OSXFile.resolveAlias(serializedAlias, true);
                            if (f != null) {
                                userItems.add(new FileNode(f));
                                continue;
                            }
                            userItems.add(new AliasNode(serializedAlias, aliasName));
                        }
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new Object[]{sysItemsMap, userItems};
    }

    public void treeNodesChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        if (e.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    private class SidebarViewToModelNode
    extends Node
    implements Comparable {
        private FileSystemTreeModel.Node target;

        public SidebarViewToModelNode(FileSystemTreeModel.Node target) {
            this.target = target;
        }

        public File getFile() {
            return this.target.getFile();
        }

        public File getResolvedFile() {
            return this.target.getResolvedFile();
        }

        public File lazyGetResolvedFile() {
            return this.target.lazyGetResolvedFile();
        }

        public boolean isTraversable() {
            return this.target.isTraversable();
        }

        public boolean isAcceptable() {
            return this.target.isAcceptable();
        }

        public int getFileLabel() {
            return this.target.getFileLabel();
        }

        public String getUserName() {
            return this.target.getUserName();
        }

        public Icon getIcon() {
            return this.target.getIcon();
        }

        public long getFileLength() {
            return this.target.getFileLength();
        }

        public String getFileKind() {
            return this.target.getFileKind();
        }

        public boolean isValidating() {
            return this.target.isValidating();
        }

        public FileSystemTreeModel.Node getTarget() {
            return this.target;
        }

        public String toString() {
            return this.target.toString();
        }

        public int compareTo(Object o) {
            return this.compareTo((SidebarViewToModelNode)o);
        }

        public int compareTo(SidebarViewToModelNode that) {
            SystemItemInfo i2;
            FileSystemTreeModel.Node o1 = this.getTarget();
            FileSystemTreeModel.Node o2 = that.getTarget();
            SystemItemInfo i1 = (SystemItemInfo)SidebarTreeModel.this.systemItemsMap.get(o1.getUserName());
            if (i1 == null && o1.getResolvedFile().getName().equals("")) {
                i1 = (SystemItemInfo)SidebarTreeModel.this.systemItemsMap.get("Computer");
            }
            if ((i2 = (SystemItemInfo)SidebarTreeModel.this.systemItemsMap.get(o2.getUserName())) == null && o2.getResolvedFile().getName().equals("")) {
                i2 = (SystemItemInfo)SidebarTreeModel.this.systemItemsMap.get("Computer");
            }
            if (i1 != null && i2 != null) {
                return i1.sequenceNumber - i2.sequenceNumber;
            }
            if (i1 != null) {
                return -1;
            }
            if (i2 != null) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof SidebarViewToModelNode ? this.compareTo((SidebarViewToModelNode)o) == 0 : false;
        }

        public int hashCode() {
            return this.getTarget() == null ? 0 : this.getTarget().getUserName().hashCode();
        }
    }

    private static class SystemItemInfo {
        String name = "";
        int sequenceNumber = 0;
        boolean isVisible = true;

        private SystemItemInfo() {
        }
    }

    private class AliasNode
    extends Node {
        private byte[] serializedAlias;
        private File file;
        private Icon icon;
        private String userName;
        private String aliasName;
        private boolean isTraversable;
        protected int fileLabel;

        public AliasNode(byte[] serializedAlias, String aliasName) {
            this.fileLabel = -1;
            this.file = null;
            this.aliasName = aliasName;
            this.serializedAlias = serializedAlias;
            this.isTraversable = true;
        }

        public File lazyGetResolvedFile() {
            return this.getResolvedFile();
        }

        public File getResolvedFile() {
            if (this.file == null) {
                this.icon = null;
                this.file = OSXFile.resolveAlias(this.serializedAlias, false);
            }
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        public String getFileKind() {
            return null;
        }

        public int getFileLabel() {
            return -1;
        }

        public long getFileLength() {
            return -1L;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (this.file != null && !UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(AliasNode.this.file);
                        }

                        @Override
                        public void done(Icon value) {
                            AliasNode.this.icon = value;
                            int[] changedIndices = new int[]{AliasNode.this.getParent().getIndex(AliasNode.this)};
                            Object[] changedChildren = new Object[]{AliasNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, ((DefaultMutableTreeNode)AliasNode.this.getParent()).getPath(), changedIndices, changedChildren);
                        }
                    });
                }
            }
            return this.icon;
        }

        public String getUserName() {
            if (this.userName == null && this.file != null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName == null ? this.aliasName : this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        public boolean isAcceptable() {
            return true;
        }

        public boolean isValidating() {
            return false;
        }
    }

    private abstract class Node
    extends DefaultMutableTreeNode
    implements FileInfo {
        private Node() {
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isHidden() {
            return false;
        }
    }

    private class FileNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private boolean isTraversable;
        protected int fileLabel = -1;

        public FileNode(File file) {
            this.file = file;
            this.isTraversable = true;
        }

        public File lazyGetResolvedFile() {
            return this.file;
        }

        public File getResolvedFile() {
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean allowsChildren() {
            return false;
        }

        public String getFileKind() {
            return null;
        }

        public int getFileLabel() {
            return -1;
        }

        public long getFileLength() {
            return -1L;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (!UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(FileNode.this.file);
                        }

                        @Override
                        public void done(Icon value) {
                            FileNode.this.icon = value;
                            int[] changedIndices = new int[]{FileNode.this.getParent().getIndex(FileNode.this)};
                            Object[] changedChildren = new Object[]{FileNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, SidebarTreeModel.this.placesNode.getPath(), changedIndices, changedChildren);
                        }
                    });
                }
            }
            return this.icon;
        }

        public String getUserName() {
            if (this.userName == null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        public boolean isAcceptable() {
            return true;
        }

        public boolean isValidating() {
            return false;
        }
    }
}

