/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.dla;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import toxi.geom.PointOctree;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;
import toxi.sim.dla.DLAConfiguration;
import toxi.sim.dla.DLAEventListener;
import toxi.sim.dla.DLAGuideLines;
import toxi.sim.dla.DLAParticle;
import toxi.sim.dla.DLASegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLA {
    protected static final Logger logger = Logger.getLogger(DLA.class.getName());
    protected int numParticles;
    protected DLAParticle currParticle;
    protected PointOctree octree;
    protected PointOctree octreeGuides;
    protected Vec3D currCurvePoint;
    protected Vec3D dirCurvePoint;
    protected Vec3D minBounds;
    protected Vec3D maxBounds;
    protected DLAGuideLines guidelines;
    protected ArrayList<DLASegment> activeSegments = new ArrayList();
    protected List<DLAEventListener> listeners = new ArrayList<DLAEventListener>();
    protected int numActiveSegments = 0;
    protected DLAConfiguration config;

    public DLA(float f) {
        this.octree = this.createOctree(new Vec3D(-0.5f, -0.5f, -0.5f).scale(f), f);
        this.octreeGuides = this.createOctree(new Vec3D(-0.5f, -0.5f, -0.5f).scale(f), f);
        this.minBounds = Vec3D.MAX_VALUE.copy();
        this.maxBounds = Vec3D.MIN_VALUE.copy();
    }

    public DLA(float f, DLAConfiguration dLAConfiguration, DLAGuideLines dLAGuideLines) {
        this(f);
        this.config = dLAConfiguration;
        if (dLAGuideLines != null) {
            this.guidelines = dLAGuideLines;
            this.parseGuidelines();
            this.updateCurvePoint();
        }
    }

    public DLA addListener(DLAEventListener dLAEventListener) {
        this.listeners.add(dLAEventListener);
        logger.info("adding listener: " + dLAEventListener);
        return this;
    }

    public void addParticle(Vec3D vec3D) {
        if (this.octree.addPoint(vec3D.copy())) {
            ++this.numParticles;
            this.minBounds.minSelf((ReadonlyVec3D)vec3D);
            this.maxBounds.maxSelf((ReadonlyVec3D)vec3D);
            if (this.listeners != null) {
                for (DLAEventListener dLAEventListener : this.listeners) {
                    dLAEventListener.dlaNewParticleAdded(this, vec3D);
                }
            }
        }
    }

    protected void alignAttachedParticle(DLAParticle dLAParticle, Vec3D vec3D) {
        Vec3D vec3D2 = dLAParticle.sub(vec3D).normalize();
        vec3D2.interpolateToSelf((ReadonlyVec3D)this.dirCurvePoint, this.config.getCurveAlign());
        vec3D2.scaleSelf(this.config.getGrowthScale());
        vec3D2.normalizeTo(this.config.getParticleRadius());
        dLAParticle.set(vec3D).addSelf(vec3D2);
    }

    protected boolean checkParticle(DLAParticle dLAParticle) {
        ArrayList arrayList = this.octree.getPointsWithinSphere((Vec3D)dLAParticle, this.config.snapDistance);
        float f = this.config.getStickiness();
        if (arrayList != null) {
            float f2 = 2.1474836E9f;
            Vec3D vec3D = null;
            for (Vec3D vec3D2 : arrayList) {
                float f3 = vec3D2.distanceToSquared((ReadonlyVec3D)dLAParticle);
                if (!(f3 < f2)) continue;
                f2 = f3;
                vec3D = vec3D2;
            }
            if (f2 < this.config.getSnapDistanceSquared() && Math.random() < (double)f) {
                this.alignAttachedParticle(dLAParticle, vec3D);
                this.addParticle(dLAParticle);
                return true;
            }
        }
        if (dLAParticle.sub(this.currCurvePoint).magSquared() < this.config.getCurveAttachDistanceSquared() && (arrayList = this.octreeGuides.getPointsWithinSphere((Vec3D)dLAParticle, this.config.getCurveAttachDistance())) != null) {
            for (int i = arrayList.size(); i > 0; --i) {
                if (!(Math.random() < (double)f)) continue;
                this.addParticle(dLAParticle);
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.octree.empty();
        this.octreeGuides.empty();
        this.reset();
    }

    protected PointOctree createOctree(Vec3D vec3D, float f) {
        return new PointOctree(vec3D, f);
    }

    public DLAConfiguration getConfig() {
        return this.config;
    }

    public Vec3D getCurrentCurvePoint() {
        return this.currCurvePoint;
    }

    public DLAParticle getCurrentParticle() {
        return this.currParticle;
    }

    public DLAGuideLines getGuidelines() {
        return this.guidelines;
    }

    public PointOctree getGuideOctree() {
        return this.octreeGuides;
    }

    public int getNumActiveSegments() {
        return this.numActiveSegments;
    }

    public int getNumParticles() {
        return this.numParticles;
    }

    public PointOctree getParticleOctree() {
        return this.octree;
    }

    public List<Vec3D> getParticles() {
        return this.octree.getPoints();
    }

    protected void parseGuidelines() {
        this.guidelines.reset();
        this.octreeGuides.empty();
        while (!this.guidelines.isComplete()) {
            double d = this.config.getGuideLineDensity();
            this.guidelines.updatePoint(d);
            Vec3D vec3D = this.guidelines.getPoint();
            this.octreeGuides.addPoint(vec3D);
        }
        this.guidelines.reset();
    }

    public DLA removeListener(DLAEventListener dLAEventListener) {
        this.listeners.remove(dLAEventListener);
        logger.info("removing listener: " + dLAEventListener);
        return this;
    }

    public void reset() {
        this.guidelines.reset();
        this.updateCurvePoint();
    }

    public void save(String string, boolean bl) {
        List list = this.octree.getPoints();
        if (list != null) {
            Vec3D vec3D = this.minBounds.add(this.maxBounds).scaleSelf(0.5f);
            logger.info("bounds: " + this.minBounds + " -> " + this.maxBounds + " offset origin: " + vec3D);
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                int n = list.size() * 4 * 3;
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
                if (bl) {
                    for (Vec3D vec3D2 : list) {
                        vec3D2 = vec3D2.sub(vec3D);
                        mappedByteBuffer.putFloat(vec3D2.x);
                        mappedByteBuffer.putFloat(vec3D2.y);
                        mappedByteBuffer.putFloat(vec3D2.z);
                    }
                } else {
                    for (Vec3D vec3D3 : list) {
                        mappedByteBuffer.putFloat(vec3D3.x);
                        mappedByteBuffer.putFloat(vec3D3.y);
                        mappedByteBuffer.putFloat(vec3D3.z);
                    }
                }
                mappedByteBuffer.force();
                fileChannel.close();
                randomAccessFile.close();
                logger.info("written " + list.size() + " particles to " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void saveAsText(String string, boolean bl) {
        List list = this.octree.getPoints();
        if (list != null) {
            Vec3D vec3D = this.minBounds.add(this.maxBounds).scaleSelf(0.5f);
            logger.info("bounds: " + this.minBounds + " -> " + this.maxBounds + " offset origin: " + vec3D);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                for (Vec3D vec3D2 : this.octree.getPoints()) {
                    StringBuilder stringBuilder = new StringBuilder(36);
                    stringBuilder.append(vec3D2.x).append(',').append(vec3D2.y).append(',').append(vec3D2.z).append("\n");
                    bufferedWriter.write(stringBuilder.toString());
                }
                bufferedWriter.close();
                logger.info("written " + list.size() + " particles to " + string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setConfig(DLAConfiguration dLAConfiguration) {
        this.config = dLAConfiguration;
    }

    public void setGuidelines(DLAGuideLines dLAGuideLines) {
        this.guidelines = dLAGuideLines;
        this.parseGuidelines();
        this.updateCurvePoint();
    }

    public void update() {
        if (this.currParticle == null) {
            Vec3D vec3D = Vec3D.randomVector();
            vec3D = this.currCurvePoint.add(vec3D.scale(MathUtils.random((float)this.config.getSpawnRadius())));
            this.currParticle = new DLAParticle(vec3D, this.config.getEscapeRadius(), this.config.getParticleSpeed(), this.config.getSearchSpeed());
        }
        this.currParticle.update(this.currCurvePoint);
        if (this.checkParticle(this.currParticle)) {
            this.currParticle = null;
            this.updateCurvePoint();
        }
    }

    public void update(int n) {
        for (int i = 0; i < n; ++i) {
            this.update();
        }
    }

    protected void updateCurvePoint() {
        Object object;
        if (Math.random() < (double)this.config.getContinuousGrowthRatio() && this.numActiveSegments > 0) {
            object = this.activeSegments.get((int)(this.config.getContinuousGrowthCoeff() * (float)(this.numActiveSegments - 1)));
            float f = MathUtils.random((float)1.0f);
            this.dirCurvePoint = object.getDirectionAt(f);
            this.currCurvePoint = object.a.add(this.dirCurvePoint.scale(object.getLength() * f));
        } else {
            object = this.guidelines.updatePoint(this.config.getCurveSpeed());
            if (!this.activeSegments.contains(object)) {
                this.activeSegments.add((DLASegment)((Object)object));
                ++this.numActiveSegments;
                if (this.listeners != null) {
                    for (DLAEventListener dLAEventListener : this.listeners) {
                        dLAEventListener.dlaSegmentSwitched(this, (DLASegment)((Object)object));
                    }
                }
            }
            this.currCurvePoint = this.guidelines.getPoint();
            this.dirCurvePoint = this.guidelines.getDirection();
        }
        if (this.guidelines.isComplete()) {
            this.guidelines.reset();
            if (this.listeners != null) {
                for (DLAEventListener dLAEventListener : this.listeners) {
                    dLAEventListener.dlaAllSegmentsProcessed(this);
                }
            }
        }
    }
}

