/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.dla;

import toxi.geom.Vec3D;
import toxi.util.datatypes.BiasedFloatRange;

public class DLAConfiguration {
    protected float snapDistance = 1.8f;
    protected float snapDistanceSquared = this.snapDistance * this.snapDistance;
    protected float curveAttachDistance = 2.0f;
    protected float curveAttachDistanceSquared = this.curveAttachDistance * this.curveAttachDistance;
    protected float spawnRadius = 12.0f;
    protected float escapeRadius = 36.0f;
    protected float particleRadius = 0.25f;
    protected float stickiness = 0.1f;
    protected float curveAlign = 0.74f;
    protected float curveSpeed = 4.5E-4f;
    protected float searchSpeed = this.snapDistance * 0.66f;
    protected float particleSpeed = 0.001f;
    protected double guideLineDensity = 0.1;
    protected float continuousGrowthRatio = 0.1f;
    protected Vec3D growthScale = new Vec3D(1.0f, 1.0f, 1.0f);
    protected BiasedFloatRange growthBiasRange = new BiasedFloatRange(0.0f, 1.0f, 0.0f, 1.0f);

    public float getContinuousGrowthBias() {
        return this.growthBiasRange.getBias();
    }

    public float getContinuousGrowthCoeff() {
        return this.growthBiasRange.pickRandom();
    }

    public float getContinuousGrowthRatio() {
        return this.continuousGrowthRatio;
    }

    public float getCurveAlign() {
        return this.curveAlign;
    }

    public float getCurveAttachDistance() {
        return this.curveAttachDistance;
    }

    public float getCurveAttachDistanceSquared() {
        return this.curveAttachDistanceSquared;
    }

    public float getCurveSpeed() {
        return this.curveSpeed;
    }

    public float getEscapeRadius() {
        return this.escapeRadius;
    }

    public Vec3D getGrowthScale() {
        return this.growthScale;
    }

    public double getGuideLineDensity() {
        return this.guideLineDensity;
    }

    public float getParticleRadius() {
        return this.particleRadius;
    }

    public float getParticleSpeed() {
        return this.particleSpeed;
    }

    public float getSearchSpeed() {
        return this.searchSpeed;
    }

    public float getSnapDistance() {
        return this.snapDistance;
    }

    public float getSnapDistanceSquared() {
        return this.snapDistanceSquared;
    }

    public float getSpawnRadius() {
        return this.spawnRadius;
    }

    public float getStickiness() {
        return this.stickiness;
    }

    public void setContinuousGrowthBias(float f, float f2) {
        this.growthBiasRange.setBias(f);
        this.growthBiasRange.setStandardDeviation(f2);
    }

    public void setContinuousGrowthRatio(float f) {
        this.continuousGrowthRatio = f;
    }

    public void setCurveAlign(float f) {
        this.curveAlign = f;
    }

    public void setCurveAttachDistance(float f) {
        this.curveAttachDistance = f;
    }

    public void setCurveSpeed(float f) {
        this.curveSpeed = f;
    }

    public void setEscapeRadius(float f) {
        this.escapeRadius = f;
    }

    public void setGrowthScale(Vec3D vec3D) {
        this.growthScale = vec3D;
    }

    public void setGuideLineDensity(double d) {
        this.guideLineDensity = d;
    }

    public void setParticleRadius(float f) {
        this.particleRadius = f;
    }

    public void setParticleSpeed(float f) {
        this.particleSpeed = f;
    }

    public void setSearchSpeed(float f) {
        this.searchSpeed = f;
    }

    public void setSnapDistance(float f) {
        this.snapDistance = f;
    }

    public void setSpawnRadius(float f) {
        this.spawnRadius = f;
    }

    public void setStickiness(float f) {
        this.stickiness = f;
    }
}

