/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.grayscott;

import toxi.geom.Rect;
import toxi.math.MathUtils;

public class GrayScott {
    public float[] u;
    public float[] v;
    protected float[] uu;
    protected float[] vv;
    protected int width;
    protected int height;
    protected float f;
    protected float k;
    protected float dU;
    protected float dV;
    protected boolean isTiling;

    public GrayScott(int n, int n2, boolean bl) {
        this.width = n;
        this.height = n2;
        this.u = new float[n * n2];
        this.v = new float[this.u.length];
        this.uu = new float[this.u.length];
        this.vv = new float[this.u.length];
        this.isTiling = bl;
        this.reset();
        this.setCoefficients(0.023f, 0.077f, 0.16f, 0.08f);
    }

    public float getCurrentUAt(int n, int n2) {
        if (n2 >= 0 && n2 < this.height && n >= 0 && n < this.width) {
            return this.u[n2 * this.width + n];
        }
        return 0.0f;
    }

    public float getCurrentVAt(int n, int n2) {
        if (n2 >= 0 && n2 < this.height && n >= 0 && n < this.width) {
            return this.v[n2 * this.width + n];
        }
        return 0.0f;
    }

    public float getDiffuseU() {
        return this.dU;
    }

    public float getDiffuseV() {
        return this.dV;
    }

    public float getF() {
        return this.f;
    }

    public float getFCoeffAt(int n, int n2) {
        return this.f;
    }

    public float getK() {
        return this.k;
    }

    public float getKCoeffAt(int n, int n2) {
        return this.k;
    }

    public boolean isTiling() {
        return this.isTiling;
    }

    public void reset() {
        for (int i = 0; i < this.uu.length; ++i) {
            this.uu[i] = 1.0f;
            this.vv[i] = 0.0f;
        }
    }

    public void seedImage(int[] nArray, int n, int n2) {
        int n3 = MathUtils.clip((int)((this.width - n) / 2), (int)0, (int)(this.width - 1));
        int n4 = MathUtils.clip((int)((this.height - n2) / 2), (int)0, (int)(this.height - 1));
        n = MathUtils.min((int)n, (int)this.width);
        n2 = MathUtils.min((int)n2, (int)this.height);
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n;
            for (int j = 0; j < n; ++j) {
                if (0 >= (nArray[n5 + j] & 0xFF)) continue;
                int n6 = (n4 + i) * this.width + n3 + j;
                this.uu[n6] = 0.5f;
                this.vv[n6] = 0.25f;
            }
        }
    }

    public void setCoefficients(float f, float f2, float f3, float f4) {
        this.f = f;
        this.k = f2;
        this.dU = f3;
        this.dV = f4;
    }

    public void setDiffuseU(float f) {
        this.dU = f;
    }

    public void setDiffuseV(float f) {
        this.dV = f;
    }

    public void setF(float f) {
        this.f = f;
    }

    public void setK(float f) {
        this.k = f;
    }

    public void setRect(int n, int n2, int n3, int n4) {
        int n5 = MathUtils.clip((int)(n - n3 / 2), (int)0, (int)this.width);
        int n6 = MathUtils.clip((int)(n + n3 / 2), (int)0, (int)this.width);
        int n7 = MathUtils.clip((int)(n2 - n4 / 2), (int)0, (int)this.height);
        int n8 = MathUtils.clip((int)(n2 + n4 / 2), (int)0, (int)this.height);
        for (int i = n7; i < n8; ++i) {
            for (int j = n5; j < n6; ++j) {
                int n9 = i * this.width + j;
                this.uu[n9] = 0.5f;
                this.vv[n9] = 0.25f;
            }
        }
    }

    public void setRect(Rect rect) {
        this.setRect((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    public void setTiling(boolean bl) {
        this.isTiling = bl;
    }

    public void update(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        f = MathUtils.clip((float)f, (float)0.0f, (float)1.0f);
        int n8 = this.width - 1;
        int n9 = this.height - 1;
        for (n7 = 1; n7 < n9; ++n7) {
            for (n6 = 1; n6 < n8; ++n6) {
                n5 = n7 * this.width + n6;
                n4 = n5 - this.width;
                n3 = n5 + this.width;
                n2 = n5 - 1;
                n = n5 + 1;
                f6 = this.getFCoeffAt(n6, n7);
                f5 = this.getKCoeffAt(n6, n7);
                f4 = this.uu[n5];
                f3 = this.vv[n5];
                f2 = f4 * f3 * f3;
                this.u[n5] = MathUtils.max((float)0.0f, (float)(f4 + f * (this.dU * (this.uu[n] + this.uu[n2] + this.uu[n3] + this.uu[n4] - 4.0f * f4) - f2 + f6 * (1.0f - f4))));
                this.v[n5] = MathUtils.max((float)0.0f, (float)(f3 + f * (this.dV * (this.vv[n] + this.vv[n2] + this.vv[n3] + this.vv[n4] - 4.0f * f3) + f2 - f5 * f3)));
            }
        }
        if (this.isTiling) {
            n7 = n8 - 1;
            n6 = n9 * this.width;
            n5 = (n9 - 1) * this.width;
            for (n4 = 0; n4 < this.width; ++n4) {
                n3 = n4 == 0 ? n8 : n4 - 1;
                n2 = n4 == n8 ? 0 : n4 + 1;
                n = n6 + n4;
                f6 = this.uu[n4];
                f5 = this.vv[n4];
                f4 = this.uu[n];
                f3 = this.vv[n];
                f2 = f6 * f5 * f5;
                this.u[n4] = MathUtils.max((float)0.0f, (float)(f6 + f * (this.dU * (this.uu[n2] + this.uu[n3] + this.uu[this.width + n4] + f4 - 4.0f * f6) - f2 + this.f * (1.0f - f6))));
                this.v[n4] = MathUtils.max((float)0.0f, (float)(f5 + f * (this.dV * (this.vv[n2] + this.vv[n3] + this.vv[this.width + n4] + f3 - 4.0f * f5) + f2 - this.k * f5)));
                f2 = f4 * f3 * f3;
                this.u[n] = MathUtils.max((float)0.0f, (float)(f4 + f * (this.dU * (this.uu[n6 + n2] + this.uu[n6 + n3] + f6 + this.uu[n5 + n4] - 4.0f * f4) - f2 + this.f * (1.0f - f4))));
                this.v[n] = MathUtils.max((float)0.0f, (float)(f3 + f * (this.dU * (this.vv[n6 + n2] + this.vv[n6 + n3] + f5 + this.vv[n5 + n4] - 4.0f * f3) + f2 - this.k * f3)));
            }
            for (n4 = 0; n4 < this.height; ++n4) {
                n3 = n4 * this.width;
                n2 = n3 + n8;
                n = n3 + n7;
                f6 = this.uu[n3];
                f5 = this.vv[n3];
                f4 = this.uu[n2];
                f3 = this.vv[n2];
                f2 = f6 * f5 * f5;
                int n10 = (n4 == 0 ? n9 : n4 - 1) * this.width;
                int n11 = (n4 == n9 ? 0 : n4 + 1) * this.width;
                this.u[n3] = MathUtils.max((float)0.0f, (float)(f6 + f * (this.dU * (this.uu[n3 + 1] + f4 + this.uu[n11] + this.uu[n10] - 4.0f * f6) - f2 + this.f * (1.0f - f6))));
                this.v[n3] = MathUtils.max((float)0.0f, (float)(f5 + f * (this.dV * (this.vv[n3 + 1] + f3 + this.vv[n11] + this.vv[n10] - 4.0f * f5) + f2 - this.k * f5)));
                f2 = f4 * f3 * f3;
                this.u[n2] = MathUtils.max((float)0.0f, (float)(f4 + f * (this.dU * (f6 + this.uu[n] + this.uu[n11 + n8] + this.uu[n10 + n8] - 4.0f * f4) - f2 + this.f * (1.0f - f4))));
                this.v[n2] = MathUtils.max((float)0.0f, (float)(f3 + f * (this.dV * (f5 + this.vv[n] + this.vv[n11 + n8] + this.vv[n10 + n8] - 4.0f * f3) + f2 - this.k * f3)));
            }
        }
        System.arraycopy(this.u, 0, this.uu, 0, this.u.length);
        System.arraycopy(this.v, 0, this.vv, 0, this.v.length);
    }
}

