/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import toxi.audio.JOALUtil;
import toxi.geom.Vec3D;

public class SoundListener
extends Vec3D {
    protected JOALUtil liboal;
    protected final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected final float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
    protected final float[] orient = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    protected SoundListener(JOALUtil jOALUtil) {
        this.liboal = jOALUtil;
        this.setGain(1.0f);
        this.setPosition(this.position);
        this.setVelocity(this.velocity);
        this.setOrientation(this.orient);
    }

    public final float[] getOrientation() {
        return this.orient;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public final float[] getVelocity() {
        return this.velocity;
    }

    public SoundListener setGain(float f) {
        this.liboal.getAL().alListenerf(4106, f);
        return this;
    }

    public SoundListener setOrientation(float f, float f2, float f3, float f4, float f5, float f6) {
        this.orient[0] = f;
        this.orient[1] = f2;
        this.orient[2] = f3;
        this.orient[3] = f4;
        this.orient[4] = f5;
        this.orient[5] = f6;
        this.liboal.getAL().alListenerfv(4111, this.orient, 0);
        return this;
    }

    public SoundListener setOrientation(float[] fArray) {
        if (fArray.length != 6) {
            throw new IllegalArgumentException("wrong number of array elements");
        }
        this.orient[0] = fArray[0];
        this.orient[1] = fArray[1];
        this.orient[2] = fArray[2];
        this.orient[3] = fArray[3];
        this.orient[4] = fArray[4];
        this.orient[5] = fArray[5];
        this.liboal.getAL().alListenerfv(4111, this.orient, 0);
        return this;
    }

    public SoundListener setPosition(float f, float f2, float f3) {
        this.x = this.position[0] = f;
        this.y = this.position[1] = f2;
        this.z = this.position[2] = f3;
        this.liboal.getAL().alListenerfv(4100, this.position, 0);
        return this;
    }

    public SoundListener setPosition(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("wrong number of elements");
        }
        this.x = this.position[0] = fArray[0];
        this.y = this.position[1] = fArray[1];
        this.z = this.position[2] = fArray[2];
        this.liboal.getAL().alListenerfv(4100, this.position, 0);
        return this;
    }

    public SoundListener setVelocity(float f, float f2, float f3) {
        this.velocity[0] = f;
        this.velocity[1] = f2;
        this.velocity[2] = f3;
        this.liboal.getAL().alListenerfv(4102, this.velocity, 0);
        return this;
    }

    public SoundListener setVelocity(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("wrong number of elements");
        }
        this.velocity[0] = fArray[0];
        this.velocity[1] = fArray[1];
        this.velocity[2] = fArray[2];
        this.liboal.getAL().alListenerfv(4102, this.velocity, 0);
        return this;
    }

    public SoundListener updatePosition() {
        this.position[0] = this.x;
        this.position[1] = this.y;
        this.position[2] = this.z;
        this.liboal.getAL().alListenerfv(4100, this.position, 0);
        return this;
    }
}

