/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Rect;
import toxi.geom.Vec3D;
import toxi.math.InterpolateStrategy;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vec2D
implements Comparable<ReadonlyVec2D>,
ReadonlyVec2D {
    public static final ReadonlyVec2D X_AXIS = new Vec2D(1.0f, 0.0f);
    public static final ReadonlyVec2D Y_AXIS = new Vec2D(0.0f, 1.0f);
    public static final ReadonlyVec2D ZERO = new Vec2D();
    public static final ReadonlyVec2D MIN_VALUE = new Vec2D(Float.MIN_VALUE, Float.MIN_VALUE);
    public static final ReadonlyVec2D MAX_VALUE = new Vec2D(Float.MAX_VALUE, Float.MAX_VALUE);
    @XmlAttribute(required=true)
    public float x;
    @XmlAttribute(required=true)
    public float y;

    public static final Vec2D fromTheta(float f) {
        return new Vec2D((float)Math.cos(f), (float)Math.sin(f));
    }

    public static final Vec2D max(Vec2D vec2D, Vec2D vec2D2) {
        return new Vec2D(MathUtils.max(vec2D.x, vec2D2.x), MathUtils.max(vec2D.y, vec2D2.y));
    }

    public static final Vec2D min(Vec2D vec2D, Vec2D vec2D2) {
        return new Vec2D(MathUtils.min(vec2D.x, vec2D2.x), MathUtils.min(vec2D.y, vec2D2.y));
    }

    public static final Vec2D randomVector() {
        return Vec2D.randomVector(MathUtils.RND);
    }

    public static final Vec2D randomVector(Random random) {
        Vec2D vec2D = new Vec2D(random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f);
        return vec2D.normalize();
    }

    public Vec2D() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vec2D(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vec2D(ReadonlyVec2D readonlyVec2D) {
        this.x = readonlyVec2D.x();
        this.y = readonlyVec2D.y();
    }

    public final Vec2D abs() {
        this.x = MathUtils.abs(this.x);
        this.y = MathUtils.abs(this.y);
        return this;
    }

    @Override
    public final Vec2D add(float f, float f2) {
        return new Vec2D(this.x + f, this.y + f2);
    }

    @Override
    public Vec2D add(ReadonlyVec2D readonlyVec2D) {
        return new Vec2D(this.x + readonlyVec2D.x(), this.y + readonlyVec2D.y());
    }

    public final Vec2D add(Vec2D vec2D) {
        return new Vec2D(this.x + vec2D.x, this.y + vec2D.y);
    }

    public final Vec2D addSelf(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public final Vec2D addSelf(Vec2D vec2D) {
        this.x += vec2D.x;
        this.y += vec2D.y;
        return this;
    }

    @Override
    public final float angleBetween(ReadonlyVec2D readonlyVec2D) {
        return (float)Math.acos(this.dot(readonlyVec2D));
    }

    @Override
    public final float angleBetween(ReadonlyVec2D readonlyVec2D, boolean bl) {
        float f = bl ? this.getNormalized().dot(readonlyVec2D.getNormalized()) : this.dot(readonlyVec2D);
        return (float)Math.acos(f);
    }

    @Override
    public Vec3D bisect(Vec2D vec2D) {
        Vec2D vec2D2 = this.sub(vec2D);
        Vec2D vec2D3 = this.add(vec2D);
        float f = vec2D2.dot(vec2D3);
        return new Vec3D(vec2D2.x, vec2D2.y, -f / 2.0f);
    }

    public final Vec2D clear() {
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    @Override
    public int compareTo(ReadonlyVec2D readonlyVec2D) {
        if (this.x == readonlyVec2D.x() && this.y == readonlyVec2D.y()) {
            return 0;
        }
        return (int)(this.magSquared() - readonlyVec2D.magSquared());
    }

    public final Vec2D constrain(Rect rect) {
        this.x = MathUtils.clip(this.x, rect.x, rect.x + rect.width);
        this.y = MathUtils.clip(this.y, rect.y, rect.y + rect.height);
        return this;
    }

    public final Vec2D constrain(Vec2D vec2D, Vec2D vec2D2) {
        this.x = MathUtils.clip(this.x, vec2D.x, vec2D2.x);
        this.y = MathUtils.clip(this.y, vec2D.y, vec2D2.y);
        return this;
    }

    @Override
    public final Vec2D copy() {
        return new Vec2D(this);
    }

    @Override
    public float cross(ReadonlyVec2D readonlyVec2D) {
        return this.x * readonlyVec2D.y() - this.y * readonlyVec2D.x();
    }

    @Override
    public final float distanceTo(ReadonlyVec2D readonlyVec2D) {
        if (readonlyVec2D != null) {
            float f = this.x - readonlyVec2D.x();
            float f2 = this.y - readonlyVec2D.y();
            return (float)Math.sqrt(f * f + f2 * f2);
        }
        return Float.NaN;
    }

    @Override
    public final float distanceToSquared(ReadonlyVec2D readonlyVec2D) {
        if (readonlyVec2D != null) {
            float f = this.x - readonlyVec2D.x();
            float f2 = this.y - readonlyVec2D.y();
            return f * f + f2 * f2;
        }
        return Float.NaN;
    }

    @Override
    public final float dot(ReadonlyVec2D readonlyVec2D) {
        return this.x * readonlyVec2D.x() + this.y * readonlyVec2D.y();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ReadonlyVec2D) {
            ReadonlyVec2D readonlyVec2D = (ReadonlyVec2D)object;
            return this.x == readonlyVec2D.x() && this.y == readonlyVec2D.y();
        }
        return false;
    }

    @Override
    public boolean equalsWithTolerance(ReadonlyVec2D readonlyVec2D, float f) {
        return MathUtils.abs(this.x - readonlyVec2D.x()) < f && MathUtils.abs(this.y - readonlyVec2D.y()) < f;
    }

    public final Vec2D floor() {
        this.x = MathUtils.floor(this.x);
        this.y = MathUtils.floor(this.y);
        return this;
    }

    public final Vec2D frac() {
        this.x -= (float)MathUtils.floor(this.x);
        this.y -= (float)MathUtils.floor(this.y);
        return this;
    }

    @Override
    public final Vec2D getAbs() {
        return new Vec2D(this).abs();
    }

    @Override
    public float getComponent(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
        }
        return 0.0f;
    }

    @Override
    public final float getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException("index must be 0 or 1");
    }

    @Override
    public final Vec2D getConstrained(Rect rect) {
        return new Vec2D(this).constrain(rect);
    }

    @Override
    public final Vec2D getFloored() {
        return new Vec2D(this).floor();
    }

    @Override
    public final Vec2D getFrac() {
        return new Vec2D(this).frac();
    }

    @Override
    public final Vec2D getInverted() {
        return new Vec2D(-this.x, -this.y);
    }

    @Override
    public final Vec2D getLimited(float f) {
        if (this.magSquared() > f * f) {
            return this.getNormalizedTo(f);
        }
        return new Vec2D(this);
    }

    @Override
    public final Vec2D getNormalized() {
        return new Vec2D(this).normalize();
    }

    @Override
    public final Vec2D getNormalizedTo(float f) {
        return new Vec2D(this).normalizeTo(f);
    }

    @Override
    public final Vec2D getPerpendicular() {
        return new Vec2D(this).perpendicular();
    }

    @Override
    public final Vec2D getReciprocal() {
        return this.copy().reciprocal();
    }

    @Override
    public final Vec2D getReflected(ReadonlyVec2D readonlyVec2D) {
        return this.copy().reflect(readonlyVec2D);
    }

    @Override
    public final Vec2D getRotated(float f) {
        return new Vec2D(this).rotate(f);
    }

    @Override
    public Vec2D getSignum() {
        return new Vec2D(this).signum();
    }

    public int hashCode() {
        return 37 * Float.floatToIntBits(this.x) + Float.floatToIntBits(this.y);
    }

    @Override
    public final float heading() {
        return (float)Math.atan2(this.y, this.x);
    }

    @Override
    public Vec2D interpolateTo(ReadonlyVec2D readonlyVec2D, float f) {
        return new Vec2D(this.x + (readonlyVec2D.x() - this.x) * f, this.y + (readonlyVec2D.y() - this.y) * f);
    }

    @Override
    public Vec2D interpolateTo(ReadonlyVec2D readonlyVec2D, float f, InterpolateStrategy interpolateStrategy) {
        return new Vec2D(interpolateStrategy.interpolate(this.x, readonlyVec2D.x(), f), interpolateStrategy.interpolate(this.y, readonlyVec2D.y(), f));
    }

    public final Vec2D interpolateTo(Vec2D vec2D, float f) {
        return new Vec2D(this.x + (vec2D.x - this.x) * f, this.y + (vec2D.y - this.y) * f);
    }

    public Vec2D interpolateTo(Vec2D vec2D, float f, InterpolateStrategy interpolateStrategy) {
        return new Vec2D(interpolateStrategy.interpolate(this.x, vec2D.x, f), interpolateStrategy.interpolate(this.y, vec2D.y, f));
    }

    public final Vec2D interpolateToSelf(ReadonlyVec2D readonlyVec2D, float f) {
        this.x += (readonlyVec2D.x() - this.x) * f;
        this.y += (readonlyVec2D.y() - this.y) * f;
        return this;
    }

    public Vec2D interpolateToSelf(ReadonlyVec2D readonlyVec2D, float f, InterpolateStrategy interpolateStrategy) {
        this.x = interpolateStrategy.interpolate(this.x, readonlyVec2D.x(), f);
        this.y = interpolateStrategy.interpolate(this.y, readonlyVec2D.y(), f);
        return this;
    }

    public final Vec2D invert() {
        this.x *= -1.0f;
        this.y *= -1.0f;
        return this;
    }

    @Override
    public boolean isInCircle(ReadonlyVec2D readonlyVec2D, float f) {
        float f2 = this.sub(readonlyVec2D).magSquared();
        return f2 <= f * f;
    }

    @Override
    public boolean isInRectangle(Rect rect) {
        if (this.x < rect.x || this.x > rect.x + rect.width) {
            return false;
        }
        return !(this.y < rect.y) && !(this.y > rect.y + rect.height);
    }

    @Override
    public boolean isInTriangle(Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        Vec2D vec2D4 = this.sub(vec2D).normalize();
        Vec2D vec2D5 = this.sub(vec2D2).normalize();
        Vec2D vec2D6 = this.sub(vec2D3).normalize();
        double d = Math.acos(vec2D4.dot(vec2D5));
        d += Math.acos(vec2D5.dot(vec2D6));
        return MathUtils.abs((float)(d += Math.acos(vec2D6.dot(vec2D4))) - (float)Math.PI * 2) <= 0.005f;
    }

    @Override
    public final boolean isMajorAxis(float f) {
        float f2 = MathUtils.abs(this.x);
        float f3 = MathUtils.abs(this.y);
        float f4 = 1.0f - f;
        if (f2 > f4) {
            return f3 < f;
        }
        if (f3 > f4) {
            return f2 < f;
        }
        return false;
    }

    @Override
    public final boolean isZeroVector() {
        return MathUtils.abs(this.x) < 1.1920929E-7f && MathUtils.abs(this.y) < 1.1920929E-7f;
    }

    public final Vec2D jitter(float f) {
        return this.jitter(f, f);
    }

    public final Vec2D jitter(float f, float f2) {
        this.x += MathUtils.normalizedRandom() * f;
        this.y += MathUtils.normalizedRandom() * f2;
        return this;
    }

    public final Vec2D jitter(Random random, float f) {
        return this.jitter(random, f, f);
    }

    public final Vec2D jitter(Random random, float f, float f2) {
        this.x += MathUtils.normalizedRandom(random) * f;
        this.y += MathUtils.normalizedRandom(random) * f2;
        return this;
    }

    public final Vec2D jitter(Random random, Vec2D vec2D) {
        return this.jitter(random, vec2D.x, vec2D.y);
    }

    public final Vec2D jitter(Vec2D vec2D) {
        return this.jitter(vec2D.x, vec2D.y);
    }

    public final Vec2D limit(float f) {
        if (this.magSquared() > f * f) {
            return this.normalize().scaleSelf(f);
        }
        return this;
    }

    @Override
    public final float magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public final float magSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public final Vec2D max(Vec2D vec2D) {
        return new Vec2D(MathUtils.max(this.x, vec2D.x), MathUtils.max(this.y, vec2D.y));
    }

    public final Vec2D maxSelf(Vec2D vec2D) {
        this.x = MathUtils.max(this.x, vec2D.x);
        this.y = MathUtils.max(this.y, vec2D.y);
        return this;
    }

    @Override
    public final Vec2D min(Vec2D vec2D) {
        return new Vec2D(MathUtils.min(this.x, vec2D.x), MathUtils.min(this.y, vec2D.y));
    }

    public final Vec2D minSelf(Vec2D vec2D) {
        this.x = MathUtils.min(this.x, vec2D.x);
        this.y = MathUtils.min(this.y, vec2D.y);
        return this;
    }

    public final Vec2D normalize() {
        float f = this.x * this.x + this.y * this.y;
        if (f > 0.0f) {
            f = 1.0f / (float)Math.sqrt(f);
            this.x *= f;
            this.y *= f;
        }
        return this;
    }

    public final Vec2D normalizeTo(float f) {
        float f2 = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        if (f2 > 0.0f) {
            f2 = f / f2;
            this.x *= f2;
            this.y *= f2;
        }
        return this;
    }

    public final Vec2D perpendicular() {
        float f = this.x;
        this.x = -this.y;
        this.y = f;
        return this;
    }

    public final Vec2D reciprocal() {
        this.x = 1.0f / this.x;
        this.y = 1.0f / this.y;
        return this;
    }

    public final Vec2D reflect(ReadonlyVec2D readonlyVec2D) {
        return this.set(readonlyVec2D.scale(this.dot(readonlyVec2D) * 2.0f).subSelf(this));
    }

    public final Vec2D rotate(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = f2 * this.x - f3 * this.y;
        this.y = f3 * this.x + f2 * this.y;
        this.x = f4;
        return this;
    }

    public final Vec2D roundToAxis() {
        if (MathUtils.abs(this.x) < 0.5f) {
            this.x = 0.0f;
        } else {
            this.x = this.x < 0.0f ? -1.0f : 1.0f;
            this.y = 0.0f;
        }
        if (MathUtils.abs(this.y) < 0.5f) {
            this.y = 0.0f;
        } else {
            this.y = this.y < 0.0f ? -1.0f : 1.0f;
            this.x = 0.0f;
        }
        return this;
    }

    @Override
    public final Vec2D scale(float f) {
        return new Vec2D(this.x * f, this.y * f);
    }

    @Override
    public final Vec2D scale(float f, float f2) {
        return new Vec2D(this.x * f, this.y * f2);
    }

    @Override
    public final Vec2D scale(ReadonlyVec2D readonlyVec2D) {
        return readonlyVec2D.copy().scaleSelf(this);
    }

    @Override
    public final Vec2D scale(Vec2D vec2D) {
        return new Vec2D(this.x * vec2D.x, this.y * vec2D.y);
    }

    public final Vec2D scaleSelf(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public final Vec2D scaleSelf(float f, float f2) {
        this.x *= f;
        this.y *= f2;
        return this;
    }

    public final Vec2D scaleSelf(Vec2D vec2D) {
        this.x *= vec2D.x;
        this.y *= vec2D.y;
        return this;
    }

    public final Vec2D set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public final Vec2D set(ReadonlyVec2D readonlyVec2D) {
        this.x = readonlyVec2D.x();
        this.y = readonlyVec2D.y();
        return this;
    }

    public final Vec2D set(Vec2D vec2D) {
        this.x = vec2D.x;
        this.y = vec2D.y;
        return this;
    }

    public final Vec2D setComponent(Axis axis, float f) {
        switch (axis) {
            case X: {
                this.x = f;
                break;
            }
            case Y: {
                this.y = f;
            }
        }
        return this;
    }

    public final Vec2D setComponent(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            default: {
                throw new IllegalArgumentException("component id needs to be 0 or 1");
            }
        }
        return this;
    }

    public final Vec2D signum() {
        this.x = this.x < 0.0f ? -1 : (this.x == 0.0f ? 0 : 1);
        this.y = this.y < 0.0f ? -1 : (this.y == 0.0f ? 0 : 1);
        return this;
    }

    @Override
    public final Vec2D sub(float f, float f2) {
        return new Vec2D(this.x - f, this.y - f2);
    }

    @Override
    public final Vec2D sub(ReadonlyVec2D readonlyVec2D) {
        return new Vec2D(this.x - readonlyVec2D.x(), this.y - readonlyVec2D.y());
    }

    @Override
    public final Vec2D sub(Vec2D vec2D) {
        return new Vec2D(this.x - vec2D.x, this.y - vec2D.y);
    }

    public final Vec2D subSelf(float f, float f2) {
        this.x -= f;
        this.y -= f2;
        return this;
    }

    public final Vec2D subSelf(Vec2D vec2D) {
        this.x -= vec2D.x;
        this.y -= vec2D.y;
        return this;
    }

    @Override
    public final Vec2D tangentNormalOfEllipse(Vec2D vec2D, Vec2D vec2D2) {
        Vec2D vec2D3 = this.sub(vec2D);
        float f = vec2D2.x * vec2D2.x;
        float f2 = vec2D2.y * vec2D2.y;
        return new Vec2D(vec2D3.x / f, vec2D3.y / f2).normalize();
    }

    @Override
    public final Vec3D to3DXY() {
        return new Vec3D(this.x, this.y, 0.0f);
    }

    @Override
    public final Vec3D to3DXZ() {
        return new Vec3D(this.x, 0.0f, this.y);
    }

    @Override
    public final Vec3D to3DYZ() {
        return new Vec3D(0.0f, this.x, this.y);
    }

    @Override
    public float[] toArray() {
        return new float[]{this.x, this.y};
    }

    @Override
    public final Vec2D toCartesian() {
        float f = (float)((double)this.x * Math.cos(this.y));
        this.y = (float)((double)this.x * Math.sin(this.y));
        this.x = f;
        return this;
    }

    @Override
    public final Vec2D toPolar() {
        float f = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        this.y = (float)Math.atan2(this.y, this.x);
        this.x = f;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("{x:").append(this.x).append(", y:").append(this.y).append("}");
        return stringBuffer.toString();
    }

    @Override
    public final float x() {
        return this.x;
    }

    @Override
    public final float y() {
        return this.y;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X(X_AXIS),
        Y(Y_AXIS);

        private final ReadonlyVec2D vector;

        private Axis(ReadonlyVec2D readonlyVec2D) {
            this.vector = readonlyVec2D;
        }

        public ReadonlyVec2D getVector() {
            return this.vector;
        }
    }
}

