/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh2d;

import toxi.geom.Vec2D;

public class DelaunayVertex {
    private double[] coordinates;

    public static DelaunayVertex circumcenter(DelaunayVertex[] delaunayVertexArray) {
        int n = delaunayVertexArray[0].dimension();
        if (delaunayVertexArray.length - 1 != n) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        DelaunayVertex[] delaunayVertexArray2 = new DelaunayVertex[n];
        for (int i = 0; i < n; ++i) {
            delaunayVertexArray2[i] = delaunayVertexArray[i].bisector(delaunayVertexArray[i + 1]);
        }
        DelaunayVertex delaunayVertex = DelaunayVertex.cross(delaunayVertexArray2);
        double d = delaunayVertex.coordinates[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = delaunayVertex.coordinates[i] / d;
        }
        return new DelaunayVertex(dArray);
    }

    public static double content(DelaunayVertex[] delaunayVertexArray) {
        int n;
        DelaunayVertex[] delaunayVertexArray2 = new DelaunayVertex[delaunayVertexArray.length];
        for (n = 0; n < delaunayVertexArray2.length; ++n) {
            delaunayVertexArray2[n] = delaunayVertexArray[n].extend(1.0);
        }
        n = 1;
        for (int i = 1; i < delaunayVertexArray2.length; ++i) {
            n *= i;
        }
        return DelaunayVertex.determinant(delaunayVertexArray2) / (double)n;
    }

    public static DelaunayVertex cross(DelaunayVertex[] delaunayVertexArray) {
        int n = delaunayVertexArray.length + 1;
        if (n != delaunayVertexArray[0].dimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        double[] dArray = new double[n];
        int n2 = 1;
        try {
            for (int i = 0; i < n; ++i) {
                blArray[i] = false;
                dArray[i] = (double)n2 * DelaunayVertex.determinant(delaunayVertexArray, 0, blArray);
                blArray[i] = true;
                n2 = -n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
        return new DelaunayVertex(dArray);
    }

    public static double determinant(DelaunayVertex[] delaunayVertexArray) {
        if (delaunayVertexArray.length != delaunayVertexArray[0].dimension()) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        boolean[] blArray = new boolean[delaunayVertexArray.length];
        for (int i = 0; i < delaunayVertexArray.length; ++i) {
            blArray[i] = true;
        }
        try {
            return DelaunayVertex.determinant(delaunayVertexArray, 0, blArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
    }

    private static double determinant(DelaunayVertex[] delaunayVertexArray, int n, boolean[] blArray) {
        if (n == delaunayVertexArray.length) {
            return 1.0;
        }
        double d = 0.0;
        int n2 = 1;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            blArray[i] = false;
            d += (double)n2 * delaunayVertexArray[n].coordinates[i] * DelaunayVertex.determinant(delaunayVertexArray, n + 1, blArray);
            blArray[i] = true;
            n2 = -n2;
        }
        return d;
    }

    public static String toString(DelaunayVertex[] delaunayVertexArray) {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (DelaunayVertex delaunayVertex : delaunayVertexArray) {
            stringBuilder.append(" " + delaunayVertex);
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public DelaunayVertex(double ... dArray) {
        this.coordinates = new double[dArray.length];
        System.arraycopy(dArray, 0, this.coordinates, 0, dArray.length);
    }

    public DelaunayVertex add(DelaunayVertex delaunayVertex) {
        int n = this.dimCheck(delaunayVertex);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coordinates[i] + delaunayVertex.coordinates[i];
        }
        return new DelaunayVertex(dArray);
    }

    public double angle(DelaunayVertex delaunayVertex) {
        return Math.acos(this.dot(delaunayVertex) / (this.magnitude() * delaunayVertex.magnitude()));
    }

    public DelaunayVertex bisector(DelaunayVertex delaunayVertex) {
        this.dimCheck(delaunayVertex);
        DelaunayVertex delaunayVertex2 = this.subtract(delaunayVertex);
        DelaunayVertex delaunayVertex3 = this.add(delaunayVertex);
        double d = delaunayVertex2.dot(delaunayVertex3);
        return delaunayVertex2.extend(-d / 2.0);
    }

    public double coord(int n) {
        return this.coordinates[n];
    }

    public int dimCheck(DelaunayVertex delaunayVertex) {
        int n = this.coordinates.length;
        if (n != delaunayVertex.coordinates.length) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        return n;
    }

    public int dimension() {
        return this.coordinates.length;
    }

    public double dot(DelaunayVertex delaunayVertex) {
        int n = this.dimCheck(delaunayVertex);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.coordinates[i] * delaunayVertex.coordinates[i];
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DelaunayVertex)) {
            return false;
        }
        DelaunayVertex delaunayVertex = (DelaunayVertex)object;
        if (this.coordinates.length != delaunayVertex.coordinates.length) {
            return false;
        }
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (this.coordinates[i] == delaunayVertex.coordinates[i]) continue;
            return false;
        }
        return true;
    }

    public DelaunayVertex extend(double ... dArray) {
        double[] dArray2 = new double[this.coordinates.length + dArray.length];
        System.arraycopy(this.coordinates, 0, dArray2, 0, this.coordinates.length);
        System.arraycopy(dArray, 0, dArray2, this.coordinates.length, dArray.length);
        return new DelaunayVertex(dArray2);
    }

    public int hashCode() {
        int n = 0;
        for (double d : this.coordinates) {
            long l = Double.doubleToLongBits(d);
            n = 31 * n ^ (int)(l ^ l >> 32);
        }
        return n;
    }

    public boolean isInside(DelaunayVertex[] delaunayVertexArray) {
        int[] nArray;
        for (int n : nArray = this.relation(delaunayVertexArray)) {
            if (n < 0) continue;
            return false;
        }
        return true;
    }

    public DelaunayVertex isOn(DelaunayVertex[] delaunayVertexArray) {
        int[] nArray = this.relation(delaunayVertexArray);
        DelaunayVertex delaunayVertex = null;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                delaunayVertex = delaunayVertexArray[i];
                continue;
            }
            if (nArray[i] <= 0) continue;
            return null;
        }
        return delaunayVertex;
    }

    public DelaunayVertex isOutside(DelaunayVertex[] delaunayVertexArray) {
        int[] nArray = this.relation(delaunayVertexArray);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            return delaunayVertexArray[i];
        }
        return null;
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    public int[] relation(DelaunayVertex[] delaunayVertexArray) {
        int n;
        int n2;
        int n3 = delaunayVertexArray.length - 1;
        if (this.dimension() != n3) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        DelaunayVertex[] delaunayVertexArray2 = new DelaunayVertex[n3 + 1];
        double[] dArray = new double[n3 + 2];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 1.0;
        }
        delaunayVertexArray2[0] = new DelaunayVertex(dArray);
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[0] = this.coordinates[n2];
            for (int i = 0; i < delaunayVertexArray.length; ++i) {
                dArray[i + 1] = delaunayVertexArray[i].coordinates[n2];
            }
            delaunayVertexArray2[n2 + 1] = new DelaunayVertex(dArray);
        }
        DelaunayVertex delaunayVertex = DelaunayVertex.cross(delaunayVertexArray2);
        double d = delaunayVertex.coordinates[0];
        int[] nArray = new int[n3 + 1];
        for (n = 0; n < nArray.length; ++n) {
            double d2 = delaunayVertex.coordinates[n + 1];
            nArray[n] = Math.abs(d2) <= 1.0E-6 * Math.abs(d) ? 0 : (d2 < 0.0 ? -1 : 1);
        }
        if (d < 0.0) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = -nArray[n];
            }
        }
        if (d == 0.0) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = Math.abs(nArray[n]);
            }
        }
        return nArray;
    }

    public DelaunayVertex subtract(DelaunayVertex delaunayVertex) {
        int n = this.dimCheck(delaunayVertex);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coordinates[i] - delaunayVertex.coordinates[i];
        }
        return new DelaunayVertex(dArray);
    }

    public String toString() {
        if (this.coordinates.length == 0) {
            return "DelaunayVertex()";
        }
        String string = "DelaunayVertex(" + this.coordinates[0];
        for (int i = 1; i < this.coordinates.length; ++i) {
            string = string + "," + this.coordinates[i];
        }
        string = string + ")";
        return string;
    }

    public Vec2D toVec2D() {
        return new Vec2D((float)this.coordinates[0], (float)this.coordinates[1]);
    }

    public int vsCircumcircle(DelaunayVertex[] delaunayVertexArray) {
        int n;
        DelaunayVertex[] delaunayVertexArray2 = new DelaunayVertex[delaunayVertexArray.length + 1];
        for (int i = 0; i < delaunayVertexArray.length; ++i) {
            delaunayVertexArray2[i] = delaunayVertexArray[i].extend(1.0, delaunayVertexArray[i].dot(delaunayVertexArray[i]));
        }
        delaunayVertexArray2[delaunayVertexArray.length] = this.extend(1.0, this.dot(this));
        double d = DelaunayVertex.determinant(delaunayVertexArray2);
        int n2 = d < 0.0 ? -1 : (n = d > 0.0 ? 1 : 0);
        if (DelaunayVertex.content(delaunayVertexArray) < 0.0) {
            n = -n;
        }
        return n;
    }
}

