/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.HashMap;
import java.util.logging.Logger;

public class SingletonRegistry {
    public static final SingletonRegistry REGISTRY = new SingletonRegistry();
    private static HashMap<String, Object> map = new HashMap();
    private static Logger logger = Logger.getLogger(SingletonRegistry.class.getName());

    public static synchronized Object getInstanceOf(String string) {
        Object object = map.get(string);
        if (object != null) {
            return object;
        }
        try {
            object = Class.forName(string).newInstance();
            map.put(string, object);
            logger.info("Created singleton: " + object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.severe("Couldn't find class: " + string);
        }
        catch (InstantiationException instantiationException) {
            logger.severe("Couldn't instantiate the class: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.severe("Couldn't access class: " + string);
        }
        return object;
    }

    public static SingletonRegistry getRegistry() {
        return REGISTRY;
    }

    protected SingletonRegistry() {
    }
}

