/*
 * Decompiled with CFR 0.152.
 */
package toxi.data.csv;

import java.util.ArrayList;
import toxi.data.csv.CSVFieldMapper;
import toxi.data.csv.CSVListener;
import toxi.util.events.EventDispatcher;

public class CSVParser {
    protected String[] lines;
    protected int currLineIndex;
    protected char quoteChar = (char)34;
    protected char separator = (char)44;
    protected CSVFieldMapper mapper;
    protected EventDispatcher<CSVListener> dispatcher = new EventDispatcher();

    public CSVParser(CSVFieldMapper cSVFieldMapper) {
        this.mapper = cSVFieldMapper;
    }

    public CSVFieldMapper getMapper() {
        return this.mapper;
    }

    protected final String getNextLine() {
        ++this.currLineIndex;
        if (this.currLineIndex < this.lines.length) {
            return this.lines[this.currLineIndex];
        }
        return null;
    }

    public void parse(String[] stringArray) {
        this.lines = stringArray;
        this.currLineIndex = -1;
        if (this.mapper.setColumnOrder(this.parseLine(this.getNextLine()))) {
            while (this.currLineIndex < stringArray.length - 1) {
                String[] stringArray2 = this.parseLine(this.getNextLine());
                if (stringArray2.length >= this.mapper.getMappedFieldCount()) {
                    for (CSVListener cSVListener : this.dispatcher) {
                        cSVListener.csvNewItemParsed(stringArray2, this.mapper);
                    }
                    continue;
                }
                if (stringArray2.length <= 1) continue;
                for (CSVListener cSVListener : this.dispatcher) {
                    cSVListener.csvNewItemFailure(stringArray2, this.mapper);
                }
            }
            for (Object object : this.dispatcher) {
                object.csvParseSuccess(this);
            }
        } else {
            for (CSVListener cSVListener : this.dispatcher) {
                cSVListener.csvParseFailure(this);
            }
        }
    }

    protected final String[] parseLine(String string) {
        int n;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        do {
            if (bl) {
                stringBuffer.append("\n");
                string = this.getNextLine();
                if (string == null) break;
            }
            n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == this.quoteChar) {
                    if (bl && n > i + 1 && string.charAt(i + 1) == this.quoteChar) {
                        stringBuffer.append(string.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    bl ^= true;
                    if (i <= 2 || string.charAt(i - 1) == this.separator || n <= i + 1 || string.charAt(i + 1) == this.separator) continue;
                    stringBuffer.append(c);
                    continue;
                }
                if (c == this.separator && !bl) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
        } while (bl);
        arrayList.add(stringBuffer.toString());
        String[] stringArray = arrayList.toArray(new String[0]);
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].trim();
            if (!stringArray[n].endsWith("\"")) continue;
            stringArray[n] = stringArray[n].substring(0, stringArray[n].length() - 1);
        }
        return stringArray;
    }

    public void setMapper(CSVFieldMapper cSVFieldMapper) {
        this.mapper = cSVFieldMapper;
    }
}

