/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import java.util.ArrayList;
import java.util.StringTokenizer;
import toxi.color.ColorList;
import toxi.color.ColorRange;
import toxi.color.NamedColor;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.math.MathUtils;

public class ColorTheme {
    protected String name;
    protected ArrayList<ThemePart> parts = new ArrayList();
    protected float weightedSum;

    public ColorTheme(String string) {
        this.name = string;
    }

    public ColorTheme addRange(ColorRange colorRange, ReadonlyTColor readonlyTColor, float f) {
        this.parts.add(new ThemePart(colorRange, readonlyTColor, f));
        this.weightedSum += f;
        return this;
    }

    public ColorTheme addRange(String string, float f) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ReadonlyTColor readonlyTColor = null;
        ColorRange colorRange = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (ColorRange.getPresetForName(string2) != null) {
                colorRange = ColorRange.getPresetForName(string2);
                continue;
            }
            if (NamedColor.getForName(string2) == null) continue;
            readonlyTColor = NamedColor.getForName(string2);
        }
        if (colorRange != null) {
            this.addRange(colorRange, readonlyTColor, f);
        }
        return this;
    }

    public TColor getColor() {
        float f = MathUtils.random((float)1.0f);
        for (ThemePart themePart : this.parts) {
            float f2 = themePart.weight / this.weightedSum;
            if (f2 >= f) {
                return themePart.getColor();
            }
            f -= f2;
        }
        return null;
    }

    public ColorList getColors(int n) {
        ColorList colorList = new ColorList();
        for (int i = 0; i < n; ++i) {
            colorList.add(this.getColor());
        }
        return colorList;
    }

    public String getName() {
        return this.name;
    }

    static class ThemePart {
        ColorRange range;
        ReadonlyTColor col;
        float weight;

        ThemePart(ColorRange colorRange, ReadonlyTColor readonlyTColor, float f) {
            this.range = colorRange;
            this.col = readonlyTColor;
            this.weight = f;
        }

        public TColor getColor() {
            return this.range.getColor(this.col, 0.035f);
        }
    }
}

