/*
 * Decompiled with CFR 0.152.
 */
package toxi.color.theory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import toxi.color.theory.AnalogousStrategy;
import toxi.color.theory.ColorTheoryStrategy;
import toxi.color.theory.ComplementaryStrategy;
import toxi.color.theory.CompoundTheoryStrategy;
import toxi.color.theory.LeftSplitComplementaryStrategy;
import toxi.color.theory.MonochromeTheoryStrategy;
import toxi.color.theory.RightSplitComplementaryStrategy;
import toxi.color.theory.SingleComplementStrategy;
import toxi.color.theory.SplitComplementaryStrategy;
import toxi.color.theory.TetradTheoryStrategy;
import toxi.color.theory.TriadTheoryStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorTheoryRegistry {
    private static final HashMap<String, ColorTheoryStrategy> implementations = new HashMap();
    public static final ColorTheoryStrategy SINGLE_COMPLEMENT = new SingleComplementStrategy();
    public static final ColorTheoryStrategy COMPLEMENTARY = new ComplementaryStrategy();
    public static final ColorTheoryStrategy SPLIT_COMPLEMENTARY = new SplitComplementaryStrategy();
    public static final ColorTheoryStrategy LEFT_SPLIT_COMPLEMENTARY = new LeftSplitComplementaryStrategy();
    public static final ColorTheoryStrategy RIGHT_SPLIT_COMPLEMENTARY = new RightSplitComplementaryStrategy();
    public static final ColorTheoryStrategy ANALOGOUS = new AnalogousStrategy();
    public static final ColorTheoryStrategy MONOCHROME = new MonochromeTheoryStrategy();
    public static final ColorTheoryStrategy TRIAD = new TriadTheoryStrategy();
    public static final ColorTheoryStrategy TETRAD = new TetradTheoryStrategy();
    public static final ColorTheoryStrategy COMPOUND = new CompoundTheoryStrategy();

    public static ArrayList<String> getRegisteredNames() {
        return new ArrayList<String>(implementations.keySet());
    }

    public static ArrayList<ColorTheoryStrategy> getRegisteredStrategies() {
        return new ArrayList<ColorTheoryStrategy>(implementations.values());
    }

    public static ColorTheoryStrategy getStrategyForName(String string) {
        return implementations.get(string);
    }

    public static void registerImplementation(ColorTheoryStrategy colorTheoryStrategy) {
        implementations.put(colorTheoryStrategy.getName().toUpperCase(), colorTheoryStrategy);
    }

    static {
        Field[] fieldArray = ColorTheoryRegistry.class.getDeclaredFields();
        try {
            for (Field field : fieldArray) {
                if (field.getType() != ColorTheoryStrategy.class) continue;
                String string = field.getName();
                implementations.put(string, (ColorTheoryStrategy)field.get(null));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }
}

