/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import toxi.geom.Vec3D;
import toxi.volume.VolumetricSpace;

public class VolumetricSpaceArray
extends VolumetricSpace {
    protected float[] data;

    public VolumetricSpaceArray(Vec3D vec3D, int n, int n2, int n3) {
        super(vec3D, n, n2, n3);
        this.data = new float[n * n2 * n3];
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0f;
        }
    }

    public void closeSides() {
        this.setVolumeSidesTo(0.0f);
    }

    public float[] getData() {
        return this.data;
    }

    public final float getVoxelAt(int n) {
        return this.data[n];
    }

    public final float getVoxelAt(int n, int n2, int n3) {
        return this.data[n + n2 * this.resX + n3 * this.sliceRes];
    }

    public void saveData(String string) {
        logger.info("saving volume data...");
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            for (float f : this.data) {
                dataOutputStream.writeFloat(f);
            }
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setVolumeSidesTo(float f) {
        int n;
        int n2;
        int n3;
        for (n3 = this.resZ1; n3 > 0; --n3) {
            int n4;
            n2 = n3 * this.sliceRes;
            n = n2 + this.resY1 * this.resX;
            for (n4 = 0; n4 < this.resX; ++n4) {
                this.data[n2 + n4] = f;
                this.data[n + n4] = f;
            }
            int n5 = n2 + this.resX;
            for (n4 = 1; n4 < this.resY1; ++n4) {
                this.data[n5] = f;
                this.data[n5 + this.resX1] = f;
                n5 += this.resX;
            }
        }
        n2 = 0;
        n = this.resZ1 * this.sliceRes;
        for (n3 = 0; n3 < this.sliceRes; ++n3) {
            this.data[n2++] = f;
            this.data[n++] = f;
        }
    }

    public final void setVoxelAt(int n, float f) {
        if (n >= 0 && n < this.data.length) {
            this.data[n] = f;
        }
    }

    public final void setVoxelAt(int n, int n2, int n3, float f) {
        int n4 = n + n2 * this.resX + n3 * this.sliceRes;
        if (n4 >= 0 && n4 < this.data.length) {
            this.data[n4] = f;
        }
    }
}

