/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics;

import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;

public class VerletSpring {
    protected static final float EPS = 1.0E-6f;
    public VerletParticle a;
    public VerletParticle b;
    protected float restLength;
    protected float restLengthSquared;
    protected float strength;
    protected boolean isALocked;
    protected boolean isBLocked;

    public VerletSpring(VerletParticle verletParticle, VerletParticle verletParticle2, float f, float f2) {
        this.a = verletParticle;
        this.b = verletParticle2;
        this.restLength = f;
        this.strength = f2;
    }

    public final float getRestLength() {
        return this.restLength;
    }

    public final float getStrength() {
        return this.strength;
    }

    public VerletSpring lockA(boolean bl) {
        this.isALocked = bl;
        return this;
    }

    public VerletSpring lockB(boolean bl) {
        this.isBLocked = bl;
        return this;
    }

    public VerletSpring setRestLength(float f) {
        this.restLength = f;
        this.restLengthSquared = f * f;
        return this;
    }

    public VerletSpring setStrength(float f) {
        this.strength = f;
        return this;
    }

    protected void update(boolean bl) {
        Vec3D vec3D = this.b.sub(this.a);
        float f = vec3D.magnitude() + 1.0E-6f;
        float f2 = (f - this.restLength) / (f * (this.a.invWeight + this.b.invWeight)) * this.strength;
        if (!this.a.isLocked && !this.isALocked) {
            this.a.addSelf(vec3D.scale(f2 * this.a.invWeight));
            if (bl) {
                this.a.applyConstraints();
            }
        }
        if (!this.b.isLocked && !this.isBLocked) {
            this.b.addSelf(vec3D.scale(-f2 * this.b.invWeight));
            if (bl) {
                this.b.applyConstraints();
            }
        }
    }
}

