/*
 * Decompiled with CFR 0.152.
 */
package de.looksgood.ani.easing;

import de.looksgood.ani.easing.Easing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.core.PApplet;

public class CustomEasing
extends Easing {
    private static HashMap<String, CustomEasing> customEasingsLookup = new HashMap();
    private ArrayList<Segment> segments = new ArrayList();
    private String name;

    public CustomEasing(String theName, String theSegments) {
        this.setMode(this.easingMode);
        this.name = theName;
        this.segments = new ArrayList();
        Pattern regex = Pattern.compile("\\{(.*?)\\}");
        Matcher regexMatcher = regex.matcher(theSegments.toLowerCase());
        while (regexMatcher.find()) {
            String segmentString = regexMatcher.group();
            segmentString = segmentString.replace('{', ' ');
            segmentString = segmentString.replace('}', ' ');
            segmentString = PApplet.trim((String)segmentString);
            String[] segmentPropertiesString = PApplet.split((String)segmentString, (char)',');
            HashMap<String, Float> segmentProperties = new HashMap<String, Float>();
            int i = 0;
            while (i < segmentPropertiesString.length) {
                String[] p = PApplet.split((String)PApplet.trim((String)segmentPropertiesString[i]), (char)':');
                segmentProperties.put(PApplet.trim((String)p[0]), Float.valueOf(Float.parseFloat(p[1])));
                ++i;
            }
            this.segments.add(new Segment(((Float)segmentProperties.get("s")).floatValue(), ((Float)segmentProperties.get("cp")).floatValue(), ((Float)segmentProperties.get("e")).floatValue()));
        }
        customEasingsLookup.put(this.name, this);
    }

    public static CustomEasing create(String theName, String theSegments) {
        CustomEasing tmp = new CustomEasing(theName, theSegments);
        return tmp;
    }

    public static CustomEasing byName(String theName) {
        return customEasingsLookup.get(theName);
    }

    public float easeIn(float t, float b, float c, float d) {
        return this.easeBezier(t, b, c, d);
    }

    public float easeOut(float t, float b, float c, float d) {
        return this.easeBezier(t, b, c, d);
    }

    public float easeInOut(float t, float b, float c, float d) {
        return this.easeBezier(t, b, c, d);
    }

    private float easeBezier(float t, float b, float c, float d) {
        float factor = t / d;
        int qty = this.segments.size();
        int i = (int)((float)qty * factor);
        i = PApplet.min((int)i, (int)(this.segments.size() - 1));
        float time = (factor - (float)i * (1.0f / (float)qty)) * (float)qty;
        Segment s = this.segments.get(i);
        return b + c * (s.s + time * (2.0f * (1.0f - time) * (s.cp - s.s) + time * (s.e - s.s)));
    }

    private class Segment {
        public float s;
        public float cp;
        public float e;

        public Segment(float s, float cp, float e) {
            this.s = s;
            this.cp = cp;
            this.e = e;
        }
    }
}

