/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import processing.core.PApplet;

public class XML
implements Serializable {
    protected Node node;
    protected String name;
    protected XML parent;
    protected XML[] children;

    protected XML() {
    }

    public XML(PApplet parent, String filename) throws IOException, ParserConfigurationException, SAXException {
        this(parent.createReader(filename));
    }

    public XML(File file) throws IOException, ParserConfigurationException, SAXException {
        this(PApplet.createReader(file));
    }

    public XML(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(reader));
        this.node = document.getDocumentElement();
        this.name = this.node.getNodeName();
    }

    public XML(String name) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            this.node = document.createElement(name);
            this.name = name;
            this.parent = null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected XML(XML parent, Node node) {
        this.node = node;
        this.parent = parent;
        this.name = node.getNodeName();
    }

    public static XML parse(String xml) {
        try {
            return new XML(new StringReader(xml));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean save(OutputStream output) {
        return this.save(PApplet.createWriter(output));
    }

    public boolean save(File file) {
        return this.save(PApplet.createWriter(file));
    }

    public boolean save(PrintWriter output) {
        output.print(this.format(2));
        output.flush();
        return true;
    }

    public XML getParent() {
        return this.parent;
    }

    protected Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        Document document = this.node.getOwnerDocument();
        this.node = document.renameNode(this.node, null, newName);
        this.name = this.node.getNodeName();
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    protected void checkChildren() {
        if (this.children == null) {
            NodeList kids = this.node.getChildNodes();
            int childCount = kids.getLength();
            this.children = new XML[childCount];
            for (int i = 0; i < childCount; ++i) {
                this.children[i] = new XML(this, kids.item(i));
            }
        }
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.length;
    }

    public boolean hasChildren() {
        this.checkChildren();
        return this.children.length > 0;
    }

    public String[] listChildren() {
        this.checkChildren();
        String[] outgoing = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            outgoing[i] = this.children[i].getName();
        }
        return outgoing;
    }

    public XML[] getChildren() {
        this.checkChildren();
        return this.children;
    }

    public XML getChild(int index) {
        this.checkChildren();
        return this.children[index];
    }

    public XML getChild(String name) {
        if (name.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(name, '/'), 0);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            XML kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName == null || !kidName.equals(name)) continue;
            return kid;
        }
        return null;
    }

    protected XML getChildRecursive(String[] items, int offset) {
        if (Character.isDigit(items[offset].charAt(0))) {
            XML kid = this.getChild(Integer.parseInt(items[offset]));
            if (offset == items.length - 1) {
                return kid;
            }
            return kid.getChildRecursive(items, offset + 1);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            XML kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName == null || !kidName.equals(items[offset])) continue;
            if (offset == items.length - 1) {
                return kid;
            }
            return kid.getChildRecursive(items, offset + 1);
        }
        return null;
    }

    public XML[] getChildren(String name) {
        if (name.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(name, '/'), 0);
        }
        if (Character.isDigit(name.charAt(0))) {
            return new XML[]{this.getChild(Integer.parseInt(name))};
        }
        int childCount = this.getChildCount();
        XML[] matches = new XML[childCount];
        int matchCount = 0;
        for (int i = 0; i < childCount; ++i) {
            XML kid = this.getChild(i);
            String kidName = kid.getName();
            if (kidName == null || !kidName.equals(name)) continue;
            matches[matchCount++] = kid;
        }
        return (XML[])PApplet.subset(matches, 0, matchCount);
    }

    protected XML[] getChildrenRecursive(String[] items, int offset) {
        if (offset == items.length - 1) {
            return this.getChildren(items[offset]);
        }
        XML[] matches = this.getChildren(items[offset]);
        XML[] outgoing = new XML[]{};
        for (int i = 0; i < matches.length; ++i) {
            XML[] kidMatches = matches[i].getChildrenRecursive(items, offset + 1);
            outgoing = (XML[])PApplet.concat(outgoing, kidMatches);
        }
        return outgoing;
    }

    public XML addChild(String tag) {
        Document document = this.node.getOwnerDocument();
        Element newChild = document.createElement(tag);
        return this.appendChild(newChild);
    }

    public XML addChild(XML child) {
        Document document = this.node.getOwnerDocument();
        Node newChild = document.importNode(child.getNode(), true);
        return this.appendChild(newChild);
    }

    protected XML appendChild(Node newNode) {
        this.node.appendChild(newNode);
        XML newbie = new XML(this, newNode);
        if (this.children != null) {
            this.children = (XML[])PApplet.concat(this.children, new XML[]{newbie});
        }
        return newbie;
    }

    public void removeChild(XML kid) {
        this.node.removeChild(kid.node);
        this.children = null;
    }

    public void trim() {
        this.checkChildren();
        int index = 0;
        for (int i = 0; i < this.children.length; ++i) {
            Node childNode;
            if (i != index) {
                this.children[index] = this.children[i];
            }
            if ((childNode = this.children[i].getNode()).getNodeType() == 3 && this.children[i].getContent().trim().length() <= 0) continue;
            this.children[i].trim();
            ++index;
        }
        if (index != this.children.length) {
            this.children = (XML[])PApplet.subset(this.children, 0, index);
        }
    }

    public int getAttributeCount() {
        return this.node.getAttributes().getLength();
    }

    public String[] listAttributes() {
        NamedNodeMap nnm = this.node.getAttributes();
        String[] outgoing = new String[nnm.getLength()];
        for (int i = 0; i < outgoing.length; ++i) {
            outgoing[i] = nnm.item(i).getNodeName();
        }
        return outgoing;
    }

    public boolean hasAttribute(String name) {
        return this.node.getAttributes().getNamedItem(name) != null;
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        Node attr = this.node.getAttributes().getNamedItem(name);
        return attr == null ? defaultValue : attr.getNodeValue();
    }

    public void setString(String name, String value) {
        ((Element)this.node).setAttribute(name, value);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public void setInt(String name, int value) {
        this.setString(name, String.valueOf(value));
    }

    public int getInt(String name, int defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public void setFloat(String name, float value) {
        this.setString(name, String.valueOf(value));
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public void setDouble(String name, double value) {
        this.setString(name, String.valueOf(value));
    }

    public String getContent() {
        return this.node.getTextContent();
    }

    public void setContent(String text) {
        this.node.setTextContent(text);
    }

    public String format(int indent) {
        try {
            DOMSource dumSource = new DOMSource(this.node);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (indent == -1 || this.parent != null) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            if (indent != 0) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
                transformer.setOutputProperty("indent", "yes");
            }
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(dumSource, sr);
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.format(-1);
    }
}

