/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PShape;
import processing.core.PShapeOBJ;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShapeOpenGL;

public class PGraphics3D
extends PGraphicsOpenGL {
    public PGraphics3D() {
        this.hints[10] = true;
    }

    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public boolean is3D() {
        return true;
    }

    @Override
    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    protected void defaultCamera() {
        this.camera();
    }

    @Override
    protected void begin2D() {
        this.pushProjection();
        this.ortho(-this.width / 2, this.width / 2, -this.height / 2, this.height / 2, -1.0f, 1.0f);
        this.pushMatrix();
        this.camera(this.width / 2, this.height / 2);
    }

    @Override
    protected void end2D() {
        this.popMatrix();
        this.popProjection();
    }

    protected static boolean isSupportedExtension(String extension) {
        return extension.equals("obj");
    }

    protected static PShape loadShapeImpl(PGraphics pg, String filename, String extension) {
        PShapeOBJ obj = null;
        if (extension.equals("obj")) {
            obj = new PShapeOBJ(pg.parent, filename);
        } else if (extension.equals("objz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(pg.parent.createInput(filename));
                obj = new PShapeOBJ(pg.parent, PApplet.createReader(input));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (obj != null) {
            int prevTextureMode = pg.textureMode;
            pg.textureMode = 1;
            PShapeOpenGL p3d = PShapeOpenGL.createShape3D(pg.parent, obj);
            pg.textureMode = prevTextureMode;
            return p3d;
        }
        return null;
    }

    @Override
    public PShape createShape(PShape source) {
        return PShapeOpenGL.createShape3D(this.parent, source);
    }

    @Override
    public PShape createShape() {
        return this.createShape(20);
    }

    @Override
    public PShape createShape(int type) {
        return PGraphics3D.createShapeImpl(this.parent, type);
    }

    @Override
    public PShape createShape(int kind, float ... p) {
        return PGraphics3D.createShapeImpl(this.parent, kind, p);
    }

    protected static PShapeOpenGL createShapeImpl(PApplet parent, int type) {
        PShapeOpenGL shape = null;
        if (type == 0) {
            shape = new PShapeOpenGL(parent, 0);
        } else if (type == 2) {
            shape = new PShapeOpenGL(parent, 2);
        } else if (type == 3) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(3);
        } else if (type == 5) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(5);
        } else if (type == 8 || type == 9) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(9);
        } else if (type == 11) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(11);
        } else if (type == 10) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(10);
        } else if (type == 16 || type == 17) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(17);
        } else if (type == 18) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(18);
        } else if (type == 20) {
            shape = new PShapeOpenGL(parent, 3);
            shape.setKind(20);
        }
        shape.is3D(true);
        return shape;
    }

    protected static PShapeOpenGL createShapeImpl(PApplet parent, int kind, float ... p) {
        PShapeOpenGL shape = null;
        int len = p.length;
        if (kind == 2) {
            if (len != 2 && len != 3) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(2);
        } else if (kind == 4) {
            if (len != 4 && len != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(4);
        } else if (kind == 8) {
            if (len != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(8);
        } else if (kind == 16) {
            if (len != 8) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(16);
        } else if (kind == 30) {
            if (len != 4 && len != 5 && len != 8) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(30);
        } else if (kind == 31) {
            if (len != 4) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(31);
        } else if (kind == 32) {
            if (len != 6) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(32);
        } else if (kind == 41) {
            if (len != 1 && len != 3) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(41);
        } else if (kind == 40) {
            if (len != 1) {
                PGraphics3D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(40);
        } else {
            PGraphics3D.showWarning("Unrecognized primitive type");
        }
        if (shape != null) {
            shape.setParams(p);
        }
        shape.is3D(true);
        return shape;
    }
}

