/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.FontTexture;
import processing.opengl.FrameBuffer;
import processing.opengl.LinePath;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PShader;
import processing.opengl.Texture;

public class PGraphicsOpenGL
extends PGraphics {
    public PGL pgl;
    protected static PGraphicsOpenGL pgPrimary = null;
    protected static PGraphicsOpenGL pgCurrent = null;
    protected WeakHashMap<PFont, FontTexture> fontMap = new WeakHashMap();
    protected static final int FLUSH_CONTINUOUSLY = 0;
    protected static final int FLUSH_WHEN_FULL = 1;
    protected static final int IMMEDIATE = 0;
    protected static final int RETAINED = 1;
    protected int flushMode = 1;
    public int glPolyVertex;
    public int glPolyColor;
    public int glPolyNormal;
    public int glPolyTexcoord;
    public int glPolyAmbient;
    public int glPolySpecular;
    public int glPolyEmissive;
    public int glPolyShininess;
    public int glPolyIndex;
    protected boolean polyBuffersCreated = false;
    protected PGL.Context polyBuffersContext;
    public int glLineVertex;
    public int glLineColor;
    public int glLineAttrib;
    public int glLineIndex;
    protected boolean lineBuffersCreated = false;
    protected PGL.Context lineBuffersContext;
    public int glPointVertex;
    public int glPointColor;
    public int glPointAttrib;
    public int glPointIndex;
    protected boolean pointBuffersCreated = false;
    protected PGL.Context pointBuffersContext;
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    protected static boolean glParamsRead = false;
    public static boolean npotTexSupported;
    public static boolean autoMipmapGenSupported;
    public static boolean fboMultisampleSupported;
    public static boolean packedDepthStencilSupported;
    public static boolean blendEqSupported;
    public static int maxTextureSize;
    public static int maxSamples;
    public static float maxPointSize;
    public static float maxLineWidth;
    public static int depthBits;
    public static int stencilBits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    public static String OPENGL_EXTENSIONS;
    public static String GLSL_VERSION;
    protected static HashMap<GLResource, Boolean> glTextureObjects;
    protected static HashMap<GLResource, Boolean> glVertexBuffers;
    protected static HashMap<GLResource, Boolean> glFrameBuffers;
    protected static HashMap<GLResource, Boolean> glRenderBuffers;
    protected static HashMap<GLResource, Boolean> glslPrograms;
    protected static HashMap<GLResource, Boolean> glslVertexShaders;
    protected static HashMap<GLResource, Boolean> glslFragmentShaders;
    protected static URL defPolyColorShaderVertURL;
    protected static URL defPolyTexShaderVertURL;
    protected static URL defPolyLightShaderVertURL;
    protected static URL defPolyTexlightShaderVertURL;
    protected static URL defPolyNoTexShaderFragURL;
    protected static URL defPolyTexShaderFragURL;
    protected static URL defLineShaderVertURL;
    protected static URL defLineShaderFragURL;
    protected static URL defPointShaderVertURL;
    protected static URL defPointShaderFragURL;
    protected static PolyColorShader defPolyColorShader;
    protected static PolyTexShader defPolyTexShader;
    protected static PolyLightShader defPolyLightShader;
    protected static PolyTexlightShader defPolyTexlightShader;
    protected static LineShader defLineShader;
    protected static PointShader defPointShader;
    protected static URL maskShaderFragURL;
    protected static PolyTexShader maskShader;
    protected PolyColorShader polyColorShader;
    protected PolyTexShader polyTexShader;
    protected PolyLightShader polyLightShader;
    protected PolyTexlightShader polyTexlightShader;
    protected LineShader lineShader;
    protected PointShader pointShader;
    protected boolean shaderWarningsEnabled = true;
    protected InGeometry inGeo;
    protected TessGeometry tessGeo;
    protected static Tessellator tessellator;
    protected TexCache texCache;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    protected float cameraEyeX;
    protected float cameraEyeY;
    protected float cameraEyeZ;
    protected boolean manipulatingCamera;
    protected boolean usingOrthoProjection;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projmodelview;
    protected float[] glProjection;
    protected float[] glModelview;
    protected float[] glProjmodelview;
    protected float[] glNormal;
    protected static PMatrix3D identity;
    protected boolean matricesAllocated = false;
    protected boolean sized;
    protected static final int MATRIX_STACK_DEPTH = 32;
    protected int modelviewStackDepth;
    protected int projectionStackDepth;
    protected float[][] modelviewStack = new float[32][16];
    protected float[][] modelviewInvStack = new float[32][16];
    protected float[][] cameraStack = new float[32][16];
    protected float[][] cameraInvStack = new float[32][16];
    protected float[][] projectionStack = new float[32][16];
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[] lightPosition;
    public float[] lightNormal;
    public float[] lightAmbient;
    public float[] lightDiffuse;
    public float[] lightSpecular;
    public float[] lightFalloffCoefficients;
    public float[] lightSpotParameters;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    protected boolean lightsAllocated = false;
    protected int textureWrap = 0;
    protected int textureSampling = 5;
    protected int blendMode;
    protected boolean clip = false;
    protected int[] clipRect = new int[]{0, 0, 0, 0};
    FontTexture textTex;
    protected static final int FB_STACK_DEPTH = 16;
    protected static int fbStackDepth;
    protected static FrameBuffer[] fbStack;
    protected static FrameBuffer screenFramebuffer;
    protected static FrameBuffer currentFramebuffer;
    protected FrameBuffer offscreenFramebuffer;
    protected FrameBuffer offscreenFramebufferMultisample;
    protected boolean offscreenMultisample;
    protected boolean offscreenNotCurrent;
    protected Texture texture;
    protected Texture textureCopy;
    protected PImage imageCopy;
    protected IntBuffer pixelBuffer;
    protected int[] nativePixels;
    protected IntBuffer nativePixelBuffer;
    protected boolean setgetPixels;
    protected boolean drawing = false;
    protected boolean restoreSurface = false;
    protected boolean smoothDisabled = false;
    protected int smoothCallCount = 0;
    protected int lastSmoothCall = -10;
    protected static final int OP_NONE = 0;
    protected static final int OP_READ = 1;
    protected static final int OP_WRITE = 2;
    protected int pixelsOp = 0;
    protected boolean resized = false;
    protected int[] viewport = new int[]{0, 0, 0, 0};
    protected boolean clearColorBuffer;
    protected boolean clearColorBuffer0;
    protected boolean openContour = false;
    protected boolean breakShape = false;
    protected boolean defaultEdges = false;
    protected PImage textureImage0;
    protected static final int EDGE_MIDDLE = 0;
    protected static final int EDGE_START = 1;
    protected static final int EDGE_STOP = 2;
    protected static final int EDGE_SINGLE = 3;
    protected static final int MIN_POINT_ACCURACY = 20;
    protected static final float POINT_ACCURACY_FACTOR = 10.0f;
    protected final float[][] QUAD_POINT_SIGNS = new float[][]{{-1.0f, 1.0f}, {-1.0f, -1.0f}, {1.0f, -1.0f}, {1.0f, 1.0f}};

    public PGraphicsOpenGL() {
        this.pgl = new PGL(this);
        if (tessellator == null) {
            tessellator = new Tessellator();
        }
        this.inGeo = this.newInGeometry(0);
        this.tessGeo = this.newTessGeometry(0);
        this.texCache = this.newTexCache();
        this.glPolyVertex = 0;
        this.glPolyColor = 0;
        this.glPolyNormal = 0;
        this.glPolyTexcoord = 0;
        this.glPolyAmbient = 0;
        this.glPolySpecular = 0;
        this.glPolyEmissive = 0;
        this.glPolyShininess = 0;
        this.glPolyIndex = 0;
        this.glLineVertex = 0;
        this.glLineColor = 0;
        this.glLineAttrib = 0;
        this.glLineIndex = 0;
        this.glPointVertex = 0;
        this.glPointColor = 0;
        this.glPointAttrib = 0;
        this.glPointIndex = 0;
    }

    @Override
    public void setPrimary(boolean primary) {
        super.setPrimary(primary);
        this.format = 2;
    }

    @Override
    public void setFrameRate(float frameRate) {
        this.pgl.setFrameRate(frameRate);
    }

    @Override
    public void setSize(int iwidth, int iheight) {
        this.resized = 0 < this.width && this.width != iwidth || 0 < this.height && this.height != iwidth;
        this.width = iwidth;
        this.height = iheight;
        if (this.pixels != null) {
            this.allocatePixels();
        }
        this.allocate();
        this.reapplySettings();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.sized = true;
        this.pgl.initialized = false;
    }

    @Override
    protected void allocate() {
        super.allocate();
        if (!this.matricesAllocated) {
            this.projection = new PMatrix3D();
            this.camera = new PMatrix3D();
            this.cameraInv = new PMatrix3D();
            this.modelview = new PMatrix3D();
            this.modelviewInv = new PMatrix3D();
            this.projmodelview = new PMatrix3D();
            this.matricesAllocated = true;
        }
        if (!this.lightsAllocated) {
            this.lightType = new int[8];
            this.lightPosition = new float[32];
            this.lightNormal = new float[24];
            this.lightAmbient = new float[24];
            this.lightDiffuse = new float[24];
            this.lightSpecular = new float[24];
            this.lightFalloffCoefficients = new float[24];
            this.lightSpotParameters = new float[16];
            this.currentLightSpecular = new float[3];
            this.lightsAllocated = true;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.deleteFinalizedGLResources();
        this.deletePolyBuffers();
        this.deleteLineBuffers();
        this.deletePointBuffers();
    }

    protected void setFlushMode(int mode) {
        this.flushMode = mode;
    }

    protected void setFontTexture(PFont font, FontTexture fontTexture) {
        this.fontMap.put(font, fontTexture);
    }

    protected FontTexture getFontTexture(PFont font) {
        return this.fontMap.get(font);
    }

    protected void removeFontTexture(PFont font) {
        this.fontMap.remove(font);
    }

    protected int createTextureObject(int context) {
        this.deleteFinalizedTextureObjects();
        int[] temp = new int[1];
        this.pgl.genTextures(1, temp, 0);
        int id = temp[0];
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same texture twice");
        } else {
            glTextureObjects.put(res, false);
        }
        return id;
    }

    protected void deleteTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            int[] temp = new int[]{id};
            this.pgl.deleteTextures(1, temp, 0);
            glTextureObjects.remove(res);
        }
    }

    protected void deleteAllTextureObjects() {
        for (GLResource res : glTextureObjects.keySet()) {
            int[] temp = new int[]{res.id};
            this.pgl.deleteTextures(1, temp, 0);
        }
        glTextureObjects.clear();
    }

    protected synchronized void finalizeTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            glTextureObjects.put(res, true);
        }
    }

    protected void deleteFinalizedTextureObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glTextureObjects.keySet()) {
            if (!glTextureObjects.get(res).booleanValue()) continue;
            finalized.add(res);
            int[] temp = new int[]{res.id};
            this.pgl.deleteTextures(1, temp, 0);
        }
        for (GLResource res : finalized) {
            glTextureObjects.remove(res);
        }
    }

    protected void removeTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            glTextureObjects.remove(res);
        }
    }

    protected int createVertexBufferObject(int context) {
        this.deleteFinalizedVertexBufferObjects();
        int[] temp = new int[1];
        this.pgl.genBuffers(1, temp, 0);
        int id = temp[0];
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same VBO twice");
        } else {
            glVertexBuffers.put(res, false);
        }
        return id;
    }

    protected void deleteVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            int[] temp = new int[]{id};
            this.pgl.deleteBuffers(1, temp, 0);
            glVertexBuffers.remove(res);
        }
    }

    protected void deleteAllVertexBufferObjects() {
        for (GLResource res : glVertexBuffers.keySet()) {
            int[] temp = new int[]{res.id};
            this.pgl.deleteBuffers(1, temp, 0);
        }
        glVertexBuffers.clear();
    }

    protected synchronized void finalizeVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            glVertexBuffers.put(res, true);
        }
    }

    protected void deleteFinalizedVertexBufferObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glVertexBuffers.keySet()) {
            if (!glVertexBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            int[] temp = new int[]{res.id};
            this.pgl.deleteBuffers(1, temp, 0);
        }
        for (GLResource res : finalized) {
            glVertexBuffers.remove(res);
        }
    }

    protected void removeVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            glVertexBuffers.remove(res);
        }
    }

    protected int createFrameBufferObject(int context) {
        this.deleteFinalizedFrameBufferObjects();
        int[] temp = new int[1];
        this.pgl.genFramebuffers(1, temp, 0);
        int id = temp[0];
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same FBO twice");
        } else {
            glFrameBuffers.put(res, false);
        }
        return id;
    }

    protected void deleteFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            int[] temp = new int[]{id};
            this.pgl.deleteFramebuffers(1, temp, 0);
            glFrameBuffers.remove(res);
        }
    }

    protected void deleteAllFrameBufferObjects() {
        for (GLResource res : glFrameBuffers.keySet()) {
            int[] temp = new int[]{res.id};
            this.pgl.deleteFramebuffers(1, temp, 0);
        }
        glFrameBuffers.clear();
    }

    protected synchronized void finalizeFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            glFrameBuffers.put(res, true);
        }
    }

    protected void deleteFinalizedFrameBufferObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glFrameBuffers.keySet()) {
            if (!glFrameBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            int[] temp = new int[]{res.id};
            this.pgl.deleteFramebuffers(1, temp, 0);
        }
        for (GLResource res : finalized) {
            glFrameBuffers.remove(res);
        }
    }

    protected void removeFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            glFrameBuffers.remove(res);
        }
    }

    protected int createRenderBufferObject(int context) {
        this.deleteFinalizedRenderBufferObjects();
        int[] temp = new int[1];
        this.pgl.genRenderbuffers(1, temp, 0);
        int id = temp[0];
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same renderbuffer twice");
        } else {
            glRenderBuffers.put(res, false);
        }
        return id;
    }

    protected void deleteRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            int[] temp = new int[]{id};
            this.pgl.deleteRenderbuffers(1, temp, 0);
            glRenderBuffers.remove(res);
        }
    }

    protected void deleteAllRenderBufferObjects() {
        for (GLResource res : glRenderBuffers.keySet()) {
            int[] temp = new int[]{res.id};
            this.pgl.deleteRenderbuffers(1, temp, 0);
        }
        glRenderBuffers.clear();
    }

    protected synchronized void finalizeRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            glRenderBuffers.put(res, true);
        }
    }

    protected void deleteFinalizedRenderBufferObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glRenderBuffers.keySet()) {
            if (!glRenderBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            int[] temp = new int[]{res.id};
            this.pgl.deleteRenderbuffers(1, temp, 0);
        }
        for (GLResource res : finalized) {
            glRenderBuffers.remove(res);
        }
    }

    protected void removeRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            glRenderBuffers.remove(res);
        }
    }

    protected int createGLSLProgramObject(int context) {
        this.deleteFinalizedGLSLProgramObjects();
        int id = this.pgl.createProgram();
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same glsl program twice");
        } else {
            glslPrograms.put(res, false);
        }
        return id;
    }

    protected void deleteGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            this.pgl.deleteProgram(res.id);
            glslPrograms.remove(res);
        }
    }

    protected void deleteAllGLSLProgramObjects() {
        for (GLResource res : glslPrograms.keySet()) {
            this.pgl.deleteProgram(res.id);
        }
        glslPrograms.clear();
    }

    protected synchronized void finalizeGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            glslPrograms.put(res, true);
        }
    }

    protected void deleteFinalizedGLSLProgramObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslPrograms.keySet()) {
            if (!glslPrograms.get(res).booleanValue()) continue;
            finalized.add(res);
            this.pgl.deleteProgram(res.id);
        }
        for (GLResource res : finalized) {
            glslPrograms.remove(res);
        }
    }

    protected void removeGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            glslPrograms.remove(res);
        }
    }

    protected int createGLSLVertShaderObject(int context) {
        this.deleteFinalizedGLSLVertShaderObjects();
        int id = this.pgl.createShader(35633);
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same glsl vertex shader twice");
        } else {
            glslVertexShaders.put(res, false);
        }
        return id;
    }

    protected void deleteGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            this.pgl.deleteShader(res.id);
            glslVertexShaders.remove(res);
        }
    }

    protected void deleteAllGLSLVertShaderObjects() {
        for (GLResource res : glslVertexShaders.keySet()) {
            this.pgl.deleteShader(res.id);
        }
        glslVertexShaders.clear();
    }

    protected synchronized void finalizeGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            glslVertexShaders.put(res, true);
        }
    }

    protected void deleteFinalizedGLSLVertShaderObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslVertexShaders.keySet()) {
            if (!glslVertexShaders.get(res).booleanValue()) continue;
            finalized.add(res);
            this.pgl.deleteShader(res.id);
        }
        for (GLResource res : finalized) {
            glslVertexShaders.remove(res);
        }
    }

    protected void removeGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            glslVertexShaders.remove(res);
        }
    }

    protected int createGLSLFragShaderObject(int context) {
        this.deleteFinalizedGLSLFragShaderObjects();
        int id = this.pgl.createShader(35632);
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            PGraphicsOpenGL.showWarning("Adding same glsl fragment shader twice");
        } else {
            glslFragmentShaders.put(res, false);
        }
        return id;
    }

    protected void deleteGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            this.pgl.deleteShader(res.id);
            glslFragmentShaders.remove(res);
        }
    }

    protected void deleteAllGLSLFragShaderObjects() {
        for (GLResource res : glslFragmentShaders.keySet()) {
            this.pgl.deleteShader(res.id);
        }
        glslFragmentShaders.clear();
    }

    protected synchronized void finalizeGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.put(res, true);
        }
    }

    protected void deleteFinalizedGLSLFragShaderObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslFragmentShaders.keySet()) {
            if (!glslFragmentShaders.get(res).booleanValue()) continue;
            finalized.add(res);
            this.pgl.deleteShader(res.id);
        }
        for (GLResource res : finalized) {
            glslFragmentShaders.remove(res);
        }
    }

    protected void removeGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.remove(res);
        }
    }

    protected void deleteFinalizedGLResources() {
        this.deleteFinalizedTextureObjects();
        this.deleteFinalizedVertexBufferObjects();
        this.deleteFinalizedFrameBufferObjects();
        this.deleteFinalizedRenderBufferObjects();
        this.deleteFinalizedGLSLProgramObjects();
        this.deleteFinalizedGLSLVertShaderObjects();
        this.deleteFinalizedGLSLFragShaderObjects();
    }

    protected void pushFramebuffer() {
        if (fbStackDepth == 16) {
            throw new RuntimeException("Too many pushFramebuffer calls");
        }
        PGraphicsOpenGL.fbStack[PGraphicsOpenGL.fbStackDepth] = currentFramebuffer;
        ++fbStackDepth;
    }

    protected void setFramebuffer(FrameBuffer fbo) {
        currentFramebuffer = fbo;
        currentFramebuffer.bind();
    }

    protected void popFramebuffer() {
        if (fbStackDepth == 0) {
            throw new RuntimeException("popFramebuffer call is unbalanced.");
        }
        currentFramebuffer.finish();
        currentFramebuffer = fbStack[--fbStackDepth];
        currentFramebuffer.bind();
    }

    protected void createPolyBuffers() {
        if (!this.polyBuffersCreated || this.polyBuffersContextIsOutdated()) {
            this.polyBuffersContext = this.pgl.getCurrentContext();
            int sizef = 1024;
            int sizei = 1024;
            int sizex = 1024;
            this.glPolyVertex = this.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyVertex);
            this.pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glPolyColor = this.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyColor);
            this.pgl.bufferData(34962, sizei, null, 35044);
            this.glPolyNormal = this.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyNormal);
            this.pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glPolyTexcoord = this.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyTexcoord);
            this.pgl.bufferData(34962, 2 * sizef, null, 35044);
            this.glPolyAmbient = pgPrimary.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyAmbient);
            this.pgl.bufferData(34962, sizei, null, 35044);
            this.glPolySpecular = pgPrimary.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolySpecular);
            this.pgl.bufferData(34962, sizei, null, 35044);
            this.glPolyEmissive = pgPrimary.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyEmissive);
            this.pgl.bufferData(34962, sizei, null, 35044);
            this.glPolyShininess = pgPrimary.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPolyShininess);
            this.pgl.bufferData(34962, sizef, null, 35044);
            this.pgl.bindBuffer(34962, 0);
            this.glPolyIndex = this.createVertexBufferObject(this.polyBuffersContext.id());
            this.pgl.bindBuffer(34963, this.glPolyIndex);
            this.pgl.bufferData(34963, sizex, null, 35044);
            this.pgl.bindBuffer(34963, 0);
            this.polyBuffersCreated = true;
        }
    }

    protected void updatePolyBuffers(boolean lit, boolean tex) {
        this.createPolyBuffers();
        int size = this.tessGeo.polyVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.pgl.bindBuffer(34962, this.glPolyVertex);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.polyVertices, 0, 4 * size), 35044);
        this.pgl.bindBuffer(34962, this.glPolyColor);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polyColors, 0, size), 35044);
        if (lit) {
            this.pgl.bindBuffer(34962, this.glPolyNormal);
            this.pgl.bufferData(34962, 3 * sizef, FloatBuffer.wrap(this.tessGeo.polyNormals, 0, 3 * size), 35044);
            this.pgl.bindBuffer(34962, this.glPolyAmbient);
            this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polyAmbient, 0, size), 35044);
            this.pgl.bindBuffer(34962, this.glPolySpecular);
            this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polySpecular, 0, size), 35044);
            this.pgl.bindBuffer(34962, this.glPolyEmissive);
            this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polyEmissive, 0, size), 35044);
            this.pgl.bindBuffer(34962, this.glPolyShininess);
            this.pgl.bufferData(34962, sizef, FloatBuffer.wrap(this.tessGeo.polyShininess, 0, size), 35044);
        }
        if (tex) {
            this.pgl.bindBuffer(34962, this.glPolyTexcoord);
            this.pgl.bufferData(34962, 2 * sizef, FloatBuffer.wrap(this.tessGeo.polyTexcoords, 0, 2 * size), 35044);
        }
        this.pgl.bindBuffer(34963, this.glPolyIndex);
        this.pgl.bufferData(34963, this.tessGeo.polyIndexCount * 2, ShortBuffer.wrap(this.tessGeo.polyIndices, 0, this.tessGeo.polyIndexCount), 35044);
    }

    protected void unbindPolyBuffers() {
        this.pgl.bindBuffer(34962, 0);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean polyBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.polyBuffersContext);
    }

    protected void deletePolyBuffers() {
        if (this.polyBuffersCreated) {
            this.deleteVertexBufferObject(this.glPolyVertex, this.polyBuffersContext.id());
            this.glPolyVertex = 0;
            this.deleteVertexBufferObject(this.glPolyColor, this.polyBuffersContext.id());
            this.glPolyColor = 0;
            this.deleteVertexBufferObject(this.glPolyNormal, this.polyBuffersContext.id());
            this.glPolyNormal = 0;
            this.deleteVertexBufferObject(this.glPolyTexcoord, this.polyBuffersContext.id());
            this.glPolyTexcoord = 0;
            this.deleteVertexBufferObject(this.glPolyAmbient, this.polyBuffersContext.id());
            this.glPolyAmbient = 0;
            this.deleteVertexBufferObject(this.glPolySpecular, this.polyBuffersContext.id());
            this.glPolySpecular = 0;
            this.deleteVertexBufferObject(this.glPolyEmissive, this.polyBuffersContext.id());
            this.glPolyEmissive = 0;
            this.deleteVertexBufferObject(this.glPolyShininess, this.polyBuffersContext.id());
            this.glPolyShininess = 0;
            this.deleteVertexBufferObject(this.glPolyIndex, this.polyBuffersContext.id());
            this.glPolyIndex = 0;
            this.polyBuffersCreated = false;
        }
    }

    protected void createLineBuffers() {
        if (!this.lineBuffersCreated || this.lineBufferContextIsOutdated()) {
            this.lineBuffersContext = this.pgl.getCurrentContext();
            int sizef = 1024;
            int sizei = 1024;
            int sizex = 1024;
            this.glLineVertex = this.createVertexBufferObject(this.lineBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glLineVertex);
            this.pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glLineColor = this.createVertexBufferObject(this.lineBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glLineColor);
            this.pgl.bufferData(34962, sizei, null, 35044);
            this.glLineAttrib = this.createVertexBufferObject(this.lineBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glLineAttrib);
            this.pgl.bufferData(34962, 4 * sizef, null, 35044);
            this.pgl.bindBuffer(34962, 0);
            this.glLineIndex = this.createVertexBufferObject(this.lineBuffersContext.id());
            this.pgl.bindBuffer(34963, this.glLineIndex);
            this.pgl.bufferData(34963, sizex, null, 35044);
            this.pgl.bindBuffer(34963, 0);
            this.lineBuffersCreated = true;
        }
    }

    protected void updateLineBuffers() {
        this.createLineBuffers();
        int size = this.tessGeo.lineVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.pgl.bindBuffer(34962, this.glLineVertex);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.lineVertices, 0, 4 * size), 35044);
        this.pgl.bindBuffer(34962, this.glLineColor);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.lineColors, 0, size), 35044);
        this.pgl.bindBuffer(34962, this.glLineAttrib);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.lineAttribs, 0, 4 * size), 35044);
        this.pgl.bindBuffer(34963, this.glLineIndex);
        this.pgl.bufferData(34963, this.tessGeo.lineIndexCount * 2, ShortBuffer.wrap(this.tessGeo.lineIndices, 0, this.tessGeo.lineIndexCount), 35044);
    }

    protected void unbindLineBuffers() {
        this.pgl.bindBuffer(34962, 0);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean lineBufferContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.lineBuffersContext);
    }

    protected void deleteLineBuffers() {
        if (this.lineBuffersCreated) {
            this.deleteVertexBufferObject(this.glLineVertex, this.lineBuffersContext.id());
            this.glLineVertex = 0;
            this.deleteVertexBufferObject(this.glLineColor, this.lineBuffersContext.id());
            this.glLineColor = 0;
            this.deleteVertexBufferObject(this.glLineAttrib, this.lineBuffersContext.id());
            this.glLineAttrib = 0;
            this.deleteVertexBufferObject(this.glLineIndex, this.lineBuffersContext.id());
            this.glLineIndex = 0;
            this.lineBuffersCreated = false;
        }
    }

    protected void createPointBuffers() {
        if (!this.pointBuffersCreated || this.pointBuffersContextIsOutdated()) {
            this.pointBuffersContext = this.pgl.getCurrentContext();
            int sizef = 1024;
            int sizei = 1024;
            int sizex = 1024;
            this.glPointVertex = this.createVertexBufferObject(this.pointBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPointVertex);
            this.pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glPointColor = this.createVertexBufferObject(this.pointBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPointColor);
            this.pgl.bufferData(34962, sizei, null, 35044);
            this.glPointAttrib = this.createVertexBufferObject(this.pointBuffersContext.id());
            this.pgl.bindBuffer(34962, this.glPointAttrib);
            this.pgl.bufferData(34962, 2 * sizef, null, 35044);
            this.pgl.bindBuffer(34962, 0);
            this.glPointIndex = this.createVertexBufferObject(this.pointBuffersContext.id());
            this.pgl.bindBuffer(34963, this.glPointIndex);
            this.pgl.bufferData(34963, sizex, null, 35044);
            this.pgl.bindBuffer(34963, 0);
            this.pointBuffersCreated = true;
        }
    }

    protected void updatePointBuffers() {
        this.createPointBuffers();
        int size = this.tessGeo.pointVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.pgl.bindBuffer(34962, this.glPointVertex);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.pointVertices, 0, 4 * size), 35044);
        this.pgl.bindBuffer(34962, this.glPointColor);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.pointColors, 0, size), 35044);
        this.pgl.bindBuffer(34962, this.glPointAttrib);
        this.pgl.bufferData(34962, 2 * sizef, FloatBuffer.wrap(this.tessGeo.pointAttribs, 0, 2 * size), 35044);
        this.pgl.bindBuffer(34963, this.glPointIndex);
        this.pgl.bufferData(34963, this.tessGeo.pointIndexCount * 2, ShortBuffer.wrap(this.tessGeo.pointIndices, 0, this.tessGeo.pointIndexCount), 35044);
    }

    protected void unbindPointBuffers() {
        this.pgl.bindBuffer(34962, 0);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean pointBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.pointBuffersContext);
    }

    protected void deletePointBuffers() {
        if (this.pointBuffersCreated) {
            this.deleteVertexBufferObject(this.glPointVertex, this.pointBuffersContext.id());
            this.glPointVertex = 0;
            this.deleteVertexBufferObject(this.glPointColor, this.pointBuffersContext.id());
            this.glPointColor = 0;
            this.deleteVertexBufferObject(this.glPointAttrib, this.pointBuffersContext.id());
            this.glPointAttrib = 0;
            this.deleteVertexBufferObject(this.glPointIndex, this.pointBuffersContext.id());
            this.glPointIndex = 0;
            this.pointBuffersCreated = false;
        }
    }

    @Override
    public boolean canDraw() {
        return this.pgl.canDraw();
    }

    @Override
    public void requestDraw() {
        if (this.primarySurface) {
            if (this.pgl.initialized) {
                this.pgl.requestDraw();
            } else {
                this.initPrimary();
            }
        }
    }

    @Override
    public void beginDraw() {
        if (this.drawing) {
            PGraphicsOpenGL.showWarning("Already called beginDraw().");
            return;
        }
        if (pgCurrent != null && !PGraphicsOpenGL.pgCurrent.primarySurface && !this.primarySurface) {
            PGraphicsOpenGL.showWarning("Already called beginDraw() for another PGraphicsOpenGL object.");
            return;
        }
        if (!glParamsRead) {
            this.getGLParameters();
        }
        if (screenFramebuffer == null) {
            screenFramebuffer = new FrameBuffer(this.parent, this.width, this.height, true);
            this.setFramebuffer(screenFramebuffer);
        }
        if (this.primarySurface) {
            this.pgl.updatePrimary();
            this.pgl.drawBuffer(this.pgl.primaryDrawBuffer());
        } else {
            if (!this.pgl.initialized) {
                this.initOffscreen();
            } else {
                boolean outdatedMulti;
                boolean outdated = this.offscreenFramebuffer != null && this.offscreenFramebuffer.contextIsOutdated();
                boolean bl = outdatedMulti = this.offscreenFramebufferMultisample != null && this.offscreenFramebufferMultisample.contextIsOutdated();
                if (outdated || outdatedMulti) {
                    this.pgl.initialized = false;
                    this.initOffscreen();
                }
            }
            this.pushFramebuffer();
            if (this.offscreenMultisample) {
                this.setFramebuffer(this.offscreenFramebufferMultisample);
            } else {
                this.setFramebuffer(this.offscreenFramebuffer);
            }
            this.pgl.updateOffscreen(PGraphicsOpenGL.pgPrimary.pgl);
            this.pgl.drawBuffer(36064);
        }
        this.report("top beginDraw()");
        this.drawing = true;
        pgCurrent = this;
        this.inGeo.clear();
        this.tessGeo.clear();
        this.texCache.clear();
        super.noTexture();
        this.setDefaultBlend();
        if (this.hints[2]) {
            this.pgl.disable(2929);
        } else {
            this.pgl.enable(2929);
        }
        this.pgl.depthFunc(515);
        this.flushMode = this.hints[7] ? 0 : 1;
        if (this.primarySurface) {
            int[] temp = new int[1];
            this.pgl.getIntegerv(32937, temp, 0);
            if (this.quality != temp[0] && 1 < temp[0] && 1 < this.quality) {
                this.quality = temp[0];
            }
        }
        if (this.quality < 2) {
            this.pgl.disable(32925);
        } else {
            this.pgl.enable(32925);
        }
        this.pgl.disable(2832);
        this.pgl.disable(2848);
        this.pgl.disable(2881);
        this.viewport[0] = 0;
        this.viewport[1] = 0;
        this.viewport[2] = this.width;
        this.viewport[3] = this.height;
        this.pgl.viewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        if (this.resized) {
            this.background(this.backgroundColor);
            if (this.texture != null) {
                pgPrimary.removeCache(this);
                this.texture = null;
                this.loadTexture();
            }
            this.resized = false;
        }
        if (this.sized) {
            this.defaultPerspective();
            this.defaultCamera();
            this.sized = false;
        } else {
            this.modelview.set(this.camera);
            this.modelviewInv.set(this.cameraInv);
            this.calcProjmodelview();
        }
        if (this.is3D()) {
            this.noLights();
            this.lightFalloff(1.0f, 0.0f, 0.0f);
            this.lightSpecular(0.0f, 0.0f, 0.0f);
        }
        this.pgl.frontFace(2304);
        this.pgl.disable(2884);
        this.pgl.activeTexture(33984);
        this.normalZ = 0.0f;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        this.pgl.depthMask(true);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clear(1280);
        if (this.primarySurface) {
            this.pgl.beginOnscreenDraw(this.clearColorBuffer);
        } else {
            this.pgl.beginOffscreenDraw(PGraphicsOpenGL.pgPrimary.clearColorBuffer);
            this.offscreenFramebuffer.setColorBuffer(this.texture);
            if (this.clip) {
                this.pgl.enable(3089);
                this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
            } else {
                this.pgl.disable(3089);
            }
        }
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.restoreSurface) {
            this.restoreSurfaceFromPixels();
            this.restoreSurface = false;
        }
        if (this.hints[6]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pixelsOp = 0;
        this.modified = false;
        this.setgetPixels = false;
        this.clearColorBuffer0 = this.clearColorBuffer;
        this.clearColorBuffer = false;
        this.report("bot beginDraw()");
    }

    @Override
    public void endDraw() {
        this.report("top endDraw()");
        this.flush();
        if (!this.drawing) {
            PGraphicsOpenGL.showWarning("Cannot call endDraw() before beginDraw().");
            return;
        }
        if (this.primarySurface) {
            this.pgl.endOnscreenDraw(this.clearColorBuffer0);
            if (!this.pgl.initialized || this.parent.frameCount == 0) {
                this.saveSurfaceToPixels();
                this.restoreSurface = true;
            }
            this.pgl.flush();
        } else {
            if (this.offscreenMultisample) {
                this.offscreenFramebufferMultisample.copy(this.offscreenFramebuffer);
            }
            if (!this.pgl.initialized || !PGraphicsOpenGL.pgPrimary.pgl.initialized || this.parent.frameCount == 0) {
                this.saveSurfaceToPixels();
                this.restoreSurface = true;
            }
            this.popFramebuffer();
            this.texture.updateTexels();
            this.pgl.endOffscreenDraw(PGraphicsOpenGL.pgPrimary.clearColorBuffer0);
            pgPrimary.restoreGL();
        }
        this.drawing = false;
        pgCurrent = pgCurrent == pgPrimary ? null : pgPrimary;
        this.report("bot endDraw()");
    }

    @Override
    public PGL beginPGL() {
        this.flush();
        return this.pgl;
    }

    @Override
    public void endPGL() {
        this.restoreGL();
    }

    protected void restartPGL() {
        this.pgl.initialized = false;
    }

    protected void restoreGL() {
        this.blendMode(this.blendMode);
        if (this.hints[2]) {
            this.pgl.disable(2929);
        } else {
            this.pgl.enable(2929);
        }
        this.pgl.depthFunc(515);
        if (this.quality < 2) {
            this.pgl.disable(32925);
        } else {
            this.pgl.enable(32925);
            this.pgl.disable(2832);
            this.pgl.disable(2848);
            this.pgl.disable(2881);
        }
        this.pgl.viewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        if (this.clip) {
            this.pgl.enable(3089);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(3089);
        }
        this.pgl.frontFace(2304);
        this.pgl.disable(2884);
        this.pgl.activeTexture(33984);
        if (this.hints[6]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pgl.drawBuffer(this.pgl.primaryDrawBuffer());
    }

    protected void beginPixelsOp(int op) {
        if (this.primarySurface) {
            if (this.pgl.primaryIsFboBacked()) {
                if (op == 1) {
                    this.offscreenNotCurrent = true;
                    this.pgl.bindPrimaryColorFBO();
                    this.pgl.readBuffer(this.pgl.primaryDrawBuffer());
                } else {
                    this.offscreenNotCurrent = false;
                    this.pgl.drawBuffer(this.pgl.primaryDrawBuffer());
                }
            } else {
                if (op == 1) {
                    this.pgl.readBuffer(this.pgl.primaryDrawBuffer());
                } else {
                    this.pgl.drawBuffer(this.pgl.primaryDrawBuffer());
                }
                this.offscreenNotCurrent = false;
            }
        } else if (op == 1) {
            boolean bl = this.offscreenNotCurrent = this.offscreenFramebuffer != currentFramebuffer;
            if (this.offscreenNotCurrent) {
                this.pushFramebuffer();
                this.setFramebuffer(this.offscreenFramebuffer);
                this.pgl.updateOffscreen(PGraphicsOpenGL.pgPrimary.pgl);
            }
            this.pgl.readBuffer(36064);
        } else {
            if (this.offscreenMultisample) {
                this.offscreenNotCurrent = this.offscreenFramebufferMultisample != currentFramebuffer;
            } else {
                boolean bl = this.offscreenNotCurrent = this.offscreenFramebuffer != currentFramebuffer;
            }
            if (this.offscreenNotCurrent) {
                this.pushFramebuffer();
                if (this.offscreenMultisample) {
                    this.setFramebuffer(this.offscreenFramebufferMultisample);
                } else {
                    this.setFramebuffer(this.offscreenFramebuffer);
                }
                this.pgl.updateOffscreen(PGraphicsOpenGL.pgPrimary.pgl);
            }
            this.pgl.drawBuffer(36064);
        }
        this.pixelsOp = op;
    }

    protected void endPixelsOp() {
        if (this.offscreenNotCurrent) {
            if (this.primarySurface) {
                this.pgl.bindPrimaryMultiFBO();
            } else {
                if (this.pixelsOp == 2 && this.offscreenMultisample) {
                    this.offscreenFramebufferMultisample.copy(this.offscreenFramebuffer);
                }
                this.popFramebuffer();
            }
        }
        this.pixelsOp = 0;
    }

    protected void updateGLProjection() {
        if (this.glProjection == null) {
            this.glProjection = new float[16];
        }
        this.glProjection[0] = this.projection.m00;
        this.glProjection[1] = this.projection.m10;
        this.glProjection[2] = this.projection.m20;
        this.glProjection[3] = this.projection.m30;
        this.glProjection[4] = this.projection.m01;
        this.glProjection[5] = this.projection.m11;
        this.glProjection[6] = this.projection.m21;
        this.glProjection[7] = this.projection.m31;
        this.glProjection[8] = this.projection.m02;
        this.glProjection[9] = this.projection.m12;
        this.glProjection[10] = this.projection.m22;
        this.glProjection[11] = this.projection.m32;
        this.glProjection[12] = this.projection.m03;
        this.glProjection[13] = this.projection.m13;
        this.glProjection[14] = this.projection.m23;
        this.glProjection[15] = this.projection.m33;
    }

    protected void updateGLModelview() {
        if (this.glModelview == null) {
            this.glModelview = new float[16];
        }
        this.glModelview[0] = this.modelview.m00;
        this.glModelview[1] = this.modelview.m10;
        this.glModelview[2] = this.modelview.m20;
        this.glModelview[3] = this.modelview.m30;
        this.glModelview[4] = this.modelview.m01;
        this.glModelview[5] = this.modelview.m11;
        this.glModelview[6] = this.modelview.m21;
        this.glModelview[7] = this.modelview.m31;
        this.glModelview[8] = this.modelview.m02;
        this.glModelview[9] = this.modelview.m12;
        this.glModelview[10] = this.modelview.m22;
        this.glModelview[11] = this.modelview.m32;
        this.glModelview[12] = this.modelview.m03;
        this.glModelview[13] = this.modelview.m13;
        this.glModelview[14] = this.modelview.m23;
        this.glModelview[15] = this.modelview.m33;
    }

    protected void calcProjmodelview() {
        this.projmodelview.set(this.projection);
        this.projmodelview.apply(this.modelview);
    }

    protected void updateGLProjmodelview() {
        if (this.glProjmodelview == null) {
            this.glProjmodelview = new float[16];
        }
        this.glProjmodelview[0] = this.projmodelview.m00;
        this.glProjmodelview[1] = this.projmodelview.m10;
        this.glProjmodelview[2] = this.projmodelview.m20;
        this.glProjmodelview[3] = this.projmodelview.m30;
        this.glProjmodelview[4] = this.projmodelview.m01;
        this.glProjmodelview[5] = this.projmodelview.m11;
        this.glProjmodelview[6] = this.projmodelview.m21;
        this.glProjmodelview[7] = this.projmodelview.m31;
        this.glProjmodelview[8] = this.projmodelview.m02;
        this.glProjmodelview[9] = this.projmodelview.m12;
        this.glProjmodelview[10] = this.projmodelview.m22;
        this.glProjmodelview[11] = this.projmodelview.m32;
        this.glProjmodelview[12] = this.projmodelview.m03;
        this.glProjmodelview[13] = this.projmodelview.m13;
        this.glProjmodelview[14] = this.projmodelview.m23;
        this.glProjmodelview[15] = this.projmodelview.m33;
    }

    protected void updateGLNormal() {
        if (this.glNormal == null) {
            this.glNormal = new float[9];
        }
        this.glNormal[0] = this.modelviewInv.m00;
        this.glNormal[1] = this.modelviewInv.m01;
        this.glNormal[2] = this.modelviewInv.m02;
        this.glNormal[3] = this.modelviewInv.m10;
        this.glNormal[4] = this.modelviewInv.m11;
        this.glNormal[5] = this.modelviewInv.m12;
        this.glNormal[6] = this.modelviewInv.m20;
        this.glNormal[7] = this.modelviewInv.m21;
        this.glNormal[8] = this.modelviewInv.m22;
    }

    @Override
    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.clearColorBuffer = false;
        this.textureMode(2);
        this.ambient(255);
        this.specular(125);
        this.emissive(0);
        this.shininess(1.0f);
        this.setAmbient = false;
    }

    @Override
    public void hint(int which) {
        boolean oldValue = this.hints[PApplet.abs(which)];
        super.hint(which);
        boolean newValue = this.hints[PApplet.abs(which)];
        if (oldValue == newValue) {
            return;
        }
        if (which == 2) {
            this.flush();
            this.pgl.disable(2929);
        } else if (which == -2) {
            this.flush();
            this.pgl.enable(2929);
        } else if (which == 6) {
            this.flush();
            this.pgl.depthMask(false);
        } else if (which == -6) {
            this.flush();
            this.pgl.depthMask(true);
        } else if (which == -7) {
            this.flush();
            this.setFlushMode(1);
        } else if (which == 7) {
            this.flush();
            this.setFlushMode(0);
        } else if (which == 8) {
            this.flush();
        } else if (which == -10) {
            if (0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
                this.flush();
            }
        } else if (which == 10 && 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
            this.flush();
        }
    }

    protected boolean getHint(int which) {
        if (which > 0) {
            return this.hints[which];
        }
        return !this.hints[-which];
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.inGeo.clear();
        this.breakShape = true;
        this.defaultEdges = true;
        this.textureImage0 = this.textureImage;
        super.noTexture();
        this.normalMode = 0;
    }

    @Override
    public void endShape(int mode) {
        if (this.flushMode == 1 && this.hints[8] && this.textureImage0 != null && this.textureImage == null) {
            this.textureImage = this.textureImage0;
            this.flush();
            this.textureImage = null;
        }
        this.tessellate(mode);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    protected void endShape(int[] indices) {
        this.endShape(indices, null);
    }

    protected void endShape(int[] indices, int[] edges) {
        if (this.shape != 8 && this.shape != 9) {
            throw new RuntimeException("Indices and edges can only be set for TRIANGLE shapes");
        }
        if (this.flushMode == 1 && this.hints[8] && this.textureImage0 != null && this.textureImage == null) {
            this.textureImage = this.textureImage0;
            this.flush();
            this.textureImage = null;
        }
        this.tessellate(indices, edges);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    @Override
    public void textureWrap(int wrap) {
        this.textureWrap = wrap;
    }

    public void textureSampling(int sampling) {
        this.textureSampling = sampling;
    }

    @Override
    public void texture(PImage image) {
        if (this.flushMode == 1 && this.hints[8] && image != this.textureImage0) {
            this.textureImage = this.textureImage0;
            this.flush();
        }
        super.texture(image);
    }

    @Override
    public void noTexture() {
        if (this.flushMode == 1 && this.hints[8] && null != this.textureImage0) {
            this.textureImage = this.textureImage0;
            this.flush();
        }
        super.noTexture();
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphicsOpenGL.showWarning("Already called beginContour().");
            return;
        }
        this.openContour = true;
        this.breakShape = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphicsOpenGL.showWarning("Need to call beginContour() first.");
            return;
        }
        this.openContour = false;
    }

    @Override
    public void vertex(float x, float y) {
        this.vertexImpl(x, y, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        this.vertexImpl(x, y, 0.0f, u, v);
    }

    @Override
    public void vertex(float x, float y, float z) {
        this.vertexImpl(x, y, z, 0.0f, 0.0f);
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        this.vertexImpl(x, y, z, u, v);
    }

    protected void vertexImpl(float x, float y, float z, float u, float v) {
        boolean textured = this.textureImage != null;
        int fcolor = 0;
        if (this.fill || textured) {
            fcolor = !textured ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        int scolor = 0;
        float sweight = 0.0f;
        if (this.stroke) {
            scolor = this.strokeColor;
            sweight = this.strokeWeight;
        }
        if (textured && this.textureMode == 2) {
            u = PApplet.min(1.0f, u / (float)this.textureImage.width);
            v = PApplet.min(1.0f, v / (float)this.textureImage.height);
        }
        this.inGeo.addVertex(x, y, z, fcolor, this.normalX, this.normalY, this.normalZ, u, v, scolor, sweight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, this.vertexCode());
    }

    protected int vertexCode() {
        int code = 0;
        if (this.breakShape) {
            code = 4;
            this.breakShape = false;
        }
        return code;
    }

    @Override
    public void clip(float a, float b, float c, float d) {
        if (this.imageMode == 0) {
            if (c < 0.0f) {
                a += c;
                c = -c;
            }
            if (d < 0.0f) {
                b += d;
                d = -d;
            }
            this.clipImpl(a, b, a + c, b + d);
        } else if (this.imageMode == 1) {
            float temp;
            if (c < a) {
                temp = a;
                a = c;
                c = temp;
            }
            if (d < b) {
                temp = b;
                b = d;
                d = temp;
            }
            this.clipImpl(a, b, c, d);
        } else if (this.imageMode == 3) {
            if (c < 0.0f) {
                c = -c;
            }
            if (d < 0.0f) {
                d = -d;
            }
            float x1 = a - c / 2.0f;
            float y1 = b - d / 2.0f;
            this.clipImpl(x1, y1, x1 + c, y1 + d);
        }
    }

    protected void clipImpl(float x1, float y1, float x2, float y2) {
        this.flush();
        this.pgl.enable(3089);
        float h = y2 - y1;
        this.clipRect[0] = (int)x1;
        this.clipRect[1] = (int)((float)this.height - y1 - h);
        this.clipRect[2] = (int)(x2 - x1);
        this.clipRect[3] = (int)h;
        this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        this.clip = true;
    }

    @Override
    public void noClip() {
        if (this.clip) {
            this.flush();
            this.pgl.disable(3089);
            this.clip = false;
        }
    }

    protected void tessellate(int mode) {
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage0, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.shape == 3) {
            tessellator.tessellatePoints();
        } else if (this.shape == 5) {
            tessellator.tessellateLines();
        } else if (this.shape == 50) {
            tessellator.tessellateLineStrip();
        } else if (this.shape == 51) {
            tessellator.tessellateLineLoop();
        } else if (this.shape == 8 || this.shape == 9) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTrianglesEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTrianglesNormals();
            }
            tessellator.tessellateTriangles();
        } else if (this.shape == 11) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleFanEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleFanNormals();
            }
            tessellator.tessellateTriangleFan();
        } else if (this.shape == 10) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleStripNormals();
            }
            tessellator.tessellateTriangleStrip();
        } else if (this.shape == 16 || this.shape == 17) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadsEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadsNormals();
            }
            tessellator.tessellateQuads();
        } else if (this.shape == 18) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadStripNormals();
            }
            tessellator.tessellateQuadStrip();
        } else if (this.shape == 20) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addPolygonEdges(mode == 2);
            }
            tessellator.tessellatePolygon(false, mode == 2, this.normalMode == 0);
        }
    }

    protected void tessellate(int[] indices, int[] edges) {
        if (edges != null) {
            int nedges = edges.length / 2;
            for (int n = 0; n < nedges; ++n) {
                int i0 = edges[2 * n + 0];
                int i1 = edges[2 * n + 1];
                this.inGeo.addEdge(i0, i1, n == 0, n == nedges - 1);
            }
        }
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage0, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.stroke && this.defaultEdges && edges == null) {
            this.inGeo.addTrianglesEdges();
        }
        if (this.normalMode == 0) {
            this.inGeo.calcTrianglesNormals();
        }
        tessellator.tessellateTriangles(indices);
    }

    @Override
    public void flush() {
        boolean hasPixels;
        boolean hasPolys = 0 < this.tessGeo.polyVertexCount && 0 < this.tessGeo.polyIndexCount;
        boolean hasLines = 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount;
        boolean hasPoints = 0 < this.tessGeo.pointVertexCount && 0 < this.tessGeo.pointIndexCount;
        boolean bl = hasPixels = this.modified && this.pixels != null;
        if (hasPixels) {
            this.flushPixels();
            this.setgetPixels = false;
        }
        if (hasPoints || hasLines || hasPolys) {
            PMatrix3D modelview0 = null;
            PMatrix3D modelviewInv0 = null;
            if (this.flushMode == 1 && !this.hints[9]) {
                modelview0 = this.modelview;
                modelviewInv0 = this.modelviewInv;
                this.modelview = this.modelviewInv = identity;
                this.projmodelview.set(this.projection);
            }
            if (hasPolys) {
                this.flushPolys();
                if (this.raw != null) {
                    this.rawPolys();
                }
            }
            if (this.is3D()) {
                if (hasLines) {
                    this.flushLines();
                    if (this.raw != null) {
                        this.rawLines();
                    }
                }
                if (hasPoints) {
                    this.flushPoints();
                    if (this.raw != null) {
                        this.rawPoints();
                    }
                }
            }
            if (this.flushMode == 1 && !this.hints[9]) {
                this.modelview = modelview0;
                this.modelviewInv = modelviewInv0;
                this.calcProjmodelview();
            }
        }
        this.tessGeo.clear();
        this.texCache.clear();
    }

    protected void flushPixels() {
        this.drawPixels(this.mx1, this.my1, this.mx2 - this.mx1 + 1, this.my2 - this.my1 + 1);
        this.modified = false;
    }

    protected void flushPolys() {
        this.updatePolyBuffers(this.lights, this.texCache.hasTexture);
        this.texCache.beginRender();
        for (int i = 0; i < this.texCache.size; ++i) {
            Texture tex = this.texCache.getTexture(i);
            PolyShader shader = this.getPolyShader(this.lights, tex != null);
            shader.bind();
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            for (int n = first; n <= last; ++n) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                shader.setVertexAttribute(this.glPolyVertex, 4, 5126, 0, 4 * voffset * 4);
                shader.setColorAttribute(this.glPolyColor, 4, 5121, 0, 4 * voffset * 1);
                if (this.lights) {
                    shader.setNormalAttribute(this.glPolyNormal, 3, 5126, 0, 3 * voffset * 4);
                    shader.setAmbientAttribute(this.glPolyAmbient, 4, 5121, 0, 4 * voffset * 1);
                    shader.setSpecularAttribute(this.glPolySpecular, 4, 5121, 0, 4 * voffset * 1);
                    shader.setEmissiveAttribute(this.glPolyEmissive, 4, 5121, 0, 4 * voffset * 1);
                    shader.setShininessAttribute(this.glPolyShininess, 1, 5126, 0, voffset * 4);
                }
                if (tex != null) {
                    shader.setTexcoordAttribute(this.glPolyTexcoord, 2, 5126, 0, 2 * voffset * 4);
                    shader.setTexture(tex);
                }
                this.pgl.bindBuffer(34963, this.glPolyIndex);
                this.pgl.drawElements(4, icount, 5123, ioffset * 2);
                this.pgl.bindBuffer(34963, 0);
            }
            shader.unbind();
        }
        this.texCache.endRender();
        this.unbindPolyBuffers();
    }

    void rawPolys() {
        this.raw.colorMode(1);
        this.raw.noStroke();
        this.raw.beginShape(9);
        float[] vertices = this.tessGeo.polyVertices;
        int[] color = this.tessGeo.polyColors;
        float[] uv = this.tessGeo.polyTexcoords;
        short[] indices = this.tessGeo.polyIndices;
        for (int i = 0; i < this.texCache.size; ++i) {
            PImage textureImage = this.texCache.getTextureImage(i);
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            for (int n = first; n <= last; ++n) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                for (int tr = ioffset / 3; tr < (ioffset + icount) / 3; ++tr) {
                    float sy2;
                    float sx2;
                    float sy1;
                    int i0 = voffset + indices[3 * tr + 0];
                    int i1 = voffset + indices[3 * tr + 1];
                    int i2 = voffset + indices[3 * tr + 2];
                    float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    int argb2 = PGL.nativeToJavaARGB(color[i2]);
                    if (this.flushMode == 0 || this.hints[9]) {
                        float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i2, src2, 0, 4);
                        this.modelview.mult(src0, pt0);
                        this.modelview.mult(src1, pt1);
                        this.modelview.mult(src2, pt2);
                    } else {
                        PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, pt1, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i2, pt2, 0, 4);
                    }
                    if (textureImage != null) {
                        this.raw.texture(textureImage);
                        if (this.raw.is3D()) {
                            this.raw.fill(argb0);
                            this.raw.vertex(pt0[0], pt0[1], pt0[2], uv[2 * i0 + 0], uv[2 * i0 + 1]);
                            this.raw.fill(argb1);
                            this.raw.vertex(pt1[0], pt1[1], pt1[2], uv[2 * i1 + 0], uv[2 * i1 + 1]);
                            this.raw.fill(argb2);
                            this.raw.vertex(pt2[0], pt2[1], pt2[2], uv[2 * i2 + 0], uv[2 * i2 + 1]);
                            continue;
                        }
                        if (!this.raw.is2D()) continue;
                        float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sx2 = this.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        sy2 = this.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        this.raw.fill(argb0);
                        this.raw.vertex(sx0, sy0, uv[2 * i0 + 0], uv[2 * i0 + 1]);
                        this.raw.fill(argb1);
                        this.raw.vertex(sx1, sy1, uv[2 * i1 + 0], uv[2 * i1 + 1]);
                        this.raw.fill(argb1);
                        this.raw.vertex(sx2, sy2, uv[2 * i2 + 0], uv[2 * i2 + 1]);
                        continue;
                    }
                    if (this.raw.is3D()) {
                        this.raw.fill(argb0);
                        this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                        this.raw.fill(argb1);
                        this.raw.vertex(pt1[0], pt1[1], pt1[2]);
                        this.raw.fill(argb2);
                        this.raw.vertex(pt2[0], pt2[1], pt2[2]);
                        continue;
                    }
                    if (!this.raw.is2D()) continue;
                    float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                    sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                    sx2 = this.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                    sy2 = this.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                    this.raw.fill(argb0);
                    this.raw.vertex(sx0, sy0);
                    this.raw.fill(argb1);
                    this.raw.vertex(sx1, sy1);
                    this.raw.fill(argb2);
                    this.raw.vertex(sx2, sy2);
                }
            }
        }
        this.raw.endShape();
    }

    protected void flushLines() {
        this.updateLineBuffers();
        LineShader shader = this.getLineShader();
        shader.bind();
        IndexCache cache = this.tessGeo.lineIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.glLineVertex, 4, 5126, 0, 4 * voffset * 4);
            shader.setColorAttribute(this.glLineColor, 4, 5121, 0, 4 * voffset * 1);
            shader.setLineAttribute(this.glLineAttrib, 4, 5126, 0, 4 * voffset * 4);
            this.pgl.bindBuffer(34963, this.glLineIndex);
            this.pgl.drawElements(4, icount, 5123, ioffset * 2);
            this.pgl.bindBuffer(34963, 0);
        }
        shader.unbind();
        this.unbindLineBuffers();
    }

    void rawLines() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.strokeJoin(this.strokeJoin);
        this.raw.beginShape(5);
        float[] vertices = this.tessGeo.lineVertices;
        int[] color = this.tessGeo.lineColors;
        float[] attribs = this.tessGeo.lineAttribs;
        short[] indices = this.tessGeo.lineIndices;
        IndexCache cache = this.tessGeo.lineIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            for (int ln = ioffset / 6; ln < (ioffset + icount) / 6; ++ln) {
                int i0 = voffset + indices[6 * ln + 0];
                int i1 = voffset + indices[6 * ln + 5];
                float sw0 = 2.0f * attribs[4 * i0 + 3];
                float sw1 = 2.0f * attribs[4 * i1 + 3];
                if (PGraphicsOpenGL.zero(sw0)) continue;
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                int argb1 = PGL.nativeToJavaARGB(color[i1]);
                if (this.flushMode == 0 || this.hints[9]) {
                    float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                    this.modelview.mult(src0, pt0);
                    this.modelview.mult(src1, pt1);
                } else {
                    PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i1, pt1, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(sw0);
                    this.raw.stroke(argb0);
                    this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                    this.raw.strokeWeight(sw1);
                    this.raw.stroke(argb1);
                    this.raw.vertex(pt1[0], pt1[1], pt1[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                float sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                this.raw.strokeWeight(sw0);
                this.raw.stroke(argb0);
                this.raw.vertex(sx0, sy0);
                this.raw.strokeWeight(sw1);
                this.raw.stroke(argb1);
                this.raw.vertex(sx1, sy1);
            }
        }
        this.raw.endShape();
    }

    protected void flushPoints() {
        this.updatePointBuffers();
        PointShader shader = this.getPointShader();
        shader.bind();
        IndexCache cache = this.tessGeo.pointIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.glPointVertex, 4, 5126, 0, 4 * voffset * 4);
            shader.setColorAttribute(this.glPointColor, 4, 5121, 0, 4 * voffset * 1);
            shader.setPointAttribute(this.glPointAttrib, 2, 5126, 0, 2 * voffset * 4);
            this.pgl.bindBuffer(34963, this.glPointIndex);
            this.pgl.drawElements(4, icount, 5123, ioffset * 2);
            this.pgl.bindBuffer(34963, 0);
        }
        shader.unbind();
        this.unbindPointBuffers();
    }

    void rawPoints() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.beginShape(3);
        float[] vertices = this.tessGeo.pointVertices;
        int[] color = this.tessGeo.pointColors;
        float[] attribs = this.tessGeo.pointAttribs;
        short[] indices = this.tessGeo.pointIndices;
        IndexCache cache = this.tessGeo.pointIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int perim;
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            for (int pt = ioffset; pt < (ioffset + icount) / 3; pt += perim) {
                float weight;
                float size = attribs[2 * pt + 2];
                if (0.0f < size) {
                    weight = size / 0.5f;
                    perim = PApplet.max(20, (int)((float)Math.PI * 2 * weight / 10.0f)) + 1;
                } else {
                    weight = -size / 0.5f;
                    perim = 5;
                }
                int i0 = voffset + indices[3 * pt];
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                if (this.flushMode == 0 || this.hints[9]) {
                    float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    this.modelview.mult(src0, pt0);
                } else {
                    PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(weight);
                    this.raw.stroke(argb0);
                    this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                this.raw.strokeWeight(weight);
                this.raw.stroke(argb0);
                this.raw.vertex(sx0, sy0);
            }
        }
        this.raw.endShape();
    }

    @Override
    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierVertexImpl(x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.bezierVertexImpl(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    protected void bezierVertexImpl(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        this.quadraticVertexImpl(cx, cy, 0.0f, x3, y3, 0.0f);
    }

    @Override
    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.quadraticVertexImpl(cx, cy, cz, x3, y3, z3);
    }

    protected void quadraticVertexImpl(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(cx, cy, cz, x3, y3, z3, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void curveVertex(float x, float y) {
        this.curveVertexImpl(x, y, 0.0f);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        this.curveVertexImpl(x, y, z);
    }

    protected void curveVertexImpl(float x, float y, float z) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(x, y, z, this.fill, this.stroke, this.curveDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void point(float x, float y) {
        this.pointImpl(x, y, 0.0f);
    }

    @Override
    public void point(float x, float y, float z) {
        this.pointImpl(x, y, z);
    }

    protected void pointImpl(float x, float y, float z) {
        this.beginShape(3);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(x, y, z, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        this.lineImpl(x1, y1, 0.0f, x2, y2, 0.0f);
    }

    @Override
    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.lineImpl(x1, y1, z1, x2, y2, z2);
    }

    protected void lineImpl(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.beginShape(5);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(x1, y1, z1, x2, y2, z2, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void rect(float a, float b, float c, float d) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(a, b, c, d, this.fill, this.stroke, this.rectMode);
        this.endShape();
    }

    @Override
    public void rect(float a, float b, float c, float d, float tl, float tr, float br, float bl) {
        this.beginShape(20);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(a, b, c, d, tl, tr, br, bl, this.fill, this.stroke, this.bezierDetail, this.rectMode);
        this.endShape(2);
    }

    @Override
    public void ellipse(float a, float b, float c, float d) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(a, b, c, d, this.fill, this.stroke, this.ellipseMode);
        this.endShape();
    }

    @Override
    public void arc(float a, float b, float c, float d, float start, float stop) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addArc(a, b, c, d, start, stop, this.fill, this.stroke, this.ellipseMode);
        this.endShape();
    }

    @Override
    public void box(float w, float h, float d) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(w, h, d, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void sphere(float r) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] indices = this.inGeo.addSphere(r, this.sphereDetailU, this.sphereDetailV, this.fill, this.stroke);
        this.endShape(indices);
    }

    @Override
    public void smooth() {
        this.smooth(2);
    }

    @Override
    public void smooth(int level) {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = true;
        if (maxSamples < level) {
            PGraphics.showWarning("Smooth level " + level + " is not supported by the hardware. Using " + maxSamples + " instead.");
            level = maxSamples;
        }
        if (this.quality != level) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning("The smooth/noSmooth functions are being called too often.\nThis results in screen flickering, so they will be disabled\nfor the rest of the sketch's execution.");
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = level;
            if (this.quality == 1) {
                this.quality = 0;
            }
            this.pgl.initialized = false;
        }
    }

    @Override
    public void noSmooth() {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = false;
        if (1 < this.quality) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning("The smooth/noSmooth functions are being called too often.\nThis results in screen flickering, so they will be disabled\nfor the rest of the sketch's execution.");
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = 0;
            this.pgl.initialized = false;
        }
    }

    @Override
    protected void shape(PShape shape, float x, float y, float z) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - shape.getWidth() / 2.0f, y - shape.getHeight() / 2.0f, z - shape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(x, y, z);
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    protected void shape(PShape shape, float x, float y, float z, float c, float d, float e) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - c / 2.0f, y - d / 2.0f, z - e / 2.0f);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(x, y, z);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(x, y, z);
                this.scale((c -= x) / shape.getWidth(), (d -= y) / shape.getHeight(), (e -= z) / shape.getDepth());
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    public PShape loadShape(String filename) {
        String ext = PApplet.getExtension(filename);
        if (PGraphics2D.isSupportedExtension(ext)) {
            return PGraphics2D.loadShapeImpl(this, filename, ext);
        }
        if (PGraphics3D.isSupportedExtension(ext)) {
            return PGraphics3D.loadShapeImpl(this, filename, ext);
        }
        PGraphics.showWarning("Unsupported format");
        return null;
    }

    @Override
    protected boolean textModeCheck(int mode) {
        return mode == 4;
    }

    @Override
    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        this.textTex = pgPrimary.getFontTexture(this.textFont);
        if (this.textTex == null) {
            this.textTex = new FontTexture(this.parent, this.textFont, maxTextureSize, maxTextureSize, this.is3D());
            pgPrimary.setFontTexture(this.textFont, this.textTex);
        } else if (this.textTex.contextIsOutdated()) {
            this.textTex = new FontTexture(this.parent, this.textFont, PApplet.min(1024, maxTextureSize), PApplet.min(1024, maxTextureSize), this.is3D());
            pgPrimary.setFontTexture(this.textFont, this.textTex);
        }
        this.textTex.begin();
        int savedTextureMode = this.textureMode;
        boolean savedStroke = this.stroke;
        float savedNormalX = this.normalX;
        float savedNormalY = this.normalY;
        float savedNormalZ = this.normalZ;
        boolean savedTint = this.tint;
        int savedTintColor = this.tintColor;
        int savedBlendMode = this.blendMode;
        this.textureMode = 1;
        this.stroke = false;
        this.normalX = 0.0f;
        this.normalY = 0.0f;
        this.normalZ = 1.0f;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.blendMode(1);
        super.textLineImpl(buffer, start, stop, x, y);
        this.textureMode = savedTextureMode;
        this.stroke = savedStroke;
        this.normalX = savedNormalX;
        this.normalY = savedNormalY;
        this.normalZ = savedNormalZ;
        this.tint = savedTint;
        this.tintColor = savedTintColor;
        this.blendMode(savedBlendMode);
        this.textTex.end();
    }

    @Override
    protected void textCharImpl(char ch, float x, float y) {
        PFont.Glyph glyph = this.textFont.getGlyph(ch);
        if (glyph != null) {
            FontTexture.TextureInfo tinfo = this.textTex.getTexInfo(glyph);
            if (tinfo == null) {
                tinfo = this.textTex.addToTexture(glyph);
            }
            if (this.textMode == 4) {
                float high = (float)glyph.height / (float)this.textFont.getSize();
                float bwidth = (float)glyph.width / (float)this.textFont.getSize();
                float lextent = (float)glyph.leftExtent / (float)this.textFont.getSize();
                float textent = (float)glyph.topExtent / (float)this.textFont.getSize();
                float x1 = x + lextent * this.textSize;
                float y1 = y - textent * this.textSize;
                float x2 = x1 + bwidth * this.textSize;
                float y2 = y1 + high * this.textSize;
                this.textCharModelImpl(tinfo, x1, y1, x2, y2);
            }
        }
    }

    protected void textCharModelImpl(FontTexture.TextureInfo info, float x0, float y0, float x1, float y1) {
        if (this.textTex.currentTex != info.texIndex) {
            this.textTex.setTexture(info.texIndex);
        }
        PImage tex = this.textTex.getCurrentTexture();
        this.beginShape(17);
        this.texture(tex);
        this.vertex(x0, y0, info.u0, info.v0);
        this.vertex(x1, y0, info.u1, info.v0);
        this.vertex(x1, y1, info.u1, info.v1);
        this.vertex(x0, y1, info.u0, info.v1);
        this.endShape();
    }

    @Override
    public void pushMatrix() {
        if (this.modelviewStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.modelview.get(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.get(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.get(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.get(this.cameraInvStack[this.modelviewStackDepth]);
        ++this.modelviewStackDepth;
    }

    @Override
    public void popMatrix() {
        if (this.hints[9]) {
            this.flush();
        }
        if (this.modelviewStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.modelviewStackDepth;
        this.modelview.set(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.set(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.set(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.set(this.cameraInvStack[this.modelviewStackDepth]);
        this.calcProjmodelview();
    }

    @Override
    public void translate(float tx, float ty) {
        this.translateImpl(tx, ty, 0.0f);
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        this.translateImpl(tx, ty, tz);
    }

    protected void translateImpl(float tx, float ty, float tz) {
        if (this.hints[9]) {
            this.flush();
        }
        this.modelview.translate(tx, ty, tz);
        PGraphicsOpenGL.invTranslate(this.modelviewInv, tx, ty, tz);
        this.projmodelview.translate(tx, ty, tz);
    }

    protected static void invTranslate(PMatrix3D matrix, float tx, float ty, float tz) {
        matrix.preApply(1.0f, 0.0f, 0.0f, -tx, 0.0f, 1.0f, 0.0f, -ty, 0.0f, 0.0f, 1.0f, -tz, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float angle) {
        this.rotateImpl(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotateX(float angle) {
        this.rotateImpl(angle, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateY(float angle) {
        this.rotateImpl(angle, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void rotateZ(float angle) {
        this.rotateImpl(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float angle, float v0, float v1, float v2) {
        this.rotateImpl(angle, v0, v1, v2);
    }

    protected void rotateImpl(float angle, float v0, float v1, float v2) {
        float norm2;
        if (this.hints[9]) {
            this.flush();
        }
        if (PGraphicsOpenGL.zero(norm2 = v0 * v0 + v1 * v1 + v2 * v2)) {
            return;
        }
        if (PGraphicsOpenGL.diff(norm2, 1.0f)) {
            float norm = PApplet.sqrt(norm2);
            v0 /= norm;
            v1 /= norm;
            v2 /= norm;
        }
        this.modelview.rotate(angle, v0, v1, v2);
        PGraphicsOpenGL.invRotate(this.modelviewInv, angle, v0, v1, v2);
        this.calcProjmodelview();
    }

    private static void invRotate(PMatrix3D matrix, float angle, float v0, float v1, float v2) {
        float c = PApplet.cos(-angle);
        float s = PApplet.sin(-angle);
        float t = 1.0f - c;
        matrix.preApply(t * v0 * v0 + c, t * v0 * v1 - s * v2, t * v0 * v2 + s * v1, 0.0f, t * v0 * v1 + s * v2, t * v1 * v1 + c, t * v1 * v2 - s * v0, 0.0f, t * v0 * v2 - s * v1, t * v1 * v2 + s * v0, t * v2 * v2 + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void scale(float s) {
        this.scaleImpl(s, s, s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.scaleImpl(sx, sy, 1.0f);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        this.scaleImpl(sx, sy, sz);
    }

    protected void scaleImpl(float sx, float sy, float sz) {
        if (this.hints[9]) {
            this.flush();
        }
        this.modelview.scale(sx, sy, sz);
        PGraphicsOpenGL.invScale(this.modelviewInv, sx, sy, sz);
        this.projmodelview.scale(sx, sy, sz);
    }

    protected static void invScale(PMatrix3D matrix, float x, float y, float z) {
        matrix.preApply(1.0f / x, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearX(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrixImpl(1.0f, t, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearY(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrixImpl(1.0f, 0.0f, 0.0f, 0.0f, t, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void resetMatrix() {
        if (this.hints[9]) {
            this.flush();
        }
        this.modelview.reset();
        this.modelviewInv.reset();
        this.projmodelview.set(this.projection);
        this.camera.reset();
        this.cameraInv.reset();
    }

    @Override
    public void applyMatrix(PMatrix2D source) {
        this.applyMatrixImpl(source.m00, source.m01, 0.0f, source.m02, source.m10, source.m11, 0.0f, source.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.applyMatrixImpl(n00, n01, 0.0f, n02, n10, n11, 0.0f, n12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(PMatrix3D source) {
        this.applyMatrixImpl(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.applyMatrixImpl(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void applyMatrixImpl(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        if (this.hints[9]) {
            this.flush();
        }
        this.modelview.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.projmodelview.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void begin2D() {
    }

    protected void end2D() {
    }

    @Override
    public PMatrix getMatrix() {
        return this.modelview.get();
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        if (target == null) {
            target = new PMatrix3D();
        }
        target.set(this.modelview);
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    @Override
    public void printMatrix() {
        this.modelview.print();
    }

    public void pushProjection() {
        if (this.projectionStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.projection.get(this.projectionStack[this.projectionStackDepth]);
        ++this.projectionStackDepth;
    }

    public void popProjection() {
        this.flush();
        if (this.projectionStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.projectionStackDepth;
        this.projection.set(this.projectionStack[this.projectionStackDepth]);
        this.checkOrthoProjection();
    }

    public void applyProjection(PMatrix3D mat) {
        this.flush();
        this.projection.apply(mat);
        this.checkOrthoProjection();
    }

    public void setProjection(PMatrix3D mat) {
        this.flush();
        this.projection.set(mat);
        this.checkOrthoProjection();
    }

    protected void checkOrthoProjection() {
        this.usingOrthoProjection = PGraphicsOpenGL.zero(this.projection.m01) && PGraphicsOpenGL.zero(this.projection.m02) && PGraphicsOpenGL.zero(this.projection.m10) && PGraphicsOpenGL.zero(this.projection.m12) && PGraphicsOpenGL.zero(this.projection.m20) && PGraphicsOpenGL.zero(this.projection.m21) && PGraphicsOpenGL.zero(this.projection.m30) && PGraphicsOpenGL.zero(this.projection.m31) && PGraphicsOpenGL.zero(this.projection.m32) && PGraphicsOpenGL.same(this.projection.m33, 1.0f);
    }

    protected static boolean same(float a, float b) {
        return Math.abs(a - b) < PGL.FLOAT_EPS;
    }

    protected static boolean diff(float a, float b) {
        return PGL.FLOAT_EPS <= Math.abs(a - b);
    }

    protected static boolean zero(float a) {
        return Math.abs(a) < PGL.FLOAT_EPS;
    }

    protected static boolean nonZero(float a) {
        return PGL.FLOAT_EPS <= Math.abs(a);
    }

    @Override
    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
    }

    @Override
    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.manipulatingCamera = false;
    }

    @Override
    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float z2;
        float z1;
        float z0;
        float mag;
        if (this.hints[9]) {
            this.flush();
        }
        if (PGraphicsOpenGL.nonZero(mag = PApplet.sqrt((z0 = eyeX - centerX) * z0 + (z1 = eyeY - centerY) * z1 + (z2 = eyeZ - centerZ) * z2))) {
            z0 /= mag;
            z1 /= mag;
            z2 /= mag;
        }
        this.cameraEyeX = eyeX;
        this.cameraEyeY = eyeY;
        this.cameraEyeZ = eyeZ;
        float y0 = upX;
        float y1 = upY;
        float y2 = upZ;
        float x0 = y1 * z2 - y2 * z1;
        float x1 = -y0 * z2 + y2 * z0;
        float x2 = y0 * z1 - y1 * z0;
        y0 = z1 * x2 - z2 * x1;
        y1 = -z0 * x2 + z2 * x0;
        y2 = z0 * x1 - z1 * x0;
        mag = PApplet.sqrt(x0 * x0 + x1 * x1 + x2 * x2);
        if (PGraphicsOpenGL.nonZero(mag)) {
            x0 /= mag;
            x1 /= mag;
            x2 /= mag;
        }
        if (PGraphicsOpenGL.nonZero(mag = PApplet.sqrt(y0 * y0 + y1 * y1 + y2 * y2))) {
            y0 /= mag;
            y1 /= mag;
            y2 /= mag;
        }
        this.modelview.set(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float tx = -eyeX;
        float ty = -eyeY;
        float tz = -eyeZ;
        this.modelview.translate(tx, ty, tz);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.calcProjmodelview();
    }

    public void camera(float centerX, float centerY) {
        this.modelview.reset();
        this.modelview.translate(-centerX, -centerY);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.calcProjmodelview();
    }

    @Override
    public void printCamera() {
        this.camera.print();
    }

    protected void defaultCamera() {
        this.camera();
    }

    @Override
    public void ortho() {
        this.ortho(-this.width / 2, this.width / 2, -this.height / 2, this.height / 2, this.cameraNear, this.cameraFar);
    }

    @Override
    public void ortho(float left, float right, float bottom, float top) {
        this.ortho(left, right, bottom, top, this.cameraNear, this.cameraFar);
    }

    @Override
    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        this.flush();
        float x = 2.0f / (right - left);
        float y = 2.0f / (top - bottom);
        float z = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.projection.set(x, 0.0f, 0.0f, tx, 0.0f, -y, 0.0f, ty, 0.0f, 0.0f, z, tz, 0.0f, 0.0f, 0.0f, 1.0f);
        this.calcProjmodelview();
        this.usingOrthoProjection = true;
    }

    @Override
    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    @Override
    public void perspective(float fov, float aspect, float zNear, float zFar) {
        float ymax = zNear * (float)Math.tan(fov / 2.0f);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustum(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    @Override
    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        this.flush();
        float n2 = 2.0f * znear;
        float w = right - left;
        float h = top - bottom;
        float d = zfar - znear;
        this.projection.set(n2 / w, 0.0f, (right + left) / w, 0.0f, 0.0f, -n2 / h, (top + bottom) / h, 0.0f, 0.0f, 0.0f, -(zfar + znear) / d, -(n2 * zfar) / d, 0.0f, 0.0f, -1.0f, 0.0f);
        this.calcProjmodelview();
        this.usingOrthoProjection = false;
    }

    @Override
    public void printProjection() {
        this.projection.print();
    }

    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    public float screenX(float x, float y) {
        return this.screenXImpl(x, y, 0.0f);
    }

    @Override
    public float screenY(float x, float y) {
        return this.screenYImpl(x, y, 0.0f);
    }

    @Override
    public float screenX(float x, float y, float z) {
        return this.screenXImpl(x, y, z);
    }

    @Override
    public float screenY(float x, float y, float z) {
        return this.screenYImpl(x, y, z);
    }

    @Override
    public float screenZ(float x, float y, float z) {
        return this.screenZImpl(x, y, z);
    }

    protected float screenXImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenXImpl(ax, ay, az, aw);
    }

    protected float screenXImpl(float x, float y, float z, float w) {
        float ox = this.projection.m00 * x + this.projection.m01 * y + this.projection.m02 * z + this.projection.m03 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            ox /= ow;
        }
        float sx = (float)this.width * (1.0f + ox) / 2.0f;
        return sx;
    }

    protected float screenYImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenYImpl(ax, ay, az, aw);
    }

    protected float screenYImpl(float x, float y, float z, float w) {
        float oy = this.projection.m10 * x + this.projection.m11 * y + this.projection.m12 * z + this.projection.m13 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            oy /= ow;
        }
        float sy = (float)this.height * (1.0f + oy) / 2.0f;
        sy = (float)this.height - sy;
        return sy;
    }

    protected float screenZImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenZImpl(ax, ay, az, aw);
    }

    protected float screenZImpl(float x, float y, float z, float w) {
        float oz = this.projection.m20 * x + this.projection.m21 * y + this.projection.m22 * z + this.projection.m23 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            oz /= ow;
        }
        float sz = (oz + 1.0f) / 2.0f;
        return sz;
    }

    @Override
    public float modelX(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float ox = this.cameraInv.m00 * ax + this.cameraInv.m01 * ay + this.cameraInv.m02 * az + this.cameraInv.m03 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? ox / ow : ox;
    }

    @Override
    public float modelY(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oy = this.cameraInv.m10 * ax + this.cameraInv.m11 * ay + this.cameraInv.m12 * az + this.cameraInv.m13 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? oy / ow : oy;
    }

    @Override
    public float modelZ(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oz = this.cameraInv.m20 * ax + this.cameraInv.m21 * ay + this.cameraInv.m22 * az + this.cameraInv.m23 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? oz / ow : oz;
    }

    @Override
    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    @Override
    public void strokeJoin(int join) {
        this.strokeJoin = join;
    }

    @Override
    public void strokeCap(int cap) {
        this.strokeCap = cap;
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        if (!this.setAmbient) {
            this.ambientFromCalc();
            this.setAmbient = false;
        }
    }

    @Override
    public void lights() {
        this.enableLighting();
        int colorModeSaved = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = colorModeSaved;
    }

    @Override
    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    @Override
    public void ambientLight(float r, float g, float b) {
        this.ambientLight(r, g, b, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 0;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.lightAmbient(this.lightCount, r, g, b);
        this.noLightDiffuse(this.lightCount);
        this.noLightSpecular(this.lightCount);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void directionalLight(float r, float g, float b, float dx, float dy, float dz) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 1;
        this.lightPosition(this.lightCount, 0.0f, 0.0f, 0.0f, true);
        this.lightNormal(this.lightCount, dx, dy, dz);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.noLightFalloff(this.lightCount);
        ++this.lightCount;
    }

    @Override
    public void pointLight(float r, float g, float b, float x, float y, float z) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 2;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void spotLight(float r, float g, float b, float x, float y, float z, float dx, float dy, float dz, float angle, float concentration) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 3;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, dx, dy, dz);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.lightSpot(this.lightCount, angle, concentration);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void lightFalloff(float constant, float linear, float quadratic) {
        this.currentLightFalloffConstant = constant;
        this.currentLightFalloffLinear = linear;
        this.currentLightFalloffQuadratic = quadratic;
    }

    @Override
    public void lightSpecular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
    }

    protected void enableLighting() {
        if (!this.lights) {
            this.flush();
            this.lights = true;
        }
    }

    protected void disableLighting() {
        if (this.lights) {
            this.flush();
            this.lights = false;
        }
    }

    protected void lightPosition(int num, float x, float y, float z, boolean dir) {
        this.lightPosition[4 * num + 0] = x * this.modelview.m00 + y * this.modelview.m01 + z * this.modelview.m02 + this.modelview.m03;
        this.lightPosition[4 * num + 1] = x * this.modelview.m10 + y * this.modelview.m11 + z * this.modelview.m12 + this.modelview.m13;
        this.lightPosition[4 * num + 2] = x * this.modelview.m20 + y * this.modelview.m21 + z * this.modelview.m22 + this.modelview.m23;
        this.lightPosition[4 * num + 3] = dir ? 1.0f : 0.0f;
    }

    protected void lightNormal(int num, float dx, float dy, float dz) {
        float nx = dx * this.modelviewInv.m00 + dy * this.modelviewInv.m10 + dz * this.modelviewInv.m20;
        float ny = dx * this.modelviewInv.m01 + dy * this.modelviewInv.m11 + dz * this.modelviewInv.m21;
        float nz = dx * this.modelviewInv.m02 + dy * this.modelviewInv.m12 + dz * this.modelviewInv.m22;
        float invn = 1.0f / PApplet.dist(0.0f, 0.0f, 0.0f, nx, ny, nz);
        this.lightNormal[3 * num + 0] = invn * nx;
        this.lightNormal[3 * num + 1] = invn * ny;
        this.lightNormal[3 * num + 2] = invn * nz;
    }

    protected void lightAmbient(int num, float r, float g, float b) {
        this.colorCalc(r, g, b);
        this.lightAmbient[3 * num + 0] = this.calcR;
        this.lightAmbient[3 * num + 1] = this.calcG;
        this.lightAmbient[3 * num + 2] = this.calcB;
    }

    protected void noLightAmbient(int num) {
        this.lightAmbient[3 * num + 0] = 0.0f;
        this.lightAmbient[3 * num + 1] = 0.0f;
        this.lightAmbient[3 * num + 2] = 0.0f;
    }

    protected void lightDiffuse(int num, float r, float g, float b) {
        this.colorCalc(r, g, b);
        this.lightDiffuse[3 * num + 0] = this.calcR;
        this.lightDiffuse[3 * num + 1] = this.calcG;
        this.lightDiffuse[3 * num + 2] = this.calcB;
    }

    protected void noLightDiffuse(int num) {
        this.lightDiffuse[3 * num + 0] = 0.0f;
        this.lightDiffuse[3 * num + 1] = 0.0f;
        this.lightDiffuse[3 * num + 2] = 0.0f;
    }

    protected void lightSpecular(int num, float r, float g, float b) {
        this.lightSpecular[3 * num + 0] = r;
        this.lightSpecular[3 * num + 1] = g;
        this.lightSpecular[3 * num + 2] = b;
    }

    protected void noLightSpecular(int num) {
        this.lightSpecular[3 * num + 0] = 0.0f;
        this.lightSpecular[3 * num + 1] = 0.0f;
        this.lightSpecular[3 * num + 2] = 0.0f;
    }

    protected void lightFalloff(int num, float c0, float c1, float c2) {
        this.lightFalloffCoefficients[3 * num + 0] = c0;
        this.lightFalloffCoefficients[3 * num + 1] = c1;
        this.lightFalloffCoefficients[3 * num + 2] = c2;
    }

    protected void noLightFalloff(int num) {
        this.lightFalloffCoefficients[3 * num + 0] = 1.0f;
        this.lightFalloffCoefficients[3 * num + 1] = 0.0f;
        this.lightFalloffCoefficients[3 * num + 2] = 0.0f;
    }

    protected void lightSpot(int num, float angle, float exponent) {
        this.lightSpotParameters[2 * num + 0] = Math.max(0.0f, PApplet.cos(angle));
        this.lightSpotParameters[2 * num + 1] = exponent;
    }

    protected void noLightSpot(int num) {
        this.lightSpotParameters[2 * num + 0] = 0.0f;
        this.lightSpotParameters[2 * num + 1] = 0.0f;
    }

    @Override
    protected void backgroundImpl(PImage image) {
        this.backgroundImpl();
        this.set(0, 0, image);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    @Override
    protected void backgroundImpl() {
        this.flush();
        this.pgl.depthMask(true);
        this.pgl.clearDepth(1.0f);
        this.pgl.clear(256);
        if (this.hints[6]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pgl.clearColor(this.backgroundR, this.backgroundG, this.backgroundB, this.backgroundA);
        this.pgl.clear(16384);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    public void report(String where) {
        int err;
        if (!this.hints[4] && (err = this.pgl.getError()) != 0) {
            String errString = this.pgl.errorString(err);
            String msg = "OpenGL error " + err + " at " + where + ": " + errString;
            PGraphics.showWarning(msg);
        }
    }

    @Override
    public boolean isGL() {
        return true;
    }

    @Override
    public void loadPixels() {
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        if (!this.setgetPixels) {
            this.flush();
        }
        this.allocatePixels();
        if (!this.setgetPixels) {
            this.readPixels();
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    protected void saveSurfaceToPixels() {
        this.allocatePixels();
        this.readPixels();
    }

    protected void restoreSurfaceFromPixels() {
        this.drawPixels(0, 0, this.width, this.height);
    }

    protected void allocatePixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = IntBuffer.wrap(this.pixels);
        }
    }

    protected void readPixels() {
        this.beginPixelsOp(1);
        this.pixelBuffer.rewind();
        this.pgl.readPixels(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
        this.endPixelsOp();
        PGL.nativeToJavaARGB(this.pixels, this.width, this.height);
    }

    protected void drawPixels(int x, int y, int w, int h) {
        int i0 = y * this.width + x;
        int len = w * h;
        if (this.nativePixels == null || this.nativePixels.length < len) {
            this.nativePixels = new int[len];
            this.nativePixelBuffer = IntBuffer.wrap(this.nativePixels);
        }
        PApplet.arrayCopy(this.pixels, i0, this.nativePixels, 0, len);
        PGL.javaToNativeARGB(this.nativePixels, w, h);
        if (this.primarySurface) {
            this.loadTextureImpl(2, false);
        }
        this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, x, y, w, h, IntBuffer.wrap(this.nativePixels));
        if (this.primarySurface || this.offscreenMultisample) {
            this.beginPixelsOp(2);
            this.drawTexture(x, y, w, h);
            this.endPixelsOp();
        }
    }

    @Override
    public int get(int x, int y) {
        this.loadPixels();
        this.setgetPixels = true;
        return super.get(x, y);
    }

    @Override
    protected PImage getImpl(int x, int y, int w, int h) {
        this.loadPixels();
        this.setgetPixels = true;
        return super.getImpl(x, y, w, h);
    }

    @Override
    public void set(int x, int y, int argb) {
        this.loadPixels();
        this.setgetPixels = true;
        super.set(x, y, argb);
    }

    @Override
    protected void setImpl(int dx, int dy, int sx, int sy, int sw, int sh, PImage src) {
        this.loadPixels();
        this.setgetPixels = true;
        super.setImpl(dx, dy, sx, sy, sw, sh, src);
    }

    public void loadTexture() {
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        this.flush();
        if (this.primarySurface) {
            this.loadTextureImpl(2, false);
            if (this.pgl.primaryIsFboBacked()) {
                this.pgl.bindPrimaryColorFBO();
                this.texture.set(this.pgl.getFboTexTarget(), this.pgl.getFboTexName(), this.pgl.getFboWidth(), this.pgl.getFboHeight(), this.width, this.height);
                this.pgl.bindPrimaryMultiFBO();
            } else {
                if (this.nativePixels == null || this.nativePixels.length < this.width * this.height) {
                    this.nativePixels = new int[this.width * this.height];
                    this.nativePixelBuffer = IntBuffer.wrap(this.nativePixels);
                }
                this.beginPixelsOp(1);
                this.pgl.readPixels(0, 0, this.width, this.height, 6408, 5121, this.nativePixelBuffer);
                this.endPixelsOp();
                this.texture.setNative(this.nativePixels, 0, 0, this.width, this.height);
            }
        } else {
            if (this.offscreenMultisample) {
                this.offscreenFramebufferMultisample.copy(this.offscreenFramebuffer);
            }
            if (this.offscreenMultisample) {
                this.pushFramebuffer();
                this.setFramebuffer(this.offscreenFramebuffer);
            }
            this.pgl.colorMask(false, false, false, true);
            this.pgl.clearColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.pgl.clear(16384);
            this.pgl.colorMask(true, true, true, true);
            if (this.offscreenMultisample) {
                this.popFramebuffer();
            }
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    public void updateTexture() {
        this.texture.updateTexels();
    }

    public void updateTexture(int x, int y, int w, int h) {
        this.texture.updateTexels(x, y, w, h);
    }

    public void updateDisplay() {
        this.flush();
        this.beginPixelsOp(2);
        this.drawTexture();
        this.endPixelsOp();
    }

    public void setTexture(PImage img) {
        if (this.width != img.width || this.height != img.height) {
            PGraphics.showWarning("Resolution of image is different from PGraphics object");
            return;
        }
        if (this.texture == null || this.texture != pgPrimary.getCache(img)) {
            Texture.Parameters params;
            Texture tex = (Texture)pgPrimary.getCache(img);
            Texture.Parameters parameters = params = tex != null ? tex.getParameters() : null;
            if (tex == null || tex.contextIsOutdated() || !this.validSurfaceTex(tex)) {
                params = this.primarySurface ? new Texture.Parameters(2, 2, false) : new Texture.Parameters(2, 4, false);
                tex = this.addTexture(img, params);
            }
            if (tex != null) {
                this.texture = tex;
                this.texture.invertedY(true);
                pgPrimary.setCache(this, this.texture);
                if (!this.primarySurface && this.offscreenFramebuffer != null) {
                    this.offscreenFramebuffer.setColorBuffer(this.texture);
                    this.offscreenFramebuffer.clear();
                }
            }
        }
    }

    public void drawTexture(int target, int id, int width, int height, int X0, int Y0, int X1, int Y1) {
        this.beginPGL();
        this.pgl.drawTexture(target, id, width, height, X0, Y0, X1, Y1);
        this.endPGL();
    }

    public void drawTexture(int target, int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        this.beginPGL();
        this.pgl.drawTexture(target, id, width, height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        this.endPGL();
    }

    protected void loadTextureImpl(int sampling, boolean mipmap) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.texture == null || this.texture.contextIsOutdated()) {
            Texture.Parameters params = new Texture.Parameters(2, sampling, mipmap);
            this.texture = new Texture(this.parent, this.width, this.height, params);
            this.texture.invertedY(true);
            pgPrimary.setCache(this, this.texture);
        }
    }

    protected void drawTexture() {
        this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, 0, 0, this.width, this.height);
    }

    protected void drawTexture(int x, int y, int w, int h) {
        this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, x, y, x + w, y + h);
    }

    protected boolean validSurfaceTex(Texture tex) {
        Texture.Parameters params = tex.getParameters();
        if (this.primarySurface) {
            return params.sampling == 2 && !params.mipmaps;
        }
        return params.sampling == 4 && !params.mipmaps;
    }

    @Override
    public void mask(int[] alpha) {
        PImage temp = this.get();
        temp.mask(alpha);
        this.set(0, 0, temp);
    }

    @Override
    public void mask(PImage alpha) {
        if (alpha.width != this.width || alpha.height != this.height) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        if (maskShader == null) {
            maskShader = new PolyTexShader(this.parent, defPolyTexShaderVertURL, maskShaderFragURL);
        }
        maskShader.set("maskSampler", alpha);
        this.filter(maskShader);
    }

    @Override
    public void filter(int kind) {
        PImage temp = this.get();
        temp.filter(kind);
        this.set(0, 0, temp);
    }

    @Override
    public void filter(int kind, float param) {
        PImage temp = this.get();
        temp.filter(kind, param);
        this.set(0, 0, temp);
    }

    @Override
    public void filter(PShader shader) {
        if (!(shader instanceof PolyTexShader)) {
            PGraphics.showWarning("Object is not a valid shader");
            return;
        }
        this.loadTexture();
        if (this.textureCopy == null || this.textureCopy.width != this.width || this.textureCopy.height != this.height) {
            Texture.Parameters params = new Texture.Parameters(2, 2, false);
            this.textureCopy = new Texture(this.parent, this.width, this.height, params);
            this.textureCopy.invertedY(true);
            this.imageCopy = this.wrapTexture(this.textureCopy);
        }
        this.textureCopy.set(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, this.width, this.height);
        this.pgl.depthMask(false);
        this.pgl.disable(2929);
        PolyTexShader prevTexShader = this.polyTexShader;
        this.polyTexShader = (PolyTexShader)shader;
        boolean prevLights = this.lights;
        this.lights = false;
        int prevTextureMode = this.textureMode;
        this.textureMode = 1;
        boolean prevStroke = this.stroke;
        this.stroke = false;
        this.begin2D();
        this.beginShape(17);
        this.texture(this.imageCopy);
        this.vertex(0.0f, 0.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, 0.0f, 1.0f);
        this.endShape();
        this.end2D();
        this.stroke = prevStroke;
        this.lights = prevLights;
        this.textureMode = prevTextureMode;
        this.polyTexShader = prevTexShader;
        if (!this.hints[2]) {
            this.pgl.enable(2929);
        }
        if (!this.hints[6]) {
            this.pgl.depthMask(true);
        }
    }

    @Override
    public void blendMode(int mode) {
        if (this.blendMode != mode) {
            this.flush();
            this.blendMode = mode;
            this.pgl.enable(3042);
            if (mode == 0) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(1, 0);
            } else if (mode == 1) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(770, 771);
            } else if (mode == 2) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(770, 1);
            } else if (mode == 4) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(775, 0);
            } else if (mode == 8) {
                if (!blendEqSupported) {
                    PGraphics.showWarning("This blend mode is not supported");
                    return;
                }
                this.pgl.blendEquation(32776);
                this.pgl.blendFunc(770, 772);
            } else if (mode == 16) {
                if (!blendEqSupported) {
                    PGraphics.showWarning("This blend mode is not supported");
                    return;
                }
                this.pgl.blendEquation(32775);
                this.pgl.blendFunc(770, 772);
            } else if (mode == 32) {
                if (!blendEqSupported) {
                    PGraphics.showWarning("This blend mode is not supported");
                    return;
                }
                this.pgl.blendEquation(32779);
                this.pgl.blendFunc(1, 1);
            } else if (mode == 64) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(775, 769);
            } else if (mode == 128) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(774, 768);
            } else if (mode == 256) {
                if (blendEqSupported) {
                    this.pgl.blendEquation(32774);
                }
                this.pgl.blendFunc(775, 1);
            }
        }
    }

    protected void setDefaultBlend() {
        this.blendMode = 1;
        this.pgl.enable(3042);
        if (blendEqSupported) {
            this.pgl.blendEquation(32774);
        }
        this.pgl.blendFunc(770, 771);
    }

    public Texture getTexture() {
        this.loadTexture();
        return this.texture;
    }

    public Texture getTexture(PImage img) {
        Texture tex = (Texture)this.initCache(img);
        if (tex == null) {
            return null;
        }
        if (img.isModified()) {
            if (img.width != tex.width || img.height != tex.height) {
                tex.init(img.width, img.height);
            }
            this.updateTexture(img, tex);
        }
        if (tex.hasBuffers()) {
            tex.bufferUpdate();
        }
        this.checkTexture(tex);
        return tex;
    }

    @Override
    public Object initCache(PImage img) {
        Texture tex = (Texture)pgPrimary.getCache(img);
        if ((tex == null || tex.contextIsOutdated()) && (tex = this.addTexture(img)) != null) {
            img.loadPixels();
            tex.set(img.pixels);
        }
        return tex;
    }

    protected void bindBackTexture() {
        if (this.primarySurface) {
            this.pgl.bindBackBufferTex();
        }
    }

    protected void unbindBackTexture() {
        if (this.primarySurface) {
            this.pgl.unbindBackBufferTex();
        }
    }

    protected Texture addTexture(PImage img) {
        Texture.Parameters params = new Texture.Parameters(2, this.textureSampling, this.getHint(-11), this.textureWrap);
        return this.addTexture(img, params);
    }

    protected Texture addTexture(PImage img, Texture.Parameters params) {
        if (img.width == 0 || img.height == 0) {
            return null;
        }
        if (img.parent == null) {
            img.parent = this.parent;
        }
        Texture tex = new Texture(img.parent, img.width, img.height, params);
        pgPrimary.setCache(img, tex);
        return tex;
    }

    protected void checkTexture(Texture tex) {
        if (tex.usingMipmaps == this.hints[11]) {
            if (this.hints[11]) {
                tex.usingMipmaps(false, this.textureSampling);
            } else {
                tex.usingMipmaps(true, this.textureSampling);
            }
        }
        if (tex.usingRepeat && this.textureWrap == 0 || !tex.usingRepeat && this.textureWrap == 1) {
            if (this.textureWrap == 0) {
                tex.usingRepeat(false);
            } else {
                tex.usingRepeat(true);
            }
        }
    }

    protected PImage wrapTexture(Texture tex) {
        PImage img = new PImage();
        img.parent = this.parent;
        img.width = tex.width;
        img.height = tex.height;
        img.format = 2;
        pgPrimary.setCache(img, tex);
        return img;
    }

    protected void updateTexture(PImage img, Texture tex) {
        if (tex != null) {
            int x = img.getModifiedX1();
            int y = img.getModifiedY1();
            int w = img.getModifiedX2() - x + 1;
            int h = img.getModifiedY2() - y + 1;
            tex.set(img.pixels, x, y, w, h, img.format);
        }
        img.setModified(false);
    }

    @Override
    public void resize(int wide, int high) {
        PGraphics.showMethodWarning("resize");
    }

    protected void initPrimary() {
        this.pgl.initPrimarySurface(this.quality);
        if (pgPrimary == null) {
            pgPrimary = this;
        }
    }

    protected void initOffscreen() {
        boolean packed;
        pgPrimary = (PGraphicsOpenGL)this.parent.g;
        this.pgl.initOffscreenSurface(PGraphicsOpenGL.pgPrimary.pgl);
        this.pgl.updateOffscreen(PGraphicsOpenGL.pgPrimary.pgl);
        this.loadTextureImpl(4, false);
        if (this.offscreenFramebuffer != null) {
            this.offscreenFramebuffer.release();
        }
        if (this.offscreenFramebufferMultisample != null) {
            this.offscreenFramebufferMultisample.release();
        }
        boolean bl = packed = depthBits == 24 && stencilBits == 8 && packedDepthStencilSupported;
        if (fboMultisampleSupported && 1 < this.quality) {
            this.offscreenFramebufferMultisample = new FrameBuffer(this.parent, this.texture.glWidth, this.texture.glHeight, this.quality, 0, depthBits, stencilBits, packed, false);
            this.offscreenFramebufferMultisample.clear();
            this.offscreenMultisample = true;
            this.offscreenFramebuffer = new FrameBuffer(this.parent, this.texture.glWidth, this.texture.glHeight, 1, 1, 0, 0, false, false);
        } else {
            this.quality = 0;
            this.offscreenFramebuffer = new FrameBuffer(this.parent, this.texture.glWidth, this.texture.glHeight, 1, 1, depthBits, stencilBits, packed, false);
            this.offscreenMultisample = false;
        }
        this.offscreenFramebuffer.setColorBuffer(this.texture);
        this.offscreenFramebuffer.clear();
    }

    protected void getGLParameters() {
        OPENGL_VENDOR = this.pgl.getString(7936);
        OPENGL_RENDERER = this.pgl.getString(7937);
        OPENGL_VERSION = this.pgl.getString(7938);
        OPENGL_EXTENSIONS = this.pgl.getString(7939);
        GLSL_VERSION = this.pgl.getString(35724);
        int major = this.pgl.getGLVersion()[0];
        if (major < 2) {
            PGraphics.showWarning("The OpenGL version is less than 2.0 so Processing might not draw properly");
            if (OPENGL_EXTENSIONS.indexOf("_fragment_shader") == -1 || OPENGL_EXTENSIONS.indexOf("_vertex_shader") == -1 || OPENGL_EXTENSIONS.indexOf("_shader_objects") == -1 || OPENGL_EXTENSIONS.indexOf("_shading_language") == -1) {
                throw new RuntimeException("GLSL shaders are not supported by this video card");
            }
        }
        npotTexSupported = -1 < OPENGL_EXTENSIONS.indexOf("_texture_non_power_of_two");
        autoMipmapGenSupported = -1 < OPENGL_EXTENSIONS.indexOf("_generate_mipmap");
        fboMultisampleSupported = -1 < OPENGL_EXTENSIONS.indexOf("_framebuffer_multisample");
        packedDepthStencilSupported = -1 < OPENGL_EXTENSIONS.indexOf("_packed_depth_stencil");
        try {
            this.pgl.blendEquation(32774);
            blendEqSupported = true;
        }
        catch (Exception e) {
            blendEqSupported = false;
        }
        int[] temp = new int[2];
        this.pgl.getIntegerv(3379, temp, 0);
        maxTextureSize = temp[0];
        this.pgl.getIntegerv(36183, temp, 0);
        maxSamples = temp[0];
        this.pgl.getIntegerv(33902, temp, 0);
        maxLineWidth = temp[1];
        this.pgl.getIntegerv(33901, temp, 0);
        maxPointSize = temp[1];
        this.pgl.getIntegerv(3414, temp, 0);
        depthBits = temp[0];
        this.pgl.getIntegerv(3415, temp, 0);
        stencilBits = temp[0];
        glParamsRead = true;
    }

    @Override
    public PShader loadShader(String fragFilename) {
        int shaderType = this.getTypeFromFragmentShader(fragFilename);
        PolyColorShader shader = null;
        if (shaderType == 2) {
            shader = new PolyTexShader(this.parent);
            shader.setVertexShader(defPolyTexShaderVertURL);
        } else if (shaderType == 0) {
            shader = new PolyColorShader(this.parent);
            shader.setVertexShader(defPolyColorShaderVertURL);
        }
        if (shader == null) {
            PGraphics.showWarning("The GLSL code doesn't seem to contain a valid shader to use in Processing.");
        } else {
            shader.setFragmentShader(fragFilename);
        }
        return shader;
    }

    @Override
    public PShader loadShader(String fragFilename, String vertFilename) {
        int shaderType = this.getTypeFromVertexShader(vertFilename);
        PShader shader = null;
        if (fragFilename == null || fragFilename.equals("")) {
            if (shaderType == 5) {
                shader = new PointShader(this.parent);
                shader.setFragmentShader(defPointShaderFragURL);
            } else if (shaderType == 4) {
                shader = new LineShader(this.parent);
                shader.setFragmentShader(defLineShaderFragURL);
            } else if (shaderType == 3) {
                shader = new PolyTexlightShader(this.parent);
                shader.setFragmentShader(defPolyTexShaderFragURL);
            } else if (shaderType == 1) {
                shader = new PolyLightShader(this.parent);
                shader.setFragmentShader(defPolyNoTexShaderFragURL);
            } else if (shaderType == 2) {
                shader = new PolyTexShader(this.parent);
                shader.setFragmentShader(defPolyTexShaderFragURL);
            } else if (shaderType == 0) {
                shader = new PolyColorShader(this.parent);
                shader.setFragmentShader(defPolyNoTexShaderFragURL);
            }
            if (shader != null) {
                shader.setVertexShader(vertFilename);
            }
        } else if (shaderType == 5) {
            shader = new PointShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 4) {
            shader = new LineShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 3) {
            shader = new PolyTexlightShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 1) {
            shader = new PolyLightShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 2) {
            shader = new PolyTexShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 0) {
            shader = new PolyColorShader(this.parent, vertFilename, fragFilename);
        }
        if (shader == null) {
            PGraphics.showWarning("The GLSL code doesn't seem to contain a valid shader to use in Processing.");
        }
        return shader;
    }

    @Override
    public void shader(PShader shader) {
        this.shader(shader, 20);
    }

    @Override
    public void shader(PShader shader, int kind) {
        this.flush();
        if (kind == 9 || kind == 17 || kind == 20) {
            if (shader instanceof PolyTexShader) {
                this.polyTexShader = (PolyTexShader)shader;
            } else if (shader instanceof PolyColorShader) {
                this.polyColorShader = (PolyColorShader)shader;
            } else if (shader instanceof PolyTexlightShader) {
                this.polyTexlightShader = (PolyTexlightShader)shader;
            } else if (shader instanceof PolyLightShader) {
                this.polyLightShader = (PolyLightShader)shader;
            } else {
                PGraphicsOpenGL.showWarning("shader() called with a wrong shader object");
            }
        } else if (kind == 5) {
            if (shader instanceof LineShader) {
                this.lineShader = (LineShader)shader;
            } else {
                PGraphicsOpenGL.showWarning("shader() called with a wrong shader object");
            }
        } else if (kind == 3) {
            if (shader instanceof PointShader) {
                this.pointShader = (PointShader)shader;
            } else {
                PGraphicsOpenGL.showWarning("shader() called with a wrong shader object");
            }
        } else {
            PGraphicsOpenGL.showWarning("shader() called with an unknown shader type");
        }
    }

    @Override
    public void resetShader() {
        this.resetShader(20);
    }

    @Override
    public void resetShader(int kind) {
        this.flush();
        if (kind == 9 || kind == 17 || kind == 20) {
            this.polyTexShader = null;
            this.polyColorShader = null;
            this.polyTexlightShader = null;
            this.polyLightShader = null;
        } else if (kind == 5) {
            this.lineShader = null;
        } else if (kind == 3) {
            this.pointShader = null;
        } else {
            PGraphics.showWarning("Wrong shader type");
        }
    }

    public void shaderWarnings(boolean enable) {
        this.shaderWarningsEnabled = enable;
    }

    protected int getTypeFromFragmentShader(String filename) {
        String[] source = this.parent.loadStrings(filename);
        Pattern pattern = Pattern.compile("uniform *sampler2D *textureSampler");
        int type = 0;
        for (int i = 0; i < source.length; ++i) {
            Matcher matcher = pattern.matcher(source[i]);
            if (!matcher.find()) continue;
            type = 2;
            break;
        }
        return type;
    }

    protected int getTypeFromVertexShader(String filename) {
        String[] source = this.parent.loadStrings(filename);
        Pattern pointPattern = Pattern.compile("attribute *vec2 *inPoint");
        Pattern linePattern = Pattern.compile("attribute *vec4 *inLine");
        Pattern lightPattern1 = Pattern.compile("uniform *vec4 *lightPosition");
        Pattern lightPattern2 = Pattern.compile("uniform *vec3 *lightNormal");
        Pattern texPattern = Pattern.compile("attribute vec2 inTexcoord");
        int type = 0;
        for (int i = 0; i < source.length; ++i) {
            boolean foundPoint = pointPattern.matcher(source[i]).find();
            boolean foundLine = linePattern.matcher(source[i]).find();
            boolean foundLight = lightPattern1.matcher(source[i]).find() || lightPattern2.matcher(source[i]).find();
            boolean foundTex = texPattern.matcher(source[i]).find();
            if (foundPoint) {
                type = 5;
            } else if (foundLine) {
                type = 4;
            } else if (foundLight && foundTex) {
                type = 3;
            } else if (foundLight) {
                type = 1;
            } else if (foundTex) {
                type = 2;
            }
            if (type != 0) break;
        }
        return type;
    }

    protected PolyShader getPolyShader(boolean lit, boolean tex) {
        PolyShader shader;
        if (lit) {
            if (tex) {
                if (this.polyTexlightShader == null) {
                    if (defPolyTexlightShader == null) {
                        defPolyTexlightShader = new PolyTexlightShader(this.parent, defPolyTexlightShaderVertURL, defPolyTexShaderFragURL);
                    }
                    shader = defPolyTexlightShader;
                    this.texlightShaderCheck();
                } else {
                    shader = this.polyTexlightShader;
                }
            } else if (this.polyLightShader == null) {
                if (defPolyLightShader == null) {
                    defPolyLightShader = new PolyLightShader(this.parent, defPolyLightShaderVertURL, defPolyNoTexShaderFragURL);
                }
                shader = defPolyLightShader;
                this.lightShaderCheck();
            } else {
                shader = this.polyLightShader;
            }
        } else if (tex) {
            if (this.polyTexShader == null) {
                if (defPolyTexShader == null) {
                    defPolyTexShader = new PolyTexShader(this.parent, defPolyTexShaderVertURL, defPolyTexShaderFragURL);
                }
                shader = defPolyTexShader;
                this.texShaderCheck();
            } else {
                shader = this.polyTexShader;
            }
        } else if (this.polyColorShader == null) {
            if (defPolyColorShader == null) {
                defPolyColorShader = new PolyColorShader(this.parent, defPolyColorShaderVertURL, defPolyNoTexShaderFragURL);
            }
            shader = defPolyColorShader;
            this.colorShaderCheck();
        } else {
            shader = this.polyColorShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected void texlightShaderCheck() {
        if (this.shaderWarningsEnabled && (this.polyLightShader != null || this.polyTexShader != null || this.polyColorShader != null)) {
            PGraphics.showWarning("Your shader cannot be used to render textured and lit geometry, using default shader instead.");
        }
    }

    protected void lightShaderCheck() {
        if (this.shaderWarningsEnabled && (this.polyTexlightShader != null || this.polyTexShader != null || this.polyColorShader != null)) {
            PGraphics.showWarning("Your shader cannot be used to render lit geometry, using default shader instead.");
        }
    }

    protected void texShaderCheck() {
        if (this.shaderWarningsEnabled && (this.polyTexlightShader != null || this.polyLightShader != null || this.polyColorShader != null)) {
            PGraphics.showWarning("Your shader cannot be used to render textured geometry, using default shader instead.");
        }
    }

    protected void colorShaderCheck() {
        if (this.shaderWarningsEnabled && (this.polyTexlightShader != null || this.polyLightShader != null || this.polyTexShader != null)) {
            PGraphics.showWarning("Your shader cannot be used to render colored geometry, using default shader instead.");
        }
    }

    protected LineShader getLineShader() {
        LineShader shader;
        if (this.lineShader == null) {
            if (defLineShader == null) {
                defLineShader = new LineShader(this.parent, defLineShaderVertURL, defLineShaderFragURL);
            }
            shader = defLineShader;
        } else {
            shader = this.lineShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected PointShader getPointShader() {
        PointShader shader;
        if (this.pointShader == null) {
            if (defPointShader == null) {
                defPointShader = new PointShader(this.parent, defPointShaderVertURL, defPointShaderFragURL);
            }
            shader = defPointShader;
        } else {
            shader = this.pointShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected static int expandArraySize(int currSize, int newMinSize) {
        int newSize;
        for (newSize = currSize; newSize < newMinSize; newSize <<= 1) {
        }
        return newSize;
    }

    protected InGeometry newInGeometry(int mode) {
        return new InGeometry(mode);
    }

    protected TessGeometry newTessGeometry(int mode) {
        return new TessGeometry(mode);
    }

    protected TexCache newTexCache() {
        return new TexCache();
    }

    static {
        glTextureObjects = new HashMap();
        glVertexBuffers = new HashMap();
        glFrameBuffers = new HashMap();
        glRenderBuffers = new HashMap();
        glslPrograms = new HashMap();
        glslVertexShaders = new HashMap();
        glslFragmentShaders = new HashMap();
        defPolyColorShaderVertURL = PGraphicsOpenGL.class.getResource("PolyColorShaderVert.glsl");
        defPolyTexShaderVertURL = PGraphicsOpenGL.class.getResource("PolyTexShaderVert.glsl");
        defPolyLightShaderVertURL = PGraphicsOpenGL.class.getResource("PolyLightShaderVert.glsl");
        defPolyTexlightShaderVertURL = PGraphicsOpenGL.class.getResource("PolyTexlightShaderVert.glsl");
        defPolyNoTexShaderFragURL = PGraphicsOpenGL.class.getResource("PolyNoTexShaderFrag.glsl");
        defPolyTexShaderFragURL = PGraphicsOpenGL.class.getResource("PolyTexShaderFrag.glsl");
        defLineShaderVertURL = PGraphicsOpenGL.class.getResource("LineShaderVert.glsl");
        defLineShaderFragURL = PGraphicsOpenGL.class.getResource("LineShaderFrag.glsl");
        defPointShaderVertURL = PGraphicsOpenGL.class.getResource("PointShaderVert.glsl");
        defPointShaderFragURL = PGraphicsOpenGL.class.getResource("PointShaderFrag.glsl");
        maskShaderFragURL = PGraphicsOpenGL.class.getResource("MaskShaderFrag.glsl");
        identity = new PMatrix3D();
        fbStack = new FrameBuffer[16];
    }

    protected class Tessellator {
        InGeometry in;
        TessGeometry tess;
        TexCache texCache;
        PImage prevTexImage;
        PImage newTexImage;
        int firstTexIndex;
        int firstTexCache;
        PGL.Tessellator gluTess;
        TessellatorCallback callback = new TessellatorCallback();
        boolean fill;
        boolean stroke;
        int strokeColor;
        float strokeWeight;
        int strokeJoin;
        int strokeCap;
        boolean accurate2DStrokes;
        PMatrix transform;
        boolean is2D;
        boolean is3D;
        int[] rawIndices;
        int rawSize;
        int[] dupIndices;
        int dupCount;
        int firstPolyIndexCache;
        int lastPolyIndexCache;
        int firstLineIndexCache;
        int lastLineIndexCache;
        int firstPointIndexCache;
        int lastPointIndexCache;

        Tessellator() {
            this.gluTess = PGraphicsOpenGL.this.pgl.createTessellator(this.callback);
            this.rawIndices = new int[512];
            this.accurate2DStrokes = true;
            this.transform = null;
            this.is2D = false;
            this.is3D = true;
        }

        void setInGeometry(InGeometry in) {
            this.in = in;
            this.firstPolyIndexCache = -1;
            this.lastPolyIndexCache = -1;
            this.firstLineIndexCache = -1;
            this.lastLineIndexCache = -1;
            this.firstPointIndexCache = -1;
            this.lastPointIndexCache = -1;
        }

        void setTessGeometry(TessGeometry tess) {
            this.tess = tess;
        }

        void setFill(boolean fill) {
            this.fill = fill;
        }

        void setStroke(boolean stroke) {
            this.stroke = stroke;
        }

        void setStrokeColor(int color) {
            this.strokeColor = PGL.javaToNativeARGB(color);
        }

        void setStrokeWeight(float weight) {
            this.strokeWeight = weight;
        }

        void setStrokeJoin(int strokeJoin) {
            this.strokeJoin = strokeJoin;
        }

        void setStrokeCap(int strokeCap) {
            this.strokeCap = strokeCap;
        }

        void setAccurate2DStrokes(boolean accurate) {
            this.accurate2DStrokes = accurate;
        }

        void setTexCache(TexCache texCache, PImage prevTexImage, PImage newTexImage) {
            this.texCache = texCache;
            this.prevTexImage = prevTexImage;
            this.newTexImage = newTexImage;
        }

        void set3D(boolean value) {
            if (value) {
                this.is2D = false;
                this.is3D = true;
            } else {
                this.is2D = true;
                this.is3D = false;
            }
        }

        void setTransform(PMatrix transform) {
            this.transform = transform;
        }

        void tessellatePoints() {
            if (this.strokeCap == 2) {
                this.tessellateRoundPoints();
            } else {
                this.tessellateSquarePoints();
            }
        }

        void tessellateRoundPoints() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 1 <= nInVert) {
                int nPtVert = PApplet.max(20, (int)((float)Math.PI * 2 * this.strokeWeight / 10.0f)) + 1;
                if (32768 <= nPtVert) {
                    throw new RuntimeException("Error in point tessellation.");
                }
                this.updateTex();
                int nvertTot = nPtVert * nInVert;
                int nindTot = 3 * (nPtVert - 1) * nInVert;
                if (this.is3D) {
                    this.tessellateRoundPoints3D(nvertTot, nindTot, nPtVert);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateRoundPoints2D(nvertTot, nindTot, nPtVert);
                    this.endNoTex();
                }
            }
        }

        void tessellateRoundPoints3D(int nvertTot, int nindTot, int nPtVert) {
            int index;
            int perim = nPtVert - 1;
            this.tess.pointVertexCheck(nvertTot);
            this.tess.pointIndexCheck(nindTot);
            int vertIdx = this.tess.firstPointVertex;
            int attribIdx = this.tess.firstPointVertex;
            int indIdx = this.tess.firstPointIndex;
            IndexCache cache = this.tess.pointIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                if (32768 <= count + nPtVert) {
                    index = cache.addNew();
                    count = 0;
                }
                for (int k2 = 0; k2 < nPtVert; ++k2) {
                    this.tess.setPointVertex(vertIdx, this.in, i);
                    ++vertIdx;
                }
                this.tess.pointAttribs[2 * attribIdx + 0] = 0.0f;
                this.tess.pointAttribs[2 * attribIdx + 1] = 0.0f;
                ++attribIdx;
                float val = 0.0f;
                float inc = 720.0f / (float)perim;
                for (k = 0; k < perim; ++k) {
                    this.tess.pointAttribs[2 * attribIdx + 0] = 0.5f * cosLUT[(int)val] * this.strokeWeight;
                    this.tess.pointAttribs[2 * attribIdx + 1] = 0.5f * sinLUT[(int)val] * this.strokeWeight;
                    val = (val + inc) % 720.0f;
                    ++attribIdx;
                }
                for (k = 1; k < nPtVert - 1; ++k) {
                    this.tess.pointIndices[indIdx++] = (short)(count + 0);
                    this.tess.pointIndices[indIdx++] = (short)(count + k);
                    this.tess.pointIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.pointIndices[indIdx++] = (short)(count + 0);
                this.tess.pointIndices[indIdx++] = (short)(count + 1);
                this.tess.pointIndices[indIdx++] = (short)(count + nPtVert - 1);
                cache.incCounts(index, 3 * (nPtVert - 1), nPtVert);
            }
            this.lastPointIndexCache = index;
        }

        void tessellateRoundPoints2D(int nvertTot, int nindTot, int nPtVert) {
            int index;
            int perim = nPtVert - 1;
            this.tess.polyVertexCheck(nvertTot);
            this.tess.polyIndexCheck(nindTot);
            int vertIdx = this.tess.firstPolyVertex;
            int indIdx = this.tess.firstPolyIndex;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                if (32768 <= count + nPtVert) {
                    index = cache.addNew();
                    count = 0;
                }
                float x0 = this.in.vertices[3 * i + 0];
                float y0 = this.in.vertices[3 * i + 1];
                int rgba = this.in.strokeColors[i];
                float val = 0.0f;
                float inc = 720.0f / (float)perim;
                this.tess.setPolyVertex(vertIdx, x0, y0, 0.0f, rgba);
                ++vertIdx;
                for (k = 0; k < perim; ++k) {
                    this.tess.setPolyVertex(vertIdx, x0 + 0.5f * cosLUT[(int)val] * this.strokeWeight, y0 + 0.5f * sinLUT[(int)val] * this.strokeWeight, 0.0f, rgba);
                    ++vertIdx;
                    val = (val + inc) % 720.0f;
                }
                for (k = 1; k < nPtVert - 1; ++k) {
                    this.tess.polyIndices[indIdx++] = (short)(count + 0);
                    this.tess.polyIndices[indIdx++] = (short)(count + k);
                    this.tess.polyIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.polyIndices[indIdx++] = (short)(count + 0);
                this.tess.polyIndices[indIdx++] = (short)(count + 1);
                this.tess.polyIndices[indIdx++] = (short)(count + nPtVert - 1);
                cache.incCounts(index, 3 * (nPtVert - 1), nPtVert);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = index;
        }

        void tessellateSquarePoints() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 1 <= nInVert) {
                this.updateTex();
                int quadCount = nInVert;
                int nvertTot = 5 * quadCount;
                int nindTot = 12 * quadCount;
                if (this.is3D) {
                    this.tessellateSquarePoints3D(nvertTot, nindTot);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateSquarePoints2D(nvertTot, nindTot);
                    this.endNoTex();
                }
            }
        }

        void tessellateSquarePoints3D(int nvertTot, int nindTot) {
            int index;
            this.tess.pointVertexCheck(nvertTot);
            this.tess.pointIndexCheck(nindTot);
            int vertIdx = this.tess.firstPointVertex;
            int attribIdx = this.tess.firstPointVertex;
            int indIdx = this.tess.firstPointIndex;
            IndexCache cache = this.tess.pointIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                int nvert = 5;
                if (32768 <= count + nvert) {
                    index = cache.addNew();
                    count = 0;
                }
                for (k = 0; k < nvert; ++k) {
                    this.tess.setPointVertex(vertIdx, this.in, i);
                    ++vertIdx;
                }
                this.tess.pointAttribs[2 * attribIdx + 0] = 0.0f;
                this.tess.pointAttribs[2 * attribIdx + 1] = 0.0f;
                ++attribIdx;
                for (k = 0; k < 4; ++k) {
                    this.tess.pointAttribs[2 * attribIdx + 0] = 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][0] * this.strokeWeight;
                    this.tess.pointAttribs[2 * attribIdx + 1] = 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][1] * this.strokeWeight;
                    ++attribIdx;
                }
                for (k = 1; k < nvert - 1; ++k) {
                    this.tess.pointIndices[indIdx++] = (short)(count + 0);
                    this.tess.pointIndices[indIdx++] = (short)(count + k);
                    this.tess.pointIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.pointIndices[indIdx++] = (short)(count + 0);
                this.tess.pointIndices[indIdx++] = (short)(count + 1);
                this.tess.pointIndices[indIdx++] = (short)(count + nvert - 1);
                cache.incCounts(index, 12, 5);
            }
            this.lastPointIndexCache = index;
        }

        void tessellateSquarePoints2D(int nvertTot, int nindTot) {
            int index;
            this.tess.polyVertexCheck(nvertTot);
            this.tess.polyIndexCheck(nindTot);
            int vertIdx = this.tess.firstPolyVertex;
            int indIdx = this.tess.firstPolyIndex;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                int nvert = 5;
                if (32768 <= count + nvert) {
                    index = cache.addNew();
                    count = 0;
                }
                float x0 = this.in.vertices[3 * i + 0];
                float y0 = this.in.vertices[3 * i + 1];
                int rgba = this.in.strokeColors[i];
                this.tess.setPolyVertex(vertIdx, x0, y0, 0.0f, rgba);
                ++vertIdx;
                for (k = 0; k < nvert - 1; ++k) {
                    this.tess.setPolyVertex(vertIdx, x0 + 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][0] * this.strokeWeight, y0 + 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][1] * this.strokeWeight, 0.0f, rgba);
                    ++vertIdx;
                }
                for (k = 1; k < nvert - 1; ++k) {
                    this.tess.polyIndices[indIdx++] = (short)(count + 0);
                    this.tess.polyIndices[indIdx++] = (short)(count + k);
                    this.tess.polyIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.polyIndices[indIdx++] = (short)(count + 0);
                this.tess.polyIndices[indIdx++] = (short)(count + 1);
                this.tess.polyIndices[indIdx++] = (short)(count + nvert - 1);
                cache.incCounts(index, 12, 5);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = index;
        }

        void tessellateLines() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= nInVert) {
                this.updateTex();
                int lineCount = nInVert / 2;
                if (this.is3D) {
                    this.tessellateLines3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLines2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLines3D(int lineCount) {
            int index;
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            int first = this.in.firstVertex;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            for (int ln = 0; ln < lineCount; ++ln) {
                int i0 = first + 2 * ln + 0;
                int i1 = first + 2 * ln + 1;
                index = this.addLine3D(i0, i1, index, null, false);
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLines2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            int first = this.in.firstVertex;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i0 = first + 2 * ln + 0;
                    int i1 = first + 2 * ln + 1;
                    index = this.addLine2D(i0, i1, index, false);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i0 = first + 2 * ln + 0;
                    int i1 = first + 2 * ln + 1;
                    path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1]);
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                }
                this.tessellateLinePath(path);
            }
        }

        void tessellateLineStrip() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= nInVert) {
                this.updateTex();
                int lineCount = nInVert - 1;
                if (this.is3D) {
                    this.tessellateLineStrip3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineStrip2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineStrip3D(int lineCount) {
            int index;
            int nBevelTr = this.noCapsJoins() ? 0 : lineCount - 1;
            int nvert = lineCount * 4 + nBevelTr;
            int nind = lineCount * 2 * 3 + nBevelTr * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int i0 = this.in.firstVertex;
            short[] lastInd = new short[]{-1, -1};
            for (int ln = 0; ln < lineCount; ++ln) {
                int i1 = this.in.firstVertex + ln + 1;
                index = 0 < nBevelTr ? this.addLine3D(i0, i1, index, lastInd, false) : this.addLine3D(i0, i1, index, null, false);
                i0 = i1;
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLineStrip2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                int i0 = this.in.firstVertex;
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i1 = this.in.firstVertex + ln + 1;
                    index = this.addLine2D(i0, i1, index, false);
                    i0 = i1;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                int first = this.in.firstVertex;
                LinePath path = new LinePath(1);
                path.moveTo(this.in.vertices[3 * first + 0], this.in.vertices[3 * first + 1]);
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i1 = first + ln + 1;
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                }
                this.tessellateLinePath(path);
            }
        }

        void tessellateLineLoop() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= nInVert) {
                this.updateTex();
                int lineCount = nInVert;
                if (this.is3D) {
                    this.tessellateLineLoop3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineLoop2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineLoop3D(int lineCount) {
            int index;
            int nBevelTr = this.noCapsJoins() ? 0 : lineCount - 1;
            int nvert = lineCount * 4 + nBevelTr;
            int nind = lineCount * 2 * 3 + nBevelTr * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int i0 = this.in.firstVertex;
            short[] lastInd = new short[]{-1, -1};
            for (int ln = 0; ln < lineCount - 1; ++ln) {
                int i1 = this.in.firstVertex + ln + 1;
                index = 0 < nBevelTr ? this.addLine3D(i0, i1, index, lastInd, false) : this.addLine3D(i0, i1, index, null, false);
                i0 = i1;
            }
            this.lastLineIndexCache = index = this.addLine3D(this.in.lastVertex, this.in.firstVertex, index, lastInd, false);
        }

        void tessellateLineLoop2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                int i0 = this.in.firstVertex;
                for (int ln = 0; ln < lineCount - 1; ++ln) {
                    int i1 = this.in.firstVertex + ln + 1;
                    index = this.addLine2D(i0, i1, index, false);
                    i0 = i1;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = (index = this.addLine2D(this.in.lastVertex, this.in.firstVertex, index, false));
            } else {
                int first = this.in.firstVertex;
                LinePath path = new LinePath(1);
                path.moveTo(this.in.vertices[3 * first + 0], this.in.vertices[3 * first + 1]);
                for (int ln = 0; ln < lineCount - 1; ++ln) {
                    int i1 = first + ln + 1;
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                }
                path.closePath();
                this.tessellateLinePath(path);
            }
        }

        void tessellateEdges() {
            if (this.stroke) {
                if (this.is3D) {
                    this.tessellateEdges3D();
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateEdges2D();
                    this.endNoTex();
                }
            }
        }

        void tessellateEdges3D() {
            int index;
            boolean bevel = !this.noCapsJoins();
            int nInVert = this.in.getNumEdgeVertices(bevel);
            int nInInd = this.in.getNumEdgeIndices(bevel);
            this.tess.lineVertexCheck(nInVert);
            this.tess.lineIndexCheck(nInInd);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            short[] lastInd = new short[]{-1, -1};
            for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                int[] edge = this.in.edges[i];
                int i0 = edge[0];
                int i1 = edge[1];
                if (bevel) {
                    index = this.addLine3D(i0, i1, index, lastInd, true);
                    if (edge[2] != 2 && edge[2] != 3) continue;
                    lastInd[1] = -1;
                    lastInd[0] = -1;
                    continue;
                }
                index = this.addLine3D(i0, i1, index, null, true);
            }
            this.lastLineIndexCache = index;
        }

        void tessellateEdges2D() {
            int nInVert = this.in.getNumEdgeVertices(false);
            if (this.noCapsJoins(nInVert)) {
                int index;
                int nInInd = this.in.getNumEdgeIndices(false);
                this.tess.polyVertexCheck(nInVert);
                this.tess.polyIndexCheck(nInInd);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                    int[] edge = this.in.edges[i];
                    int i0 = edge[0];
                    int i1 = edge[1];
                    index = this.addLine2D(i0, i1, index, true);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                block7: for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                    int[] edge = this.in.edges[i];
                    int i0 = edge[0];
                    int i1 = edge[1];
                    switch (edge[2]) {
                        case 0: {
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                            continue block7;
                        }
                        case 1: {
                            path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1]);
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                            continue block7;
                        }
                        case 2: {
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                            path.moveTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                            continue block7;
                        }
                        case 3: {
                            path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1]);
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                            path.moveTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1]);
                        }
                    }
                }
                this.tessellateLinePath(path);
            }
        }

        int addLine3D(int i0, int i1, int index, short[] lastInd, boolean constStroke) {
            IndexCache cache = this.tess.lineIndexCache;
            int count = cache.vertexCount[index];
            boolean addBevel = lastInd != null && -1 < lastInd[0] && -1 < lastInd[1];
            boolean newCache = false;
            if (32768 <= count + 4 + (addBevel ? 1 : 0)) {
                index = cache.addNew();
                count = 0;
                newCache = true;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int color = constStroke ? this.strokeColor : this.in.strokeColors[i0];
            int color0 = color;
            float weight = constStroke ? this.strokeWeight : this.in.strokeWeights[i0];
            this.tess.setLineVertex(vidx++, this.in, i0, i1, color, weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 0);
            this.tess.setLineVertex(vidx++, this.in, i0, i1, color, -weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 1);
            color = constStroke ? this.strokeColor : this.in.strokeColors[i1];
            weight = constStroke ? this.strokeWeight : this.in.strokeWeights[i1];
            this.tess.setLineVertex(vidx++, this.in, i1, i0, color, -weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 2);
            this.tess.lineIndices[iidx++] = (short)(count + 2);
            this.tess.lineIndices[iidx++] = (short)(count + 1);
            this.tess.setLineVertex(vidx++, this.in, i1, i0, color, weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 3);
            cache.incCounts(index, 6, 4);
            if (lastInd != null) {
                if (-1 < lastInd[0] && -1 < lastInd[1]) {
                    this.tess.setLineVertex(vidx, this.in, i0, color0);
                    if (newCache) {
                        PGraphics.showWarning("Stroke path is too long, some bevel triangles won't be added.");
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = (short)(count + 1);
                        this.tess.lineIndices[iidx] = (short)(count + 1);
                    } else {
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = lastInd[0];
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = lastInd[1];
                        this.tess.lineIndices[iidx] = (short)(count + 1);
                    }
                    cache.incCounts(index, 6, 1);
                }
                lastInd[0] = (short)(count + 2);
                lastInd[1] = (short)(count + 3);
            }
            return index;
        }

        int addLine2D(int i0, int i1, int index, boolean constStroke) {
            IndexCache cache = this.tess.polyIndexCache;
            int count = cache.vertexCount[index];
            if (32768 <= count + 4) {
                index = cache.addNew();
                count = 0;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int color = constStroke ? this.strokeColor : this.in.strokeColors[i0];
            float weight = constStroke ? this.strokeWeight : this.in.strokeWeights[i0];
            float x0 = this.in.vertices[3 * i0 + 0];
            float y0 = this.in.vertices[3 * i0 + 1];
            float x1 = this.in.vertices[3 * i1 + 0];
            float y1 = this.in.vertices[3 * i1 + 1];
            float dirx = x1 - x0;
            float diry = y1 - y0;
            float llen = PApplet.sqrt(dirx * dirx + diry * diry);
            float normx = 0.0f;
            float normy = 0.0f;
            if (PGraphicsOpenGL.nonZero(llen)) {
                normx = -diry / llen;
                normy = dirx / llen;
            }
            this.tess.setPolyVertex(vidx++, x0 + normx * weight / 2.0f, y0 + normy * weight / 2.0f, 0.0f, color);
            this.tess.polyIndices[iidx++] = (short)(count + 0);
            this.tess.setPolyVertex(vidx++, x0 - normx * weight / 2.0f, y0 - normy * weight / 2.0f, 0.0f, color);
            this.tess.polyIndices[iidx++] = (short)(count + 1);
            if (!constStroke) {
                color = this.in.strokeColors[i1];
                weight = this.in.strokeWeights[i1];
            }
            this.tess.setPolyVertex(vidx++, x1 - normx * weight / 2.0f, y1 - normy * weight / 2.0f, 0.0f, color);
            this.tess.polyIndices[iidx++] = (short)(count + 2);
            this.tess.polyIndices[iidx++] = (short)(count + 2);
            this.tess.polyIndices[iidx++] = (short)(count + 0);
            this.tess.setPolyVertex(vidx++, x1 + normx * weight / 2.0f, y1 + normy * weight / 2.0f, 0.0f, color);
            this.tess.polyIndices[iidx++] = (short)(count + 3);
            cache.incCounts(index, 6, 4);
            return index;
        }

        boolean noCapsJoins(int nInVert) {
            if (!this.accurate2DStrokes) {
                return true;
            }
            if (5000 <= nInVert) {
                return true;
            }
            return this.noCapsJoins();
        }

        boolean noCapsJoins() {
            float scaleFactor = 1.0f;
            if (this.transform != null) {
                if (this.transform instanceof PMatrix2D) {
                    PMatrix2D tr = (PMatrix2D)this.transform;
                    float areaScaleFactor = Math.abs(tr.m00 * tr.m11 - tr.m01 * tr.m10);
                    scaleFactor = (float)Math.sqrt(areaScaleFactor);
                } else if (this.transform instanceof PMatrix3D) {
                    PMatrix3D tr = (PMatrix3D)this.transform;
                    float volumeScaleFactor = Math.abs(tr.m00 * (tr.m11 * tr.m22 - tr.m12 * tr.m21) + tr.m01 * (tr.m12 * tr.m20 - tr.m10 * tr.m22) + tr.m02 * (tr.m10 * tr.m21 - tr.m11 * tr.m20));
                    scaleFactor = (float)Math.pow(volumeScaleFactor, 0.3333333432674408);
                }
            }
            return scaleFactor * this.strokeWeight < 2.0f;
        }

        void tessellateTriangles() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = nInVert;
                this.setRawSize(nInInd);
                int idx = 0;
                int i = this.in.firstVertex;
                while (i <= this.in.lastVertex) {
                    this.rawIndices[idx++] = i++;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateTriangles(int[] indices) {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = indices.length;
                this.setRawSize(nInInd);
                PApplet.arrayCopy(indices, this.rawIndices, nInInd);
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateTriangleFan() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = 3 * (nInVert - 2);
                this.setRawSize(nInInd);
                int idx = 0;
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    this.rawIndices[idx++] = this.in.firstVertex;
                    this.rawIndices[idx++] = i;
                    this.rawIndices[idx++] = i + 1;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateTriangleStrip() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = 3 * (nInVert - 2);
                this.setRawSize(nInInd);
                int idx = 0;
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    this.rawIndices[idx++] = i;
                    if (i % 2 == 0) {
                        this.rawIndices[idx++] = i - 1;
                        this.rawIndices[idx++] = i + 1;
                        continue;
                    }
                    this.rawIndices[idx++] = i + 1;
                    this.rawIndices[idx++] = i - 1;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateQuads() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 4 <= nInVert) {
                int quadCount = nInVert / 4;
                int nInInd = 6 * quadCount;
                this.setRawSize(nInInd);
                int idx = 0;
                for (int qd = 0; qd < quadCount; ++qd) {
                    int i0 = this.in.firstVertex + 4 * qd + 0;
                    int i1 = this.in.firstVertex + 4 * qd + 1;
                    int i2 = this.in.firstVertex + 4 * qd + 2;
                    int i3 = this.in.firstVertex + 4 * qd + 3;
                    this.rawIndices[idx++] = i0;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i3;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i3;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateQuadStrip() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 4 <= nInVert) {
                int quadCount = nInVert / 2 - 1;
                int nInInd = 6 * quadCount;
                this.setRawSize(nInInd);
                int idx = 0;
                for (int qd = 1; qd < nInVert / 2; ++qd) {
                    int i0 = this.in.firstVertex + 2 * (qd - 1);
                    int i1 = this.in.firstVertex + 2 * (qd - 1) + 1;
                    int i2 = this.in.firstVertex + 2 * qd + 1;
                    int i3 = this.in.firstVertex + 2 * qd;
                    this.rawIndices[idx++] = i0;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i3;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i3;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void splitRawIndices() {
            int index;
            this.tess.polyIndexCheck(this.rawSize);
            int offset = this.tess.firstPolyIndex;
            int inInd0 = 0;
            int inInd1 = 0;
            int inMaxVert0 = this.in.firstVertex;
            int inMaxVert1 = this.in.firstVertex;
            int inMaxVertRef = inMaxVert0;
            int inMaxVertRel = -1;
            this.dupCount = 0;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPolyIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int trCount = this.rawSize / 3;
            for (int tr = 0; tr < trCount; ++tr) {
                int ri2;
                int ri1;
                int ri0;
                if (index == -1) {
                    index = cache.addNew();
                }
                int i0 = this.rawIndices[3 * tr + 0];
                int i1 = this.rawIndices[3 * tr + 1];
                int i2 = this.rawIndices[3 * tr + 2];
                int ii0 = i0 - inMaxVertRef;
                int ii1 = i1 - inMaxVertRef;
                int ii2 = i2 - inMaxVertRef;
                int count = cache.vertexCount[index];
                if (ii0 < 0) {
                    this.addDupIndex(ii0);
                    ri0 = ii0;
                } else {
                    ri0 = count + ii0;
                }
                if (ii1 < 0) {
                    this.addDupIndex(ii1);
                    ri1 = ii1;
                } else {
                    ri1 = count + ii1;
                }
                if (ii2 < 0) {
                    this.addDupIndex(ii2);
                    ri2 = ii2;
                } else {
                    ri2 = count + ii2;
                }
                this.tess.polyIndices[offset + 3 * tr + 0] = (short)ri0;
                this.tess.polyIndices[offset + 3 * tr + 1] = (short)ri1;
                this.tess.polyIndices[offset + 3 * tr + 2] = (short)ri2;
                inInd1 = 3 * tr + 2;
                inMaxVert1 = PApplet.max(inMaxVert1, PApplet.max(i0, i1, i2));
                inMaxVert0 = PApplet.min(inMaxVert0, PApplet.min(i0, i1, i2));
                inMaxVertRel = PApplet.max(inMaxVertRel, PApplet.max(ri0, ri1, ri2));
                if ((32765 > inMaxVertRel + this.dupCount || inMaxVertRel + this.dupCount >= 32768) && tr != trCount - 1) continue;
                int nondupCount = 0;
                if (0 < this.dupCount) {
                    int i;
                    for (i = inInd0; i <= inInd1; ++i) {
                        short ri = this.tess.polyIndices[offset + i];
                        if (ri >= 0) continue;
                        this.tess.polyIndices[offset + i] = (short)(inMaxVertRel + 1 + this.dupIndexPos(ri));
                    }
                    if (inMaxVertRef <= inMaxVert1) {
                        this.tess.addPolyVertices(this.in, inMaxVertRef, inMaxVert1);
                        nondupCount = inMaxVert1 - inMaxVertRef + 1;
                    }
                    for (i = 0; i < this.dupCount; ++i) {
                        this.tess.addPolyVertex(this.in, this.dupIndices[i] + inMaxVertRef);
                    }
                } else {
                    this.tess.addPolyVertices(this.in, inMaxVert0, inMaxVert1);
                    nondupCount = inMaxVert1 - inMaxVert0 + 1;
                }
                cache.incCounts(index, inInd1 - inInd0 + 1, nondupCount + this.dupCount);
                this.lastPolyIndexCache = index;
                index = -1;
                inMaxVertRel = -1;
                inMaxVert0 = inMaxVertRef = inMaxVert1 + 1;
                inInd0 = inInd1 + 1;
                if (this.dupIndices != null) {
                    Arrays.fill(this.dupIndices, 0, this.dupCount, 0);
                }
                this.dupCount = 0;
            }
        }

        void addDupIndex(int idx) {
            int i;
            if (this.dupIndices == null) {
                this.dupIndices = new int[16];
            }
            if (this.dupIndices.length == this.dupCount) {
                int n = this.dupCount << 1;
                int[] temp = new int[n];
                PApplet.arrayCopy(this.dupIndices, 0, temp, 0, this.dupCount);
                this.dupIndices = temp;
            }
            if (idx < this.dupIndices[0]) {
                for (i = this.dupCount; i > 0; --i) {
                    this.dupIndices[i] = this.dupIndices[i - 1];
                }
                this.dupIndices[0] = idx;
                ++this.dupCount;
            } else if (this.dupIndices[this.dupCount - 1] < idx) {
                this.dupIndices[this.dupCount] = idx;
                ++this.dupCount;
            } else {
                for (i = 0; i < this.dupCount - 1 && this.dupIndices[i] != idx; ++i) {
                    if (this.dupIndices[i] >= idx || idx >= this.dupIndices[i + 1]) continue;
                    for (int j = this.dupCount; j > i + 1; --j) {
                        this.dupIndices[j] = this.dupIndices[j - 1];
                    }
                    this.dupIndices[i + 1] = idx;
                    ++this.dupCount;
                    break;
                }
            }
        }

        int dupIndexPos(int idx) {
            for (int i = 0; i < this.dupCount; ++i) {
                if (this.dupIndices[i] != idx) continue;
                return i;
            }
            return 0;
        }

        void setRawSize(int size) {
            int size0 = this.rawIndices.length;
            if (size0 < size) {
                int size1 = PGraphicsOpenGL.expandArraySize(size0, size);
                this.expandRawIndices(size1);
            }
            this.rawSize = size;
        }

        void expandRawIndices(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.rawIndices, 0, temp, 0, this.rawSize);
            this.rawIndices = temp;
        }

        void beginTex() {
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void beginNoTex() {
            this.prevTexImage = this.newTexImage;
            this.newTexImage = null;
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endNoTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void updateTex() {
            this.beginTex();
            this.endTex();
        }

        void setFirstTexIndex(int firstIndex, int firstCache) {
            if (this.texCache != null) {
                this.firstTexIndex = firstIndex;
                this.firstTexCache = PApplet.max(0, firstCache);
            }
        }

        void setLastTexIndex(int lastIndex, int lastCache) {
            if (this.texCache != null) {
                if (this.prevTexImage != this.newTexImage || this.texCache.size == 0) {
                    this.texCache.addTexture(this.newTexImage, this.firstTexIndex, this.firstTexCache, lastIndex, lastCache);
                } else {
                    this.texCache.setLastIndex(lastIndex, lastCache);
                }
            }
        }

        void tessellatePolygon(boolean solid, boolean closed, boolean calcNormals) {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                this.firstPolyIndexCache = -1;
                this.callback.init(this.in.renderMode == 1, false, calcNormals);
                this.gluTess.beginPolygon();
                if (solid) {
                    this.gluTess.setWindingRule(100131);
                } else {
                    this.gluTess.setWindingRule(100130);
                }
                this.gluTess.beginContour();
                for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                    boolean breakPt = this.in.breaks[i];
                    if (breakPt) {
                        this.gluTess.endContour();
                        this.gluTess.beginContour();
                    }
                    int fa = this.in.colors[i] >> 24 & 0xFF;
                    int fr = this.in.colors[i] >> 16 & 0xFF;
                    int fg = this.in.colors[i] >> 8 & 0xFF;
                    int fb = this.in.colors[i] >> 0 & 0xFF;
                    int aa = this.in.ambient[i] >> 24 & 0xFF;
                    int ar = this.in.ambient[i] >> 16 & 0xFF;
                    int ag = this.in.ambient[i] >> 8 & 0xFF;
                    int ab = this.in.ambient[i] >> 0 & 0xFF;
                    int sa = this.in.specular[i] >> 24 & 0xFF;
                    int sr = this.in.specular[i] >> 16 & 0xFF;
                    int sg = this.in.specular[i] >> 8 & 0xFF;
                    int sb = this.in.specular[i] >> 0 & 0xFF;
                    int ea = this.in.emissive[i] >> 24 & 0xFF;
                    int er = this.in.emissive[i] >> 16 & 0xFF;
                    int eg = this.in.emissive[i] >> 8 & 0xFF;
                    int eb = this.in.emissive[i] >> 0 & 0xFF;
                    double[] vertex = new double[]{this.in.vertices[3 * i + 0], this.in.vertices[3 * i + 1], this.in.vertices[3 * i + 2], fa, fr, fg, fb, this.in.normals[3 * i + 0], this.in.normals[3 * i + 1], this.in.normals[3 * i + 2], this.in.texcoords[2 * i + 0], this.in.texcoords[2 * i + 1], aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, this.in.shininess[i]};
                    this.gluTess.addVertex(vertex);
                }
                this.gluTess.endContour();
                this.gluTess.endPolygon();
            }
            this.endTex();
            this.tessellateEdges();
        }

        public void tessellateLinePath(LinePath path) {
            int cap;
            this.callback.init(this.in.renderMode == 1, true, false);
            int n = this.strokeCap == 2 ? 1 : (cap = this.strokeCap == 4 ? 2 : 0);
            int join = this.strokeJoin == 2 ? 1 : (this.strokeJoin == 32 ? 2 : 0);
            LinePath strokedPath = LinePath.createStrokedPath(path, this.strokeWeight, cap, join);
            this.gluTess.beginPolygon();
            float[] coords = new float[6];
            LinePath.PathIterator iter = strokedPath.getPathIterator();
            int rule = iter.getWindingRule();
            switch (rule) {
                case 0: {
                    this.gluTess.setWindingRule(100130);
                    break;
                }
                case 1: {
                    this.gluTess.setWindingRule(100131);
                }
            }
            while (!iter.isDone()) {
                float sr = 0.0f;
                float sg = 0.0f;
                float sb = 0.0f;
                float sa = 0.0f;
                switch (iter.currentSegment(coords)) {
                    case 0: {
                        this.gluTess.beginContour();
                    }
                    case 1: {
                        sa = this.strokeColor >> 24 & 0xFF;
                        sr = this.strokeColor >> 16 & 0xFF;
                        sg = this.strokeColor >> 8 & 0xFF;
                        sb = this.strokeColor >> 0 & 0xFF;
                        double[] vertex = new double[]{coords[0], coords[1], 0.0, sa, sr, sg, sb, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        this.gluTess.addVertex(vertex);
                        break;
                    }
                    case 2: {
                        this.gluTess.endContour();
                    }
                }
                iter.next();
            }
            this.gluTess.endPolygon();
        }

        protected class TessellatorCallback
        implements PGL.TessellatorCallback {
            boolean calcNormals;
            boolean strokeTess;
            IndexCache cache;
            int cacheIndex;
            int vertFirst;
            int vertCount;
            int primitive;

            protected TessellatorCallback() {
            }

            public void init(boolean addCache, boolean strokeTess, boolean calcNorm) {
                this.strokeTess = strokeTess;
                this.calcNormals = calcNorm;
                this.cache = Tessellator.this.tess.polyIndexCache;
                if (addCache) {
                    this.cache.addNew();
                }
            }

            @Override
            public void begin(int type) {
                this.cacheIndex = this.cache.getLast();
                if (Tessellator.this.firstPolyIndexCache == -1) {
                    Tessellator.this.firstPolyIndexCache = this.cacheIndex;
                }
                if (this.strokeTess && Tessellator.this.firstLineIndexCache == -1) {
                    Tessellator.this.firstLineIndexCache = this.cacheIndex;
                }
                this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                this.vertCount = 0;
                switch (type) {
                    case 6: {
                        this.primitive = 11;
                        break;
                    }
                    case 5: {
                        this.primitive = 10;
                        break;
                    }
                    case 4: {
                        this.primitive = 9;
                    }
                }
            }

            @Override
            public void end() {
                if (32768 <= this.vertFirst + this.vertCount) {
                    this.cacheIndex = this.cache.addNew();
                    this.vertFirst = 0;
                }
                int indCount = 0;
                switch (this.primitive) {
                    case 11: {
                        indCount = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            this.addIndex(0);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(0, i, i + 1);
                        }
                        break;
                    }
                    case 10: {
                        indCount = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            if (i % 2 == 0) {
                                this.addIndex(i + 1);
                                this.addIndex(i);
                                this.addIndex(i - 1);
                                if (!this.calcNormals) continue;
                                this.calcTriNormal(i + 1, i, i - 1);
                                continue;
                            }
                            this.addIndex(i - 1);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(i - 1, i, i + 1);
                        }
                        break;
                    }
                    case 9: {
                        indCount = this.vertCount;
                        for (int i = 0; i < this.vertCount; ++i) {
                            this.addIndex(i);
                        }
                        if (!this.calcNormals) break;
                        for (int tr = 0; tr < this.vertCount / 3; ++tr) {
                            int i0 = 3 * tr + 0;
                            int i1 = 3 * tr + 1;
                            int i2 = 3 * tr + 2;
                            this.calcTriNormal(i0, i1, i2);
                        }
                        break;
                    }
                }
                this.cache.incCounts(this.cacheIndex, indCount, this.vertCount);
                Tessellator.this.lastPolyIndexCache = this.cacheIndex;
                if (this.strokeTess) {
                    Tessellator.this.lastLineIndexCache = this.cacheIndex;
                }
            }

            protected void addIndex(int tessIdx) {
                Tessellator.this.tess.polyIndexCheck();
                Tessellator.this.tess.polyIndices[Tessellator.this.tess.polyIndexCount - 1] = (short)(this.vertFirst + tessIdx);
            }

            protected void calcTriNormal(int tessIdx0, int tessIdx1, int tessIdx2) {
                Tessellator.this.tess.calcPolyNormal(this.vertFirst + tessIdx0, this.vertFirst + tessIdx1, this.vertFirst + tessIdx2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void vertex(Object data) {
                if (!(data instanceof double[])) throw new RuntimeException("TessCallback vertex() data not understood");
                double[] d = (double[])data;
                int l = d.length;
                if (l < 25) {
                    throw new RuntimeException("TessCallback vertex() data is not of length 25");
                }
                if (this.vertCount >= 32768) throw new RuntimeException("The tessellator is generating too many vertices, reduce complexity of shape.");
                int fcolor = (int)d[3] << 24 | (int)d[4] << 16 | (int)d[5] << 8 | (int)d[6];
                int acolor = (int)d[12] << 24 | (int)d[13] << 16 | (int)d[14] << 8 | (int)d[15];
                int scolor = (int)d[16] << 24 | (int)d[17] << 16 | (int)d[18] << 8 | (int)d[19];
                int ecolor = (int)d[20] << 24 | (int)d[21] << 16 | (int)d[22] << 8 | (int)d[23];
                Tessellator.this.tess.addPolyVertex((float)d[0], (float)d[1], (float)d[2], fcolor, (float)d[7], (float)d[8], (float)d[9], (float)d[10], (float)d[11], acolor, scolor, ecolor, (float)d[24]);
                ++this.vertCount;
            }

            @Override
            public void error(int errnum) {
                String estring = PGraphicsOpenGL.this.pgl.tessError(errnum);
                PGraphics.showWarning("Tessellation Error: " + estring);
            }

            @Override
            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                double[] vertex = new double[33];
                vertex[0] = coords[0];
                vertex[1] = coords[1];
                vertex[2] = coords[2];
                for (int i = 3; i < 25; ++i) {
                    vertex[i] = 0.0;
                    for (int j = 0; j < 4; ++j) {
                        double[] vertData = (double[])data[j];
                        if (vertData == null) continue;
                        int n = i;
                        vertex[n] = vertex[n] + (double)weight[j] * vertData[i];
                    }
                }
                double sum = vertex[7] * vertex[7] + vertex[8] * vertex[8] + vertex[9] * vertex[9];
                double len = Math.sqrt(sum);
                vertex[7] = vertex[7] / len;
                vertex[8] = vertex[8] / len;
                vertex[9] = vertex[9] / len;
                outData[0] = vertex;
            }
        }
    }

    protected class TessGeometry {
        int renderMode;
        int polyVertexCount;
        int firstPolyVertex;
        int lastPolyVertex;
        float[] polyVertices;
        int[] polyColors;
        float[] polyNormals;
        float[] polyTexcoords;
        int[] polyAmbient;
        int[] polySpecular;
        int[] polyEmissive;
        float[] polyShininess;
        int polyIndexCount;
        int firstPolyIndex;
        int lastPolyIndex;
        short[] polyIndices;
        IndexCache polyIndexCache;
        int lineVertexCount;
        int firstLineVertex;
        int lastLineVertex;
        float[] lineVertices;
        int[] lineColors;
        float[] lineAttribs;
        int lineIndexCount;
        int firstLineIndex;
        int lastLineIndex;
        short[] lineIndices;
        IndexCache lineIndexCache;
        int pointVertexCount;
        int firstPointVertex;
        int lastPointVertex;
        float[] pointVertices;
        int[] pointColors;
        float[] pointAttribs;
        int pointIndexCount;
        int firstPointIndex;
        int lastPointIndex;
        short[] pointIndices;
        IndexCache pointIndexCache;

        TessGeometry(int mode) {
            this.polyIndexCache = new IndexCache();
            this.lineIndexCache = new IndexCache();
            this.pointIndexCache = new IndexCache();
            this.renderMode = mode;
            this.allocate();
        }

        void allocate() {
            this.polyVertices = new float[256];
            this.polyColors = new int[64];
            this.polyNormals = new float[192];
            this.polyTexcoords = new float[128];
            this.polyAmbient = new int[64];
            this.polySpecular = new int[64];
            this.polyEmissive = new int[64];
            this.polyShininess = new float[64];
            this.polyIndices = new short[64];
            this.lineVertices = new float[256];
            this.lineColors = new int[64];
            this.lineAttribs = new float[256];
            this.lineIndices = new short[64];
            this.pointVertices = new float[256];
            this.pointColors = new int[64];
            this.pointAttribs = new float[128];
            this.pointIndices = new short[64];
            this.clear();
        }

        void clear() {
            this.polyVertexCount = 0;
            this.lastPolyVertex = 0;
            this.firstPolyVertex = 0;
            this.polyIndexCount = 0;
            this.lastPolyIndex = 0;
            this.firstPolyIndex = 0;
            this.lineVertexCount = 0;
            this.lastLineVertex = 0;
            this.firstLineVertex = 0;
            this.lineIndexCount = 0;
            this.lastLineIndex = 0;
            this.firstLineIndex = 0;
            this.pointVertexCount = 0;
            this.lastPointVertex = 0;
            this.firstPointVertex = 0;
            this.pointIndexCount = 0;
            this.lastPointIndex = 0;
            this.firstPointIndex = 0;
            this.polyIndexCache.clear();
            this.lineIndexCache.clear();
            this.pointIndexCache.clear();
        }

        void dipose() {
            this.polyVertices = null;
            this.polyColors = null;
            this.polyNormals = null;
            this.polyTexcoords = null;
            this.polyAmbient = null;
            this.polySpecular = null;
            this.polyEmissive = null;
            this.polyShininess = null;
            this.polyIndices = null;
            this.lineVertices = null;
            this.lineColors = null;
            this.lineAttribs = null;
            this.lineIndices = null;
            this.pointVertices = null;
            this.pointColors = null;
            this.pointAttribs = null;
            this.pointIndices = null;
        }

        void polyVertexCheck() {
            if (this.polyVertexCount == this.polyVertices.length / 4) {
                int newSize = this.polyVertexCount << 1;
                this.expandPolyVertices(newSize);
                this.expandPolyColors(newSize);
                this.expandPolyNormals(newSize);
                this.expandPolyTexcoords(newSize);
                this.expandPolyAmbient(newSize);
                this.expandPolySpecular(newSize);
                this.expandPolyEmissive(newSize);
                this.expandPolyShininess(newSize);
            }
            this.firstPolyVertex = this.polyVertexCount++;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyVertexCheck(int count) {
            int oldSize = this.polyVertices.length / 4;
            if (this.polyVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.polyVertexCount + count);
                this.expandPolyVertices(newSize);
                this.expandPolyColors(newSize);
                this.expandPolyNormals(newSize);
                this.expandPolyTexcoords(newSize);
                this.expandPolyAmbient(newSize);
                this.expandPolySpecular(newSize);
                this.expandPolyEmissive(newSize);
                this.expandPolyShininess(newSize);
            }
            this.firstPolyVertex = this.polyVertexCount;
            this.polyVertexCount += count;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyIndexCheck(int count) {
            int oldSize = this.polyIndices.length;
            if (this.polyIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.polyIndexCount + count);
                this.expandPolyIndices(newSize);
            }
            this.firstPolyIndex = this.polyIndexCount;
            this.polyIndexCount += count;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void polyIndexCheck() {
            if (this.polyIndexCount == this.polyIndices.length) {
                int newSize = this.polyIndexCount << 1;
                this.expandPolyIndices(newSize);
            }
            this.firstPolyIndex = this.polyIndexCount++;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void lineVertexCheck(int count) {
            int oldSize = this.lineVertices.length / 4;
            if (this.lineVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.lineVertexCount + count);
                this.expandLineVertices(newSize);
                this.expandLineColors(newSize);
                this.expandLineAttribs(newSize);
            }
            this.firstLineVertex = this.lineVertexCount;
            this.lineVertexCount += count;
            this.lastLineVertex = this.lineVertexCount - 1;
        }

        void lineIndexCheck(int count) {
            int oldSize = this.lineIndices.length;
            if (this.lineIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.lineIndexCount + count);
                this.expandLineIndices(newSize);
            }
            this.firstLineIndex = this.lineIndexCount;
            this.lineIndexCount += count;
            this.lastLineIndex = this.lineIndexCount - 1;
        }

        void pointVertexCheck(int count) {
            int oldSize = this.pointVertices.length / 4;
            if (this.pointVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.pointVertexCount + count);
                this.expandPointVertices(newSize);
                this.expandPointColors(newSize);
                this.expandPointAttribs(newSize);
            }
            this.firstPointVertex = this.pointVertexCount;
            this.pointVertexCount += count;
            this.lastPointVertex = this.pointVertexCount - 1;
        }

        void pointIndexCheck(int count) {
            int oldSize = this.pointIndices.length;
            if (this.pointIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.pointIndexCount + count);
                this.expandPointIndices(newSize);
            }
            this.firstPointIndex = this.pointIndexCount;
            this.pointIndexCount += count;
            this.lastPointIndex = this.pointIndexCount - 1;
        }

        boolean isFull() {
            return 32768 <= this.polyVertexCount || 32768 <= this.lineVertexCount || 32768 <= this.pointVertexCount;
        }

        void getPolyVertexMin(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.polyVertices[index++]);
                v.y = PApplet.min(v.y, this.polyVertices[index++]);
                v.z = PApplet.min(v.z, this.polyVertices[index]);
            }
        }

        void getLineVertexMin(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.lineVertices[index++]);
                v.y = PApplet.min(v.y, this.lineVertices[index++]);
                v.z = PApplet.min(v.z, this.lineVertices[index]);
            }
        }

        void getPointVertexMin(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.pointVertices[index++]);
                v.y = PApplet.min(v.y, this.pointVertices[index++]);
                v.z = PApplet.min(v.z, this.pointVertices[index]);
            }
        }

        void getPolyVertexMax(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.polyVertices[index++]);
                v.y = PApplet.max(v.y, this.polyVertices[index++]);
                v.z = PApplet.max(v.z, this.polyVertices[index]);
            }
        }

        void getLineVertexMax(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.lineVertices[index++]);
                v.y = PApplet.max(v.y, this.lineVertices[index++]);
                v.z = PApplet.max(v.z, this.lineVertices[index]);
            }
        }

        void getPointVertexMax(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.pointVertices[index++]);
                v.y = PApplet.max(v.y, this.pointVertices[index++]);
                v.z = PApplet.max(v.z, this.pointVertices[index]);
            }
        }

        int getPolyVertexSum(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x += this.polyVertices[index++];
                v.y += this.polyVertices[index++];
                v.z += this.polyVertices[index];
            }
            return last - first + 1;
        }

        int getLineVertexSum(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x += this.lineVertices[index++];
                v.y += this.lineVertices[index++];
                v.z += this.lineVertices[index];
            }
            return last - first + 1;
        }

        int getPointVertexSum(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x += this.pointVertices[index++];
                v.y += this.pointVertices[index++];
                v.z += this.pointVertices[index];
            }
            return last - first + 1;
        }

        void expandPolyVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.polyVertices, 0, temp, 0, 4 * this.polyVertexCount);
            this.polyVertices = temp;
        }

        void expandPolyColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyColors, 0, temp, 0, this.polyVertexCount);
            this.polyColors = temp;
        }

        void expandPolyNormals(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.polyNormals, 0, temp, 0, 3 * this.polyVertexCount);
            this.polyNormals = temp;
        }

        void expandPolyTexcoords(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.polyTexcoords, 0, temp, 0, 2 * this.polyVertexCount);
            this.polyTexcoords = temp;
        }

        void expandPolyAmbient(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyAmbient, 0, temp, 0, this.polyVertexCount);
            this.polyAmbient = temp;
        }

        void expandPolySpecular(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polySpecular, 0, temp, 0, this.polyVertexCount);
            this.polySpecular = temp;
        }

        void expandPolyEmissive(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyEmissive, 0, temp, 0, this.polyVertexCount);
            this.polyEmissive = temp;
        }

        void expandPolyShininess(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.polyShininess, 0, temp, 0, this.polyVertexCount);
            this.polyShininess = temp;
        }

        void expandPolyIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.polyIndices, 0, temp, 0, this.polyIndexCount);
            this.polyIndices = temp;
        }

        void expandLineVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.lineVertices, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineVertices = temp;
        }

        void expandLineColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lineColors, 0, temp, 0, this.lineVertexCount);
            this.lineColors = temp;
        }

        void expandLineAttribs(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.lineAttribs, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineAttribs = temp;
        }

        void expandLineIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.lineIndices, 0, temp, 0, this.lineIndexCount);
            this.lineIndices = temp;
        }

        void expandPointVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.pointVertices, 0, temp, 0, 4 * this.pointVertexCount);
            this.pointVertices = temp;
        }

        void expandPointColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.pointColors, 0, temp, 0, this.pointVertexCount);
            this.pointColors = temp;
        }

        void expandPointAttribs(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.pointAttribs, 0, temp, 0, 2 * this.pointVertexCount);
            this.pointAttribs = temp;
        }

        void expandPointIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.pointIndices, 0, temp, 0, this.pointIndexCount);
            this.pointIndices = temp;
        }

        void trim() {
            if (0 < this.polyVertexCount && this.polyVertexCount < this.polyVertices.length / 4) {
                this.trimPolyVertices();
                this.trimPolyColors();
                this.trimPolyNormals();
                this.trimPolyTexcoords();
                this.trimPolyAmbient();
                this.trimPolySpecular();
                this.trimPolyEmissive();
                this.trimPolyShininess();
            }
            if (0 < this.polyIndexCount && this.polyIndexCount < this.polyIndices.length) {
                this.trimPolyIndices();
            }
            if (0 < this.lineVertexCount && this.lineVertexCount < this.lineVertices.length / 4) {
                this.trimLineVertices();
                this.trimLineColors();
                this.trimLineAttribs();
            }
            if (0 < this.lineIndexCount && this.lineIndexCount < this.lineIndices.length) {
                this.trimLineIndices();
            }
            if (0 < this.pointVertexCount && this.pointVertexCount < this.pointVertices.length / 4) {
                this.trimPointVertices();
                this.trimPointColors();
                this.trimPointAttribs();
            }
            if (0 < this.pointIndexCount && this.pointIndexCount < this.pointIndices.length) {
                this.trimPointIndices();
            }
        }

        void trimPolyVertices() {
            float[] temp = new float[4 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyVertices, 0, temp, 0, 4 * this.polyVertexCount);
            this.polyVertices = temp;
        }

        void trimPolyColors() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyColors, 0, temp, 0, this.polyVertexCount);
            this.polyColors = temp;
        }

        void trimPolyNormals() {
            float[] temp = new float[3 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyNormals, 0, temp, 0, 3 * this.polyVertexCount);
            this.polyNormals = temp;
        }

        void trimPolyTexcoords() {
            float[] temp = new float[2 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyTexcoords, 0, temp, 0, 2 * this.polyVertexCount);
            this.polyTexcoords = temp;
        }

        void trimPolyAmbient() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyAmbient, 0, temp, 0, this.polyVertexCount);
            this.polyAmbient = temp;
        }

        void trimPolySpecular() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polySpecular, 0, temp, 0, this.polyVertexCount);
            this.polySpecular = temp;
        }

        void trimPolyEmissive() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyEmissive, 0, temp, 0, this.polyVertexCount);
            this.polyEmissive = temp;
        }

        void trimPolyShininess() {
            float[] temp = new float[this.polyVertexCount];
            PApplet.arrayCopy(this.polyShininess, 0, temp, 0, this.polyVertexCount);
            this.polyShininess = temp;
        }

        void trimPolyIndices() {
            short[] temp = new short[this.polyIndexCount];
            PApplet.arrayCopy(this.polyIndices, 0, temp, 0, this.polyIndexCount);
            this.polyIndices = temp;
        }

        void trimLineVertices() {
            float[] temp = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineVertices, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineVertices = temp;
        }

        void trimLineColors() {
            int[] temp = new int[this.lineVertexCount];
            PApplet.arrayCopy(this.lineColors, 0, temp, 0, this.lineVertexCount);
            this.lineColors = temp;
        }

        void trimLineAttribs() {
            float[] temp = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineAttribs, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineAttribs = temp;
        }

        void trimLineIndices() {
            short[] temp = new short[this.lineIndexCount];
            PApplet.arrayCopy(this.lineIndices, 0, temp, 0, this.lineIndexCount);
            this.lineIndices = temp;
        }

        void trimPointVertices() {
            float[] temp = new float[4 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointVertices, 0, temp, 0, 4 * this.pointVertexCount);
            this.pointVertices = temp;
        }

        void trimPointColors() {
            int[] temp = new int[this.pointVertexCount];
            PApplet.arrayCopy(this.pointColors, 0, temp, 0, this.pointVertexCount);
            this.pointColors = temp;
        }

        void trimPointAttribs() {
            float[] temp = new float[2 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointAttribs, 0, temp, 0, 2 * this.pointVertexCount);
            this.pointAttribs = temp;
        }

        void trimPointIndices() {
            short[] temp = new short[this.pointIndexCount];
            PApplet.arrayCopy(this.pointIndices, 0, temp, 0, this.pointIndexCount);
            this.pointIndices = temp;
        }

        void incPolyIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.polyIndices[n] = (short)(this.polyIndices[n] + inc);
            }
        }

        void incLineIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.lineIndices[n] = (short)(this.lineIndices[n] + inc);
            }
        }

        void incPointIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.pointIndices[n] = (short)(this.pointIndices[n] + inc);
            }
        }

        void calcPolyNormal(int i0, int i1, int i2) {
            int index = 4 * i0;
            float x0 = this.polyVertices[index++];
            float y0 = this.polyVertices[index++];
            float z0 = this.polyVertices[index];
            index = 4 * i1;
            float x1 = this.polyVertices[index++];
            float y1 = this.polyVertices[index++];
            float z1 = this.polyVertices[index];
            index = 4 * i2;
            float x2 = this.polyVertices[index++];
            float y2 = this.polyVertices[index++];
            float z2 = this.polyVertices[index];
            float v12x = x2 - x1;
            float v12y = y2 - y1;
            float v12z = z2 - z1;
            float v10x = x0 - x1;
            float v10y = y0 - y1;
            float v10z = z0 - z1;
            float nx = v12y * v10z - v10y * v12z;
            float ny = v12z * v10x - v10z * v12x;
            float nz = v12x * v10y - v10x * v12y;
            float d = PApplet.sqrt(nx * nx + ny * ny + nz * nz);
            index = 3 * i0;
            this.polyNormals[index++] = nx /= d;
            this.polyNormals[index++] = ny /= d;
            this.polyNormals[index] = nz /= d;
            index = 3 * i1;
            this.polyNormals[index++] = nx;
            this.polyNormals[index++] = ny;
            this.polyNormals[index] = nz;
            index = 3 * i2;
            this.polyNormals[index++] = nx;
            this.polyNormals[index++] = ny;
            this.polyNormals[index] = nz;
        }

        void setPointVertex(int tessIdx, InGeometry in, int inIdx) {
            int index = 3 * inIdx;
            float x = in.vertices[index++];
            float y = in.vertices[index++];
            float z = in.vertices[index];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1 && !PGraphicsOpenGL.this.hints[9]) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                index = 4 * tessIdx;
                this.pointVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                this.pointVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                this.pointVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.pointVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
            } else {
                index = 4 * tessIdx;
                this.pointVertices[index++] = x;
                this.pointVertices[index++] = y;
                this.pointVertices[index++] = z;
                this.pointVertices[index] = 1.0f;
            }
            this.pointColors[tessIdx] = in.strokeColors[inIdx];
        }

        void setLineVertex(int tessIdx, InGeometry in, int inIdx0, int rgba) {
            int index = 3 * inIdx0;
            float x0 = in.vertices[index++];
            float y0 = in.vertices[index++];
            float z0 = in.vertices[index];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1 && !PGraphicsOpenGL.this.hints[9]) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0 * mm.m00 + y0 * mm.m01 + z0 * mm.m02 + mm.m03;
                this.lineVertices[index++] = x0 * mm.m10 + y0 * mm.m11 + z0 * mm.m12 + mm.m13;
                this.lineVertices[index++] = x0 * mm.m20 + y0 * mm.m21 + z0 * mm.m22 + mm.m23;
                this.lineVertices[index] = x0 * mm.m30 + y0 * mm.m31 + z0 * mm.m32 + mm.m33;
            } else {
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0;
                this.lineVertices[index++] = y0;
                this.lineVertices[index++] = z0;
                this.lineVertices[index] = 1.0f;
            }
            this.lineColors[tessIdx] = rgba;
            index = 4 * tessIdx;
            this.lineAttribs[index++] = 0.0f;
            this.lineAttribs[index++] = 0.0f;
            this.lineAttribs[index++] = 0.0f;
            this.lineAttribs[index] = 0.0f;
        }

        void setLineVertex(int tessIdx, InGeometry in, int inIdx0, int inIdx1, int rgba, float weight) {
            int index = 3 * inIdx0;
            float x0 = in.vertices[index++];
            float y0 = in.vertices[index++];
            float z0 = in.vertices[index];
            index = 3 * inIdx1;
            float x1 = in.vertices[index++];
            float y1 = in.vertices[index++];
            float z1 = in.vertices[index];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1 && !PGraphicsOpenGL.this.hints[9]) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0 * mm.m00 + y0 * mm.m01 + z0 * mm.m02 + mm.m03;
                this.lineVertices[index++] = x0 * mm.m10 + y0 * mm.m11 + z0 * mm.m12 + mm.m13;
                this.lineVertices[index++] = x0 * mm.m20 + y0 * mm.m21 + z0 * mm.m22 + mm.m23;
                this.lineVertices[index] = x0 * mm.m30 + y0 * mm.m31 + z0 * mm.m32 + mm.m33;
                index = 4 * tessIdx;
                this.lineAttribs[index++] = x1 * mm.m00 + y1 * mm.m01 + z1 * mm.m02 + mm.m03;
                this.lineAttribs[index++] = x1 * mm.m10 + y1 * mm.m11 + z1 * mm.m12 + mm.m13;
                this.lineAttribs[index] = x1 * mm.m20 + y1 * mm.m21 + z1 * mm.m22 + mm.m23;
            } else {
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0;
                this.lineVertices[index++] = y0;
                this.lineVertices[index++] = z0;
                this.lineVertices[index] = 1.0f;
                index = 4 * tessIdx;
                this.lineAttribs[index++] = x1;
                this.lineAttribs[index++] = y1;
                this.lineAttribs[index] = z1;
            }
            this.lineColors[tessIdx] = rgba;
            this.lineAttribs[4 * tessIdx + 3] = weight;
        }

        void setPolyVertex(int tessIdx, float x, float y, float z, int rgba) {
            this.setPolyVertex(tessIdx, x, y, z, rgba, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f);
        }

        void setPolyVertex(int tessIdx, float x, float y, float z, int rgba, float nx, float ny, float nz, float u, float v, int am, int sp, int em, float shine) {
            int index;
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1 && !PGraphicsOpenGL.this.hints[9]) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                PMatrix3D nm = PGraphicsOpenGL.this.modelviewInv;
                index = 4 * tessIdx;
                this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                index = 3 * tessIdx;
                this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
            } else {
                index = 4 * tessIdx;
                this.polyVertices[index++] = x;
                this.polyVertices[index++] = y;
                this.polyVertices[index++] = z;
                this.polyVertices[index] = 1.0f;
                index = 3 * tessIdx;
                this.polyNormals[index++] = nx;
                this.polyNormals[index++] = ny;
                this.polyNormals[index] = nz;
            }
            this.polyColors[tessIdx] = rgba;
            index = 2 * tessIdx;
            this.polyTexcoords[index++] = u;
            this.polyTexcoords[index] = v;
            this.polyAmbient[tessIdx] = am;
            this.polySpecular[tessIdx] = sp;
            this.polyEmissive[tessIdx] = em;
            this.polyShininess[tessIdx] = shine;
        }

        void addPolyVertex(float x, float y, float z, int rgba, float nx, float ny, float nz, float u, float v, int am, int sp, int em, float shine) {
            int index;
            this.polyVertexCheck();
            int count = this.polyVertexCount - 1;
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1 && !PGraphicsOpenGL.this.hints[9]) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                PMatrix3D nm = PGraphicsOpenGL.this.modelviewInv;
                index = 4 * count;
                this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                index = 3 * count;
                this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
            } else {
                index = 4 * count;
                this.polyVertices[index++] = x;
                this.polyVertices[index++] = y;
                this.polyVertices[index++] = z;
                this.polyVertices[index] = 1.0f;
                index = 3 * count;
                this.polyNormals[index++] = nx;
                this.polyNormals[index++] = ny;
                this.polyNormals[index] = nz;
            }
            this.polyColors[count] = rgba;
            index = 2 * count;
            this.polyTexcoords[index++] = u;
            this.polyTexcoords[index] = v;
            this.polyAmbient[count] = am;
            this.polySpecular[count] = sp;
            this.polyEmissive[count] = em;
            this.polyShininess[count] = shine;
        }

        void addPolyVertices(InGeometry in) {
            this.addPolyVertices(in, in.firstVertex, in.lastVertex);
        }

        void addPolyVertex(InGeometry in, int i) {
            this.addPolyVertices(in, i, i);
        }

        void addPolyVertices(InGeometry in, int i0, int i1) {
            int tessIdx;
            int index;
            int nvert = i1 - i0 + 1;
            this.polyVertexCheck(nvert);
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1 && !PGraphicsOpenGL.this.hints[9]) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                PMatrix3D nm = PGraphicsOpenGL.this.modelviewInv;
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    int tessIdx2 = this.firstPolyVertex + i;
                    index = 3 * inIdx;
                    float x = in.vertices[index++];
                    float y = in.vertices[index++];
                    float z = in.vertices[index];
                    index = 3 * inIdx;
                    float nx = in.normals[index++];
                    float ny = in.normals[index++];
                    float nz = in.normals[index];
                    index = 4 * tessIdx2;
                    this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                    this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                    this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                    this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                    index = 3 * tessIdx2;
                    this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                    this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                    this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
                }
            } else if (nvert <= 2) {
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    index = 3 * inIdx;
                    float x = in.vertices[index++];
                    float y = in.vertices[index++];
                    float z = in.vertices[index];
                    index = 3 * inIdx;
                    float nx = in.normals[index++];
                    float ny = in.normals[index++];
                    float nz = in.normals[index];
                    index = 4 * tessIdx;
                    this.polyVertices[index++] = x;
                    this.polyVertices[index++] = y;
                    this.polyVertices[index++] = z;
                    this.polyVertices[index] = 1.0f;
                    index = 3 * tessIdx;
                    this.polyNormals[index++] = nx;
                    this.polyNormals[index++] = ny;
                    this.polyNormals[index] = nz;
                }
            } else {
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    PApplet.arrayCopy(in.vertices, 3 * inIdx, this.polyVertices, 4 * tessIdx, 3);
                    this.polyVertices[4 * tessIdx + 3] = 1.0f;
                }
                PApplet.arrayCopy(in.normals, 3 * i0, this.polyNormals, 3 * this.firstPolyVertex, 3 * nvert);
            }
            if (nvert <= 2) {
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    index = 2 * inIdx;
                    float u = in.texcoords[index++];
                    float v = in.texcoords[index];
                    this.polyColors[tessIdx] = in.colors[inIdx];
                    index = 2 * tessIdx;
                    this.polyTexcoords[index++] = u;
                    this.polyTexcoords[index] = v;
                    this.polyAmbient[tessIdx] = in.ambient[inIdx];
                    this.polySpecular[tessIdx] = in.specular[inIdx];
                    this.polyEmissive[tessIdx] = in.emissive[inIdx];
                    this.polyShininess[tessIdx] = in.shininess[inIdx];
                }
            } else {
                PApplet.arrayCopy(in.colors, i0, this.polyColors, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.texcoords, 2 * i0, this.polyTexcoords, 2 * this.firstPolyVertex, 2 * nvert);
                PApplet.arrayCopy(in.ambient, i0, this.polyAmbient, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.specular, i0, this.polySpecular, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.emissive, i0, this.polyEmissive, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.shininess, i0, this.polyShininess, this.firstPolyVertex, nvert);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnPolyGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnPolyGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnLineGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnLineGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnLineGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnPointGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnPointGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnPointGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.polyVertices[index++];
                    float y = this.polyVertices[index];
                    index = 3 * i;
                    float nx = this.polyNormals[index++];
                    float ny = this.polyNormals[index];
                    index = 4 * i;
                    this.polyVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.polyVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    index = 3 * i;
                    this.polyNormals[index++] = nx * tr.m00 + ny * tr.m01;
                    this.polyNormals[index] = nx * tr.m10 + ny * tr.m11;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.lineVertices[index++];
                    float y = this.lineVertices[index];
                    index = 4 * i;
                    float xa = this.lineAttribs[index++];
                    float ya = this.lineAttribs[index];
                    index = 4 * i;
                    this.lineVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.lineVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    index = 4 * i;
                    this.lineAttribs[index++] = xa * tr.m00 + ya * tr.m01 + tr.m02;
                    this.lineAttribs[index] = xa * tr.m10 + ya * tr.m11 + tr.m12;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.pointVertices[index++];
                    float y = this.pointVertices[index];
                    index = 4 * i;
                    this.pointVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.pointVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                }
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.polyVertices[index++];
                    float y = this.polyVertices[index++];
                    float z = this.polyVertices[index++];
                    float w = this.polyVertices[index];
                    index = 3 * i;
                    float nx = this.polyNormals[index++];
                    float ny = this.polyNormals[index++];
                    float nz = this.polyNormals[index];
                    index = 4 * i;
                    this.polyVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.polyVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.polyVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.polyVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    index = 3 * i;
                    this.polyNormals[index++] = nx * tr.m00 + ny * tr.m01 + nz * tr.m02;
                    this.polyNormals[index++] = nx * tr.m10 + ny * tr.m11 + nz * tr.m12;
                    this.polyNormals[index] = nx * tr.m20 + ny * tr.m21 + nz * tr.m22;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.lineVertices[index++];
                    float y = this.lineVertices[index++];
                    float z = this.lineVertices[index++];
                    float w = this.lineVertices[index];
                    index = 4 * i;
                    float xa = this.lineAttribs[index++];
                    float ya = this.lineAttribs[index++];
                    float za = this.lineAttribs[index];
                    index = 4 * i;
                    this.lineVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.lineVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.lineVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.lineVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    index = 4 * i;
                    this.lineAttribs[index++] = xa * tr.m00 + ya * tr.m01 + za * tr.m02 + tr.m03;
                    this.lineAttribs[index++] = xa * tr.m10 + ya * tr.m11 + za * tr.m12 + tr.m13;
                    this.lineAttribs[index] = xa * tr.m20 + ya * tr.m21 + za * tr.m22 + tr.m23;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.pointVertices[index++];
                    float y = this.pointVertices[index++];
                    float z = this.pointVertices[index++];
                    float w = this.pointVertices[index];
                    index = 4 * i;
                    this.pointVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.pointVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.pointVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.pointVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                }
            }
        }
    }

    protected class InGeometry {
        int renderMode;
        int vertexCount;
        int edgeCount;
        int firstVertex;
        int lastVertex;
        int firstEdge;
        int lastEdge;
        float[] vertices;
        int[] colors;
        float[] normals;
        float[] texcoords;
        int[] strokeColors;
        float[] strokeWeights;
        boolean[] breaks;
        int[][] edges;
        int[] ambient;
        int[] specular;
        int[] emissive;
        float[] shininess;
        int fillColor;
        int strokeColor;
        float strokeWeight;
        int ambientColor;
        int specularColor;
        int emissiveColor;
        float shininessFactor;
        float normalX;
        float normalY;
        float normalZ;

        InGeometry(int mode) {
            this.renderMode = mode;
            this.allocate();
        }

        void clear() {
            this.lastVertex = 0;
            this.firstVertex = 0;
            this.vertexCount = 0;
            this.lastEdge = 0;
            this.firstEdge = 0;
            this.edgeCount = 0;
        }

        void clearEdges() {
            this.lastEdge = 0;
            this.firstEdge = 0;
            this.edgeCount = 0;
        }

        void allocate() {
            this.vertices = new float[192];
            this.colors = new int[64];
            this.normals = new float[192];
            this.texcoords = new float[128];
            this.strokeColors = new int[64];
            this.strokeWeights = new float[64];
            this.ambient = new int[64];
            this.specular = new int[64];
            this.emissive = new int[64];
            this.shininess = new float[64];
            this.breaks = new boolean[64];
            this.edges = new int[128][3];
            this.clear();
        }

        void dispose() {
            this.breaks = null;
            this.vertices = null;
            this.colors = null;
            this.normals = null;
            this.texcoords = null;
            this.strokeColors = null;
            this.strokeWeights = null;
            this.ambient = null;
            this.specular = null;
            this.emissive = null;
            this.shininess = null;
            this.edges = null;
        }

        void vertexCheck() {
            if (this.vertexCount == this.vertices.length / 3) {
                int newSize = this.vertexCount << 1;
                this.expandVertices(newSize);
                this.expandColors(newSize);
                this.expandNormals(newSize);
                this.expandTexcoords(newSize);
                this.expandStrokeColors(newSize);
                this.expandStrokeWeights(newSize);
                this.expandAmbient(newSize);
                this.expandSpecular(newSize);
                this.expandEmissive(newSize);
                this.expandShininess(newSize);
                this.expandBreaks(newSize);
            }
        }

        void edgeCheck() {
            if (this.edgeCount == this.edges.length) {
                int newLen = this.edgeCount << 1;
                this.expandEdges(newLen);
            }
        }

        float getVertexX(int idx) {
            return this.vertices[3 * idx + 0];
        }

        float getVertexY(int idx) {
            return this.vertices[3 * idx + 1];
        }

        float getVertexZ(int idx) {
            return this.vertices[3 * idx + 2];
        }

        float getLastVertexX() {
            return this.vertices[3 * (this.vertexCount - 1) + 0];
        }

        float getLastVertexY() {
            return this.vertices[3 * (this.vertexCount - 1) + 1];
        }

        float getLastVertexZ() {
            return this.vertices[3 * (this.vertexCount - 1) + 2];
        }

        int getNumEdgeVertices(boolean bevel) {
            int segVert = 4 * (this.lastEdge - this.firstEdge + 1);
            int bevVert = 0;
            if (bevel) {
                for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                    int[] edge = this.edges[i];
                    if (edge[2] != 0 && edge[2] != 1) continue;
                    ++bevVert;
                }
            }
            return segVert + bevVert;
        }

        int getNumEdgeIndices(boolean bevel) {
            int segInd = 6 * (this.lastEdge - this.firstEdge + 1);
            int bevInd = 0;
            if (bevel) {
                for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                    int[] edge = this.edges[i];
                    if (edge[2] != 0 && edge[2] != 1) continue;
                    bevInd += 6;
                }
            }
            return segInd + bevInd;
        }

        void getVertexMin(PVector v) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.vertices[index++]);
                v.y = PApplet.min(v.y, this.vertices[index++]);
                v.z = PApplet.min(v.z, this.vertices[index]);
            }
        }

        void getVertexMax(PVector v) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.vertices[index++]);
                v.y = PApplet.max(v.y, this.vertices[index++]);
                v.z = PApplet.max(v.z, this.vertices[index]);
            }
        }

        int getVertexSum(PVector v) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int index = 4 * i;
                v.x += this.vertices[index++];
                v.y += this.vertices[index++];
                v.z += this.vertices[index];
            }
            return this.vertexCount;
        }

        void expandVertices(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.vertices, 0, temp, 0, 3 * this.vertexCount);
            this.vertices = temp;
        }

        void expandColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.colors, 0, temp, 0, this.vertexCount);
            this.colors = temp;
        }

        void expandNormals(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.normals, 0, temp, 0, 3 * this.vertexCount);
            this.normals = temp;
        }

        void expandTexcoords(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.texcoords, 0, temp, 0, 2 * this.vertexCount);
            this.texcoords = temp;
        }

        void expandStrokeColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.strokeColors, 0, temp, 0, this.vertexCount);
            this.strokeColors = temp;
        }

        void expandStrokeWeights(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.strokeWeights, 0, temp, 0, this.vertexCount);
            this.strokeWeights = temp;
        }

        void expandAmbient(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.ambient, 0, temp, 0, this.vertexCount);
            this.ambient = temp;
        }

        void expandSpecular(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.specular, 0, temp, 0, this.vertexCount);
            this.specular = temp;
        }

        void expandEmissive(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.emissive, 0, temp, 0, this.vertexCount);
            this.emissive = temp;
        }

        void expandShininess(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.shininess, 0, temp, 0, this.vertexCount);
            this.shininess = temp;
        }

        void expandBreaks(int n) {
            boolean[] temp = new boolean[n];
            PApplet.arrayCopy(this.breaks, 0, temp, 0, this.vertexCount);
            this.breaks = temp;
        }

        void expandEdges(int n) {
            int[][] temp = new int[n][3];
            PApplet.arrayCopy(this.edges, 0, temp, 0, this.edgeCount);
            this.edges = temp;
        }

        void trim() {
            if (0 < this.vertexCount && this.vertexCount < this.vertices.length / 3) {
                this.trimVertices();
                this.trimColors();
                this.trimNormals();
                this.trimTexcoords();
                this.trimStrokeColors();
                this.trimStrokeWeights();
                this.trimAmbient();
                this.trimSpecular();
                this.trimEmissive();
                this.trimShininess();
                this.trimBreaks();
            }
            if (0 < this.edgeCount && this.edgeCount < this.edges.length) {
                this.trimEdges();
            }
        }

        void trimVertices() {
            float[] temp = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.vertices, 0, temp, 0, 3 * this.vertexCount);
            this.vertices = temp;
        }

        void trimColors() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.colors, 0, temp, 0, this.vertexCount);
            this.colors = temp;
        }

        void trimNormals() {
            float[] temp = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.normals, 0, temp, 0, 3 * this.vertexCount);
            this.normals = temp;
        }

        void trimTexcoords() {
            float[] temp = new float[2 * this.vertexCount];
            PApplet.arrayCopy(this.texcoords, 0, temp, 0, 2 * this.vertexCount);
            this.texcoords = temp;
        }

        void trimStrokeColors() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.strokeColors, 0, temp, 0, this.vertexCount);
            this.strokeColors = temp;
        }

        void trimStrokeWeights() {
            float[] temp = new float[this.vertexCount];
            PApplet.arrayCopy(this.strokeWeights, 0, temp, 0, this.vertexCount);
            this.strokeWeights = temp;
        }

        void trimAmbient() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.ambient, 0, temp, 0, this.vertexCount);
            this.ambient = temp;
        }

        void trimSpecular() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.specular, 0, temp, 0, this.vertexCount);
            this.specular = temp;
        }

        void trimEmissive() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.emissive, 0, temp, 0, this.vertexCount);
            this.emissive = temp;
        }

        void trimShininess() {
            float[] temp = new float[this.vertexCount];
            PApplet.arrayCopy(this.shininess, 0, temp, 0, this.vertexCount);
            this.shininess = temp;
        }

        void trimBreaks() {
            boolean[] temp = new boolean[this.vertexCount];
            PApplet.arrayCopy(this.breaks, 0, temp, 0, this.vertexCount);
            this.breaks = temp;
        }

        void trimEdges() {
            int[][] temp = new int[this.edgeCount][3];
            PApplet.arrayCopy(this.edges, 0, temp, 0, this.edgeCount);
            this.edges = temp;
        }

        int addVertex(float x, float y, int code) {
            return this.addVertex(x, y, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float u, float v, int code) {
            return this.addVertex(x, y, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, u, v, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float z, int code) {
            return this.addVertex(x, y, z, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float z, float u, float v, int code) {
            return this.addVertex(x, y, z, this.fillColor, this.normalX, this.normalY, this.normalZ, u, v, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float z, int fcolor, float nx, float ny, float nz, float u, float v, int scolor, float sweight, int am, int sp, int em, float shine, int code) {
            this.vertexCheck();
            PGraphicsOpenGL.this.curveVertexCount = 0;
            int index = 3 * this.vertexCount;
            this.vertices[index++] = x;
            this.vertices[index++] = y;
            this.vertices[index] = z;
            this.colors[this.vertexCount] = PGL.javaToNativeARGB(fcolor);
            index = 3 * this.vertexCount;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
            index = 2 * this.vertexCount;
            this.texcoords[index++] = u;
            this.texcoords[index] = v;
            this.strokeColors[this.vertexCount] = PGL.javaToNativeARGB(scolor);
            this.strokeWeights[this.vertexCount] = sweight;
            this.ambient[this.vertexCount] = PGL.javaToNativeARGB(am);
            this.specular[this.vertexCount] = PGL.javaToNativeARGB(sp);
            this.emissive[this.vertexCount] = PGL.javaToNativeARGB(em);
            this.shininess[this.vertexCount] = shine;
            this.breaks[this.vertexCount] = code == 4;
            this.lastVertex = this.vertexCount++;
            return this.lastVertex;
        }

        void addBezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean fill, boolean stroke, int detail, int code) {
            this.addBezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4, fill, stroke, detail, code, 20);
        }

        void addBezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean fill, boolean stroke, int detail, int code, int shape) {
            PGraphicsOpenGL.this.bezierInitCheck();
            PGraphicsOpenGL.this.bezierVertexCheck(shape, this.vertexCount);
            PMatrix3D draw = PGraphicsOpenGL.this.bezierDrawMatrix;
            float x1 = this.getLastVertexX();
            float y1 = this.getLastVertexY();
            float z1 = this.getLastVertexZ();
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            for (int j = 0; j < detail; ++j) {
                x1 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                yplot1 += yplot2;
                yplot2 += yplot3;
                zplot2 += zplot3;
                this.addVertex(x1, y1 += yplot1, z1 += (zplot1 += zplot2), j == 0 && code == 4 ? 4 : 0);
            }
        }

        public void addQuadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3, boolean fill, boolean stroke, int detail, int code) {
            this.addQuadraticVertex(cx, cy, cz, x3, y3, z3, fill, stroke, detail, code, 20);
        }

        public void addQuadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3, boolean fill, boolean stroke, int detail, int code, int shape) {
            float x1 = this.getLastVertexX();
            float y1 = this.getLastVertexY();
            float z1 = this.getLastVertexZ();
            this.addBezierVertex(x1 + (cx - x1) * 2.0f / 3.0f, y1 + (cy - y1) * 2.0f / 3.0f, z1 + (cz - z1) * 2.0f / 3.0f, x3 + (cx - x3) * 2.0f / 3.0f, y3 + (cy - y3) * 2.0f / 3.0f, z3 + (cz - z3) * 2.0f / 3.0f, x3, y3, z3, fill, stroke, detail, code, shape);
        }

        void addCurveVertex(float x, float y, float z, boolean fill, boolean stroke, int detail, int code) {
            this.addCurveVertex(x, y, z, fill, stroke, detail, code, 20);
        }

        void addCurveVertex(float x, float y, float z, boolean fill, boolean stroke, int detail, int code, int shape) {
            PGraphicsOpenGL.this.curveVertexCheck(shape);
            float[] vertex = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount];
            vertex[0] = x;
            vertex[1] = y;
            vertex[2] = z;
            PGraphicsOpenGL.this.curveVertexCount++;
            if (PGraphicsOpenGL.this.curveVertexCount > 3) {
                float[] v1 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 4];
                float[] v2 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 3];
                float[] v3 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 2];
                float[] v4 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 1];
                this.addCurveVertexSegment(v1[0], v1[1], v1[2], v2[0], v2[1], v2[2], v3[0], v3[1], v3[2], v4[0], v4[1], v4[2], detail, code);
            }
        }

        void addCurveVertexSegment(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int detail, int code) {
            float x0 = x2;
            float y0 = y2;
            float z0 = z2;
            PMatrix3D draw = PGraphicsOpenGL.this.curveDrawMatrix;
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            int savedCount = PGraphicsOpenGL.this.curveVertexCount;
            this.addVertex(x0, y0, z0, code == 4 ? 4 : 0);
            for (int j = 0; j < detail; ++j) {
                x0 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                yplot2 += yplot3;
                this.addVertex(x0, y0 += (yplot1 += yplot2), z0 += (zplot1 += (zplot2 += zplot3)), 0);
            }
            PGraphicsOpenGL.this.curveVertexCount = savedCount;
        }

        float[][] getVertexData() {
            float[][] data = new float[this.vertexCount][37];
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] vert = data[i];
                vert[0] = this.vertices[3 * i + 0];
                vert[1] = this.vertices[3 * i + 1];
                vert[2] = this.vertices[3 * i + 2];
                vert[3] = (float)(this.colors[i] >> 16 & 0xFF) / 255.0f;
                vert[4] = (float)(this.colors[i] >> 8 & 0xFF) / 255.0f;
                vert[5] = (float)(this.colors[i] >> 0 & 0xFF) / 255.0f;
                vert[6] = (float)(this.colors[i] >> 24 & 0xFF) / 255.0f;
                vert[7] = this.texcoords[2 * i + 0];
                vert[8] = this.texcoords[2 * i + 1];
                vert[9] = this.normals[3 * i + 0];
                vert[10] = this.normals[3 * i + 1];
                vert[11] = this.normals[3 * i + 2];
                vert[13] = (float)(this.strokeColors[i] >> 16 & 0xFF) / 255.0f;
                vert[14] = (float)(this.strokeColors[i] >> 8 & 0xFF) / 255.0f;
                vert[15] = (float)(this.strokeColors[i] >> 0 & 0xFF) / 255.0f;
                vert[16] = (float)(this.strokeColors[i] >> 24 & 0xFF) / 255.0f;
                vert[17] = this.strokeWeights[i];
            }
            return data;
        }

        int addEdge(int i, int j, boolean start, boolean end) {
            this.edgeCheck();
            int[] edge = this.edges[this.edgeCount];
            edge[0] = i;
            edge[1] = j;
            edge[2] = (start ? 1 : 0) + 2 * (end ? 1 : 0);
            this.lastEdge = this.edgeCount++;
            return this.lastEdge;
        }

        void addTrianglesEdges() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 3; ++i) {
                int i0 = 3 * i + 0;
                int i1 = 3 * i + 1;
                int i2 = 3 * i + 2;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, true);
            }
        }

        void addTriangleFanEdges() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i0 = this.firstVertex;
                int i1 = i;
                int i2 = i + 1;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, true);
            }
        }

        void addTriangleStripEdges() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i2;
                int i1;
                int i0 = i;
                if (i % 2 == 0) {
                    i1 = i - 1;
                    i2 = i + 1;
                } else {
                    i1 = i + 1;
                    i2 = i - 1;
                }
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, true);
            }
        }

        void addQuadsEdges() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 4; ++i) {
                int i0 = 4 * i + 0;
                int i1 = 4 * i + 1;
                int i2 = 4 * i + 2;
                int i3 = 4 * i + 3;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i3, false, false);
                this.addEdge(i3, i0, false, true);
            }
        }

        void addQuadStripEdges() {
            for (int qd = 1; qd < (this.lastVertex - this.firstVertex + 1) / 2; ++qd) {
                int i0 = this.firstVertex + 2 * (qd - 1);
                int i1 = this.firstVertex + 2 * (qd - 1) + 1;
                int i2 = this.firstVertex + 2 * qd + 1;
                int i3 = this.firstVertex + 2 * qd;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i3, false, false);
                this.addEdge(i3, i0, false, true);
            }
        }

        void addPolygonEdges(boolean closed) {
            int start = this.firstVertex;
            boolean begin = true;
            for (int i = this.firstVertex + 1; i <= this.lastVertex; ++i) {
                if (this.breaks[i]) {
                    if (closed) {
                        this.addEdge(i - 1, start, begin, true);
                    }
                    start = i;
                    begin = true;
                    continue;
                }
                if (i == this.lastVertex) {
                    if (closed && start + 1 < i) {
                        this.addEdge(i - 1, i, begin, false);
                        this.addEdge(i, start, false, true);
                    } else {
                        this.addEdge(i - 1, i, begin, true);
                    }
                } else if (i < this.lastVertex && this.breaks[i + 1] && !closed) {
                    this.addEdge(i - 1, i, begin, true);
                } else {
                    this.addEdge(i - 1, i, begin, false);
                }
                begin = false;
            }
        }

        void calcTriangleNormal(int i0, int i1, int i2) {
            int index = 3 * i0;
            float x0 = this.vertices[index++];
            float y0 = this.vertices[index++];
            float z0 = this.vertices[index];
            index = 3 * i1;
            float x1 = this.vertices[index++];
            float y1 = this.vertices[index++];
            float z1 = this.vertices[index];
            index = 3 * i2;
            float x2 = this.vertices[index++];
            float y2 = this.vertices[index++];
            float z2 = this.vertices[index];
            float v12x = x2 - x1;
            float v12y = y2 - y1;
            float v12z = z2 - z1;
            float v10x = x0 - x1;
            float v10y = y0 - y1;
            float v10z = z0 - z1;
            float nx = v12y * v10z - v10y * v12z;
            float ny = v12z * v10x - v10z * v12x;
            float nz = v12x * v10y - v10x * v12y;
            float d = PApplet.sqrt(nx * nx + ny * ny + nz * nz);
            index = 3 * i0;
            this.normals[index++] = nx /= d;
            this.normals[index++] = ny /= d;
            this.normals[index] = nz /= d;
            index = 3 * i1;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
            index = 3 * i2;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
        }

        void calcTrianglesNormals() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 3; ++i) {
                int i0 = 3 * i + 0;
                int i1 = 3 * i + 1;
                int i2 = 3 * i + 2;
                this.calcTriangleNormal(i0, i1, i2);
            }
        }

        void calcTriangleFanNormals() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i0 = this.firstVertex;
                int i1 = i;
                int i2 = i + 1;
                this.calcTriangleNormal(i0, i1, i2);
            }
        }

        void calcTriangleStripNormals() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i2;
                int i0;
                int i1 = i;
                if (i % 2 == 0) {
                    i0 = i + 1;
                    i2 = i - 1;
                } else {
                    i0 = i - 1;
                    i2 = i + 1;
                }
                this.calcTriangleNormal(i0, i1, i2);
            }
        }

        void calcQuadsNormals() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 4; ++i) {
                int i0 = 4 * i + 0;
                int i1 = 4 * i + 1;
                int i2 = 4 * i + 2;
                int i3 = 4 * i + 3;
                this.calcTriangleNormal(i0, i1, i2);
                this.calcTriangleNormal(i2, i3, i0);
            }
        }

        void calcQuadStripNormals() {
            for (int qd = 1; qd < (this.lastVertex - this.firstVertex + 1) / 2; ++qd) {
                int i0 = this.firstVertex + 2 * (qd - 1);
                int i1 = this.firstVertex + 2 * (qd - 1) + 1;
                int i2 = this.firstVertex + 2 * qd;
                int i3 = this.firstVertex + 2 * qd + 1;
                this.calcTriangleNormal(i0, i3, i1);
                this.calcTriangleNormal(i0, i2, i3);
            }
        }

        void setMaterial(int fillColor, int strokeColor, float strokeWeight, int ambientColor, int specularColor, int emissiveColor, float shininessFactor) {
            this.fillColor = fillColor;
            this.strokeColor = strokeColor;
            this.strokeWeight = strokeWeight;
            this.ambientColor = ambientColor;
            this.specularColor = specularColor;
            this.emissiveColor = emissiveColor;
            this.shininessFactor = shininessFactor;
        }

        void setNormal(float normalX, float normalY, float normalZ) {
            this.normalX = normalX;
            this.normalY = normalY;
            this.normalZ = normalZ;
        }

        void addPoint(float x, float y, float z, boolean fill, boolean stroke) {
            this.addVertex(x, y, z, 0);
        }

        void addLine(float x1, float y1, float z1, float x2, float y2, float z2, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0);
            int idx2 = this.addVertex(x2, y2, z2, 0);
            if (stroke) {
                this.addEdge(idx1, idx2, true, true);
            }
        }

        void addTriangle(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0);
            int idx2 = this.addVertex(x2, y2, z2, 0);
            int idx3 = this.addVertex(x3, y3, z3, 0);
            if (stroke) {
                this.addEdge(idx1, idx2, true, false);
                this.addEdge(idx2, idx3, false, false);
                this.addEdge(idx3, idx1, false, true);
            }
        }

        void addQuad(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0.0f, 0.0f, 0);
            int idx2 = this.addVertex(x2, y2, z2, 1.0f, 0.0f, 0);
            int idx3 = this.addVertex(x3, y3, z3, 1.0f, 1.0f, 0);
            int idx4 = this.addVertex(x4, y4, z4, 0.0f, 1.0f, 0);
            if (stroke) {
                this.addEdge(idx1, idx2, true, false);
                this.addEdge(idx2, idx3, false, false);
                this.addEdge(idx3, idx4, false, false);
                this.addEdge(idx4, idx1, false, true);
            }
        }

        void addRect(float a, float b, float c, float d, boolean fill, boolean stroke, int rectMode) {
            float temp;
            switch (rectMode) {
                case 1: {
                    break;
                }
                case 0: {
                    c += a;
                    d += b;
                    break;
                }
                case 2: {
                    float hradius = c;
                    float vradius = d;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                    break;
                }
                case 3: {
                    float hradius = c / 2.0f;
                    float vradius = d / 2.0f;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                }
            }
            if (a > c) {
                temp = a;
                a = c;
                c = temp;
            }
            if (b > d) {
                temp = b;
                b = d;
                d = temp;
            }
            this.addQuad(a, b, 0.0f, c, b, 0.0f, c, d, 0.0f, a, d, 0.0f, fill, stroke);
        }

        void addRect(float a, float b, float c, float d, float tl, float tr, float br, float bl, boolean fill, boolean stroke, int detail, int rectMode) {
            float maxRounding;
            float temp;
            switch (rectMode) {
                case 1: {
                    break;
                }
                case 0: {
                    c += a;
                    d += b;
                    break;
                }
                case 2: {
                    float hradius = c;
                    float vradius = d;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                    break;
                }
                case 3: {
                    float hradius = c / 2.0f;
                    float vradius = d / 2.0f;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                }
            }
            if (a > c) {
                temp = a;
                a = c;
                c = temp;
            }
            if (b > d) {
                temp = b;
                b = d;
                d = temp;
            }
            if (tl > (maxRounding = PApplet.min((c - a) / 2.0f, (d - b) / 2.0f))) {
                tl = maxRounding;
            }
            if (tr > maxRounding) {
                tr = maxRounding;
            }
            if (br > maxRounding) {
                br = maxRounding;
            }
            if (bl > maxRounding) {
                bl = maxRounding;
            }
            if (PGraphicsOpenGL.nonZero(tr)) {
                this.addVertex(c - tr, b, 0);
                this.addQuadraticVertex(c, b, 0.0f, c, b + tr, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(c, b, 0);
            }
            if (PGraphicsOpenGL.nonZero(br)) {
                this.addVertex(c, d - br, 0);
                this.addQuadraticVertex(c, d, 0.0f, c - br, d, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(c, d, 0);
            }
            if (PGraphicsOpenGL.nonZero(bl)) {
                this.addVertex(a + bl, d, 0);
                this.addQuadraticVertex(a, d, 0.0f, a, d - bl, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(a, d, 0);
            }
            if (PGraphicsOpenGL.nonZero(tl)) {
                this.addVertex(a, b + tl, 0);
                this.addQuadraticVertex(a, b, 0.0f, a + tl, b, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(a, b, 0);
            }
            if (stroke) {
                this.addPolygonEdges(true);
            }
        }

        void addEllipse(float a, float b, float c, float d, boolean fill, boolean stroke, int ellipseMode) {
            float x = a;
            float y = b;
            float w = c;
            float h = d;
            if (ellipseMode == 1) {
                w = c - a;
                h = d - b;
            } else if (ellipseMode == 2) {
                x = a - c;
                y = b - d;
                w = c * 2.0f;
                h = d * 2.0f;
            } else if (ellipseMode == 3) {
                x = a - c / 2.0f;
                y = b - d / 2.0f;
            }
            if (w < 0.0f) {
                x += w;
                w = -w;
            }
            if (h < 0.0f) {
                y += h;
                h = -h;
            }
            float radiusH = w / 2.0f;
            float radiusV = h / 2.0f;
            float centerX = x + radiusH;
            float centerY = y + radiusV;
            float sx1 = pgCurrent.screenX(x, y);
            float sy1 = pgCurrent.screenY(x, y);
            float sx2 = pgCurrent.screenX(x + w, y + h);
            float sy2 = pgCurrent.screenY(x + w, y + h);
            int accuracy = PApplet.max(20, (int)((float)Math.PI * 2 * PApplet.dist(sx1, sy1, sx2, sy2) / 10.0f));
            float inc = 720.0f / (float)accuracy;
            if (fill) {
                this.addVertex(centerX, centerY, 0);
            }
            int idx = 0;
            int pidx = 0;
            int idx0 = 0;
            float val = 0.0f;
            for (int i = 0; i < accuracy; ++i) {
                idx = this.addVertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV, 0);
                val = (val + inc) % 720.0f;
                if (0 < i) {
                    if (stroke) {
                        this.addEdge(pidx, idx, i == 1, false);
                    }
                } else {
                    idx0 = idx;
                }
                pidx = idx;
            }
            this.addVertex(centerX + cosLUT[0] * radiusH, centerY + sinLUT[0] * radiusV, 0);
            if (stroke) {
                this.addEdge(idx, idx0, false, true);
            }
        }

        void addArc(float a, float b, float c, float d, float start, float stop, boolean fill, boolean stroke, int ellipseMode) {
            float x = a;
            float y = b;
            float w = c;
            float h = d;
            if (ellipseMode == 1) {
                w = c - a;
                h = d - b;
            } else if (ellipseMode == 2) {
                x = a - c;
                y = b - d;
                w = c * 2.0f;
                h = d * 2.0f;
            } else if (ellipseMode == 3) {
                x = a - c / 2.0f;
                y = b - d / 2.0f;
            }
            if (Float.isInfinite(start) || Float.isInfinite(stop)) {
                return;
            }
            if (stop < start) {
                return;
            }
            while (start < 0.0f) {
                start += (float)Math.PI * 2;
                stop += (float)Math.PI * 2;
            }
            if (stop - start > (float)Math.PI * 2) {
                start = 0.0f;
                stop = (float)Math.PI * 2;
            }
            float hr = w / 2.0f;
            float vr = h / 2.0f;
            float centerX = x + hr;
            float centerY = y + vr;
            int startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            int stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            if (fill) {
                PGraphicsOpenGL.this.vertex(centerX, centerY, 0.0f);
            }
            int increment = 1;
            int idx = 0;
            int pidx = 0;
            for (int i = startLUT; i < stopLUT; i += increment) {
                int ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                idx = this.addVertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr, 0);
                if (startLUT < i && stroke) {
                    this.addEdge(pidx, idx, i == startLUT + 1, false);
                }
                pidx = idx;
            }
            idx = this.addVertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr, 0);
        }

        void addBox(float w, float h, float d, boolean fill, boolean stroke) {
            float x1 = -w / 2.0f;
            float x2 = w / 2.0f;
            float y1 = -h / 2.0f;
            float y2 = h / 2.0f;
            float z1 = -d / 2.0f;
            float z2 = d / 2.0f;
            if (fill || stroke) {
                this.setNormal(0.0f, 0.0f, 1.0f);
                this.addVertex(x1, y1, z1, 0.0f, 0.0f, 0);
                this.addVertex(x2, y1, z1, 1.0f, 0.0f, 0);
                this.addVertex(x2, y2, z1, 1.0f, 1.0f, 0);
                this.addVertex(x1, y2, z1, 0.0f, 1.0f, 0);
                this.setNormal(1.0f, 0.0f, 0.0f);
                this.addVertex(x2, y1, z1, 0.0f, 0.0f, 0);
                this.addVertex(x2, y1, z2, 1.0f, 0.0f, 0);
                this.addVertex(x2, y2, z2, 1.0f, 1.0f, 0);
                this.addVertex(x2, y2, z1, 0.0f, 1.0f, 0);
                this.setNormal(0.0f, 0.0f, -1.0f);
                this.addVertex(x2, y1, z2, 0.0f, 0.0f, 0);
                this.addVertex(x1, y1, z2, 1.0f, 0.0f, 0);
                this.addVertex(x1, y2, z2, 1.0f, 1.0f, 0);
                this.addVertex(x2, y2, z2, 0.0f, 1.0f, 0);
                this.setNormal(-1.0f, 0.0f, 0.0f);
                this.addVertex(x1, y1, z2, 0.0f, 0.0f, 0);
                this.addVertex(x1, y1, z1, 1.0f, 0.0f, 0);
                this.addVertex(x1, y2, z1, 1.0f, 1.0f, 0);
                this.addVertex(x1, y2, z2, 0.0f, 1.0f, 0);
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(x1, y1, z2, 0.0f, 0.0f, 0);
                this.addVertex(x2, y1, z2, 1.0f, 0.0f, 0);
                this.addVertex(x2, y1, z1, 1.0f, 1.0f, 0);
                this.addVertex(x1, y1, z1, 0.0f, 1.0f, 0);
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(x1, y2, z1, 0.0f, 0.0f, 0);
                this.addVertex(x2, y2, z1, 1.0f, 0.0f, 0);
                this.addVertex(x2, y2, z2, 1.0f, 1.0f, 0);
                this.addVertex(x1, y2, z2, 0.0f, 1.0f, 0);
            }
            if (stroke) {
                this.addEdge(0, 1, true, true);
                this.addEdge(1, 2, true, true);
                this.addEdge(2, 3, true, true);
                this.addEdge(3, 0, true, true);
                this.addEdge(0, 9, true, true);
                this.addEdge(1, 8, true, true);
                this.addEdge(2, 11, true, true);
                this.addEdge(3, 10, true, true);
                this.addEdge(8, 9, true, true);
                this.addEdge(9, 10, true, true);
                this.addEdge(10, 11, true, true);
                this.addEdge(11, 8, true, true);
            }
        }

        int[] addSphere(float r, int detailU, int detailV, boolean fill, boolean stroke) {
            int i;
            int i1;
            int i0;
            int i2;
            if (detailU < 3 || detailV < 2) {
                PGraphicsOpenGL.this.sphereDetail(30);
                detailV = 30;
                detailU = 30;
            } else {
                PGraphicsOpenGL.this.sphereDetail(detailU, detailV);
            }
            int nind = 3 * detailU + (6 * detailU + 3) * (detailV - 2) + 3 * detailU;
            int[] indices = new int[nind];
            int vertCount = 0;
            int indCount = 0;
            float du = 1.0f / (float)detailU;
            float dv = 1.0f / (float)detailV;
            float u = 1.0f;
            float v = 1.0f;
            for (i2 = 0; i2 < detailU; ++i2) {
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(0.0f, r, 0.0f, u, v, 0);
                u -= du;
            }
            int vert0 = vertCount = detailU;
            u = 1.0f;
            v -= dv;
            for (i2 = 0; i2 < detailU; ++i2) {
                this.setNormal(PGraphicsOpenGL.this.sphereX[i2], PGraphicsOpenGL.this.sphereY[i2], PGraphicsOpenGL.this.sphereZ[i2]);
                this.addVertex(r * PGraphicsOpenGL.this.sphereX[i2], r * PGraphicsOpenGL.this.sphereY[i2], r * PGraphicsOpenGL.this.sphereZ[i2], u, v, 0);
                u -= du;
            }
            vertCount += detailU;
            int vert1 = vertCount++;
            this.setNormal(PGraphicsOpenGL.this.sphereX[0], PGraphicsOpenGL.this.sphereY[0], PGraphicsOpenGL.this.sphereZ[0]);
            this.addVertex(r * PGraphicsOpenGL.this.sphereX[0], r * PGraphicsOpenGL.this.sphereY[0], r * PGraphicsOpenGL.this.sphereZ[0], u, v, 0);
            for (i2 = 0; i2 < detailU; ++i2) {
                int i12 = vert0 + i2;
                i0 = vert0 + i2 - detailU;
                indices[3 * i2 + 0] = i12;
                indices[3 * i2 + 1] = i0;
                indices[3 * i2 + 2] = i12 + 1;
                this.addEdge(i0, i12, true, true);
                this.addEdge(i12, i12 + 1, true, true);
            }
            indCount += 3 * detailU;
            int offset = 0;
            for (int j = 2; j < detailV; ++j) {
                int i3;
                offset += detailU;
                vert0 = vertCount;
                u = 1.0f;
                v -= dv;
                for (i3 = 0; i3 < detailU; ++i3) {
                    int ioff = offset + i3;
                    this.setNormal(PGraphicsOpenGL.this.sphereX[ioff], PGraphicsOpenGL.this.sphereY[ioff], PGraphicsOpenGL.this.sphereZ[ioff]);
                    this.addVertex(r * PGraphicsOpenGL.this.sphereX[ioff], r * PGraphicsOpenGL.this.sphereY[ioff], r * PGraphicsOpenGL.this.sphereZ[ioff], u, v, 0);
                    u -= du;
                }
                vertCount += detailU;
                vert1 = vertCount++;
                this.setNormal(PGraphicsOpenGL.this.sphereX[offset], PGraphicsOpenGL.this.sphereY[offset], PGraphicsOpenGL.this.sphereZ[offset]);
                this.addVertex(r * PGraphicsOpenGL.this.sphereX[offset], r * PGraphicsOpenGL.this.sphereY[offset], r * PGraphicsOpenGL.this.sphereZ[offset], u, v, 0);
                for (i3 = 0; i3 < detailU; ++i3) {
                    i1 = vert0 + i3;
                    int i02 = vert0 + i3 - detailU - 1;
                    indices[indCount + 6 * i3 + 0] = i1;
                    indices[indCount + 6 * i3 + 1] = i02;
                    indices[indCount + 6 * i3 + 2] = i02 + 1;
                    indices[indCount + 6 * i3 + 3] = i1;
                    indices[indCount + 6 * i3 + 4] = i02 + 1;
                    indices[indCount + 6 * i3 + 5] = i1 + 1;
                    this.addEdge(i02, i1, true, true);
                    this.addEdge(i1, i1 + 1, true, true);
                    this.addEdge(i02 + 1, i1, true, true);
                }
                indices[(indCount += 6 * detailU) + 0] = vert1;
                indices[indCount + 1] = vert1 - detailU;
                indices[indCount + 2] = vert1 - 1;
                indCount += 3;
                this.addEdge(vert1 - detailU, vert1 - 1, true, true);
                this.addEdge(vert1 - 1, vert1, true, true);
            }
            u = 1.0f;
            v = 0.0f;
            for (i = 0; i < detailU; ++i) {
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(0.0f, -r, 0.0f, u, v, 0);
                u -= du;
            }
            vertCount += detailU;
            for (i = 0; i < detailU; ++i) {
                i0 = vert0 + i;
                i1 = vert0 + i + detailU + 1;
                indices[indCount + 3 * i + 0] = i0;
                indices[indCount + 3 * i + 1] = i1;
                indices[indCount + 3 * i + 2] = i0 + 1;
                this.addEdge(i0, i0 + 1, true, true);
                this.addEdge(i0, i1, true, true);
            }
            indCount += 3 * detailU;
            return indices;
        }
    }

    protected class IndexCache {
        int size;
        int[] indexCount;
        int[] indexOffset;
        int[] vertexCount;
        int[] vertexOffset;

        IndexCache() {
            this.allocate();
        }

        void allocate() {
            this.indexCount = new int[2];
            this.indexOffset = new int[2];
            this.vertexCount = new int[2];
            this.vertexOffset = new int[2];
            this.size = 0;
        }

        void clear() {
            this.size = 0;
        }

        int addNew() {
            this.arrayCheck();
            this.init(this.size);
            ++this.size;
            return this.size - 1;
        }

        int addNew(int index) {
            this.arrayCheck();
            this.indexCount[this.size] = this.indexCount[index];
            this.indexOffset[this.size] = this.indexOffset[index];
            this.vertexCount[this.size] = this.vertexCount[index];
            this.vertexOffset[this.size] = this.vertexOffset[index];
            ++this.size;
            return this.size - 1;
        }

        int getLast() {
            if (this.size == 0) {
                this.arrayCheck();
                this.init(0);
                this.size = 1;
            }
            return this.size - 1;
        }

        void incCounts(int index, int icount, int vcount) {
            int n = index;
            this.indexCount[n] = this.indexCount[n] + icount;
            int n2 = index;
            this.vertexCount[n2] = this.vertexCount[n2] + vcount;
        }

        void init(int n) {
            if (0 < n) {
                this.indexOffset[n] = this.indexOffset[n - 1] + this.indexCount[n - 1];
                this.vertexOffset[n] = this.vertexOffset[n - 1] + this.vertexCount[n - 1];
            } else {
                this.indexOffset[n] = 0;
                this.vertexOffset[n] = 0;
            }
            this.indexCount[n] = 0;
            this.vertexCount[n] = 0;
        }

        void arrayCheck() {
            if (this.size == this.indexCount.length) {
                int newSize = this.size << 1;
                this.expandIndexCount(newSize);
                this.expandIndexOffset(newSize);
                this.expandVertexCount(newSize);
                this.expandVertexOffset(newSize);
            }
        }

        void expandIndexCount(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.indexCount, 0, temp, 0, this.size);
            this.indexCount = temp;
        }

        void expandIndexOffset(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.indexOffset, 0, temp, 0, this.size);
            this.indexOffset = temp;
        }

        void expandVertexCount(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.vertexCount, 0, temp, 0, this.size);
            this.vertexCount = temp;
        }

        void expandVertexOffset(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.vertexOffset, 0, temp, 0, this.size);
            this.vertexOffset = temp;
        }
    }

    protected class TexCache {
        int size;
        PImage[] textures;
        int[] firstIndex;
        int[] lastIndex;
        int[] firstCache;
        int[] lastCache;
        boolean hasTexture;
        Texture tex0;

        TexCache() {
            this.allocate();
        }

        void allocate() {
            this.textures = new PImage[64];
            this.firstIndex = new int[64];
            this.lastIndex = new int[64];
            this.firstCache = new int[64];
            this.lastCache = new int[64];
            this.size = 0;
            this.hasTexture = false;
        }

        void clear() {
            Arrays.fill(this.textures, 0, this.size, null);
            this.size = 0;
            this.hasTexture = false;
        }

        void dispose() {
            this.textures = null;
            this.firstIndex = null;
            this.lastIndex = null;
            this.firstCache = null;
            this.lastCache = null;
        }

        void beginRender() {
            this.tex0 = null;
        }

        PImage getTextureImage(int i) {
            return this.textures[i];
        }

        Texture getTexture(int i) {
            PImage img = this.textures[i];
            Texture tex = null;
            if (img != null && (tex = pgPrimary.getTexture(img)) != null) {
                tex.bind();
                this.tex0 = tex;
            }
            if (tex == null && this.tex0 != null) {
                this.tex0.unbind();
                PGraphicsOpenGL.this.pgl.disableTexturing(this.tex0.glTarget);
            }
            return tex;
        }

        void endRender() {
            if (this.hasTexture) {
                for (int i = 0; i < this.size; ++i) {
                    Texture tex;
                    PImage img = this.textures[i];
                    if (img == null || (tex = pgPrimary.getTexture(img)) == null) continue;
                    tex.unbind();
                    PGraphicsOpenGL.this.pgl.disableTexturing(tex.glTarget);
                }
            }
        }

        void addTexture(PImage img, int firsti, int firstb, int lasti, int lastb) {
            this.arrayCheck();
            this.textures[this.size] = img;
            this.firstIndex[this.size] = firsti;
            this.lastIndex[this.size] = lasti;
            this.firstCache[this.size] = firstb;
            this.lastCache[this.size] = lastb;
            this.hasTexture |= img != null;
            ++this.size;
        }

        void setLastIndex(int lasti, int lastb) {
            this.lastIndex[this.size - 1] = lasti;
            this.lastCache[this.size - 1] = lastb;
        }

        void arrayCheck() {
            if (this.size == this.textures.length) {
                int newSize = this.size << 1;
                this.expandTextures(newSize);
                this.expandFirstIndex(newSize);
                this.expandLastIndex(newSize);
                this.expandFirstCache(newSize);
                this.expandLastCache(newSize);
            }
        }

        void expandTextures(int n) {
            PImage[] temp = new PImage[n];
            PApplet.arrayCopy(this.textures, 0, temp, 0, this.size);
            this.textures = temp;
        }

        void expandFirstIndex(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.firstIndex, 0, temp, 0, this.size);
            this.firstIndex = temp;
        }

        void expandLastIndex(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lastIndex, 0, temp, 0, this.size);
            this.lastIndex = temp;
        }

        void expandFirstCache(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.firstCache, 0, temp, 0, this.size);
            this.firstCache = temp;
        }

        void expandLastCache(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lastCache, 0, temp, 0, this.size);
            this.lastCache = temp;
        }
    }

    protected class PointShader
    extends PShader {
        protected int projmodelviewMatrixLoc;
        protected int modelviewMatrixLoc;
        protected int projectionMatrixLoc;
        protected int viewportLoc;
        protected int perspectiveLoc;
        protected int inVertexLoc;
        protected int inColorLoc;
        protected int inPointLoc;

        public PointShader(PApplet parent) {
            super(parent);
        }

        public PointShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PointShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.inVertexLoc = this.getAttributeLoc("inVertex");
            this.inColorLoc = this.getAttributeLoc("inColor");
            this.inPointLoc = this.getAttributeLoc("inPoint");
        }

        @Override
        public void loadUniforms() {
            this.projmodelviewMatrixLoc = this.getUniformLoc("projmodelviewMatrix");
            this.modelviewMatrixLoc = this.getUniformLoc("modelviewMatrix");
            this.projectionMatrixLoc = this.getUniformLoc("projectionMatrix");
            this.viewportLoc = this.getUniformLoc("viewport");
            this.perspectiveLoc = this.getUniformLoc("perspective");
        }

        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inVertexLoc, vboId, size, type, false, stride, offset);
        }

        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inColorLoc, vboId, size, type, true, stride, offset);
        }

        public void setPointAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inPointLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.inVertexLoc) {
                this.pgl.enableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.enableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.inPointLoc) {
                this.pgl.enableVertexAttribArray(this.inPointLoc);
            }
            if (-1 < this.projmodelviewMatrixLoc) {
                this.pgCurrent.updateGLProjmodelview();
                this.setUniformMatrix(this.projmodelviewMatrixLoc, this.pgCurrent.glProjmodelview);
            }
            if (-1 < this.modelviewMatrixLoc) {
                this.pgCurrent.updateGLModelview();
                this.setUniformMatrix(this.modelviewMatrixLoc, this.pgCurrent.glModelview);
            }
            if (-1 < this.projectionMatrixLoc) {
                this.pgCurrent.updateGLProjection();
                this.setUniformMatrix(this.projectionMatrixLoc, this.pgCurrent.glProjection);
            }
            float x = this.pgCurrent.viewport[0];
            float y = this.pgCurrent.viewport[1];
            float w = this.pgCurrent.viewport[2];
            float h = this.pgCurrent.viewport[3];
            this.setUniformValue(this.viewportLoc, x, y, w, h);
            if (this.pgCurrent.getHint(10) && !this.pgCurrent.usingOrthoProjection) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.inVertexLoc) {
                this.pgl.disableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.disableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.inPointLoc) {
                this.pgl.disableVertexAttribArray(this.inPointLoc);
            }
            this.pgl.bindBuffer(34962, 0);
            super.unbind();
        }
    }

    protected class LineShader
    extends PShader {
        protected int projmodelviewMatrixLoc;
        protected int modelviewMatrixLoc;
        protected int projectionMatrixLoc;
        protected int viewportLoc;
        protected int perspectiveLoc;
        protected int scaleLoc;
        protected int inVertexLoc;
        protected int inColorLoc;
        protected int inAttribLoc;

        public LineShader(PApplet parent) {
            super(parent);
        }

        public LineShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public LineShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.inVertexLoc = this.getAttributeLoc("inVertex");
            this.inColorLoc = this.getAttributeLoc("inColor");
            this.inAttribLoc = this.getAttributeLoc("inLine");
        }

        @Override
        public void loadUniforms() {
            this.projmodelviewMatrixLoc = this.getUniformLoc("projmodelviewMatrix");
            this.modelviewMatrixLoc = this.getUniformLoc("modelviewMatrix");
            this.projectionMatrixLoc = this.getUniformLoc("projectionMatrix");
            this.viewportLoc = this.getUniformLoc("viewport");
            this.perspectiveLoc = this.getUniformLoc("perspective");
            this.scaleLoc = this.getUniformLoc("scale");
        }

        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inVertexLoc, vboId, size, type, false, stride, offset);
        }

        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inColorLoc, vboId, size, type, true, stride, offset);
        }

        public void setLineAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inAttribLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.inVertexLoc) {
                this.pgl.enableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.enableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.inAttribLoc) {
                this.pgl.enableVertexAttribArray(this.inAttribLoc);
            }
            if (-1 < this.projmodelviewMatrixLoc) {
                this.pgCurrent.updateGLProjmodelview();
                this.setUniformMatrix(this.projmodelviewMatrixLoc, this.pgCurrent.glProjmodelview);
            }
            if (-1 < this.modelviewMatrixLoc) {
                this.pgCurrent.updateGLModelview();
                this.setUniformMatrix(this.modelviewMatrixLoc, this.pgCurrent.glModelview);
            }
            if (-1 < this.projectionMatrixLoc) {
                this.pgCurrent.updateGLProjection();
                this.setUniformMatrix(this.projectionMatrixLoc, this.pgCurrent.glProjection);
            }
            float x = this.pgCurrent.viewport[0];
            float y = this.pgCurrent.viewport[1];
            float w = this.pgCurrent.viewport[2];
            float h = this.pgCurrent.viewport[3];
            this.setUniformValue(this.viewportLoc, x, y, w, h);
            if (this.pgCurrent.getHint(10) && !this.pgCurrent.usingOrthoProjection) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
            if (this.pgCurrent.getHint(7)) {
                this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, 1.0f);
            } else if (PGraphicsOpenGL.this.usingOrthoProjection) {
                this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, 0.99f);
            } else {
                this.setUniformValue(this.scaleLoc, 0.99f, 0.99f, 0.99f);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.inVertexLoc) {
                this.pgl.disableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.disableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.inAttribLoc) {
                this.pgl.disableVertexAttribArray(this.inAttribLoc);
            }
            this.pgl.bindBuffer(34962, 0);
            super.unbind();
        }
    }

    protected class PolyTexlightShader
    extends PolyLightShader {
        protected int inTexcoordLoc;
        protected int textureSamplerLoc;
        protected int texcoordMatrixLoc;
        protected int texcoordOffsetLoc;
        protected float[] tcmat;

        public PolyTexlightShader(PApplet parent) {
            super(parent);
        }

        public PolyTexlightShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PolyTexlightShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.textureSamplerLoc = this.getUniformLoc("textureSampler");
            this.texcoordMatrixLoc = this.getUniformLoc("texcoordMatrix");
            this.texcoordOffsetLoc = this.getUniformLoc("texcoordOffset");
        }

        @Override
        public void loadAttributes() {
            super.loadAttributes();
            this.inTexcoordLoc = this.getAttributeLoc("inTexcoord");
        }

        @Override
        public void setTexcoordAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inTexcoordLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setTexture(Texture tex) {
            float scaleu = 1.0f;
            float scalev = 1.0f;
            float dispu = 0.0f;
            float dispv = 0.0f;
            if (tex.invertedX()) {
                scaleu = -1.0f;
                dispu = 1.0f;
            }
            if (tex.invertedY()) {
                scalev = -1.0f;
                dispv = 1.0f;
            }
            scaleu *= tex.maxTexcoordU;
            dispu *= tex.maxTexcoordU;
            scalev *= tex.maxTexcoordV;
            dispv *= tex.maxTexcoordV;
            if (-1 < this.texcoordMatrixLoc) {
                if (this.tcmat == null) {
                    this.tcmat = new float[16];
                }
                this.tcmat[0] = scaleu;
                this.tcmat[4] = 0.0f;
                this.tcmat[8] = 0.0f;
                this.tcmat[12] = dispu;
                this.tcmat[1] = 0.0f;
                this.tcmat[5] = scalev;
                this.tcmat[9] = 0.0f;
                this.tcmat[13] = dispv;
                this.tcmat[2] = 0.0f;
                this.tcmat[6] = 0.0f;
                this.tcmat[10] = 0.0f;
                this.tcmat[14] = 0.0f;
                this.tcmat[3] = 0.0f;
                this.tcmat[7] = 0.0f;
                this.tcmat[11] = 0.0f;
                this.tcmat[15] = 0.0f;
                this.setUniformMatrix(this.texcoordMatrixLoc, this.tcmat);
            }
            this.setUniformValue(this.texcoordOffsetLoc, 1.0f / (float)tex.width, 1.0f / (float)tex.height);
            this.setUniformValue(this.textureSamplerLoc, 0);
        }

        @Override
        public void bind() {
            this.firstTexUnit = 1;
            super.bind();
            if (-1 < this.inTexcoordLoc) {
                this.pgl.enableVertexAttribArray(this.inTexcoordLoc);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.inTexcoordLoc) {
                this.pgl.disableVertexAttribArray(this.inTexcoordLoc);
            }
            super.unbind();
        }
    }

    protected class PolyTexShader
    extends PolyColorShader {
        protected int inTexcoordLoc;
        protected int textureSamplerLoc;
        protected int texcoordMatrixLoc;
        protected int texcoordOffsetLoc;
        protected float[] tcmat;

        public PolyTexShader(PApplet parent) {
            super(parent);
        }

        public PolyTexShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PolyTexShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.textureSamplerLoc = this.getUniformLoc("textureSampler");
            this.texcoordMatrixLoc = this.getUniformLoc("texcoordMatrix");
            this.texcoordOffsetLoc = this.getUniformLoc("texcoordOffset");
        }

        @Override
        public void loadAttributes() {
            super.loadAttributes();
            this.inTexcoordLoc = this.getAttributeLoc("inTexcoord");
        }

        @Override
        public void setTexcoordAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inTexcoordLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setTexture(Texture tex) {
            float scaleu = 1.0f;
            float scalev = 1.0f;
            float dispu = 0.0f;
            float dispv = 0.0f;
            if (tex.invertedX()) {
                scaleu = -1.0f;
                dispu = 1.0f;
            }
            if (tex.invertedY()) {
                scalev = -1.0f;
                dispv = 1.0f;
            }
            scaleu *= tex.maxTexcoordU();
            dispu *= tex.maxTexcoordU();
            scalev *= tex.maxTexcoordV();
            dispv *= tex.maxTexcoordV();
            if (-1 < this.texcoordMatrixLoc) {
                if (this.tcmat == null) {
                    this.tcmat = new float[16];
                }
                this.tcmat[0] = scaleu;
                this.tcmat[4] = 0.0f;
                this.tcmat[8] = 0.0f;
                this.tcmat[12] = dispu;
                this.tcmat[1] = 0.0f;
                this.tcmat[5] = scalev;
                this.tcmat[9] = 0.0f;
                this.tcmat[13] = dispv;
                this.tcmat[2] = 0.0f;
                this.tcmat[6] = 0.0f;
                this.tcmat[10] = 0.0f;
                this.tcmat[14] = 0.0f;
                this.tcmat[3] = 0.0f;
                this.tcmat[7] = 0.0f;
                this.tcmat[11] = 0.0f;
                this.tcmat[15] = 0.0f;
                this.setUniformMatrix(this.texcoordMatrixLoc, this.tcmat);
            }
            this.setUniformValue(this.texcoordOffsetLoc, 1.0f / (float)tex.width, 1.0f / (float)tex.height);
            this.setUniformValue(this.textureSamplerLoc, 0);
        }

        @Override
        public void bind() {
            this.firstTexUnit = 1;
            super.bind();
            if (-1 < this.inTexcoordLoc) {
                this.pgl.enableVertexAttribArray(this.inTexcoordLoc);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.inTexcoordLoc) {
                this.pgl.disableVertexAttribArray(this.inTexcoordLoc);
            }
            super.unbind();
        }
    }

    protected class PolyLightShader
    extends PolyShader {
        protected int projmodelviewMatrixLoc;
        protected int modelviewMatrixLoc;
        protected int projectionMatrixLoc;
        protected int normalMatrixLoc;
        protected int lightCountLoc;
        protected int lightPositionLoc;
        protected int lightNormalLoc;
        protected int lightAmbientLoc;
        protected int lightDiffuseLoc;
        protected int lightSpecularLoc;
        protected int lightFalloffCoefficientsLoc;
        protected int lightSpotParametersLoc;
        protected int inVertexLoc;
        protected int inColorLoc;
        protected int inNormalLoc;
        protected int inAmbientLoc;
        protected int inSpecularLoc;
        protected int inEmissiveLoc;
        protected int inShineLoc;

        public PolyLightShader(PApplet parent) {
            super(parent);
        }

        public PolyLightShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PolyLightShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.inVertexLoc = this.getAttributeLoc("inVertex");
            this.inColorLoc = this.getAttributeLoc("inColor");
            this.inNormalLoc = this.getAttributeLoc("inNormal");
            this.inAmbientLoc = this.getAttributeLoc("inAmbient");
            this.inSpecularLoc = this.getAttributeLoc("inSpecular");
            this.inEmissiveLoc = this.getAttributeLoc("inEmissive");
            this.inShineLoc = this.getAttributeLoc("inShine");
        }

        @Override
        public void loadUniforms() {
            this.projmodelviewMatrixLoc = this.getUniformLoc("projmodelviewMatrix");
            this.modelviewMatrixLoc = this.getUniformLoc("modelviewMatrix");
            this.projectionMatrixLoc = this.getUniformLoc("projectionMatrix");
            this.normalMatrixLoc = this.getUniformLoc("normalMatrix");
            this.lightCountLoc = this.getUniformLoc("lightCount");
            this.lightPositionLoc = this.getUniformLoc("lightPosition");
            this.lightNormalLoc = this.getUniformLoc("lightNormal");
            this.lightAmbientLoc = this.getUniformLoc("lightAmbient");
            this.lightDiffuseLoc = this.getUniformLoc("lightDiffuse");
            this.lightSpecularLoc = this.getUniformLoc("lightSpecular");
            this.lightFalloffCoefficientsLoc = this.getUniformLoc("lightFalloffCoefficients");
            this.lightSpotParametersLoc = this.getUniformLoc("lightSpotParameters");
        }

        @Override
        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inVertexLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inColorLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setNormalAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inNormalLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setAmbientAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inAmbientLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setSpecularAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inSpecularLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setEmissiveAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inEmissiveLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setShininessAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inShineLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.inVertexLoc) {
                this.pgl.enableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.enableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.inNormalLoc) {
                this.pgl.enableVertexAttribArray(this.inNormalLoc);
            }
            if (-1 < this.inAmbientLoc) {
                this.pgl.enableVertexAttribArray(this.inAmbientLoc);
            }
            if (-1 < this.inSpecularLoc) {
                this.pgl.enableVertexAttribArray(this.inSpecularLoc);
            }
            if (-1 < this.inEmissiveLoc) {
                this.pgl.enableVertexAttribArray(this.inEmissiveLoc);
            }
            if (-1 < this.inShineLoc) {
                this.pgl.enableVertexAttribArray(this.inShineLoc);
            }
            if (-1 < this.projmodelviewMatrixLoc) {
                this.pgCurrent.updateGLProjmodelview();
                this.setUniformMatrix(this.projmodelviewMatrixLoc, this.pgCurrent.glProjmodelview);
            }
            if (-1 < this.modelviewMatrixLoc) {
                this.pgCurrent.updateGLModelview();
                this.setUniformMatrix(this.modelviewMatrixLoc, this.pgCurrent.glModelview);
            }
            if (-1 < this.projectionMatrixLoc) {
                this.pgCurrent.updateGLProjection();
                this.setUniformMatrix(this.projectionMatrixLoc, this.pgCurrent.glProjection);
            }
            if (-1 < this.normalMatrixLoc) {
                this.pgCurrent.updateGLNormal();
                this.setUniformMatrix(this.normalMatrixLoc, this.pgCurrent.glNormal);
            }
            this.setUniformValue(this.lightCountLoc, this.pgCurrent.lightCount);
            this.setUniformVector(this.lightPositionLoc, this.pgCurrent.lightPosition, 4);
            this.setUniformVector(this.lightNormalLoc, this.pgCurrent.lightNormal, 3);
            this.setUniformVector(this.lightAmbientLoc, this.pgCurrent.lightAmbient, 3);
            this.setUniformVector(this.lightDiffuseLoc, this.pgCurrent.lightDiffuse, 3);
            this.setUniformVector(this.lightSpecularLoc, this.pgCurrent.lightSpecular, 3);
            this.setUniformVector(this.lightFalloffCoefficientsLoc, this.pgCurrent.lightFalloffCoefficients, 3);
            this.setUniformVector(this.lightSpotParametersLoc, this.pgCurrent.lightSpotParameters, 2);
        }

        @Override
        public void unbind() {
            if (-1 < this.inVertexLoc) {
                this.pgl.disableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.disableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.inNormalLoc) {
                this.pgl.disableVertexAttribArray(this.inNormalLoc);
            }
            if (-1 < this.inAmbientLoc) {
                this.pgl.disableVertexAttribArray(this.inAmbientLoc);
            }
            if (-1 < this.inSpecularLoc) {
                this.pgl.disableVertexAttribArray(this.inSpecularLoc);
            }
            if (-1 < this.inEmissiveLoc) {
                this.pgl.disableVertexAttribArray(this.inEmissiveLoc);
            }
            if (-1 < this.inShineLoc) {
                this.pgl.disableVertexAttribArray(this.inShineLoc);
            }
            this.pgl.bindBuffer(34962, 0);
            super.unbind();
        }
    }

    protected class PolyColorShader
    extends PolyShader {
        protected int projmodelviewMatrixLoc;
        protected int modelviewMatrixLoc;
        protected int projectionMatrixLoc;
        protected int backbufferSamplerLoc;
        protected int resolutionLoc;
        protected int inVertexLoc;
        protected int inColorLoc;

        public PolyColorShader(PApplet parent) {
            super(parent);
        }

        public PolyColorShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PolyColorShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.inVertexLoc = this.getAttributeLoc("inVertex");
            this.inColorLoc = this.getAttributeLoc("inColor");
        }

        @Override
        public void loadUniforms() {
            this.projmodelviewMatrixLoc = this.getUniformLoc("projmodelviewMatrix");
            this.modelviewMatrixLoc = this.getUniformLoc("modelviewMatrix");
            this.projectionMatrixLoc = this.getUniformLoc("projectionMatrix");
            this.backbufferSamplerLoc = this.getUniformLoc("backbufferSampler");
            this.resolutionLoc = this.getUniformLoc("resolution");
        }

        @Override
        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inVertexLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.inColorLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.inVertexLoc) {
                this.pgl.enableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.enableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.projmodelviewMatrixLoc) {
                this.pgCurrent.updateGLProjmodelview();
                this.setUniformMatrix(this.projmodelviewMatrixLoc, this.pgCurrent.glProjmodelview);
            }
            if (-1 < this.modelviewMatrixLoc) {
                this.pgCurrent.updateGLModelview();
                this.setUniformMatrix(this.modelviewMatrixLoc, this.pgCurrent.glModelview);
            }
            if (-1 < this.projectionMatrixLoc) {
                this.pgCurrent.updateGLProjection();
                this.setUniformMatrix(this.projectionMatrixLoc, this.pgCurrent.glProjection);
            }
            float w = this.pgCurrent.width;
            float h = this.pgCurrent.height;
            this.setUniformValue(this.resolutionLoc, w, h);
            if (-1 < this.backbufferSamplerLoc) {
                this.setUniformValue(this.backbufferSamplerLoc, this.lastTexUnit);
                this.pgl.activeTexture(33984 + this.lastTexUnit);
                this.pgCurrent.bindBackTexture();
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.inVertexLoc) {
                this.pgl.disableVertexAttribArray(this.inVertexLoc);
            }
            if (-1 < this.inColorLoc) {
                this.pgl.disableVertexAttribArray(this.inColorLoc);
            }
            if (-1 < this.backbufferSamplerLoc) {
                this.pgl.activeTexture(33984 + this.lastTexUnit);
                this.pgCurrent.unbindBackTexture();
                this.pgl.activeTexture(33984);
            }
            this.pgl.bindBuffer(34962, 0);
            super.unbind();
        }
    }

    protected class PolyShader
    extends PShader {
        public PolyShader(PApplet parent) {
            super(parent);
        }

        public PolyShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PolyShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setNormalAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setAmbientAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setSpecularAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setEmissiveAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setShininessAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setTexcoordAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setTexture(Texture tex) {
        }
    }

    protected class GLResource {
        int id;
        int context;

        GLResource(int id, int context) {
            this.id = id;
            this.context = context;
        }

        public boolean equals(Object obj) {
            GLResource other = (GLResource)obj;
            return other.id == this.id && other.context == this.context;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.id;
            result = 31 * result + this.context;
            return result;
        }
    }
}

