/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.media.nativewindow.NativeWindowFactory;
import jogamp.newt.Debug;
import jogamp.newt.NEWTJNILibLoader;

public class MainThread {
    private static final String MACOSXDisplayClassName = "jogamp.newt.driver.macosx.MacDisplay";
    private static final Platform.OSType osType;
    private static final boolean isMacOSX;
    public static final boolean HINT_USE_MAIN_THREAD;
    public static boolean useMainThread;
    protected static final boolean DEBUG;
    private static final MainThread singletonMainThread;
    private static UserApp mainAction;

    public static void main(String[] stringArray) {
        Thread thread = Thread.currentThread();
        useMainThread = HINT_USE_MAIN_THREAD;
        if (DEBUG) {
            System.err.println("MainThread.main(): " + thread.getName() + ", useMainThread " + useMainThread + ", HINT_USE_MAIN_THREAD " + HINT_USE_MAIN_THREAD + ", isAWTAvailable " + NativeWindowFactory.isAWTAvailable() + ", ostype " + osType + ", isMacOSX " + isMacOSX);
        }
        if (!useMainThread && !NativeWindowFactory.isAWTAvailable()) {
            throw new RuntimeException("!USE_MAIN_THREAD and no AWT available");
        }
        if (stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        if (stringArray.length > 1) {
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        }
        mainAction = new UserApp(string, stringArray2);
        if (isMacOSX) {
            ReflectionUtil.callStaticMethod((String)MACOSXDisplayClassName, (String)"initSingleton", null, null, (ClassLoader)MainThread.class.getClassLoader());
        }
        if (useMainThread) {
            try {
                thread.setName(thread.getName() + "-MainThread");
            }
            catch (Exception exception) {
                // empty catch block
            }
            mainAction.start();
            if (isMacOSX) {
                try {
                    if (DEBUG) {
                        System.err.println("MainThread.main(): " + thread.getName() + "- runNSApp");
                    }
                    ReflectionUtil.callStaticMethod((String)MACOSXDisplayClassName, (String)"runNSApplication", null, null, (ClassLoader)MainThread.class.getClassLoader());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (DEBUG) {
                System.err.println("MainThread - wait until last non daemon thread ends ...");
            }
        } else {
            mainAction.run();
        }
    }

    public static MainThread getSingleton() {
        return singletonMainThread;
    }

    static {
        NativeWindowFactory.initSingleton(true);
        NEWTJNILibLoader.loadNEWT();
        HINT_USE_MAIN_THREAD = !NativeWindowFactory.isAWTAvailable() || Debug.getBooleanProperty("newt.MainThread.force", true);
        osType = Platform.getOSType();
        isMacOSX = osType == Platform.OSType.MACOS;
        useMainThread = false;
        DEBUG = Debug.debug("MainThread");
        singletonMainThread = new MainThread();
    }

    static class UserApp
    extends Thread {
        private String mainClassName;
        private String[] mainClassArgs;
        private Method mainClassMain;

        public UserApp(String string, String[] stringArray) {
            this.mainClassName = string;
            this.mainClassArgs = stringArray;
        }

        @Override
        public void run() {
            this.setName(this.getName() + "-UserApp");
            if (DEBUG) {
                System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " start");
            }
            try {
                Class clazz = ReflectionUtil.getClass((String)this.mainClassName, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
                if (null == clazz) {
                    throw new RuntimeException(new ClassNotFoundException("MainAction couldn't find main class " + this.mainClassName));
                }
                try {
                    this.mainClassMain = clazz.getDeclaredMethod("main", String[].class);
                    this.mainClassMain.setAccessible(true);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (DEBUG) {
                    System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " invoke " + this.mainClassName);
                }
                this.mainClassMain.invoke(null, new Object[]{this.mainClassArgs});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (DEBUG) {
                System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " user app fin");
            }
            if (useMainThread) {
                if (isMacOSX) {
                    try {
                        if (DEBUG) {
                            System.err.println("MainAction.main(): " + Thread.currentThread() + " MainAction fin - stopNSApp.0");
                        }
                        ReflectionUtil.callStaticMethod((String)MainThread.MACOSXDisplayClassName, (String)"stopNSApplication", null, null, (ClassLoader)MainThread.class.getClassLoader());
                        if (DEBUG) {
                            System.err.println("MainAction.main(): " + Thread.currentThread() + " MainAction fin - stopNSApp.X");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    if (DEBUG) {
                        System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " MainAction fin - System.exit(0)");
                    }
                    System.exit(0);
                }
            }
        }
    }
}

