/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import javax.media.nativewindow.Capabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class GLCapabilities
extends Capabilities
implements Cloneable,
GLCapabilitiesImmutable {
    private GLProfile glProfile = null;
    private boolean pbuffer = false;
    private boolean doubleBuffered = true;
    private boolean stereo = false;
    private boolean hardwareAccelerated = true;
    private int depthBits = 16;
    private int stencilBits = 0;
    private int accumRedBits = 0;
    private int accumGreenBits = 0;
    private int accumBlueBits = 0;
    private int accumAlphaBits = 0;
    private String sampleExtension = "default";
    private boolean sampleBuffers = false;
    private int numSamples = 2;
    private boolean pbufferFloatingPointBuffers;
    private boolean pbufferRenderToTexture;
    private boolean pbufferRenderToTextureRectangle;

    public GLCapabilities(GLProfile gLProfile) throws GLException {
        this.glProfile = null != gLProfile ? gLProfile : GLProfile.getDefault(GLProfile.getDefaultDevice());
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    @Override
    public int hashCode() {
        int n = 31 + this.glProfile.hashCode();
        n = (n << 5) - n + (this.pbuffer ? 1 : 0);
        n = (n << 5) - n + (this.stereo ? 1 : 0);
        n = (n << 5) - n + (this.hardwareAccelerated ? 1 : 0);
        n = (n << 5) - n + this.depthBits;
        n = (n << 5) - n + this.stencilBits;
        n = (n << 5) - n + this.accumRedBits;
        n = (n << 5) - n + this.accumGreenBits;
        n = (n << 5) - n + this.accumBlueBits;
        n = (n << 5) - n + this.accumAlphaBits;
        n = (n << 5) - n + (this.sampleBuffers ? 1 : 0);
        n = (n << 5) - n + this.numSamples;
        n = (n << 5) - n + this.sampleExtension.hashCode();
        n = (n << 5) - n + (this.pbufferFloatingPointBuffers ? 1 : 0);
        n = (n << 5) - n + (this.pbufferRenderToTexture ? 1 : 0);
        n = (n << 5) - n + (this.pbufferRenderToTextureRectangle ? 1 : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof GLCapabilitiesImmutable)) {
            return false;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)object;
        boolean bl2 = bl = super.equals(object) && gLCapabilitiesImmutable.getGLProfile() == this.glProfile && gLCapabilitiesImmutable.isPBuffer() == this.pbuffer && gLCapabilitiesImmutable.getStereo() == this.stereo && gLCapabilitiesImmutable.getHardwareAccelerated() == this.hardwareAccelerated && gLCapabilitiesImmutable.getDepthBits() == this.depthBits && gLCapabilitiesImmutable.getStencilBits() == this.stencilBits && gLCapabilitiesImmutable.getAccumRedBits() == this.accumRedBits && gLCapabilitiesImmutable.getAccumGreenBits() == this.accumGreenBits && gLCapabilitiesImmutable.getAccumBlueBits() == this.accumBlueBits && gLCapabilitiesImmutable.getAccumAlphaBits() == this.accumAlphaBits && gLCapabilitiesImmutable.getSampleBuffers() == this.sampleBuffers && gLCapabilitiesImmutable.getPbufferFloatingPointBuffers() == this.pbufferFloatingPointBuffers && gLCapabilitiesImmutable.getPbufferRenderToTexture() == this.pbufferRenderToTexture && gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle() == this.pbufferRenderToTextureRectangle;
        if (this.sampleBuffers) {
            bl = bl && gLCapabilitiesImmutable.getNumSamples() == this.numSamples && gLCapabilitiesImmutable.getSampleExtension().equals(this.sampleExtension);
        }
        return bl;
    }

    @Override
    public int compareTo(Object object) {
        int n;
        if (!(object instanceof GLCapabilities)) {
            Class<?> clazz = null != object ? object.getClass() : null;
            throw new ClassCastException("Not a GLCapabilities object: " + clazz);
        }
        GLCapabilities gLCapabilities = (GLCapabilities)object;
        if (this.hardwareAccelerated && !gLCapabilities.hardwareAccelerated) {
            return 1;
        }
        if (!this.hardwareAccelerated && gLCapabilities.hardwareAccelerated) {
            return -1;
        }
        if (this.stereo && !gLCapabilities.stereo) {
            return 1;
        }
        if (!this.stereo && gLCapabilities.stereo) {
            return -1;
        }
        int n2 = this.sampleBuffers ? this.numSamples : 0;
        int n3 = n = gLCapabilities.sampleBuffers ? gLCapabilities.numSamples : 0;
        if (n2 > n) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        if (this.stencilBits > gLCapabilities.stencilBits) {
            return 1;
        }
        if (this.stencilBits < gLCapabilities.stencilBits) {
            return -1;
        }
        int n4 = super.compareTo(gLCapabilities);
        if (0 != n4) {
            return n4;
        }
        if (this.depthBits > gLCapabilities.depthBits) {
            return 1;
        }
        if (this.depthBits < gLCapabilities.depthBits) {
            return -1;
        }
        return 0;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.glProfile;
    }

    public void setGLProfile(GLProfile gLProfile) {
        this.glProfile = gLProfile;
    }

    @Override
    public boolean isPBuffer() {
        return this.pbuffer;
    }

    public void setPBuffer(boolean bl) {
        if (bl) {
            this.setOnscreen(false);
        }
        this.pbuffer = bl;
    }

    @Override
    public void setOnscreen(boolean bl) {
        if (bl) {
            this.setPBuffer(false);
        }
        super.setOnscreen(bl);
    }

    @Override
    public boolean getDoubleBuffered() {
        return this.doubleBuffered;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    @Override
    public boolean getStereo() {
        return this.stereo;
    }

    public void setStereo(boolean bl) {
        this.stereo = bl;
    }

    @Override
    public boolean getHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public void setHardwareAccelerated(boolean bl) {
        this.hardwareAccelerated = bl;
    }

    @Override
    public int getDepthBits() {
        return this.depthBits;
    }

    public void setDepthBits(int n) {
        this.depthBits = n;
    }

    @Override
    public int getStencilBits() {
        return this.stencilBits;
    }

    public void setStencilBits(int n) {
        this.stencilBits = n;
    }

    @Override
    public int getAccumRedBits() {
        return this.accumRedBits;
    }

    public void setAccumRedBits(int n) {
        this.accumRedBits = n;
    }

    @Override
    public int getAccumGreenBits() {
        return this.accumGreenBits;
    }

    public void setAccumGreenBits(int n) {
        this.accumGreenBits = n;
    }

    @Override
    public int getAccumBlueBits() {
        return this.accumBlueBits;
    }

    public void setAccumBlueBits(int n) {
        this.accumBlueBits = n;
    }

    @Override
    public int getAccumAlphaBits() {
        return this.accumAlphaBits;
    }

    public void setAccumAlphaBits(int n) {
        this.accumAlphaBits = n;
    }

    public void setSampleExtension(String string) {
        this.sampleExtension = string;
    }

    @Override
    public String getSampleExtension() {
        return this.sampleExtension;
    }

    public void setSampleBuffers(boolean bl) {
        this.sampleBuffers = bl;
        if (this.sampleBuffers && this.getAlphaBits() == 0) {
            this.setAlphaBits(1);
        }
    }

    @Override
    public boolean getSampleBuffers() {
        return this.sampleBuffers;
    }

    public void setNumSamples(int n) {
        this.numSamples = n;
    }

    @Override
    public int getNumSamples() {
        return this.numSamples;
    }

    public void setPbufferFloatingPointBuffers(boolean bl) {
        this.pbufferFloatingPointBuffers = bl;
    }

    @Override
    public boolean getPbufferFloatingPointBuffers() {
        return this.pbufferFloatingPointBuffers;
    }

    public void setPbufferRenderToTexture(boolean bl) {
        this.pbufferRenderToTexture = bl;
    }

    @Override
    public boolean getPbufferRenderToTexture() {
        return this.pbufferRenderToTexture;
    }

    public void setPbufferRenderToTextureRectangle(boolean bl) {
        this.pbufferRenderToTextureRectangle = bl;
    }

    @Override
    public boolean getPbufferRenderToTextureRectangle() {
        return this.pbufferRenderToTextureRectangle;
    }

    @Override
    public StringBuffer toString(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        int n = this.sampleBuffers ? this.numSamples : 0;
        super.toString(stringBuffer);
        stringBuffer.append(", accum-rgba ").append(this.accumRedBits).append("/").append(this.accumGreenBits).append("/").append(this.accumBlueBits).append("/").append(this.accumAlphaBits);
        stringBuffer.append(", dp/st/ms: ").append(this.depthBits).append("/").append(this.stencilBits).append("/").append(n);
        if (n > 0) {
            stringBuffer.append(", sample-ext ").append(this.sampleExtension);
        }
        if (this.doubleBuffered) {
            stringBuffer.append(", dbl");
        } else {
            stringBuffer.append(", one");
        }
        if (this.stereo) {
            stringBuffer.append(", stereo");
        } else {
            stringBuffer.append(", mono  ");
        }
        if (this.hardwareAccelerated) {
            stringBuffer.append(", hw, ");
        } else {
            stringBuffer.append(", sw, ");
        }
        stringBuffer.append(this.glProfile);
        if (!this.isOnscreen()) {
            if (this.pbuffer) {
                stringBuffer.append(", pbuffer [r2t ").append(this.pbufferRenderToTexture ? 1 : 0).append(", r2tr ").append(this.pbufferRenderToTextureRectangle ? 1 : 0).append(", float ").append(this.pbufferFloatingPointBuffers ? 1 : 0).append("]");
            } else {
                stringBuffer.append(", pixmap");
            }
        }
        return stringBuffer;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GLCaps[");
        this.toString(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

