/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLExtensionNames;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLProfile;
import jogamp.opengl.ExtensionAvailabilityCache;
import jogamp.opengl.GLBufferSizeTracker;
import jogamp.opengl.GLBufferStateTracker;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDebugMessageHandler;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLStateTracker;
import jogamp.opengl.GLVersionNumber;
import jogamp.opengl.GLWorkerThread;

public abstract class GLContextImpl
extends GLContext {
    private String contextFQN;
    private int additionalCtxCreationFlags;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private String glRenderer;
    private String glRendererLowerCase;
    private GLBufferSizeTracker bufferSizeTracker;
    private GLBufferStateTracker bufferStateTracker = new GLBufferStateTracker();
    private GLStateTracker glStateTracker = new GLStateTracker();
    private GLDebugMessageHandler glDebugHandler = null;
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap<String, ExtensionAvailabilityCache> mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLProcAddress = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLXProcAddress = new HashMap();
    volatile boolean lockFailFast = true;

    public static void shutdownImpl() {
        mappedExtensionAvailabilityCache.clear();
        mappedGLProcAddress.clear();
        mappedGLXProcAddress.clear();
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
        GLContextShareSet.synchronizeBufferObjectSharing(gLContext, this);
        this.drawable = gLDrawableImpl;
        this.drawableRead = gLDrawableImpl;
        this.glDebugHandler = new GLDebugMessageHandler(this);
    }

    @Override
    protected void resetStates() {
        if (this.bufferSizeTracker != null) {
            this.bufferSizeTracker.clearCachedBufferSizes();
        }
        if (this.bufferStateTracker != null) {
            this.bufferStateTracker.clearBufferObjectState();
        }
        if (this.glStateTracker != null) {
            this.glStateTracker.clearStates(false);
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        this.additionalCtxCreationFlags = 0;
        this.glRendererLowerCase = this.glRenderer = "";
        super.resetStates();
    }

    @Override
    public final void setGLReadDrawable(GLDrawable gLDrawable) {
        if (null != gLDrawable && this.drawable != gLDrawable && !this.isGLReadDrawableAvailable()) {
            throw new GLException("GL Read Drawable not available");
        }
        boolean bl = this.lock.isOwner();
        if (bl) {
            this.release();
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
    }

    @Override
    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return (GLDrawableImpl)this.getGLDrawable();
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().getSimpleName() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().getSimpleName() + ", " + gL.toString() : "<null>";
            Exception exception = new Exception("Info: setGL (OpenGL " + this.getGLVersion() + "): " + Thread.currentThread().getName() + ", " + string + " -> " + string2);
            exception.printStackTrace();
        }
        this.gl = gL;
        return gL;
    }

    protected void drawableUpdatedNotify() throws GLException {
    }

    @Override
    public boolean isSynchronized() {
        return !this.lockFailFast;
    }

    @Override
    public void setSynchronized(boolean bl) {
        this.lockFailFast = !bl;
    }

    private final void lockConsiderFailFast() {
        block4: {
            if (this.lockFailFast) {
                try {
                    if (!this.lock.tryLock(0L)) {
                        throw new GLException("Error: Attempt to make context current on thread " + Thread.currentThread().getName() + " which is already current on thread " + this.lock.getOwner().getName());
                    }
                    break block4;
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            this.lock.lock();
        }
    }

    public abstract Object getPlatformGLExtensions();

    @Override
    public void release() throws GLException {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean bl) throws GLException {
        if (TRACE_SWITCH) {
            System.err.println("GLContext.ContextSwitch: - release() - " + Thread.currentThread().getName() + ": force: " + bl + ", " + this.lock);
        }
        if (!this.lock.isOwner()) {
            throw new GLException("Context not current on current thread " + Thread.currentThread().getName() + ": " + this);
        }
        boolean bl2 = bl || this.lock.getHoldCount() == 1;
        try {
            if (bl2 && this.contextHandle != 0L) {
                this.releaseImpl();
            }
        }
        finally {
            if (bl2) {
                GLContextImpl.setCurrent(null);
            }
            this.drawable.unlockSurface();
            this.lock.unlock();
            if (TRACE_SWITCH) {
                if (bl2) {
                    System.err.println("GLContext.ContextSwitch: - switch - CONTEXT_RELEASE - " + Thread.currentThread().getName() + " - " + this.lock);
                } else {
                    System.err.println("GLContext.ContextSwitch: - keep   - CONTEXT_RELEASE - " + Thread.currentThread().getName() + " - " + this.lock);
                }
            }
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        block14: {
            this.lockConsiderFailFast();
            try {
                if (this.lock.getHoldCount() > 2) {
                    throw new GLException("XXX: " + this.lock);
                }
                if (DEBUG || TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.0: " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this) + " - " + this.lock);
                }
                if (this.contextHandle == 0L) break block14;
                int n = this.drawable.lockSurface();
                if (1 == n) {
                    throw new GLException("Surface not ready to lock: " + this.drawable);
                }
                if (null != this.glDebugHandler) {
                    if (this.lock.getHoldCount() == 1) {
                        this.makeCurrent();
                    }
                    this.glDebugHandler.enable(false);
                }
                if (this.lock.getHoldCount() > 1) {
                    this.release(true);
                }
                try {
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    this.glDebugHandler = null;
                    if (GLContextShareSet.contextDestroyed(this) && !GLContextShareSet.hasCreatedSharedLeft(this)) {
                        GLContextShareSet.unregisterSharing(this);
                    }
                }
                finally {
                    this.drawable.unlockSurface();
                }
            }
            finally {
                this.lock.unlock();
                if (DEBUG || TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.X: " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this) + " - " + this.lock);
                }
            }
        }
        this.resetStates();
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void copy(GLContext gLContext, int n) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n2 = this.drawable.lockSurface();
        if (1 == n2) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    @Override
    public int makeCurrent() throws GLException {
        boolean bl = false;
        this.lockConsiderFailFast();
        int n = 0;
        try {
            int n2 = this.drawable.lockSurface();
            if (1 >= n2) {
                int n3 = 0;
                return n3;
            }
            try {
                GLContext gLContext;
                if (2 == n2) {
                    this.drawable.updateHandle();
                }
                if ((gLContext = GLContextImpl.getCurrent()) != null) {
                    if (gLContext == this) {
                        this.drawableUpdatedNotify();
                        if (TRACE_SWITCH) {
                            System.err.println("GLContext.ContextSwitch: - keep   - CONTEXT_CURRENT - " + Thread.currentThread().getName() + " - " + this.lock);
                        }
                        int n4 = 1;
                        return n4;
                    }
                    gLContext.release();
                }
                if (GLWorkerThread.isStarted() && !GLWorkerThread.isWorkerThread()) {
                    GLWorkerThread.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                if (0L == this.drawable.getHandle()) {
                    throw new GLException("drawable has invalid handle: " + this.drawable);
                }
                n = this.makeCurrentWithinLock(n2);
                bl = 0 == n;
            }
            catch (RuntimeException runtimeException) {
                bl = true;
                throw runtimeException;
            }
            finally {
                if (bl) {
                    this.drawable.unlockSurface();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            bl = true;
            throw runtimeException;
        }
        finally {
            if (bl) {
                this.lock.unlock();
            }
        }
        if (n == 0) {
            if (TRACE_SWITCH) {
                System.err.println("GLContext.ContextSwitch: - switch - CONTEXT_NOT_CURRENT - " + Thread.currentThread().getName() + " - " + this.lock);
            }
        } else {
            GLContextImpl.setCurrent(this);
            if (n == 2) {
                this.getGLDrawable().getGLProfile().verifyEquality(this.gl.getGLProfile());
                this.glDebugHandler.init(this.isGL2GL3() && this.isGLDebugEnabled());
                if (DEBUG_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Debug", null, this.gl, null));
                    if (this.glDebugHandler.isEnabled()) {
                        this.glDebugHandler.addListener(new GLDebugMessageHandler.StdErrGLDebugListener(true));
                    }
                }
                if (TRACE_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Trace", null, this.gl, new Object[]{System.err}));
                }
                if (TRACE_SWITCH) {
                    System.err.println("GLContext.ContextSwitch: - switch - CONTEXT_CURRENT_NEW - " + Thread.currentThread().getName() + " - " + this.lock);
                }
            } else if (TRACE_SWITCH) {
                System.err.println("GLContext.ContextSwitch: - switch - CONTEXT_CURRENT - " + Thread.currentThread().getName() + " - " + this.lock);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int makeCurrentWithinLock(int n) throws GLException {
        if (!this.isCreated()) {
            boolean bl;
            GLContextImpl gLContextImpl;
            if (DEBUG_GL) {
                this.additionalCtxCreationFlags |= 0x20;
            }
            if (null != (gLContextImpl = (GLContextImpl)GLContextShareSet.getShareContext(this))) {
                gLContextImpl.getDrawableImpl().lockSurface();
            }
            try {
                bl = this.createImpl(gLContextImpl);
            }
            finally {
                if (null != gLContextImpl) {
                    gLContextImpl.getDrawableImpl().unlockSurface();
                }
            }
            if (DEBUG) {
                if (bl) {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context OK: " + GLContextImpl.toHexString(this.contextHandle) + " for " + this.getClass().getName() + " - " + this.getGLVersion());
                } else {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context FAILED for " + this.getClass().getName());
                }
            }
            if (!bl) {
                return 0;
            }
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
            if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                int n2;
                int n3;
                if (0 != (this.ctxOptions & 8)) {
                    n3 = this.ctxMajorVersion;
                    n2 = 8;
                } else {
                    n3 = this.ctxMajorVersion < 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion == 0 ? 2 : this.ctxMajorVersion;
                    n2 = 0 != (this.ctxOptions & 4) ? 4 : 2;
                }
                GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n3, n2, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextOLD-MapVersionsAvailable HAVE: " + abstractGraphicsDevice + " -> " + n3 + "." + n2 + " -> " + this.getGLVersion());
                }
            }
            GLContextShareSet.contextCreated(this);
            return 2;
        }
        this.makeCurrentImpl();
        return 1;
    }

    protected abstract void makeCurrentImpl() throws GLException;

    protected abstract boolean createImpl(GLContextImpl var1) throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final long createContextARB(long l, boolean bl) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        GLProfile gLProfile2 = gLProfile.getImpl();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB: mappedVersionsAvailableSet(" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && !this.mapGLVersions(abstractGraphicsDevice)) {
            return 0L;
        }
        int n = gLProfile2.isGL4() ? 4 : (gLProfile2.isGL3() ? 3 : 2);
        boolean bl2 = gLProfile2.isGL2();
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        long l2 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, bl2 ? 2 : 4, nArray, nArray2, nArray3)) {
            nArray3[0] = nArray3[0] | this.additionalCtxCreationFlags;
            l2 = this.createContextARBImpl(l, bl, nArray3[0], nArray[0], nArray2[0]);
            if (0L != l2) {
                this.setGLFunctionAvailability(true, nArray[0], nArray2[0], nArray3[0]);
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        HashMap<String, Integer> hashMap = GLContext.deviceVersionAvailable;
        synchronized (hashMap) {
            boolean bl = false;
            bl |= this.createContextARBMapVersionsAvailable(4, true);
            bl |= this.createContextARBMapVersionsAvailable(3, true);
            bl |= this.createContextARBMapVersionsAvailable(2, true);
            bl |= this.createContextARBMapVersionsAvailable(4, false);
            if (bl |= this.createContextARBMapVersionsAvailable(3, false)) {
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
            } else if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersions NONE for :" + abstractGraphicsDevice);
            }
            return bl;
        }
    }

    private final boolean createContextARBMapVersionsAvailable(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = bl ? 2 : 4;
        int n7 = 5;
        if (bl) {
            n7 &= 0xFFFFFFFB;
            n7 |= 2;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (4 == n) {
            n5 = 4;
            n4 = GLContext.getMaxMinor(n5);
            n3 = 4;
            n2 = 0;
        } else if (3 == n) {
            n5 = 3;
            n4 = GLContext.getMaxMinor(n5);
            n3 = 3;
            n2 = 1;
        } else {
            n5 = 3;
            n4 = 0;
            n3 = 2;
            n2 = 0;
        }
        long l = this.createContextARBVersions(0L, true, n7, n5, n4, n3, n2, nArray, nArray2);
        if (0L == l && !bl) {
            n7 &= 0xFFFFFFFB;
            l = this.createContextARBVersions(0L, true, n7 |= 0x10, n5, n4, n3, n2, nArray, nArray2);
            if (0L == l) {
                n7 &= 0xFFFFFFFB;
                n7 &= 0xFFFFFFEF;
                l = this.createContextARBVersions(0L, true, n7 |= 2, n5, n4, n3, n2, nArray, nArray2);
            }
        }
        if (0L != l) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, n6, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
            this.destroyContextARBImpl(l);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable HAVE: " + n + "." + n6 + " -> " + this.getGLVersion());
            }
            this.resetStates();
            return true;
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable NOPE: " + n + "." + n6);
        }
        return false;
    }

    private final long createContextARBVersions(long l, boolean bl, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        nArray[0] = n2;
        nArray2[0] = n3;
        long l2 = 0L;
        boolean bl2 = false;
        while (!bl2 && GLContext.isValidGLVersion(nArray[0], nArray2[0]) && (nArray[0] > n4 || nArray[0] == n4 && nArray2[0] >= n5)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0]);
            }
            if (0L != (l2 = this.createContextARBImpl(l, bl, n, nArray[0], nArray2[0]))) {
                bl2 = true;
                this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n);
            } else {
                bl2 = false;
            }
            if (bl2 && nArray[0] >= 3) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                this.gl.glGetIntegerv(33307, nArray3, 0);
                this.gl.glGetIntegerv(33308, nArray4, 0);
                boolean bl3 = bl2 = nArray3[0] > nArray[0] || nArray3[0] == nArray[0] && nArray4[0] >= nArray2[0];
                if (!bl2) {
                    this.removeCachedVersion(nArray[0], nArray2[0], n);
                    this.destroyContextARBImpl(l2);
                    l2 = 0L;
                }
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: version verification - expected " + nArray[0] + "." + nArray2[0] + ", has " + nArray3[0] + "." + nArray4[0] + " == " + bl2);
                }
            }
            if (bl2 || GLContext.decrementGLVersion(nArray, nArray2)) continue;
            break;
        }
        return l2;
    }

    private final void setContextVersion(int n, int n2, int n3, boolean bl) {
        if (0 == n3) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        if (n > 0 || n2 > 0) {
            if (!GLContext.isValidGLVersion(n, n2)) {
                GLException gLException = new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
                throw gLException;
            }
            this.ctxMajorVersion = n;
            this.ctxMinorVersion = n2;
            this.ctxOptions = n3;
            if (bl) {
                this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, this.getGL().glGetString(7938));
            }
            return;
        }
        if (n == 0 && n2 == 0) {
            String string = this.getGL().glGetString(7938);
            if (null == string) {
                throw new GLException("GL_VERSION is NULL: " + this);
            }
            this.ctxOptions = n3;
            GLVersionNumber gLVersionNumber = new GLVersionNumber(string);
            if (gLVersionNumber.isValid()) {
                this.ctxMajorVersion = gLVersionNumber.getMajor();
                this.ctxMinorVersion = gLVersionNumber.getMinor();
                if ((this.ctxMajorVersion > 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion >= 1) && 0 == (this.ctxOptions & 1)) {
                    this.ctxMajorVersion = 3;
                    this.ctxMinorVersion = 0;
                }
                if (bl) {
                    this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, string);
                }
                return;
            }
        }
    }

    private Object createInstance(GLProfile gLProfile, String string, Class<?>[] classArray, Object[] objectArray) {
        return ReflectionUtil.createInstance((String)(gLProfile.getGLImplBaseClassName() + string), (Class[])classArray, (Object[])objectArray, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf((Object)object, (String)(gLProfile.getGLImplBaseClassName() + string));
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, "Impl", new Class[]{GLProfile.class, GLContextImpl.class}, new Object[]{gLProfile, this});
        return gL;
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    protected final String mapToRealGLFunctionName(String string) {
        String string2;
        Map<String, String> map = this.getFunctionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getFunctionNameMap();

    protected final String mapToRealGLExtensionName(String string) {
        String string2;
        Map<String, String> map = this.getExtensionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getExtensionNameMap();

    protected final void resetProcAddressTable(ProcAddressTable procAddressTable) {
        procAddressTable.reset((DynamicLookupHelper)this.getDrawableImpl().getGLDynamicLookupHelper());
    }

    private final void initGLRendererStrings() {
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        long l = gLDynamicLookupHelper.dynamicLookupFunction("glGetString");
        if (0L == l) {
            System.err.println("Warning: Entry point to 'glGetString' is NULL.");
            Thread.dumpStack();
        } else {
            String string = GLContextImpl.glGetStringInt(7937, l);
            if (null == string) {
                System.err.println("Warning: GL_RENDERER is NULL.");
                Thread.dumpStack();
            } else {
                this.glRenderer = string;
                this.glRendererLowerCase = this.glRenderer.toLowerCase();
            }
        }
    }

    protected final String getGLRendererString(boolean bl) {
        return bl ? this.glRendererLowerCase : this.glRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setGLFunctionAvailability(boolean bl, int n, int n2, int n3) {
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return;
        }
        if (null == this.gl || !this.verifyInstance(this.gl.getGLProfile(), "Impl", this.gl)) {
            this.setGL(this.createGL(this.getGLDrawable().getGLProfile()));
        }
        this.updateGLXProcAddressTable();
        this.initGLRendererStrings();
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x8000;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": Context FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null));
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = mappedGLProcAddress.get(this.contextFQN);
            if (null != procAddressTable && !this.verifyInstance(this.gl.getGLProfile(), "ProcAddressTable", procAddressTable)) {
                throw new InternalError("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null) + ") -> " + procAddressTable.getClass().getName() + " not matching " + this.gl.getGLProfile().getGLImplBaseClassName());
            }
        }
        if (null != procAddressTable) {
            this.glProcAddressTable = procAddressTable;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), "ProcAddressTable", new Class[]{FunctionAddressResolver.class}, new Object[]{new GLProcAddressResolver()});
            this.resetProcAddressTable(this.getGLProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLProcAddress.put(this.contextFQN, this.getGLProcAddressTable());
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.getGLProcAddressTable().hashCode()));
                }
            }
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object) {
            this.extensionAvailability = object;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object.hashCode()) + " - entries: " + ((ExtensionAvailabilityCache)object).getTotalExtensionCount());
            }
        } else {
            this.extensionAvailability = new ExtensionAvailabilityCache();
            this.setContextVersion(n, n2, n3, false);
            this.extensionAvailability.reset(this);
            object2 = mappedContextTypeObjectLock;
            synchronized (object2) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.extensionAvailability.hashCode()) + " - entries: " + this.extensionAvailability.getTotalExtensionCount());
                }
            }
        }
        if (this.isExtensionAvailable("GL_ARB_ES2_compatibility")) {
            n3 |= 0x100;
        }
        this.setContextVersion(n, n2, n3, true);
        this.setDefaultSwapInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeCachedVersion(int n, int n2, int n3) {
        Object object;
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x8000;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": RM Context FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null));
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.remove(this.contextFQN);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        }
        object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.remove(this.contextFQN);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        }
    }

    private final boolean isCurrentContextHardwareRasterizer() {
        boolean bl = true;
        bl = !this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? false : !this.glRendererLowerCase.contains("software") && !this.glRendererLowerCase.contains("mesa x11") && !this.glRendererLowerCase.contains("softpipe") && !this.glRendererLowerCase.contains("llvmpipe");
        return bl;
    }

    protected abstract void updateGLXProcAddressTable();

    protected abstract StringBuilder getPlatformExtensionsStringImpl();

    @Override
    public final boolean isFunctionAvailable(String string) {
        ProcAddressTable procAddressTable;
        if (null != this.glProcAddressTable) {
            try {
                if (0L != this.glProcAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        String string2 = GLExtensionNames.normalizeVEN(GLExtensionNames.normalizeARB(string, true), true);
        long l = 0L;
        int n = GLExtensionNames.getFuncNamePermutationNumber(string2);
        for (int i = 0; 0L == l && i < n; ++i) {
            String string3 = GLExtensionNames.getFuncNamePermutation(string2, i);
            try {
                l = gLDynamicLookupHelper.dynamicLookupFunction(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L != l;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    @Override
    public final int getPlatformExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getPlatformExtensionCount() : 0;
    }

    @Override
    public final String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    @Override
    public final int getGLExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getGLExtensionCount() : 0;
    }

    @Override
    public final String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.composeBits(n, n2, n3 &= 0xFFFFFEDF));
    }

    protected String getContextFQN() {
        return this.contextFQN;
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public abstract int getOffscreenContextPixelDataType();

    public void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }

    @Override
    public final String getGLDebugMessageExtension() {
        return this.glDebugHandler.getExtension();
    }

    @Override
    public final boolean isGLDebugMessageEnabled() {
        return this.glDebugHandler.isEnabled();
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setContextCreationFlags(int n) {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = n & 0x20;
        }
    }

    @Override
    public final boolean isGLDebugSynchronous() {
        return this.glDebugHandler.isSynchronous();
    }

    @Override
    public final void setGLDebugSynchronous(boolean bl) {
        this.glDebugHandler.setSynchronous(bl);
    }

    @Override
    public final void enableGLDebugMessage(boolean bl) throws GLException {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = bl ? (this.additionalCtxCreationFlags |= 0x20) : (this.additionalCtxCreationFlags &= 0xFFFFFFDF);
        } else if (0 != (this.additionalCtxCreationFlags & 0x20) && null != this.getGLDebugMessageExtension()) {
            this.glDebugHandler.enable(bl);
        }
    }

    @Override
    public final void addGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.addListener(gLDebugListener);
    }

    @Override
    public final void removeGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.removeListener(gLDebugListener);
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, IntBuffer intBuffer, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, intBuffer, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, intBuffer, bl);
        }
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, int[] nArray, int n5, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, nArray, n5, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, nArray, n5, bl);
        }
    }

    @Override
    public final void glDebugMessageInsert(int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6 = n5 = null != string ? string.length() : 0;
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageInsertARB(n, n2, n3, n4, n5, string);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageInsertAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n4, n3, n5, string);
        }
    }

    protected static native String glGetStringInt(int var0, long var1);
}

