/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ThreadingPlugin;

public class ThreadingImpl {
    protected static final boolean DEBUG = Debug.debug("Threading");
    private static boolean singleThreaded = true;
    private static Mode mode = Mode.MT;
    private static boolean hasAWT;
    private static boolean _isX11;
    private static final ThreadingPlugin threadingPlugin;

    private ThreadingImpl() {
    }

    public static boolean isX11() {
        return _isX11;
    }

    public static Mode getMode() {
        return mode;
    }

    public static void disableSingleThreading() {
        singleThreaded = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threading of javax.media.opengl implementation");
        }
    }

    public static boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static boolean isOpenGLThread() throws GLException {
        if (!ThreadingImpl.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (null != threadingPlugin) {
            return threadingPlugin.isOpenGLThread();
        }
        switch (mode) {
            case ST_AWT: {
                throw new InternalError();
            }
            case ST_WORKER: {
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + (Object)((Object)mode));
    }

    public static void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        if (!ThreadingImpl.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (ThreadingImpl.isOpenGLThread()) {
            throw new GLException("Should only call this from other threads than the OpenGL thread");
        }
        if (null != threadingPlugin) {
            threadingPlugin.invokeOnOpenGLThread(runnable);
            return;
        }
        switch (mode) {
            case ST_AWT: {
                throw new InternalError();
            }
            case ST_WORKER: {
                GLWorkerThread.start();
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + (Object)((Object)mode));
            }
        }
    }

    public static boolean isAWTMode() {
        return mode == Mode.ST_AWT;
    }

    static {
        threadingPlugin = AccessController.doPrivileged(new PrivilegedAction<ThreadingPlugin>(){

            @Override
            public ThreadingPlugin run() {
                Object object = Debug.getProperty("jogl.1thread", true);
                String string = null != object ? ((String)object).toLowerCase() : null;
                object = ThreadingImpl.class.getClassLoader();
                hasAWT = GLProfile.isAWTAvailable();
                String string2 = NativeWindowFactory.getNativeWindowType(false);
                _isX11 = "X11".equals(string2);
                ThreadingImpl.mode = hasAWT ? Mode.ST_AWT : Mode.ST_WORKER;
                if (string != null && !string.equals("true") && !string.equals("auto")) {
                    if (string.equals("worker")) {
                        singleThreaded = true;
                        ThreadingImpl.mode = Mode.ST_WORKER;
                    } else if (hasAWT && string.equals("awt")) {
                        singleThreaded = true;
                        ThreadingImpl.mode = Mode.ST_AWT;
                    } else {
                        singleThreaded = false;
                        ThreadingImpl.mode = Mode.MT;
                    }
                }
                ThreadingPlugin threadingPlugin = null;
                if (Mode.ST_AWT == mode) {
                    JogampRuntimeException jogampRuntimeException = null;
                    try {
                        threadingPlugin = (ThreadingPlugin)ReflectionUtil.createInstance((String)"jogamp.opengl.awt.AWTThreadingPlugin", (ClassLoader)object);
                    }
                    catch (JogampRuntimeException jogampRuntimeException2) {
                        jogampRuntimeException = jogampRuntimeException2;
                    }
                    if (null == threadingPlugin) {
                        throw new GLException("Mode is AWT, but class 'jogamp.opengl.awt.AWTThreadingPlugin' is not available", jogampRuntimeException);
                    }
                }
                if (DEBUG) {
                    System.err.println("Threading: jogl.1thread " + string + ", singleThreaded " + singleThreaded + ", hasAWT " + hasAWT + ", mode " + (Object)((Object)mode) + ", plugin " + threadingPlugin);
                }
                return threadingPlugin;
            }
        });
    }

    public static enum Mode {
        MT(0),
        ST_AWT(1),
        ST_WORKER(2);

        public final int id;

        private Mode(int n2) {
            this.id = n2;
        }
    }
}

