/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;

public class Table
implements Iterable<Row> {
    protected int rowCount;
    protected boolean commaSeparatedValues = false;
    protected boolean awfulCSV = false;
    protected String missingString = null;
    protected int missingInt = 0;
    protected long missingLong = 0L;
    protected float missingFloat = Float.NaN;
    protected double missingDouble = Double.NaN;
    protected int missingCategory = -1;
    String[] columnTitles;
    HashMapBlows[] columnCategories;
    HashMap<String, Integer> columnIndices;
    protected Object[] columns = new Object[0];
    static final int STRING = 0;
    static final int INT = 1;
    static final int LONG = 2;
    static final int FLOAT = 3;
    static final int DOUBLE = 4;
    static final int CATEGORICAL = 5;
    int[] columnTypes = new int[0];
    protected RowIterator rowIterator;

    public Table() {
        this.columnCategories = new HashMapBlows[0];
    }

    public Table(File file) {
        this(PApplet.createReader(file));
    }

    public Table(PApplet parent, String filename) {
        this(parent.createReader(filename));
    }

    public Table(BufferedReader reader) {
        this.columnCategories = new HashMapBlows[0];
        try {
            boolean csv = this.peekCSV(reader);
            if (csv) {
                this.parseCSV(reader);
            } else {
                this.parseTSV(reader);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Table(ResultSet rs) {
        this();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.setColumnCount(columnCount);
            int col = 0;
            while (col < columnCount) {
                this.setColumnTitle(col, rsmd.getColumnName(col + 1));
                int type = rsmd.getColumnType(col + 1);
                switch (type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.setColumnType(col, 1);
                        break;
                    }
                    case -5: {
                        this.setColumnType(col, 2);
                        break;
                    }
                    case 6: {
                        this.setColumnType(col, 3);
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        this.setColumnType(col, 4);
                    }
                }
                ++col;
            }
            int row = 0;
            while (rs.next()) {
                int col2 = 0;
                while (col2 < columnCount) {
                    switch (this.columnTypes[col2]) {
                        case 0: {
                            this.setString(row, col2, rs.getString(col2 + 1));
                            break;
                        }
                        case 1: {
                            this.setInt(row, col2, rs.getInt(col2 + 1));
                            break;
                        }
                        case 2: {
                            this.setLong(row, col2, rs.getLong(col2 + 1));
                            break;
                        }
                        case 3: {
                            this.setFloat(row, col2, rs.getFloat(col2 + 1));
                            break;
                        }
                        case 4: {
                            this.setDouble(row, col2, rs.getDouble(col2 + 1));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("column type " + this.columnTypes[col2] + " not supported.");
                        }
                    }
                    ++col2;
                }
                ++row;
            }
        }
        catch (SQLException s) {
            throw new RuntimeException(s);
        }
    }

    protected boolean peekCSV(BufferedReader reader) throws IOException {
        char[] buffer = new char[100];
        int remaining = buffer.length;
        reader.mark(remaining);
        int commas = 0;
        int tabs = 0;
        int i = 0;
        while (i < remaining) {
            int c = reader.read();
            if (c == -1) break;
            if (c == 44) {
                ++commas;
            }
            if (c == 9) {
                ++tabs;
            }
            ++i;
        }
        reader.reset();
        return commas > tabs;
    }

    public void parse(BufferedReader reader) throws IOException {
        if (this.commaSeparatedValues) {
            if (this.awfulCSV) {
                this.parseAwfulCSV(reader);
            } else {
                this.parseCSV(reader);
            }
        } else {
            this.parseTSV(reader);
        }
    }

    public void parseTSV(BufferedReader reader) throws IOException {
        this.parseBasic(reader, true);
    }

    public void parseCSV(BufferedReader reader) throws IOException {
        this.parseBasic(reader, false);
    }

    protected void parseBasic(BufferedReader reader, boolean tsv) throws IOException {
        String line = null;
        int row = 0;
        if (this.rowCount == 0) {
            this.setRowCount(10);
        }
        int prev = 0;
        while ((line = reader.readLine()) != null) {
            int pct;
            if (row == this.getRowCount()) {
                this.setRowCount(row << 1);
            }
            this.setRow(row, tsv ? PApplet.split(line, '\t') : Table.splitLineCSV(line));
            if (++row % 10000 != 0) continue;
            if (row < this.rowCount && (pct = 100 * row / this.rowCount) != prev) {
                System.out.println(String.valueOf(pct) + "%");
                prev = pct;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (row != this.getRowCount()) {
            this.setRowCount(row);
        }
    }

    public void convertTSV(BufferedReader reader, File outputFile) throws IOException {
        this.convertBasic(reader, true, outputFile);
    }

    protected void convertBasic(BufferedReader reader, boolean tsv, File outputFile) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
        DataOutputStream output = new DataOutputStream(bos);
        output.writeInt(0);
        output.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            output.writeBoolean(true);
            objectArray = this.columnTitles;
            n2 = this.columnTitles.length;
            n = 0;
            while (n < n2) {
                String title = objectArray[n];
                output.writeUTF(title);
                ++n;
            }
        } else {
            output.writeBoolean(false);
        }
        objectArray = this.columnTypes;
        n2 = this.columnTypes.length;
        n = 0;
        while (n < n2) {
            String type = objectArray[n];
            output.writeInt((int)type);
            ++n;
        }
        String line = null;
        int prev = -1;
        int row = 0;
        while ((line = reader.readLine()) != null) {
            int pct;
            this.convertRow(output, tsv ? PApplet.split(line, '\t') : Table.splitLineCSV(line));
            if (++row % 10000 != 0 || row >= this.rowCount || (pct = 100 * row / this.rowCount) == prev) continue;
            System.out.println(String.valueOf(pct) + "%");
            prev = pct;
        }
        int col = 0;
        HashMapBlows[] hashMapBlowsArray = this.columnCategories;
        int n3 = this.columnCategories.length;
        int n4 = 0;
        while (n4 < n3) {
            HashMapBlows hmb = hashMapBlowsArray[n4];
            if (hmb == null) {
                output.writeInt(0);
            } else {
                hmb.write(output);
                hmb.writeln(PApplet.createWriter(new File(String.valueOf(this.columnTitles[col]) + ".categories")));
            }
            ++col;
            ++n4;
        }
        output.flush();
        output.close();
        RandomAccessFile raf = new RandomAccessFile(outputFile, "rw");
        raf.writeInt(this.rowCount);
        raf.close();
    }

    public void parseAwfulCSV(BufferedReader reader) throws IOException {
        int ch;
        char[] c = new char[100];
        int count = 0;
        boolean insideQuote = false;
        int row = 0;
        int col = 0;
        while ((ch = reader.read()) != -1) {
            if (insideQuote) {
                if (ch == 34) {
                    reader.mark(1);
                    if (reader.read() == 34) {
                        if (count == c.length) {
                            c = PApplet.expand(c);
                        }
                        c[count++] = 34;
                        continue;
                    }
                    reader.reset();
                    insideQuote = false;
                    continue;
                }
                if (count == c.length) {
                    c = PApplet.expand(c);
                }
                c[count++] = (char)ch;
                continue;
            }
            if (ch == 34) {
                insideQuote = true;
                continue;
            }
            if (ch == 13) {
                reader.mark(1);
                if (reader.read() != 10) {
                    reader.reset();
                }
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                ++row;
                col = 0;
                continue;
            }
            if (ch == 10) {
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                ++row;
                col = 0;
                continue;
            }
            if (ch == 44) {
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                this.checkColumn(++col);
                continue;
            }
            if (count == c.length) {
                c = PApplet.expand(c);
            }
            c[count++] = (char)ch;
        }
        if (count > 0) {
            this.setString(row, col, new String(c, 0, count));
        }
    }

    protected String[] splitLine(String line) {
        return this.commaSeparatedValues ? Table.splitLineCSV(line) : PApplet.split(line, '\t');
    }

    public static String[] splitLineCSV(String line) {
        char[] c = line.toCharArray();
        int rough = 1;
        boolean quote = false;
        int i = 0;
        while (i < c.length) {
            if (!quote && c[i] == ',') {
                ++rough;
            } else if (c[i] == '\"') {
                quote = !quote;
            }
            ++i;
        }
        String[] pieces = new String[rough];
        int pieceCount = 0;
        int offset = 0;
        while (offset < c.length) {
            int start = offset;
            int stop = Table.nextComma(c, offset);
            offset = stop + 1;
            if (c[start] == '\"' && c[stop - 1] == '\"') {
                --stop;
            }
            int i2 = ++start;
            int ii = start;
            while (i2 < stop) {
                if (c[i2] == '\"') {
                    ++i2;
                }
                if (i2 != ii) {
                    c[ii] = c[i2];
                }
                ++i2;
                ++ii;
            }
            String s = new String(c, start, ii - start);
            pieces[pieceCount++] = s;
        }
        int i3 = pieceCount;
        while (i3 < pieces.length) {
            pieces[i3] = "";
            ++i3;
        }
        return pieces;
    }

    static int nextComma(char[] c, int index) {
        boolean quote = false;
        int i = index;
        while (i < c.length) {
            if (!quote && c[i] == ',') {
                return i;
            }
            if (c[i] == '\"') {
                quote = !quote;
            }
            ++i;
        }
        return c.length;
    }

    public void writeTSV(PrintWriter writer) {
        if (this.columnTitles != null) {
            int col = 0;
            while (col < this.columns.length) {
                if (col != 0) {
                    writer.print('\t');
                }
                if (this.columnTitles[col] != null) {
                    writer.print(this.columnTitles[col]);
                }
                ++col;
            }
            writer.println();
        }
        int row = 0;
        while (row < this.rowCount) {
            int col = 0;
            while (col < this.getColumnCount()) {
                String entry;
                if (col != 0) {
                    writer.print('\t');
                }
                if ((entry = this.getString(row, col)) != null) {
                    writer.print(entry);
                }
                ++col;
            }
            writer.println();
            ++row;
        }
        writer.flush();
    }

    public void writeCSV(PrintWriter writer) {
        if (this.columnTitles != null) {
            int col = 0;
            while (col < this.columns.length) {
                if (col != 0) {
                    writer.print(',');
                }
                if (this.columnTitles[col] != null) {
                    this.writeEntryCSV(writer, this.columnTitles[col]);
                }
                ++col;
            }
            writer.println();
        }
        int row = 0;
        while (row < this.rowCount) {
            int col = 0;
            while (col < this.getColumnCount()) {
                String entry;
                if (col != 0) {
                    writer.print(',');
                }
                if ((entry = this.getString(row, col)) != null) {
                    this.writeEntryCSV(writer, entry);
                }
                ++col;
            }
            writer.println();
            ++row;
        }
        writer.flush();
    }

    protected void writeEntryCSV(PrintWriter writer, String entry) {
        if (entry != null) {
            if (entry.indexOf(34) != -1) {
                char[] c = entry.toCharArray();
                writer.print('\"');
                int i = 0;
                while (i < c.length) {
                    if (c[i] == '\"') {
                        writer.print("\"\"");
                    } else {
                        writer.print(c[i]);
                    }
                    ++i;
                }
                writer.print('\"');
            } else if (entry.indexOf(44) != -1 || entry.indexOf(10) != -1 || entry.indexOf(13) != -1) {
                writer.print('\"');
                writer.print(entry);
                writer.print('\"');
            } else if (entry.length() > 0 && (entry.charAt(0) == ' ' || entry.charAt(entry.length() - 1) == ' ')) {
                writer.print('\"');
                writer.print(entry);
                writer.print('\"');
            } else {
                writer.print(entry);
            }
        }
    }

    public void writeHTML(PrintWriter writer) {
        writer.println("<table>");
        int row = 0;
        while (row < this.getRowCount()) {
            writer.println("  <tr>");
            int col = 0;
            while (col < this.getColumnCount()) {
                String entry = this.getString(row, col);
                writer.print("    <td>");
                this.writeEntryHTML(writer, entry);
                writer.println("</td>");
                ++col;
            }
            writer.println("  </tr>");
            ++row;
        }
        writer.println("</table>");
        writer.flush();
    }

    protected void writeEntryHTML(PrintWriter writer, String entry) {
        char[] cArray = entry.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < ' ' || c > '\u007f') {
                writer.print("&#");
                writer.print((int)c);
                writer.print(';');
            } else {
                writer.print(c);
            }
            ++n2;
        }
    }

    public boolean writeCSV(File file) {
        try {
            this.writeCSV(new PrintWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean writeTSV(File file) {
        try {
            this.writeTSV(new PrintWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void addColumn() {
        this.addColumn(null, 0);
    }

    public void addColumn(String title) {
        this.addColumn(title, 0);
    }

    public void addColumn(String title, int type) {
        this.insertColumn(this.columns.length, title, type);
    }

    public void insertColumn(int index) {
        this.insertColumn(index, null, 0);
    }

    public void insertColumn(int index, String title) {
        this.insertColumn(index, title, 0);
    }

    public void insertColumn(int index, String title, int type) {
        if (title != null && this.columnTitles == null) {
            this.columnTitles = new String[this.columns.length];
        }
        if (this.columnTitles != null) {
            this.columnTitles = PApplet.splice(this.columnTitles, title, index);
            this.columnIndices = null;
        }
        this.columnTypes = PApplet.splice(this.columnTypes, type, index);
        HashMapBlows[] catTemp = new HashMapBlows[this.columns.length + 1];
        int i = 0;
        while (i < index) {
            catTemp[i] = this.columnCategories[i];
            ++i;
        }
        catTemp[index] = new HashMapBlows();
        i = index;
        while (i < this.columns.length) {
            catTemp[i + 1] = this.columnCategories[i];
            ++i;
        }
        this.columnCategories = catTemp;
        Object[] temp = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, temp, 0, index);
        System.arraycopy(this.columns, index, temp, index + 1, this.columns.length - index);
        this.columns = temp;
        switch (type) {
            case 1: {
                this.columns[index] = new int[this.rowCount];
                break;
            }
            case 2: {
                this.columns[index] = new long[this.rowCount];
                break;
            }
            case 3: {
                this.columns[index] = new float[this.rowCount];
                break;
            }
            case 4: {
                this.columns[index] = new double[this.rowCount];
                break;
            }
            case 0: {
                this.columns[index] = new String[this.rowCount];
                break;
            }
            case 5: {
                this.columns[index] = new int[this.rowCount];
            }
        }
    }

    public void removeColumn(String dead) {
        this.removeColumn(this.getColumnIndex(dead));
    }

    public void removeColumn(int index) {
        Object[] temp = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, temp, 0, index);
        System.arraycopy(this.columns, index + 1, temp, index, this.columns.length - index + 1);
        this.columns = temp;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public void setColumnCount(int newCount) {
        int oldCount = this.columns.length;
        if (oldCount != newCount) {
            this.columns = (Object[])PApplet.expand(this.columns, newCount);
            int c = oldCount;
            while (c < newCount) {
                this.columns[c] = new String[this.rowCount];
                ++c;
            }
            if (this.columnTitles != null) {
                this.columnTitles = PApplet.expand(this.columnTitles, newCount);
            }
            this.columnTypes = PApplet.expand(this.columnTypes, newCount);
            this.columnCategories = (HashMapBlows[])PApplet.expand(this.columnCategories, newCount);
        }
    }

    public void setColumnType(String columnName, String columnType) {
        this.setColumnType(this.getColumnIndex(columnName), columnType);
    }

    public void setColumnType(int column, String columnType) {
        int type = -1;
        if (columnType.equals("String")) {
            type = 0;
        } else if (columnType.equals("int")) {
            type = 1;
        } else if (columnType.equals("long")) {
            type = 2;
        } else if (columnType.equals("float")) {
            type = 3;
        } else if (columnType.equals("double")) {
            type = 4;
        } else if (columnType.equals("categorical")) {
            type = 5;
        } else {
            throw new IllegalArgumentException("'" + columnType + "' is not a valid column type.");
        }
        this.setColumnType(column, type);
    }

    protected void setColumnType(String columnName, int newType) {
        this.setColumnType(this.getColumnIndex(columnName), newType);
    }

    protected void setColumnType(int column, int newType) {
        switch (newType) {
            case 1: {
                int[] intData = new int[this.rowCount];
                int row = 0;
                while (row < this.rowCount) {
                    String s = this.getString(row, column);
                    intData[row] = PApplet.parseInt(s, this.missingInt);
                    ++row;
                }
                this.columns[column] = intData;
                break;
            }
            case 2: {
                long[] longData = new long[this.rowCount];
                int row = 0;
                while (row < this.rowCount) {
                    String s = this.getString(row, column);
                    try {
                        longData[row] = Long.parseLong(s);
                    }
                    catch (NumberFormatException nfe) {
                        longData[row] = this.missingLong;
                    }
                    ++row;
                }
                this.columns[column] = longData;
                break;
            }
            case 3: {
                float[] floatData = new float[this.rowCount];
                int row = 0;
                while (row < this.rowCount) {
                    String s = this.getString(row, column);
                    floatData[row] = PApplet.parseFloat(s, this.missingFloat);
                    ++row;
                }
                this.columns[column] = floatData;
                break;
            }
            case 4: {
                double[] doubleData = new double[this.rowCount];
                int row = 0;
                while (row < this.rowCount) {
                    String s = this.getString(row, column);
                    try {
                        doubleData[row] = Double.parseDouble(s);
                    }
                    catch (NumberFormatException nfe) {
                        doubleData[row] = this.missingDouble;
                    }
                    ++row;
                }
                this.columns[column] = doubleData;
                break;
            }
            case 0: {
                if (this.columnTypes[column] == 0) break;
                String[] stringData = new String[this.rowCount];
                int row = 0;
                while (row < this.rowCount) {
                    stringData[row] = this.getString(row, column);
                    ++row;
                }
                this.columns[column] = stringData;
                break;
            }
            case 5: {
                int[] indexData = new int[this.rowCount];
                HashMapBlows categories = new HashMapBlows();
                int row = 0;
                while (row < this.rowCount) {
                    String s = this.getString(row, column);
                    indexData[row] = categories.index(s);
                    ++row;
                }
                this.columnCategories[column] = categories;
                this.columns[column] = indexData;
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
        this.columnTypes[column] = newType;
    }

    public void setTableType(String type) {
        int col = 0;
        while (col < this.columns.length) {
            this.setColumnType(col, type);
            ++col;
        }
    }

    public void setColumnTypes(Table dictionary) {
        this.setColumnTitles(dictionary.getStringColumn(0));
        if (dictionary.getColumnCount() > 1) {
            int i = 0;
            while (i < dictionary.getRowCount()) {
                this.setColumnType(i, dictionary.getString(i, 1));
                ++i;
            }
        }
    }

    public String[] removeTitleRow() {
        String[] titles = this.getStringRow(0);
        this.removeRow(0);
        this.setColumnTitles(titles);
        return titles;
    }

    public void setColumnTitles(String[] titles) {
        if (titles != null) {
            this.checkColumn(titles.length - 1);
        }
        this.columnTitles = titles;
        this.columnIndices = null;
    }

    public void setColumnTitle(int column, String title) {
        this.checkColumn(column);
        if (this.columnTitles == null) {
            this.columnTitles = new String[this.getColumnCount()];
        }
        this.columnTitles[column] = title;
        this.columnIndices = null;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String getColumnTitle(int col) {
        return this.columnTitles == null ? null : this.columnTitles[col];
    }

    public int getColumnIndex(String name) {
        return this.getColumnIndex(name, true);
    }

    protected int getColumnIndex(String name, boolean report) {
        Integer index;
        if (this.columnTitles == null) {
            System.err.println("Can't get column indices because no column titles are set.");
            return -1;
        }
        if (this.columnIndices == null) {
            this.columnIndices = new HashMap();
            int col = 0;
            while (col < this.columns.length) {
                this.columnIndices.put(this.columnTitles[col], col);
                ++col;
            }
        }
        if ((index = this.columnIndices.get(name)) == null) {
            if (report) {
                System.err.println("No column named '" + name + "' was found.");
            }
            return -1;
        }
        return index;
    }

    public int checkColumnIndex(String title) {
        int index = this.getColumnIndex(title, false);
        if (index != -1) {
            return index;
        }
        this.addColumn(title);
        return this.getColumnCount() - 1;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int newCount) {
        if (newCount != this.rowCount) {
            if (newCount > 1000000) {
                System.out.println("setting row count to " + PApplet.nfc(newCount));
            }
            long t = System.currentTimeMillis();
            int col = 0;
            while (col < this.columns.length) {
                switch (this.columnTypes[col]) {
                    case 1: {
                        this.columns[col] = PApplet.expand((int[])this.columns[col], newCount);
                        break;
                    }
                    case 2: {
                        this.columns[col] = PApplet.expand((long[])this.columns[col], newCount);
                        break;
                    }
                    case 3: {
                        this.columns[col] = PApplet.expand((float[])this.columns[col], newCount);
                        break;
                    }
                    case 4: {
                        this.columns[col] = PApplet.expand((double[])this.columns[col], newCount);
                        break;
                    }
                    case 0: {
                        this.columns[col] = PApplet.expand((String[])this.columns[col], newCount);
                        break;
                    }
                    case 5: {
                        this.columns[col] = PApplet.expand((int[])this.columns[col], newCount);
                    }
                }
                if (newCount > 1000000) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ++col;
            }
            if (newCount > 1000000) {
                int ms = (int)(System.currentTimeMillis() - t);
                System.out.println("  resize took " + PApplet.nfc(ms) + " ms");
            }
        }
        this.rowCount = newCount;
    }

    public void addRow() {
        this.setRowCount(this.rowCount + 1);
    }

    public void addRow(String[] columns) {
        this.setRow(this.getRowCount(), columns);
    }

    public void insertRow(int insert, String[] data) {
        int col = 0;
        while (col < this.columns.length) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    int[] intTemp = new int[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, intTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, intTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = intTemp;
                    break;
                }
                case 2: {
                    long[] longTemp = new long[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, longTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, longTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = longTemp;
                    break;
                }
                case 3: {
                    float[] floatTemp = new float[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, floatTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, floatTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = floatTemp;
                    break;
                }
                case 4: {
                    double[] doubleTemp = new double[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, doubleTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, doubleTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = doubleTemp;
                    break;
                }
                case 0: {
                    String[] stringTemp = new String[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, stringTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, stringTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = stringTemp;
                }
            }
            ++col;
        }
        this.setRow(insert, data);
        ++this.rowCount;
    }

    public void removeRow(int dead) {
        int col = 0;
        while (col < this.columns.length) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    int[] intTemp = new int[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, intTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, intTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = intTemp;
                    break;
                }
                case 2: {
                    long[] longTemp = new long[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, longTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, longTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = longTemp;
                    break;
                }
                case 3: {
                    float[] floatTemp = new float[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, floatTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, floatTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = floatTemp;
                    break;
                }
                case 4: {
                    double[] doubleTemp = new double[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, doubleTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, doubleTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = doubleTemp;
                    break;
                }
                case 0: {
                    String[] stringTemp = new String[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, stringTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, stringTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = stringTemp;
                }
            }
            ++col;
        }
        --this.rowCount;
    }

    public void setRow(int row, String[] pieces) {
        this.checkSize(row, pieces.length - 1);
        int col = 0;
        while (col < pieces.length) {
            this.setRowCol(row, col, pieces[col]);
            ++col;
        }
    }

    protected void setRowCol(int row, int col, String piece) {
        switch (this.columnTypes[col]) {
            case 0: {
                String[] stringData = (String[])this.columns[col];
                stringData[row] = piece;
                break;
            }
            case 1: {
                int[] intData = (int[])this.columns[col];
                intData[row] = PApplet.parseInt(piece, this.missingInt);
                break;
            }
            case 2: {
                long[] longData = (long[])this.columns[col];
                try {
                    longData[row] = Long.parseLong(piece);
                }
                catch (NumberFormatException nfe) {
                    longData[row] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] floatData = (float[])this.columns[col];
                floatData[row] = PApplet.parseFloat(piece, this.missingFloat);
                break;
            }
            case 4: {
                double[] doubleData = (double[])this.columns[col];
                try {
                    doubleData[row] = Double.parseDouble(piece);
                }
                catch (NumberFormatException nfe) {
                    doubleData[row] = this.missingDouble;
                }
                break;
            }
            case 5: {
                int[] indexData = (int[])this.columns[col];
                indexData[row] = this.columnCategories[col].index(piece);
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    public void convertRow(DataOutputStream output, String[] pieces) throws IOException {
        if (pieces.length > this.getColumnCount()) {
            throw new IllegalArgumentException("Row with too many columns: " + PApplet.join(pieces, ","));
        }
        int col = 0;
        while (col < pieces.length) {
            switch (this.columnTypes[col]) {
                case 0: {
                    output.writeUTF(pieces[col]);
                    break;
                }
                case 1: {
                    output.writeInt(PApplet.parseInt(pieces[col], this.missingInt));
                    break;
                }
                case 2: {
                    try {
                        output.writeLong(Long.parseLong(pieces[col]));
                    }
                    catch (NumberFormatException nfe) {
                        output.writeLong(this.missingLong);
                    }
                    break;
                }
                case 3: {
                    output.writeFloat(PApplet.parseFloat(pieces[col], this.missingFloat));
                    break;
                }
                case 4: {
                    try {
                        output.writeDouble(Double.parseDouble(pieces[col]));
                    }
                    catch (NumberFormatException nfe) {
                        output.writeDouble(this.missingDouble);
                    }
                    break;
                }
                case 5: {
                    output.writeInt(this.columnCategories[col].index(pieces[col]));
                }
            }
            ++col;
        }
        col = pieces.length;
        while (col < this.getColumnCount()) {
            switch (this.columnTypes[col]) {
                case 0: {
                    output.writeUTF("");
                    break;
                }
                case 1: {
                    output.writeInt(this.missingInt);
                    break;
                }
                case 2: {
                    output.writeLong(this.missingLong);
                    break;
                }
                case 3: {
                    output.writeFloat(this.missingFloat);
                    break;
                }
                case 4: {
                    output.writeDouble(this.missingDouble);
                    break;
                }
                case 5: {
                    output.writeInt(this.missingCategory);
                }
            }
            ++col;
        }
    }

    protected void convertRowCol(DataOutputStream output, int row, int col, String piece) {
        switch (this.columnTypes[col]) {
            case 0: {
                String[] stringData = (String[])this.columns[col];
                stringData[row] = piece;
                break;
            }
            case 1: {
                int[] intData = (int[])this.columns[col];
                intData[row] = PApplet.parseInt(piece, this.missingInt);
                break;
            }
            case 2: {
                long[] longData = (long[])this.columns[col];
                try {
                    longData[row] = Long.parseLong(piece);
                }
                catch (NumberFormatException nfe) {
                    longData[row] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] floatData = (float[])this.columns[col];
                floatData[row] = PApplet.parseFloat(piece, this.missingFloat);
                break;
            }
            case 4: {
                double[] doubleData = (double[])this.columns[col];
                try {
                    doubleData[row] = Double.parseDouble(piece);
                }
                catch (NumberFormatException nfe) {
                    doubleData[row] = this.missingDouble;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    @Override
    public Iterator<Row> iterator() {
        if (this.rowIterator == null) {
            this.rowIterator = new RowIterator();
        }
        this.rowIterator.reset();
        return this.rowIterator;
    }

    public Iterator<Row> createIterator() {
        return new RowIterator();
    }

    public static Iterator<Row> createIterator(final ResultSet rs) {
        return new Iterator<Row>(){
            boolean already;

            @Override
            public boolean hasNext() {
                this.already = true;
                try {
                    return rs.next();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Row next() {
                if (!this.already) {
                    try {
                        rs.next();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.already = false;
                }
                return new Row(){

                    @Override
                    public double getDouble(int column) {
                        try {
                            return rs.getDouble(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public double getDouble(String columnName) {
                        try {
                            return rs.getDouble(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public float getFloat(int column) {
                        try {
                            return rs.getFloat(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public float getFloat(String columnName) {
                        try {
                            return rs.getFloat(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public int getInt(int column) {
                        try {
                            return rs.getInt(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public int getInt(String columnName) {
                        try {
                            return rs.getInt(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public long getLong(int column) {
                        try {
                            return rs.getLong(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public long getLong(String columnName) {
                        try {
                            return rs.getLong(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public String getString(int column) {
                        try {
                            return rs.getString(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public String getString(String columnName) {
                        try {
                            return rs.getString(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("remove() not supported");
            }
        };
    }

    public int getInt(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 1) {
            int[] intData = (int[])this.columns[column];
            return intData[row];
        }
        String str = this.getString(row, column);
        return str == null || str.equals(this.missingString) ? this.missingInt : PApplet.parseInt(str, this.missingInt);
    }

    public int getInt(int row, String columnName) {
        return this.getInt(row, this.getColumnIndex(columnName));
    }

    public void setMissingInt(int value) {
        this.missingInt = value;
    }

    public void setInt(int row, int column, int what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 1) {
                throw new IllegalArgumentException("Column " + column + " is not an int column.");
            }
            int[] intData = (int[])this.columns[column];
            intData[row] = what;
        }
    }

    public int[] getIntColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getIntColumn(col);
    }

    public int[] getIntColumn(int col) {
        int[] outgoing = new int[this.rowCount];
        int row = 0;
        while (row < this.rowCount) {
            outgoing[row] = this.getInt(row, col);
            ++row;
        }
        return outgoing;
    }

    public int[] getIntRow(int row) {
        int[] outgoing = new int[this.columns.length];
        int col = 0;
        while (col < this.columns.length) {
            outgoing[col] = this.getInt(row, col);
            ++col;
        }
        return outgoing;
    }

    public long getLong(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 2) {
            long[] longData = (long[])this.columns[column];
            return longData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingLong;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return this.missingLong;
        }
    }

    public long getLong(int row, String columnName) {
        return this.getLong(row, this.getColumnIndex(columnName));
    }

    public void setMissingLong(long value) {
        this.missingLong = value;
    }

    public void setLong(int row, int column, long what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 2) {
                throw new IllegalArgumentException("Column " + column + " is not a 'long' column.");
            }
            long[] longData = (long[])this.columns[column];
            longData[row] = what;
        }
    }

    public long[] getLongColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getLongColumn(col);
    }

    public long[] getLongColumn(int col) {
        long[] outgoing = new long[this.rowCount];
        int row = 0;
        while (row < this.rowCount) {
            outgoing[row] = this.getLong(row, col);
            ++row;
        }
        return outgoing;
    }

    public long[] getLongRow(int row) {
        long[] outgoing = new long[this.columns.length];
        int col = 0;
        while (col < this.columns.length) {
            outgoing[col] = this.getLong(row, col);
            ++col;
        }
        return outgoing;
    }

    public float getFloat(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 3) {
            float[] floatData = (float[])this.columns[column];
            return floatData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingFloat;
        }
        return PApplet.parseFloat(str, this.missingFloat);
    }

    public float getFloat(int row, String columnName) {
        return this.getFloat(row, this.getColumnIndex(columnName));
    }

    public void setMissingFloat(float value) {
        this.missingFloat = value;
    }

    public void setFloat(int row, int column, float what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 3) {
                throw new IllegalArgumentException("Column " + column + " is not a float column.");
            }
            float[] longData = (float[])this.columns[column];
            longData[row] = what;
        }
    }

    public float[] getFloatColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getFloatColumn(col);
    }

    public float[] getFloatColumn(int col) {
        float[] outgoing = new float[this.rowCount];
        int row = 0;
        while (row < this.rowCount) {
            outgoing[row] = this.getFloat(row, col);
            ++row;
        }
        return outgoing;
    }

    public float[] getFloatRow(int row) {
        float[] outgoing = new float[this.columns.length];
        int col = 0;
        while (col < this.columns.length) {
            outgoing[col] = this.getFloat(row, col);
            ++col;
        }
        return outgoing;
    }

    public double getDouble(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 4) {
            double[] doubleData = (double[])this.columns[column];
            return doubleData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingDouble;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return this.missingDouble;
        }
    }

    public double getDouble(int row, String columnName) {
        return this.getDouble(row, this.getColumnIndex(columnName));
    }

    public void setMissingDouble(double value) {
        this.missingDouble = value;
    }

    public void setDouble(int row, int column, double what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 4) {
                throw new IllegalArgumentException("Column " + column + " is not a 'double' column.");
            }
            double[] doubleData = (double[])this.columns[column];
            doubleData[row] = what;
        }
    }

    public double[] getDoubleColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getDoubleColumn(col);
    }

    public double[] getDoubleColumn(int col) {
        double[] outgoing = new double[this.rowCount];
        int row = 0;
        while (row < this.rowCount) {
            outgoing[row] = this.getDouble(row, col);
            ++row;
        }
        return outgoing;
    }

    public double[] getDoubleRow(int row) {
        double[] outgoing = new double[this.columns.length];
        int col = 0;
        while (col < this.columns.length) {
            outgoing[col] = this.getDouble(row, col);
            ++col;
        }
        return outgoing;
    }

    public String getString(int row, int col) {
        this.checkBounds(row, col);
        if (this.columnTypes[col] == 0) {
            String[] stringData = (String[])this.columns[col];
            return stringData[row];
        }
        if (this.columnTypes[col] == 5) {
            int index = this.getInt(row, col);
            return this.columnCategories[col].key(index);
        }
        return String.valueOf(Array.get(this.columns[col], row));
    }

    public String getString(int row, String columnName) {
        return this.getString(row, this.getColumnIndex(columnName));
    }

    public void setMissingString(String value) {
        this.missingString = value;
    }

    public void setString(int row, int column, String what) {
        this.checkSize(row, column);
        if (this.columnTypes[column] != 0) {
            throw new IllegalArgumentException("Column " + column + " is not a String column.");
        }
        String[] stringData = (String[])this.columns[column];
        stringData[row] = what;
    }

    public void setString(int row, String columnName, String what) {
        int column = this.getColumnIndex(columnName);
        this.setString(row, column, what);
    }

    public String[] getStringColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getStringColumn(col);
    }

    public String[] getStringColumn(int col) {
        String[] outgoing = new String[this.rowCount];
        int i = 0;
        while (i < this.rowCount) {
            outgoing[i] = this.getString(i, col);
            ++i;
        }
        return outgoing;
    }

    public String[] getStringRow(int row) {
        String[] outgoing = new String[this.columns.length];
        int col = 0;
        while (col < this.columns.length) {
            outgoing[col] = this.getString(row, col);
            ++col;
        }
        return outgoing;
    }

    public void makeNullEmpty() {
        int col = 0;
        while (col < this.columns.length) {
            if (this.columnTypes[col] == 0) {
                String[] stringData = (String[])this.columns[col];
                int row = 0;
                while (row < this.rowCount) {
                    if (stringData[row] == null) {
                        stringData[row] = "";
                    }
                    ++row;
                }
            }
            ++col;
        }
    }

    public void makeEmptyNull() {
        int col = 0;
        while (col < this.columns.length) {
            if (this.columnTypes[col] == 0) {
                String[] stringData = (String[])this.columns[col];
                int row = 0;
                while (row < this.rowCount) {
                    if (stringData[row] != null && stringData[row].length() == 0) {
                        stringData[row] = null;
                    }
                    ++row;
                }
            }
            ++col;
        }
    }

    public float getMaxFloat() {
        boolean found = false;
        float max = -3.4028235E38f;
        int row = 0;
        while (row < this.getRowCount()) {
            int col = 0;
            while (col < this.getColumnCount()) {
                float value = this.getFloat(row, col);
                if (!Float.isNaN(value)) {
                    if (!found) {
                        max = value;
                        found = true;
                    } else if (value > max) {
                        max = value;
                    }
                }
                ++col;
            }
            ++row;
        }
        return found ? max : this.missingFloat;
    }

    public void removeTokens(String tokens) {
        int col = 0;
        while (col < this.getColumnCount()) {
            this.removeTokens(tokens, col);
            ++col;
        }
    }

    public void removeTokens(String tokens, int column) {
        int row = 0;
        while (row < this.rowCount) {
            String s = this.getString(row, column);
            if (s != null) {
                char[] c = s.toCharArray();
                int index = 0;
                int j = 0;
                while (j < c.length) {
                    if (tokens.indexOf(c[j]) == -1) {
                        if (index != j) {
                            c[index] = c[j];
                        }
                        ++index;
                    }
                    ++j;
                }
                if (index != c.length) {
                    this.setString(row, column, new String(c, 0, index));
                }
            }
            ++row;
        }
    }

    public void removeTokens(String tokens, String column) {
        this.removeTokens(tokens, this.getColumnIndex(column));
    }

    public int findRow(String what, int column) {
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            if (what == null) {
                int row = 0;
                while (row < this.rowCount) {
                    if (stringData[row] == null) {
                        return row;
                    }
                    ++row;
                }
            } else {
                int row = 0;
                while (row < this.rowCount) {
                    if (stringData[row] != null && stringData[row].equals(what)) {
                        return row;
                    }
                    ++row;
                }
            }
        } else {
            int row = 0;
            while (row < this.rowCount) {
                String str = this.getString(row, column);
                if (str == null ? what == null : str.equals(what)) {
                    return row;
                }
                ++row;
            }
        }
        return -1;
    }

    public int findRow(String what, String columnName) {
        return this.findRow(what, this.getColumnIndex(columnName));
    }

    public int[] findRows(String what, int column) {
        int[] outgoing = new int[this.rowCount];
        int count = 0;
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            if (what == null) {
                int row = 0;
                while (row < this.rowCount) {
                    if (stringData[row] == null) {
                        outgoing[count++] = row;
                    }
                    ++row;
                }
            } else {
                int row = 0;
                while (row < this.rowCount) {
                    if (stringData[row] != null && stringData[row].equals(what)) {
                        outgoing[count++] = row;
                    }
                    ++row;
                }
            }
        } else {
            int row = 0;
            while (row < this.rowCount) {
                String str = this.getString(row, column);
                if (str == null) {
                    if (what == null) {
                        outgoing[count++] = row;
                    }
                } else if (str.equals(what)) {
                    outgoing[count++] = row;
                }
                ++row;
            }
        }
        return PApplet.subset(outgoing, 0, count);
    }

    public int[] findRows(String what, String columnName) {
        return this.findRows(what, this.getColumnIndex(columnName));
    }

    public int matchRow(String regexp, int column) {
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            int row = 0;
            while (row < this.rowCount) {
                if (stringData[row] != null && PApplet.match(stringData[row], regexp) != null) {
                    return row;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < this.rowCount) {
                String str = this.getString(row, column);
                if (str != null && PApplet.match(str, regexp) != null) {
                    return row;
                }
                ++row;
            }
        }
        return -1;
    }

    public int matchRow(String what, String columnName) {
        return this.matchRow(what, this.getColumnIndex(columnName));
    }

    public int[] matchRows(String regexp, int column) {
        int[] outgoing = new int[this.rowCount];
        int count = 0;
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            int row = 0;
            while (row < this.rowCount) {
                if (stringData[row] != null && PApplet.match(stringData[row], regexp) != null) {
                    outgoing[count++] = row;
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < this.rowCount) {
                String str = this.getString(row, column);
                if (str != null && PApplet.match(str, regexp) != null) {
                    outgoing[count++] = row;
                }
                ++row;
            }
        }
        return PApplet.subset(outgoing, 0, count);
    }

    public int[] matchRows(String what, String columnName) {
        return this.matchRows(what, this.getColumnIndex(columnName));
    }

    public void replaceAll(String regex, String replacement, int column) {
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            int row = 0;
            while (row < this.rowCount) {
                if (stringData[row] != null) {
                    stringData[row] = stringData[row].replaceAll(regex, replacement);
                }
                ++row;
            }
        } else {
            throw new IllegalArgumentException("replaceAll() can only be used on String columns");
        }
    }

    public void replaceAll(String regex, String replacement, String columnName) {
        this.replaceAll(regex, replacement, this.getColumnIndex(columnName));
    }

    protected void checkColumn(int col) {
        if (col >= this.columns.length) {
            this.setColumnCount(col + 1);
        }
    }

    protected void checkRow(int row) {
        if (row >= this.rowCount) {
            this.setRowCount(row + 1);
        }
    }

    protected void checkSize(int row, int col) {
        this.checkRow(row);
        this.checkColumn(col);
    }

    protected void checkBounds(int row, int column) {
        if (row < 0 || row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException("Row " + row + " does not exist.");
        }
        if (column < 0 || column >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException("Column " + column + " does not exist.");
        }
    }

    public Table createSubset(int[] rowSubset) {
        Table newbie = new Table();
        newbie.setColumnTitles(this.columnTitles);
        newbie.columnTypes = this.columnTypes;
        newbie.setRowCount(rowSubset.length);
        int i = 0;
        while (i < rowSubset.length) {
            int row = rowSubset[i];
            int col = 0;
            while (col < this.columns.length) {
                switch (this.columnTypes[col]) {
                    case 0: {
                        newbie.setString(i, col, this.getString(row, col));
                        break;
                    }
                    case 1: {
                        newbie.setInt(i, col, this.getInt(row, col));
                        break;
                    }
                    case 2: {
                        newbie.setLong(i, col, this.getLong(row, col));
                        break;
                    }
                    case 3: {
                        newbie.setFloat(i, col, this.getFloat(row, col));
                        break;
                    }
                    case 4: {
                        newbie.setDouble(i, col, this.getDouble(row, col));
                    }
                }
                ++col;
            }
            ++i;
        }
        return newbie;
    }

    public String[] getUniqueEntries(String column) {
        return this.getUniqueEntries(this.getColumnIndex(column));
    }

    public String[] getUniqueEntries(int column) {
        HashMapSucks found = new HashMapSucks();
        int row = 0;
        while (row < this.getRowCount()) {
            found.check(this.getString(row, column));
            ++row;
        }
        String[] outgoing = new String[found.size()];
        found.keySet().toArray(outgoing);
        return outgoing;
    }

    public HashMap<String, Integer> getStringCount(String columnName) {
        return this.getStringCount(this.getColumnIndex(columnName));
    }

    public HashMap<String, Integer> getStringCount(int column) {
        HashMapSucks outgoing = new HashMapSucks();
        int row = 0;
        while (row < this.rowCount) {
            String entry = this.getString(row, column);
            if (entry != null) {
                outgoing.increment(entry);
            }
            ++row;
        }
        return outgoing;
    }

    public HashMap<String, Integer> getRowLookup(int col) {
        HashMap<String, Integer> outgoing = new HashMap<String, Integer>();
        int row = 0;
        while (row < this.getRowCount()) {
            outgoing.put(this.getString(row, col), row);
            ++row;
        }
        return outgoing;
    }

    public void trim() {
        int col = 0;
        while (col < this.columns.length) {
            String[] stringData = (String[])this.columns[col];
            int row = 0;
            while (row < this.rowCount) {
                if (stringData[row] != null) {
                    stringData[row] = PApplet.trim(stringData[row]);
                }
                ++row;
            }
            ++col;
        }
    }

    class HashMapBlows {
        HashMap<String, Integer> dataToIndex = new HashMap();
        ArrayList<String> indexToData = new ArrayList();

        HashMapBlows() {
        }

        int index(String key) {
            Integer value = this.dataToIndex.get(key);
            if (value != null) {
                return value;
            }
            int v = this.dataToIndex.size();
            this.dataToIndex.put(key, v);
            this.indexToData.add(key);
            return v;
        }

        String key(int index) {
            return this.indexToData.get(index);
        }

        int size() {
            return this.dataToIndex.size();
        }

        void write(DataOutputStream output) throws IOException {
            output.writeInt(this.size());
            for (String str : this.indexToData) {
                output.writeUTF(str);
            }
        }

        void writeln(PrintWriter writer) throws IOException {
            for (String str : this.indexToData) {
                writer.println(str);
            }
            writer.flush();
            writer.close();
        }

        void read(DataInputStream input) throws IOException {
            int count = input.readInt();
            this.dataToIndex = new HashMap(count);
            int i = 0;
            while (i < count) {
                String str = input.readUTF();
                this.dataToIndex.put(str, i);
                this.indexToData.add(str);
                ++i;
            }
        }
    }

    class HashMapSucks
    extends HashMap<String, Integer> {
        HashMapSucks() {
        }

        void increment(String what) {
            Integer value = (Integer)this.get(what);
            if (value == null) {
                this.put(what, 1);
            } else {
                this.put(what, value + 1);
            }
        }

        void check(String what) {
            if (this.get(what) == null) {
                this.put(what, 0);
            }
        }
    }

    public static interface Row {
        public String getString(int var1);

        public String getString(String var1);

        public int getInt(int var1);

        public int getInt(String var1);

        public long getLong(int var1);

        public long getLong(String var1);

        public float getFloat(int var1);

        public float getFloat(String var1);

        public double getDouble(int var1);

        public double getDouble(String var1);
    }

    class RowIterator
    implements Iterator<Row> {
        int row;
        Row tableRow = new Row(){

            @Override
            public String getString(int column) {
                return Table.this.getString(RowIterator.this.row, column);
            }

            @Override
            public String getString(String columnName) {
                return Table.this.getString(RowIterator.this.row, columnName);
            }

            @Override
            public int getInt(int column) {
                return Table.this.getInt(RowIterator.this.row, column);
            }

            @Override
            public int getInt(String columnName) {
                return Table.this.getInt(RowIterator.this.row, columnName);
            }

            @Override
            public long getLong(int column) {
                return Table.this.getLong(RowIterator.this.row, column);
            }

            @Override
            public long getLong(String columnName) {
                return Table.this.getLong(RowIterator.this.row, columnName);
            }

            @Override
            public float getFloat(int column) {
                return Table.this.getFloat(RowIterator.this.row, column);
            }

            @Override
            public float getFloat(String columnName) {
                return Table.this.getFloat(RowIterator.this.row, columnName);
            }

            @Override
            public double getDouble(int column) {
                return Table.this.getDouble(RowIterator.this.row, column);
            }

            @Override
            public double getDouble(String columnName) {
                return Table.this.getDouble(RowIterator.this.row, columnName);
            }
        };

        RowIterator() {
        }

        @Override
        public void remove() {
            Table.this.removeRow(this.row);
        }

        @Override
        public Row next() {
            ++this.row;
            return this.tableRow;
        }

        @Override
        public boolean hasNext() {
            return this.row + 1 < Table.this.getRowCount();
        }

        public void reset() {
            this.row = -1;
        }
    }
}

