/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioInput;
import ddf.minim.AudioPlayer;
import ddf.minim.AudioRecorder;
import ddf.minim.Minim;
import ddf.minim.Recordable;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import processing.core.PApplet;
import processing.core.PImage;

public class VoiceRecorder
extends PApplet {
    Minim minim;
    AudioInput in;
    AudioRecorder recorder;
    AudioPlayer recording;
    String[] words;
    int wordIndex;
    String currentWord;
    String newWord;
    PImage shelby;
    boolean space;
    boolean isRecording;

    public void setup() {
        this.size(512, 200, "processing.core.PGraphics2D");
        this.textMode(256);
        this.textFont(this.createFont("Serif", 24.0f));
        this.textAlign(3, 3);
        this.fill(0);
        this.stroke(0.0f, 0.0f, 255.0f);
        this.shelby = this.loadImage("data/shelby.png");
        this.prepareExitHandler();
        this.minim = new Minim((PApplet)this);
        this.in = this.minim.getLineIn(2, 2048);
        this.words = this.loadStrings("words.txt");
        this.wordIndex = PApplet.parseInt((String)this.loadStrings("data/word.txt")[0]);
        this.getWord();
    }

    public void getWord() {
        boolean bl = this.newWord != null;
        this.currentWord = bl ? this.newWord : VoiceRecorder.split((String)this.words[this.wordIndex], (char)' ')[0];
        File file = new File(this.sketchPath("recordings/" + this.currentWord + ".wav"));
        if (file.exists()) {
            file.delete();
        }
        this.recorder = this.minim.createRecorder((Recordable)this.in, "recordings/" + file.getName(), false);
        if (!bl) {
            String[] stringArray = new String[]{VoiceRecorder.str((int)this.wordIndex)};
            this.saveStrings("data/word.txt", stringArray);
        }
    }

    public void draw() {
        if (this.space) {
            this.background(0.0f, 255.0f, 0.0f);
        } else if (this.isRecording) {
            this.background(255.0f, 0.0f, 0.0f);
        } else {
            this.background(255);
        }
        this.image(this.shelby, 0.0f, 0.0f);
        int n = 0;
        while (n < this.in.bufferSize() - 1) {
            this.line(n, 50.0f + this.in.left.get(n) * 50.0f, n + 1, 50.0f + this.in.left.get(n + 1) * 50.0f);
            this.line(n, 150.0f + this.in.right.get(n) * 50.0f, n + 1, 150.0f + this.in.right.get(n + 1) * 50.0f);
            ++n;
        }
        this.text(this.currentWord, this.width / 2, this.height / 2);
        if (this.newWord != null) {
            this.text("\u221e", this.width / 2, this.height - 25);
        } else {
            this.text(VoiceRecorder.nfc((int)(this.words.length - this.wordIndex)), this.width / 2, this.height - 25);
        }
        if (this.recorder.isRecording()) {
            this.fill(255.0f, 0.0f, 0.0f);
            this.text("R", 15.0f, 18.0f);
            this.fill(0);
        }
    }

    public void keyPressed() {
        if (this.key == ' ' && !this.space) {
            this.space = true;
            ++this.wordIndex;
            this.newWord = null;
            if (this.wordIndex == this.words.length) {
                return;
            }
            this.getWord();
        }
        if (this.key == 'n') {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "";
                    VoiceRecorder.this.newWord = JOptionPane.showInputDialog(VoiceRecorder.this.frame, "Which word would you like to record?", string);
                    if (VoiceRecorder.this.newWord != null) {
                        VoiceRecorder.this.getWord();
                    }
                }
            });
        }
    }

    public void keyReleased() {
        if (this.key == ' ') {
            this.space = false;
        }
    }

    public void mousePressed() {
        this.getWord();
        if (this.recording != null && this.recording.isPlaying()) {
            this.recording.pause();
        }
        this.recorder.beginRecord();
        this.isRecording = true;
    }

    public void mouseReleased() {
        if (this.recorder.isRecording()) {
            this.recorder.endRecord();
            this.isRecording = false;
            this.recording = this.recorder.save();
            if (this.recording.length() > 100) {
                this.recording.loop();
            } else {
                File file = new File(this.sketchPath("recordings/" + this.currentWord + ".wav"));
                if (file.exists()) {
                    file.delete();
                }
            }
        }
    }

    private void prepareExitHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                File file = new File(VoiceRecorder.this.sketchPath("recordings/" + VoiceRecorder.this.currentWord + ".wav"));
                if (file.exists()) {
                    file.delete();
                }
            }
        }));
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "VoiceRecorder"});
    }
}

