import java.awt.TextArea;
import java.awt.Font;
import java.awt.Color;
import java.io.File;
import ddf.minim.*;

TextArea ta;
AudioSnippet player;
Minim minim;

String currentWord;
String[] words;
String[] settings;


void setup() {

  size(465, 370, JAVA2D);
  background(0, 0, 255);
  ta = new TextArea("", 15, 30, 1);
  ta.setFont(new java.awt.Font("Serif", Font.PLAIN, 20));
  ta.setForeground(Color.BLUE); 
  ta.addKeyListener(this);
  this.add(ta);


  minim = new Minim(this);
}

void keyPressed(KeyEvent e) {

  if (e.getKeyCode() == 32 || e.getKeyCode() == KeyEvent.VK_ENTER) {
    speak();
  }
}

void speak() {
  words = splitTokens(ta.getText());
  if (words.length > 0) {

    currentWord = words[words.length-1];
    File f = new File(sketchPath("recordings/"+currentWord+".wav"));
    if (f.exists()) {
      player = minim.loadSnippet("recordings/"+ f.getName());
      player.play();
    } 
    else{
      settings = loadStrings("data/voice.txt");
      TextToSpeech.say(currentWord, settings[0], int(settings[1]));
    }
  }
}

void stop()
{
  player.close();
  minim.stop();
  super.stop();
}

