/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioSnippet;
import ddf.minim.Minim;
import java.awt.Color;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import processing.core.PApplet;

public class VoiceWriter
extends PApplet {
    TextArea ta;
    AudioSnippet player;
    Minim minim;
    String currentWord;
    String[] words;
    String[] settings;

    public void setup() {
        this.size(465, 370, "processing.core.PGraphicsJava2D");
        this.background(0.0f, 0.0f, 255.0f);
        this.ta = new TextArea("", 15, 30, 1);
        this.ta.setFont(new Font("Serif", 0, 20));
        this.ta.setForeground(Color.BLUE);
        this.ta.addKeyListener((KeyListener)((Object)this));
        this.add(this.ta);
        this.minim = new Minim((PApplet)this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
            this.speak();
        }
    }

    public void speak() {
        this.words = VoiceWriter.splitTokens((String)this.ta.getText());
        if (this.words.length > 0) {
            this.currentWord = this.words[this.words.length - 1];
            File file = new File(this.sketchPath("recordings/" + this.currentWord + ".wav"));
            if (file.exists()) {
                this.player = this.minim.loadSnippet("recordings/" + file.getName());
                this.player.play();
            } else {
                this.settings = this.loadStrings("data/voice.txt");
                TextToSpeech.say(this.currentWord, this.settings[0], PApplet.parseInt((String)this.settings[1]));
            }
        }
    }

    public void stop() {
        this.player.close();
        this.minim.stop();
        super.stop();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "VoiceWriter"});
    }

    static class TextToSpeech {
        static final String ALEX = "Alex";
        static final String BRUCE = "Bruce";
        static final String FRED = "Fred";
        static final String JUNIOR = "Junior";
        static final String RALPH = "Ralph";
        static final String AGNES = "Agnes";
        static final String KATHY = "Kathy";
        static final String PRINCESS = "Princess";
        static final String VICKI = "Vicki";
        static final String VICTORIA = "Victoria";
        static final String ALBERT = "Albert";
        static final String BAD_NEWS = "Bad News";
        static final String BAHH = "Bahh";
        static final String BELLS = "Bells";
        static final String BOING = "Boing";
        static final String BUBBLES = "Bubbles";
        static final String CELLOS = "Cellos";
        static final String DERANGED = "Deranged";
        static final String GOOD_NEWS = "Good News";
        static final String HYSTERICAL = "Hysterical";
        static final String PIPE_ORGAN = "Pipe Organ";
        static final String TRINOIDS = "Trinoids";
        static final String WHISPER = "Whisper";
        static final String ZARVOX = "Zarvox";
        static String[] voices = new String[]{"Alex", "Bruce", "Fred", "Junior", "Ralph", "Agnes", "Kathy", "Princess", "Vicki", "Victoria", "Albert", "Bad News", "Bahh", "Bells", "Boing", "Bubbles", "Cellos", "Deranged", "Good News", "Hysterical", "Pipe Organ", "Trinoids", "Whisper", "Zarvox"};

        TextToSpeech() {
        }

        public static void say(String string, String string2, int n) {
            try {
                Runtime.getRuntime().exec(new String[]{"say", "-v", string2, "[[rate " + n + "]]" + string});
            }
            catch (IOException iOException) {
                System.err.println("IOException");
            }
        }

        public static void say(String string) {
            TextToSpeech.say(string, ALEX, 200);
        }
    }
}

