/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PVector;

public class Traveller
extends PApplet {
    mark currentMark;
    mark playingMark;
    mark[] marks;
    int currentMarkIndex = 0;
    int timer = 0;
    PVector lastMouse;
    PVector markEnd;
    int currentMarkFolder;
    boolean editor = true;
    FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    FilenameFilter txtFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".txt");
        }
    };

    public void setup() {
        this.size(720, 480, "processing.core.PGraphicsJava2D");
        this.rectMode(3);
        this.frameRate(60.0f);
        this.noCursor();
        this.fill(255);
        this.stroke(255);
        this.strokeWeight(1.0f);
        this.noFill();
        this.noSmooth();
        this.marks = new mark[0];
        this.markEnd = new PVector((float)(this.width / 2), (float)(this.height / 2));
        this.background(0);
        this.getMarkFolders();
        this.switchMarkFolder();
    }

    public void addBasicMarks() {
        mark mark2 = new mark();
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)new int[3]);
        int[] nArray = new int[3];
        nArray[0] = 1;
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)nArray);
        mark2.createPolygon();
        this.marks = (mark[])Traveller.append((Object)this.marks, (Object)mark2);
        mark2 = new mark();
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)new int[3]);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)nArray2);
        mark2.createPolygon();
        this.marks = (mark[])Traveller.append((Object)this.marks, (Object)mark2);
        mark2 = new mark();
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)new int[3]);
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)nArray3);
        mark2.createPolygon();
        this.marks = (mark[])Traveller.append((Object)this.marks, (Object)mark2);
        mark2 = new mark();
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)new int[3]);
        int[] nArray4 = new int[3];
        nArray4[1] = -1;
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)nArray4);
        mark2.createPolygon();
        this.marks = (mark[])Traveller.append((Object)this.marks, (Object)mark2);
    }

    public void draw() {
        this.background(0);
        if (this.editor) {
            this.point(this.mouseX, this.mouseY);
        }
        if (this.playingMark != null) {
            this.playingMark.render();
        }
        if (this.currentMark != null && this.currentMark.record) {
            this.currentMark.record();
        }
        ++this.timer;
        if (this.timer == 3000) {
            this.switchMarkFolder();
            this.timer = 0;
        }
    }

    public void keyPressed() {
        switch (this.key) {
            case 'e': {
                this.editor = !this.editor;
                break;
            }
            case ' ': {
                this.switchMarkFolder();
                this.background(0);
                break;
            }
            case 'x': {
                this.stroke(255);
                break;
            }
            case 'z': {
                this.stroke(0);
                break;
            }
            case 'q': {
                this.noCursor();
            }
        }
    }

    public void mousePressed() {
        mark mark2;
        this.lastMouse = new PVector((float)this.mouseX, (float)this.mouseY);
        this.playingMark = null;
        this.currentMark = mark2 = new mark();
        this.currentMark.record = true;
    }

    public void mouseDragged() {
        this.line(this.pmouseX, this.pmouseY, this.mouseX, this.mouseY);
    }

    public void mouseReleased() {
        this.currentMark.record = false;
        if (this.currentMark.points.length <= 1) {
            return;
        }
        this.marks = (mark[])Traveller.append((Object)this.marks, (Object)this.currentMark);
        String string = String.valueOf(String.valueOf(Traveller.year())) + "/" + Traveller.nf((int)Traveller.month(), (int)2) + "-" + Traveller.nf((int)Traveller.day(), (int)2);
        String string2 = String.valueOf(Traveller.nf((int)Traveller.hour(), (int)2)) + "-" + Traveller.nf((int)Traveller.minute(), (int)2) + "-" + Traveller.nf((int)Traveller.second(), (int)2);
        this.currentMark.saveMark("marks/" + string + "/" + string2);
        if (this.playingMark == null) {
            this.playingMark = this.currentMark;
        }
    }

    public void switchMarkFolder() {
        ArrayList arrayList = this.filesToArrayList();
        this.currentMarkFolder = PApplet.parseInt((float)this.random(arrayList.size() - 1));
        if (this.currentMarkFolder == arrayList.size()) {
            this.currentMarkFolder = 0;
        }
        this.marks = new mark[0];
        this.loadMarksFromFolder((File)arrayList.get(this.currentMarkFolder));
        this.addBasicMarks();
    }

    public void getMarkFolders() {
        ArrayList arrayList = this.filesToArrayList();
        this.currentMarkFolder = 0;
        this.marks = new mark[0];
        if (this.loadMarksFromFolder((File)arrayList.get(0))) {
            this.playingMark = this.marks[0];
        }
        this.addBasicMarks();
    }

    public boolean loadMarksFromFolder(File file) {
        File[] fileArray = file.listFiles(this.txtFilter);
        if (fileArray.length > 0) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                this.marks = (mark[])Traveller.append((Object)this.marks, (Object)this.loadMarkFromFile(this.createReader(file2.getPath()), new mark()));
                ++n2;
            }
        } else {
            return false;
        }
        return true;
    }

    public mark loadMarkFromFile(BufferedReader bufferedReader, mark mark2) {
        String string;
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            string = null;
        }
        if (string == null) {
            mark2.createPolygon();
            return mark2;
        }
        String[] stringArray = Traveller.split((String)string, (String)",");
        int[] nArray = new int[]{};
        nArray = Traveller.append((int[])nArray, (int)PApplet.parseInt((String)stringArray[0]));
        nArray = Traveller.append((int[])nArray, (int)PApplet.parseInt((String)stringArray[1]));
        nArray = stringArray.length == 3 ? Traveller.append((int[])nArray, (int)PApplet.parseInt((String)stringArray[2])) : Traveller.append((int[])nArray, (int)0);
        mark2.points = (int[][])Traveller.append((Object)mark2.points, (Object)nArray);
        return this.loadMarkFromFile(bufferedReader, mark2);
    }

    public ArrayList filesToArrayList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = this.sketchPath("marks/2013/");
        if (string != null) {
            File file = new File(string);
            File[] fileArray = file.listFiles(this.directoryFilter);
            int n = 0;
            while (n < fileArray.length) {
                arrayList.add(fileArray[n]);
                ++n;
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Traveller"};
        if (stringArray != null) {
            PApplet.main((String[])Traveller.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class mark {
        int[][] points = new int[0][0];
        int i = 0;
        boolean record = false;
        int countedFrames = 0;
        int skippedFrames = 0;
        Polygon poly;
        PVector lastRenderedPoint;

        mark() {
        }

        public void record() {
            int[] nArray = new int[3];
            nArray[0] = Traveller.this.mouseX - PApplet.parseInt((float)Traveller.this.lastMouse.x);
            nArray[1] = Traveller.this.mouseY - PApplet.parseInt((float)Traveller.this.lastMouse.y);
            int[] nArray2 = nArray;
            if (this.points.length > 0 && !this.comparePointArrays(this.points[this.points.length - 1], nArray2)) {
                this.points[this.points.length - 1][2] = this.skippedFrames;
                this.points = (int[][])Traveller.append((Object)this.points, (Object)nArray2);
                this.skippedFrames = 0;
            } else if (this.points.length == 0) {
                this.points = (int[][])Traveller.append((Object)this.points, (Object)nArray2);
            } else {
                ++this.skippedFrames;
            }
        }

        public boolean comparePointArrays(int[] nArray, int[] nArray2) {
            if (nArray[0] == nArray2[0]) {
                if (nArray[1] == nArray2[1]) {
                    return nArray[2] == nArray2[2];
                }
                return false;
            }
            return false;
        }

        public void createPolygon() {
            this.poly = new Polygon();
            int[][] nArray = this.points;
            int n = this.points.length;
            int n2 = 0;
            while (n2 < n) {
                int[] nArray2 = nArray[n2];
                this.poly.addPoint(nArray2[0], nArray2[1]);
                ++n2;
            }
        }

        public void render() {
            int n = this.points.length;
            if (n > 0) {
                int n2 = PApplet.parseInt((float)Traveller.this.markEnd.x) + this.points[this.i][0];
                int n3 = PApplet.parseInt((float)Traveller.this.markEnd.y) + this.points[this.i][1];
                Traveller.this.point(n2, n3);
                this.lastRenderedPoint = new PVector((float)n2, (float)n3);
                if (this.points[this.i][2] == this.countedFrames) {
                    this.countedFrames = 0;
                    ++this.i;
                } else {
                    ++this.countedFrames;
                }
                if (this.i >= n) {
                    this.i = 0;
                    Traveller.this.markEnd = new PVector((float)n2, (float)n3);
                    this.lastRenderedPoint = null;
                    Traveller.this.playingMark = this.getNextMarkRandom();
                    if (n2 > Traveller.this.width || n2 < 0) {
                        Traveller.this.playingMark = null;
                    }
                    if (n3 > Traveller.this.height || n3 < 0) {
                        Traveller.this.playingMark = null;
                    }
                }
            }
        }

        public mark getNextMarkRandom() {
            mark mark2 = Traveller.this.marks[PApplet.parseInt((float)Traveller.this.random(Traveller.this.marks.length))];
            if (!this.checkMarkBounds(mark2)) {
                return this.getNextMarkRandom();
            }
            return mark2;
        }

        public mark getNextMark() {
            mark mark2;
            ++Traveller.this.currentMarkIndex;
            if (Traveller.this.currentMarkIndex == Traveller.this.marks.length) {
                Traveller.this.currentMarkIndex = 0;
            }
            if ((mark2 = Traveller.this.marks[Traveller.this.currentMarkIndex]) == Traveller.this.playingMark && Traveller.this.marks.length > 1) {
                return this.getNextMark();
            }
            if (!this.checkMarkBounds(mark2)) {
                return null;
            }
            return mark2;
        }

        public boolean checkMarkBounds(mark mark2) {
            int[][] nArray = mark2.points;
            int n = mark2.points.length;
            int n2 = 0;
            while (n2 < n) {
                int[] nArray2 = nArray[n2];
                int n3 = PApplet.parseInt((float)Traveller.this.markEnd.x) + nArray2[0];
                int n4 = PApplet.parseInt((float)Traveller.this.markEnd.y) + nArray2[1];
                if (n3 > Traveller.this.width || n3 < 0) {
                    return false;
                }
                if (n4 > Traveller.this.height || n4 < 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public void saveMark(String string) {
            PrintWriter printWriter = Traveller.this.createWriter(String.valueOf(string) + ".txt");
            int[] nArray = new int[]{};
            int n = 0;
            String string2 = "";
            int[][] nArray2 = this.points;
            int n2 = this.points.length;
            int n3 = 0;
            while (n3 < n2) {
                int[] nArray3 = nArray2[n3];
                if (Arrays.equals(nArray, nArray3)) {
                    ++n;
                } else {
                    if (n > 0) {
                        printWriter.print("," + (n + 1) + "\n");
                    } else if (nArray3 != this.points[0]) {
                        string2 = "\n";
                    }
                    if (nArray3[2] == 0) {
                        printWriter.print(String.valueOf(string2) + nArray3[0] + "," + nArray3[1]);
                    } else {
                        printWriter.print(String.valueOf(string2) + nArray3[0] + "," + nArray3[1] + "," + nArray3[2]);
                    }
                    nArray = nArray3;
                    n = 0;
                    string2 = "";
                }
                ++n3;
            }
            printWriter.flush();
            printWriter.close();
        }
    }
}

