/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDynamicLookupHelper;

public abstract class GLDrawableImpl
implements GLDrawable {
    protected static final boolean DEBUG = GLDrawableFactoryImpl.DEBUG;
    protected final GLDrawableFactory factory;
    protected final NativeSurface surface;
    protected final GLCapabilitiesImmutable requestedCapabilities;
    protected volatile boolean realized;

    protected GLDrawableImpl(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        this(gLDrawableFactory, nativeSurface, (GLCapabilitiesImmutable)nativeSurface.getGraphicsConfiguration().getRequestedCapabilities(), bl);
    }

    protected GLDrawableImpl(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        this.factory = gLDrawableFactory;
        this.surface = nativeSurface;
        this.realized = bl;
        this.requestedCapabilities = gLCapabilitiesImmutable;
    }

    public abstract GLDynamicLookupHelper getGLDynamicLookupHelper();

    public final GLDrawableFactoryImpl getFactoryImpl() {
        return (GLDrawableFactoryImpl)this.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void swapBuffers() throws GLException {
        if (!this.realized) {
            return;
        }
        int n = this.lockSurface();
        if (1 == n) {
            return;
        }
        try {
            if (this.realized) {
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
                if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                    if (!this.surface.surfaceSwap()) {
                        this.swapBuffersImpl(true);
                    }
                } else {
                    GLContext gLContext = GLContext.getCurrent();
                    if (null != gLContext && gLContext.getGLDrawable() == this) {
                        gLContext.getGL().glFlush();
                    }
                    this.swapBuffersImpl(false);
                }
            }
        }
        finally {
            this.unlockSurface();
        }
        this.surface.surfaceUpdated(this, this.surface, System.currentTimeMillis());
    }

    protected abstract void swapBuffersImpl(boolean var1);

    public static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    @Override
    public final GLProfile getGLProfile() {
        return this.requestedCapabilities.getGLProfile();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
    }

    public final GLCapabilitiesImmutable getRequestedGLCapabilities() {
        return this.requestedCapabilities;
    }

    @Override
    public NativeSurface getNativeSurface() {
        return this.surface;
    }

    protected void destroyHandle() {
    }

    protected void createHandle() {
    }

    @Override
    public long getHandle() {
        return this.surface.getSurfaceHandle();
    }

    @Override
    public final GLDrawableFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void setRealized(boolean bl) {
        if (this.realized != bl) {
            boolean bl2 = this.surface instanceof ProxySurface;
            if (DEBUG) {
                System.err.println(GLDrawableImpl.getThreadName() + ": setRealized: drawable " + this.getClass().getSimpleName() + ", surface " + this.surface.getClass().getSimpleName() + ", isProxySurface " + bl2 + ": " + this.realized + " -> " + bl);
                Thread.dumpStack();
            }
            AbstractGraphicsDevice abstractGraphicsDevice = this.surface.getGraphicsConfiguration().getScreen().getDevice();
            if (bl) {
                if (bl2) {
                    ((ProxySurface)this.surface).createNotify();
                }
                if (1 >= this.surface.lockSurface()) {
                    throw new GLException("GLDrawableImpl.setRealized(true): Surface not ready (lockSurface)");
                }
            } else {
                abstractGraphicsDevice.lock();
            }
            try {
                if (this.realized == bl) return;
                this.realized = bl;
                if (bl) {
                    this.setRealizedImpl();
                    this.createHandle();
                    return;
                }
                this.destroyHandle();
                this.setRealizedImpl();
                return;
            }
            finally {
                if (bl) {
                    this.surface.unlockSurface();
                } else {
                    abstractGraphicsDevice.unlock();
                    if (bl2) {
                        ((ProxySurface)this.surface).destroyNotify();
                    }
                }
            }
        } else {
            if (!DEBUG) return;
            System.err.println(GLDrawableImpl.getThreadName() + ": setRealized: " + this.getClass().getName() + " " + this.realized + " == " + bl);
        }
    }

    protected abstract void setRealizedImpl();

    protected void associateContext(GLContext gLContext, boolean bl) {
    }

    protected void contextMadeCurrent(GLContext gLContext, boolean bl) {
    }

    protected int getDefaultDrawFramebuffer() {
        return 0;
    }

    protected int getDefaultReadFramebuffer() {
        return 0;
    }

    protected int getDefaultReadBuffer(GL gL) {
        if (gL.isGLES() || this.getChosenGLCapabilities().getDoubleBuffered()) {
            return 1029;
        }
        return 1028;
    }

    @Override
    public final boolean isRealized() {
        return this.realized;
    }

    @Override
    public int getWidth() {
        return this.surface.getWidth();
    }

    @Override
    public int getHeight() {
        return this.surface.getHeight();
    }

    @Override
    public boolean isGLOriented() {
        return true;
    }

    public final int lockSurface() throws GLException {
        int n = this.surface.lockSurface();
        if (2 == n && this.realized) {
            long l = this.getHandle();
            this.destroyHandle();
            this.createHandle();
            long l2 = this.getHandle();
            if (DEBUG && l != l2) {
                System.err.println(GLDrawableImpl.getThreadName() + ": Drawable handle changed: " + GLDrawableImpl.toHexString(l) + " -> " + GLDrawableImpl.toHexString(l2));
            }
        }
        return n;
    }

    public final void unlockSurface() {
        this.surface.unlockSurface();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[Realized " + this.isRealized() + ",\n\tFactory   " + this.getFactory() + ",\n\tHandle    " + GLDrawableImpl.toHexString(this.getHandle()) + ",\n\tSurface   " + this.getNativeSurface() + "]";
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

