/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.InetAddress;
import java.util.ArrayList;
import netP5.Bytes;
import netP5.TcpClient;
import oscP5.OscMessage;

public abstract class OscPatcher {
    protected static final byte ZEROBYTE = 0;
    protected static final byte KOMMA = 44;
    protected static final long TIMETAG_OFFSET = 2208988800L;
    protected static final long TIEMTAG_NOW = 1L;
    protected ArrayList<OscMessage> messages;
    protected byte[] _myAddrPattern;
    protected int _myAddrInt = -1;
    protected byte[] _myTypetag = new byte[0];
    protected byte[] _myData = new byte[0];
    protected Object[] _myArguments;
    protected boolean isValid = false;
    protected long timetag = 1L;
    protected boolean isArray = false;
    protected byte _myArrayType = 0;

    protected OscPatcher() {
    }

    protected int parseBundle(byte[] byArray, InetAddress inetAddress, int n, TcpClient tcpClient) {
        int n2;
        if (byArray.length > 16) {
            this.timetag = new Long(Bytes.toLong(Bytes.copy(byArray, 8, 8)));
            n2 = 16;
            this.messages = new ArrayList();
            int n3 = Bytes.toInt(Bytes.copy(byArray, n2, 4));
            while (n3 != 0 && n3 % 4 == 0 && n2 < byArray.length) {
                this.messages.add(new OscMessage(Bytes.copy(byArray, n2 += 4, n3), inetAddress, n, this.timetag, tcpClient));
                n3 = Bytes.toInt(Bytes.copy(byArray, n2 += n3, 4));
            }
        }
        for (n2 = 0; n2 < this.messages.size(); ++n2) {
            if (this.messages.get((int)n2).isValid) continue;
            this.messages.remove(this.messages.get(n2));
        }
        if (this.messages.size() > 0) {
            this.isValid = true;
        }
        return this.messages.size();
    }

    protected void parseMessage(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        if ((n2 = this.parseAddrPattern(byArray, n, n2)) != -1) {
            n2 = this.parseTypetag(byArray, n, n2);
        }
        if (n2 != -1) {
            this._myData = Bytes.copy(byArray, n2);
            this._myArguments = this.parseArguments(this._myData);
            this.isValid = true;
        }
    }

    protected int parseAddrPattern(byte[] byArray, int n, int n2) {
        if (n > 4 && byArray[4] == 44) {
            this._myAddrInt = Bytes.toInt(Bytes.copy(byArray, 0, 4));
        }
        for (int i = n2; i < n; ++i) {
            if (byArray[i] != 0) continue;
            this._myAddrPattern = Bytes.copy(byArray, n2, i);
            return i + OscPatcher.align(i);
        }
        return -1;
    }

    protected int parseTypetag(byte[] byArray, int n, int n2) {
        if (byArray[n2] == 44) {
            for (int i = ++n2; i < n; ++i) {
                if (byArray[i] != 0) continue;
                this._myTypetag = Bytes.copy(byArray, n2, i - n2);
                return i + OscPatcher.align(i);
            }
        }
        return -1;
    }

    protected Object[] parseArguments(byte[] byArray) {
        Object[] objectArray = new Object[]{};
        int n = 0;
        objectArray = new Object[this._myTypetag.length];
        boolean bl = this.isArray = this._myTypetag.length > 0;
        block10: for (int i = 0; i < this._myTypetag.length; ++i) {
            if (i == 0) {
                this._myArrayType = this._myTypetag[i];
            } else if (this._myTypetag[i] != this._myArrayType) {
                this.isArray = false;
            }
            switch (this._myTypetag[i]) {
                case 99: {
                    objectArray[i] = new Character((char)Bytes.toInt(Bytes.copy(byArray, n, 4)));
                    n += 4;
                    continue block10;
                }
                case 105: {
                    objectArray[i] = new Integer(Bytes.toInt(Bytes.copy(byArray, n, 4)));
                    n += 4;
                    continue block10;
                }
                case 102: {
                    objectArray[i] = new Float(Bytes.toFloat(Bytes.copy(byArray, n, 4)));
                    n += 4;
                    continue block10;
                }
                case 104: 
                case 108: {
                    objectArray[i] = new Long(Bytes.toLong(Bytes.copy(byArray, n, 8)));
                    n += 8;
                    continue block10;
                }
                case 100: {
                    objectArray[i] = new Double(Bytes.toDouble(Bytes.copy(byArray, n, 8)));
                    n += 8;
                    continue block10;
                }
                case 83: 
                case 115: {
                    int n2 = n;
                    StringBuffer stringBuffer = new StringBuffer();
                    while (byArray[n2] != 0) {
                        stringBuffer.append((char)byArray[n2]);
                        if (++n2 < byArray.length) continue;
                    }
                    objectArray[i] = stringBuffer.toString();
                    n = n2 + OscPatcher.align(n2);
                    continue block10;
                }
                case 98: {
                    int n3 = Bytes.toInt(Bytes.copy(byArray, n, 4));
                    objectArray[i] = Bytes.copy(byArray, n += 4, n3);
                    n += n3 + OscPatcher.align(n3) % 4;
                    continue block10;
                }
                case 109: {
                    objectArray[i] = Bytes.copy(byArray, n, 4);
                    n += 4;
                }
            }
        }
        this._myData = Bytes.copy(this._myData, 0, n);
        return objectArray;
    }

    protected static int align(int n) {
        return 4 - n % 4;
    }
}

