/*
 * Decompiled with CFR 0.152.
 */
package procontroll;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import processing.core.PApplet;
import procontroll.ControllInput;
import procontroll.Plug;

public class ControllButton
extends ControllInput {
    private boolean pressed = false;
    private boolean oldPressed = false;
    private final PApplet parent;
    protected final List onPressPlugs = new ArrayList();
    protected final List onReleasePlugs = new ArrayList();
    protected final List whilePressPlugs = new ArrayList();

    ControllButton(Component i_component, PApplet i_parent) {
        super(i_component);
        this.parent = i_parent;
    }

    void update() {
        this.actualValue = this.component.getPollData() * 8.0f;
        boolean bl = this.pressed = this.actualValue > 0.0f;
        if (this.pressed && this.oldPressed) {
            this.callPlugs(this.whilePressPlugs);
        } else if (this.pressed && !this.oldPressed) {
            this.callPlugs(this.onPressPlugs);
        } else if (!this.pressed && this.oldPressed) {
            this.callPlugs(this.onReleasePlugs);
        }
        this.oldPressed = this.pressed;
    }

    public boolean pressed() {
        return this.pressed;
    }

    public void plug(Object i_object, String i_methodName, int i_eventType) {
        List plugList;
        Plug plug = new Plug(i_object, i_methodName);
        switch (i_eventType) {
            case 0: {
                plugList = this.onPressPlugs;
                break;
            }
            case 1: {
                plugList = this.onReleasePlugs;
                break;
            }
            case 2: {
                plugList = this.whilePressPlugs;
                break;
            }
            default: {
                throw new RuntimeException("Error on plug " + i_methodName + " check the given event type");
            }
        }
        plugList.add(plug);
    }

    public void plug(String i_methodName, int i_eventType) {
        this.plug(this.parent, i_methodName, i_eventType);
    }

    protected void callPlugs(List i_plugList) {
        int i = 0;
        while (i < i_plugList.size()) {
            Plug plug = (Plug)i_plugList.get(i);
            plug.call();
            ++i;
        }
    }
}

