/*
 * Decompiled with CFR 0.152.
 */
package procontroll;

import java.util.List;
import net.java.games.input.Component;
import processing.core.PApplet;
import procontroll.ControllButton;
import procontroll.Plug;

public class ControllCoolieHat
extends ControllButton {
    private static final int OFF = 0;
    private static final int UP_LEFT = 1;
    private static final int UP = 2;
    private static final int UP_RIGHT = 3;
    private static final int RIGHT = 4;
    private static final int DOWN_RIGHT = 5;
    private static final int DOWN = 6;
    private static final int DOWN_LEFT = 7;
    private static final int LEFT = 8;
    private float x = 0.0f;
    private float y = 0.0f;
    private static float DIAGONAL_FACTOR = (float)Math.sin(0.7853981852531433);
    private float change = 1.0f;
    private float diagonalChange = DIAGONAL_FACTOR;
    private float multiplier = 1.0f;

    ControllCoolieHat(Component i_component, PApplet i_parent) {
        super(i_component, i_parent);
    }

    void update() {
        super.update();
        switch ((int)this.actualValue) {
            case 6: {
                this.y = this.change;
                break;
            }
            case 7: {
                this.x = -this.diagonalChange;
                this.y = this.diagonalChange;
                break;
            }
            case 8: {
                this.x = -this.change;
                break;
            }
            case 1: {
                this.x = -this.diagonalChange;
                this.y = -this.diagonalChange;
                break;
            }
            case 2: {
                this.y = -this.change;
                break;
            }
            case 3: {
                this.x = this.diagonalChange;
                this.y = -this.diagonalChange;
                break;
            }
            case 4: {
                this.x = this.change;
                break;
            }
            case 5: {
                this.x = this.diagonalChange;
                this.y = this.diagonalChange;
                break;
            }
            case 0: {
                this.x = 0.0f;
                this.y = 0.0f;
            }
        }
    }

    public String getName() {
        return "cooliehat: " + super.getName();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float i_multiplier) {
        this.change = this.multiplier = i_multiplier;
        this.diagonalChange = DIAGONAL_FACTOR * i_multiplier;
    }

    public void plug(Object i_object, String i_methodName, int i_eventType) {
        List plugList;
        Plug plug = new Plug(i_object, i_methodName, true);
        switch (i_eventType) {
            case 0: {
                plugList = this.onPressPlugs;
                break;
            }
            case 1: {
                plugList = this.onReleasePlugs;
                break;
            }
            case 2: {
                plugList = this.whilePressPlugs;
                break;
            }
            default: {
                throw new RuntimeException("Error on plug " + i_methodName + " check the given event type");
            }
        }
        plugList.add(plug);
    }

    protected void callPlugs(List i_plugList) {
        int i = 0;
        while (i < i_plugList.size()) {
            Plug plug = (Plug)i_plugList.get(i);
            plug.call(this.x, this.y);
            ++i;
        }
    }
}

