/*
 * Decompiled with CFR 0.152.
 */
package procontroll;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;
import processing.core.PApplet;
import procontroll.ControllButton;
import procontroll.ControllCoolieHat;
import procontroll.ControllInput;
import procontroll.ControllRelativeSlider;
import procontroll.ControllSlider;
import procontroll.ControllStick;

public class ControllDevice {
    private final Controller controller;
    private final List sticks = new ArrayList();
    private final List sliders = new ArrayList();
    private final List buttons = new ArrayList();
    private Rumbler[] rumblers = new Rumbler[0];
    private final Map inputMap = new HashMap();
    private final List inputs = new ArrayList();
    private boolean open = false;
    private final String name;
    private final PApplet parent;

    ControllDevice(Controller i_controller, PApplet i_parent) {
        this.controller = i_controller;
        this.parent = i_parent;
        this.name = i_controller.getName();
        this.setupDevice();
    }

    private void setupDevice() {
        Component[] components = this.controller.getComponents();
        int i = 0;
        while (i < components.length) {
            ControllInput input;
            if (components[i].isAnalog()) {
                input = components[i].isRelative() ? new ControllRelativeSlider(components[i]) : new ControllSlider(components[i]);
                this.sliders.add(input);
            } else {
                input = components[i].getIdentifier() == Component.Identifier.Axis.POV ? new ControllCoolieHat(components[i], this.parent) : new ControllButton(components[i], this.parent);
                this.buttons.add(input);
            }
            this.inputMap.put(input.getName(), input);
            ++i;
        }
        this.inputs.addAll(this.sliders);
        this.inputs.addAll(this.buttons);
        if (this.sliders.size() % 2 == 0) {
            i = 0;
            while (i < this.sliders.size()) {
                ControllSlider sliderY = (ControllSlider)this.sliders.get(i);
                ControllSlider sliderX = (ControllSlider)this.sliders.get(i + 1);
                this.sticks.add(new ControllStick(sliderX, sliderY));
                i += 2;
            }
        }
        this.rumblers = this.controller.getRumblers();
        System.out.println(this.rumblers.length);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.controller.getName();
    }

    protected void update() {
        if (this.open) {
            this.controller.poll();
            int i = 0;
            while (i < this.inputs.size()) {
                ((ControllInput)this.inputs.get(i)).update();
                ++i;
            }
        }
    }

    protected void updateRelative() {
        if (this.open) {
            int i = 0;
            while (i < this.sliders.size()) {
                ((ControllSlider)this.sliders.get(i)).updateRelative();
                ++i;
            }
        }
    }

    public void printSliders() {
        if (this.sliders.size() > 0) {
            System.out.println("\n<<< available " + this.name + " sliders: >>>\n");
            int i = 0;
            while (i < this.sliders.size()) {
                ControllSlider slider = (ControllSlider)this.sliders.get(i);
                System.out.print("     " + i + ": ");
                System.out.print(slider.getName());
                if (slider.isRelative()) {
                    System.out.println(" relative");
                } else {
                    System.out.println(" absolute");
                }
                ++i;
            }
            System.out.println("\n<<< >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
    }

    public void printButtons() {
        if (this.buttons.size() > 0) {
            System.out.println("\n<<< available " + this.name + " buttons: >>>\n");
            int i = 0;
            while (i < this.buttons.size()) {
                System.out.print("     " + i + ": ");
                System.out.println(((ControllInput)this.buttons.get(i)).getName());
                ++i;
            }
            System.out.println("\n<<< >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
    }

    public void printSticks() {
        if (this.sticks.size() > 0) {
            System.out.println("\n<<< available " + this.name + " sticks: >>>\n");
            int i = 0;
            while (i < this.sticks.size()) {
                System.out.print("     " + i + ": ");
                System.out.println(((ControllStick)this.sticks.get(i)).getName());
                ++i;
            }
            System.out.println("\n<<< >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
    }

    public int getNumberOfSliders() {
        return this.sliders.size();
    }

    public ControllSlider getSlider(int i_sliderNumb) {
        return (ControllSlider)this.sliders.get(i_sliderNumb);
    }

    public ControllSlider getSlider(String i_sliderName) {
        try {
            return (ControllSlider)this.inputMap.get(i_sliderName);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("There is no slider with the name " + i_sliderName + ".");
        }
    }

    public void setTolerance(float i_tolerance) {
        int i = 0;
        while (i < this.sliders.size()) {
            ((ControllSlider)this.sliders.get(i)).setTolerance(i_tolerance);
            ++i;
        }
    }

    public int getNumberOfButtons() {
        return this.buttons.size();
    }

    public ControllButton getButton(int i_buttonNumb) {
        return (ControllButton)this.buttons.get(i_buttonNumb);
    }

    public ControllButton getButton(String i_buttonName) {
        try {
            return (ControllButton)this.inputMap.get(i_buttonName);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("There is no button with the name " + i_buttonName + ".");
        }
    }

    public int getNumberOfSticks() {
        return this.sticks.size();
    }

    public ControllStick getStick(int i_stickNumb) {
        return (ControllStick)this.sticks.get(i_stickNumb);
    }

    public ControllStick getStick(String i_stickName) {
        int i = 0;
        while (i < this.getNumberOfSticks()) {
            ControllStick stick = (ControllStick)this.sticks.get(i);
            if (stick.getName().equals(i_stickName)) {
                return this.getStick(i);
            }
            ++i;
        }
        throw new RuntimeException("There is no stick with the name " + i_stickName + ".");
    }

    public ControllCoolieHat getCoolieHat(int i_coolieHatNumb) {
        return (ControllCoolieHat)this.buttons.get(i_coolieHatNumb);
    }

    public ControllCoolieHat getCoolieHat(String i_buttonName) {
        try {
            return (ControllCoolieHat)this.inputMap.get(i_buttonName);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("There is no button with the name " + i_buttonName + ".");
        }
    }

    public void open() {
        this.open = true;
    }

    public void close() {
        this.open = false;
    }

    public void rumble(float i_intensity, int i_id) {
        if (i_id >= this.rumblers.length) {
            return;
        }
        this.rumblers[i_id].rumble(i_intensity);
    }

    public void rumble(float i_intensity) {
        this.rumble(i_intensity, 0);
    }

    public void plug(Object i_object, String i_methodName, int i_eventType, int i_input) {
        this.open();
        this.getButton(i_input).plug(i_object, i_methodName, i_eventType);
    }

    public void plug(String i_methodName, int i_eventType, int i_input) {
        this.open();
        this.getButton(i_input).plug(this.parent, i_methodName, i_eventType);
    }

    public void plug(Object i_object, String i_methodName, int i_eventType, String i_input) {
        this.open();
        this.getButton(i_input).plug(i_object, i_methodName, i_eventType);
    }

    public void plug(String i_methodName, int i_eventType, String i_input) {
        this.open();
        this.getButton(i_input).plug(this.parent, i_methodName, i_eventType);
    }
}

