﻿package art_apes {
	
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.geom.*;
	import flash.filters.*;
	
	import art_apes.DisplayUtils;
	
	import art_apes.SESSION;
	import art_apes.USER;
	import art_apes.DynamicSprite;
	import HEARTWORKS;
	
	public class Tool extends Sprite {
		
	var TS = SESSION.ThisSession;
	var MyUser = SESSION.ThisSession.MyUser; 
	var Users = TS.Users;
		
	public var ToolType:String; // accepts 'cutout' or 'stamp' or 'shape'
	
	public var isCutout:Boolean = false;
	
		var tool_color:int = 0x000000;
		var tool_opacity:Number = 1;
		var tool_rotation:Number = 0;
		var tool_size:Number = 1;
		var tool_blur:Number = 0;
		
		var tool_button_icon:DynamicSprite;
		var tool_button:Sprite;
		
		var tool_colorTransform:ColorTransform = new ColorTransform();
		var tool_bitmap_colorTransform:ColorTransform = new ColorTransform();
		
		var tool_rotation_velocity:Number = 0;
		var tool_rotation_drag:Number = 0.92;
		
		var tool_motion_reverse:Boolean = true;
		
		public var tool_rotation_oldx:int = 0;
		public var tool_size_bigorsmall:Boolean = false;
		
		public var tool_motion_playback:Boolean = false;
		
		var tool_cutout_outline:Sprite = new Sprite();
		
		public var i:int;
		public var g:int;
		
		public var tool_motion_check:Boolean = false;
		public var Coords:Array = new Array();
		public var playPosition:int = 0;
		public var graphix;
		
		public var tool_index:int;
	
		public var tool_line:Sprite;
		
		var toolnumber:int;
		
		var not_drawing:Boolean = true;
		var drawn_something:Boolean = false;
		
		
		const mouse_double_click_time:int = 300;
		var mouse_double_click_timer:int;
		
		
		var cutout_pattern:BitmapData = new BitmapData(2, 2,true,0x00000000);
		
		
		var cutout_bitmapdata:BitmapData = new BitmapData(HEARTWORKS.APPLICATION_WIDTH, HEARTWORKS.APPLICATION_HEIGHT);
		var rect:Rectangle = new Rectangle(0,0,HEARTWORKS.APPLICATION_WIDTH,HEARTWORKS.APPLICATION_HEIGHT);
		
		public var tool_shape:DynamicSprite = new DynamicSprite();
		public var tool_container:DynamicSprite = new DynamicSprite();
		
		public var tool_baked:Boolean = false;
		
		var tool_toggle_b:Boolean = false;
		
		var uID:int;
	
		var cutout_color:int;
		
		var tool_original_color:int;
	
	
	
		
	public function Tool(id:int, tooltype:String, button:Sprite, button_icon:DynamicSprite,toolNumber:int):void {
		
		ToolType = tooltype;
		uID = id;
		
		toolnumber = toolNumber;
		
		tool_button = button;

		tool_button_icon = button_icon;
		
		trace(tool_button_icon + "button!");
		
		trace(uID +"uid");
		
		trace(ToolType);
		
		this.mouseEnabled = false;
		this.mouseChildren = false;
	}
	
	
	public function TOOL_RESET():void{
	
	//this.setRegistration(0, 0);
	//this.setRegistration(TS.SessionSupport.mouseX, TS.SessionSupport.mouseY);
	this.x = 0;
	this.y = 0;
	tool_colorTransform = new ColorTransform();
	if (ToolType!="shape"){
	tool_button_icon.graphics.clear();
	tool_button.removeChild(tool_button_icon);
	tool_button_icon = new DynamicSprite();
	tool_button.addChild(tool_button_icon);
	var a:Shape = tool_button.getChildAt(0) as Shape 
	a.graphics.clear();
	tool_button.getChildAt(1).transform.colorTransform = tool_colorTransform;
	tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
	}
	tool_color = 0x000000;
	tool_opacity = 1;
	tool_rotation = 0;
	tool_size = 1;
	tool_rotation_velocity = 0;
	tool_shape.graphics.clear();
	//tool_shape = null;
	tool_shape = new DynamicSprite();
	tool_container = new DynamicSprite();
	tool_baked = false;
	this.filters = null;
	tool_shape.filters = undefined;
	tool_blur = 0;
	//tool_container.x2 = 0;
	//tool_container.y2 = 0;
	
	graphicsData = new Vector.<IGraphicsData>();
	
	tool_button_icon.filters = undefined;
	
	if(this.ToolType=="shape"){
	tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
	}
	
	Coords = new Array();
	playPosition = 0;
	
	TOOL_TOGGLE();
	TOOL_TOGGLE();
	
	}
	
	
	public function TOOL_SOFT_RESET():void{
		
	tool_colorTransform = new ColorTransform();
	tool_shape.transform.colorTransform = tool_colorTransform;
	
	tool_color = 0x000000;
	
	tool_button_icon.filters = undefined;
	
	tool_size = 1;
	tool_rotation_velocity = 0;
	this.filters = null;
	tool_blur = 0;
	
	tool_shape.rotation2 = 0;
	tool_shape.rotation = 0;
	tool_button_icon.rotation2 = 0;
	tool_rotation = 0;
	
	tool_opacity = 1;
	
	var a:Shape = tool_button.getChildAt(0) as Shape 
	a.graphics.clear();
	
	if(this.ToolType!="shape"){
	
	tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
	tool_colorTransform.color = tool_original_color;
	tool_button.getChildAt(1).transform.colorTransform = tool_colorTransform;
	this.alpha = Math.abs(tool_opacity);
	}
			
	if (this.ToolType=="shape"){
	tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
	tool_shape.alpha = Math.abs(tool_opacity);
	tool_shape.filters = undefined;
	}
	
	if (this.ToolType=="cutout"){
	tool_colorTransform.color = cutout_color;
	tool_button.getChildAt(1).transform.colorTransform = tool_colorTransform;
	tool_button.getChildAt(3).transform.colorTransform = new ColorTransform();
	}
			
	//set canvasobject alpha
	tool_bitmap_colorTransform = new ColorTransform();
	tool_bitmap_colorTransform.alphaMultiplier = Math.abs(tool_opacity);
	
	
	if (tool_motion_playback==true){
		
	tool_container.setRegistration(TS.mouseX, TS.mouseY);
	Coords.length = 0;
	playPosition = 0;
	TS.removeEventListener(Event.ENTER_FRAME, Playback);
	
	tool_container.x2 = TS.mouseX;
	tool_container.y2 = TS.mouseY;
		
	}
	
	TS.Console.msg(ToolType + " tool #"+toolnumber+" reset softly ");
	
	
	tool_shape.scaleX2 = 1;
	tool_shape.scaleY2 = 1;
	
	TOOL_UI_CONTROLS_SETUP();
	
	
	}
	
	
	public function TOOL_TOGGLE():void {
	
	tool_toggle_b=!tool_toggle_b;

		
	if (tool_toggle_b==true) {
		
	if (Users[uID].CurrentTool != undefined)	{
	//Users[uID].PreviousTool = Users[uID].CurrentTool;
	}
	
	
	
	
	if(tool_baked==false){TS.Console.msg(ToolType + " tool #"+toolnumber+" enabled ");}
	else if(tool_baked==true){
	TS.Console.msg(ToolType + " tool #"+toolnumber+" enabled ");
	TS.Tutorial.Message(4);}
	
	
	trace("tool " +ToolType+" is  turned ON!");
	
	if (ToolType != "shape"){
	
	//Users[uID].user_tools_container_box.removeChild(this);
	Users[uID].user_tools_container_box.addChild(this);  // this sets this tool to top layer when it is turned on
	trace(Users[uID].user_tools_container_box.getChildIndex(this) +" this index");
	
	Users[uID].CurrentTool = Users[uID].user_tools_container_box.getChildAt(Users[uID].user_tools_container_box.numChildren-1);
	
	TOOL_UI_CONTROLS_SETUP();
	
	}
	
	tool_button.alpha = 1;
	
	//tool_index = Users[uID].user_tools_container_box.getChildIndex(this);
	
	//0,1,2,3
	
	// order the indeces
	
	trace(tool_index +"tool index!!!!!");
	
	if (ToolType == "stamp"){
	TS.SessionUI.ui_side_bar.addChildAt(TS.SessionUI.tool_opacity_slider_bar, 1);
	}
	
	/*var one = Users[uID].user_tools_container_box.getChildAt(1) as Tool
	var two = Users[uID].user_tools_container_box.getChildAt(2) as Tool
	var three = Users[uID].user_tools_container_box.getChildAt(3) as Tool
	var four = Users[uID].user_tools_container_box.getChildAt(4) as Tool
	
	one.tool_button.y = TS.SessionUI.ui_toolspace_4;
	two.tool_button.y = TS.SessionUI.ui_toolspace_3;
	three.tool_button.y = TS.SessionUI.ui_toolspace_2;
	four.tool_button.y = TS.SessionUI.ui_toolspace_1;*/
	
	TS.motionLine.graphics.clear();
	
	
	if (tool_baked==true) {
		
	tool_container.addChild(tool_shape);	
	this.addChild(tool_container);
	
	
	
	
	if (ToolType == "cutout"){
	TS.SessionUI.ui_side_bar.addChildAt(TS.SessionUI.tool_opacity_slider_bar, 1);
	}
	
	
	if (tool_motion_playback == true){
	TS.addEventListener(Event.ENTER_FRAME, Playback);
	}
	
	// sets mouse states
	if (uID == 0){
	TS.MyUserInput.MOUSE_MOVE_NORMAL();
	Users[0].MOUSE_MOVE = TS.MyUserInput.MOUSE_MOVE_NORMAL;
	Users[0].MOUSE_DOWN = TS.MyUserInput.MOUSE_DOWN_NORMAL;
	Users[0].MOUSE_UP = TS.MyUserInput.MOUSE_UP_NORMAL;
	Users[0].MOUSE_DOUBLE_CLICK = MYUSER_TOOL_SET_ROTATION_POINT;   // double click to free, click to set
	}
	else if (uID != 0){ 
	Users[uID].MOUSE_MOVE = TOOL_DRAWING;
	Users[uID].MOUSE_DOWN = TOOL_DRAW_START;
	Users[uID].MOUSE_UP = TOOL_DRAW_STOP;
	Users[uID].MOUSE_DOUBLE_CLICK = TOOL_SET_ROTATION_POINT;
	}
	
		
		}
		
		
	if (tool_baked==false) {

	graphicsData = new Vector.<IGraphicsData>(); 
	commands = new Vector.<int>();
	data = new Vector.<Number>();
	commandsArray = new Array();
	dataArray = new Array();
	
	TS.current_color = 0;
	tool_color = 0;
	
	TS.MyUser.UserCursor.sidebarColor();
	
	if(ToolType == "stamp"){	
	TS.Tutorial.Message(2);	
	}
	
	if(ToolType == "cutout"){	
	TS.Tutorial.Message(3);	
	}
	
	if (ToolType=="shape"){
		
		//Users[uID].user_tools_container_box.removeChild(this);
		//Users[uID].user_tools_container_box.addChildAt(this, (Users[uID].user_container_tools.numChildren));
		//Users[uID].user_container_tools.addChildAt(this, 1);
		tool_container.addChild(tool_shape);	
		TS.SessionSupport.addChildAt(tool_container, 1);
		tool_shape.setRegistration(HEARTWORKS.APPLICATION_WIDTH/2,HEARTWORKS.APPLICATION_HEIGHT/2);
		
		
		}
	
	
	if (ToolType!="shape"){

	//TS.SessionSupport.addChild(tool_container);
	//tool_container.addChild(tool_shape);
	tool_container.addChild(tool_shape);	
	
	
	if(TS.numChildren==9){
	TS.addChildAt(tool_container,3);
	}
	else if(TS.numChildren==10){
	TS.addChildAt(tool_container,4);
	}
	else if(TS.numChildren==11){
	TS.addChildAt(tool_container,5);
	}
	else {
	TS.addChildAt(tool_container,2);
	}
	//TS.MyUser.user_container_tools.addChild(tool_container); // need to fix so that drawing works correctly
	//TS.swapChildrenAt(2,1); 
	
	}
	
	tool_container.mouseEnabled = false;
	tool_container.mouseChildren = false;
	tool_shape.mouseEnabled = false;
	tool_shape.mouseChildren = false;
	
	
	if (uID == 0){
	Users[0].MOUSE_MOVE = TS.MyUserInput.MOUSE_MOVE_NORMAL;
	Users[0].MOUSE_DOWN = TS.MyUserInput.MOUSE_DOWN_NORMAL;
	Users[0].MOUSE_UP = TS.MyUserInput.MOUSE_UP_NORMAL;
	TS.addEventListener(MouseEvent.MOUSE_DOWN, MYUSER_TOOL_MAKING_START); // need to add on completion
	
		
	}
	else if (uID != 0){
	Users[uID].MOUSE_MOVE = TOOL_MAKING;
	Users[uID].MOUSE_DOWN = TOOL_MAKING_START;
	Users[uID].MOUSE_UP = TOOL_MAKING_STOP;
	Users[uID].MOUSE_DOUBLE_CLICK = TOOL_MAKING_DONE;
	}
	
		
		
		
	}
		
	}
	
	
	
	else if (tool_toggle_b==false)
	
		{
			
	
	TS.removeEventListener(Event.ENTER_FRAME, MYUSER_TOOL_MAKING);
			
			
	if (ToolType == "stamp"){
		
	trace(ToolType);	
	//TS.SessionUI.tool_opacity_slider_bar.visible=true;
		
	}
	
	
	
			
	if (ToolType=="cutout"||isCutout==true){
		
	tool_cutout_outline.graphics.clear();
		
	}
			
	tool_button.alpha = 0.2;
			
	var rect:Rectangle = new Rectangle(0,0,HEARTWORKS.APPLICATION_WIDTH,HEARTWORKS.APPLICATION_HEIGHT);
	TS.SessionSupport.support_main_bitmap_content.copyPixels(TS.SessionSupport.support_1_bitmap_content,rect,rect.topLeft,null,null,true);
    //TS.SessionSupport.support_main_bitmap_content.copyPixels(TS.SessionSupport.support_2_bitmap_content,rect,rect.topLeft,null,null,true);
	//TS.SessionSupport.support_main_bitmap_content.copyPixels(TS.SessionSupport.support_3_bitmap_content,rect,rect.topLeft,null,null,true);
	//TS.SessionSupport.support_main_bitmap_content.copyPixels(TS.SessionSupport.support_4_bitmap_content,rect,rect.topLeft,null,null,true);
	TS.SessionSupport.support_1_bitmap_content.fillRect(rect,0x00000000);
	//TS.SessionSupport.support_2_bitmap_content.fillRect(rect,0x00000000);
	//TS.SessionSupport.support_3_bitmap_content.fillRect(rect,0x00000000);
	//TS.SessionSupport.support_4_bitmap_content.fillRect(rect,0x00000000);

	if (tool_baked==false){
	tool_shape.graphics.clear();
	TS.removeEventListener(MouseEvent.MOUSE_DOWN, MYUSER_TOOL_MAKING_START);
	TS.removeEventListener(MouseEvent.MOUSE_UP, MYUSER_TOOL_MAKING_STOP);
	TS.removeEventListener(Event.ENTER_FRAME, MYUSER_TOOL_MAKING);
	
	
	
	if(TS.MyUser.UserCursor.contains(TS.MyUser.UserCursor.colordot)){
		TS.MyUser.UserCursor.removeChild(TS.MyUser.UserCursor.colordot);
		}
	
	}
	
	//tool_color = 0;
	//:voidTS.current_color = tool_color;
	

	if (tool_motion_playback == true){
	TS.removeEventListener(Event.ENTER_FRAME, Playback);
	}
	
	if(TS.MyUser.tool_motion==true){
	TS.removeEventListener(Event.ENTER_FRAME, Playback);
	tool_container.setRegistration(TS.mouseX, TS.mouseY);
	TS.MyUser.tool_motion=false;
	Coords = new Array();
	TS.motionLine.graphics.clear();
	tool_motion_check=false;
	tool_container.x2 = TS.mouseX;
	tool_container.y2 = TS.mouseY;
	}

	if (this.contains(tool_container)){
	this.removeChild(tool_container);
	}
	
	if (TS.contains(tool_container)){
	TS.removeChild(tool_container);
	}
	
	if (ToolType != "shape"){
	Users[uID].user_tools_container_box.removeChild(this);
	}
	
	//this would need to be changed...
	if (Users[uID].user_tools_stamp1.tool_toggle_b==true || Users[uID].user_tools_stamp2.tool_toggle_b==true || Users[uID].user_tools_cutout1.tool_toggle_b==true || Users[uID].user_tools_cutout2.tool_toggle_b==true) {
	Users[uID].CurrentTool = Users[uID].user_tools_container_box.getChildAt(Users[uID].user_tools_container_box.numChildren-1) as Tool;
	TOOL_UI_CONTROLS_SETUP();
	
	}
	else if (Users[uID].user_tools_shape.tool_toggle_b==true){
		
	Users[uID].CurrentTool = Users[uID].user_tools_shape;
	TOOL_UI_CONTROLS_SETUP();
	
	
	
	}
	
	if (Users[uID].user_tools_stamp1.tool_toggle_b==false && Users[uID].user_tools_stamp2.tool_toggle_b==false && Users[uID].user_tools_cutout1.tool_toggle_b==false && Users[uID].user_tools_cutout2.tool_toggle_b==false && Users[uID].user_tools_shape.tool_toggle_b==false) {
		
		Users[uID].CurrentTool = undefined;
		TS.SessionUI.ui_side_bar_tool_marker.graphics.clear();
		
		if(Users[uID].user_tools_stamp1.tool_baked==false&&Users[uID].user_tools_cutout1.tool_baked==false){
		TS.Tutorial.Message(1);
		} else { TS.Tutorial.NoMessage(); }
		
		if (TS.SessionUI.ui_side_bar.contains(TS.SessionUI.tool_opacity_slider_bar))
				
				{ TS.SessionUI.ui_side_bar.removeChild(TS.SessionUI.tool_opacity_slider_bar); }
		
	}
	
	
	
	
	
	
	trace("tool " +ToolType+" is turned off");
	TS.Console.msg(ToolType + " tool #"+toolnumber+" disabled");
	
	
	
	// sets mouse states
	if (uID == 0){
	Users[0].MOUSE_MOVE = TS.MyUserInput.MOUSE_MOVE_NORMAL;
	Users[0].MOUSE_DOWN = TS.MyUserInput.MOUSE_DOWN_NORMAL;
	Users[0].MOUSE_UP = TS.MyUserInput.MOUSE_UP_NORMAL;
	Users[0].MOUSE_DOUBLE_CLICK = TS.MyUserInput.MOUSE_DOUBLE_CLICK_NORMAL;
	}
	else if (uID != 0){
	Users[uID].MOUSE_MOVE = Users[uID].MOUSE_MOVE_NORMAL;
	Users[uID].MOUSE_DOWN = Users[uID].MOUSE_DOWN_NORMAL;
	Users[uID].MOUSE_UP = Users[uID].MOUSE_UP_NORMAL;
	Users[uID].MOUSE_DOUBLE_CLICK = Users[uID].MOUSE_DOUBLE_CLICK_NORMAL;
	}
	
		}
		
		
	}
	
	var graphicsData:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
	
	var overlay_graphicsData:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
	
	var commands:Vector.<int> = new Vector.<int>();
	var data:Vector.<Number> = new Vector.<Number>();

	var commandsArray:Array = new Array();
	var dataArray:Array = new Array();
	
	
	var overlay_commands:Vector.<int> = new Vector.<int>();
	
	var PointsArray:Array = new Array();
	
	var StartingPoint:Point;

	
	function MYUSER_TOOL_MAKING_START(e:MouseEvent){
		
		
		not_drawing = false;
		
		trace("making start");
		
		TS.addEventListener(MouseEvent.MOUSE_UP, MYUSER_TOOL_MAKING_STOP);
		
		Users[0].tool_is_making=true;
		
		// first shape needs to stick to thing then be removed then stick to other thing
		
		
		
		commands = new Vector.<int>();
		data = new Vector.<Number>();
		commandsArray = new Array();
		dataArray = new Array();
		
		
		
		
		tool_shape.graphics.lineStyle(0,0,0);

		
		if (ToolType !="shape"){
		TS.MyUser.CURSOR_POSITION(TS.mouseX,TS.mouseY);
		var point:Point = new Point(Users[0].UserCursorX, Users[0].UserCursorY);
		var poin:Point =new Point(TS.mouseX,TS.mouseY);
		tool_shape.graphics.moveTo(poin.x, poin.y);
		tool_shape.graphics.beginFill(tool_color, Math.abs(tool_opacity));
		
		var beginfill:GraphicsSolidFill = new GraphicsSolidFill(tool_color,tool_opacity);
		graphicsData.push(beginfill);
		
		
		}
		
		
		
		if (ToolType =="shape"){
			
			TS.MyUser.CURSOR_POSITION(TS.mouseX,TS.mouseY);
			var points:Point = new Point(Users[0].UserCursorX, Users[0].UserCursorY);
			var pointy:Point = this.globalToLocal(points);
			tool_shape.graphics.moveTo(TS.mouseX, TS.mouseY);
			tool_shape.graphics.beginFill(tool_color, 1);
			
			
			
			
			
			}
		
		
		if (ToolType=="cutout"||isCutout==true){
			
			StartingPoint = new Point(poin.x,poin.y);
			
			overlay_commands.push(GraphicsPathCommand.MOVE_TO);
			
			//cutout_bitmapdata = new BitmapData(HEARTWORKS.APPLICATION_WIDTH, HEARTWORKS.APPLICATION_HEIGHT);
			rect = new Rectangle(0,0,HEARTWORKS.APPLICATION_WIDTH,HEARTWORKS.APPLICATION_HEIGHT);
			
			cutout_bitmapdata.draw(TS);
			cutout_bitmapdata.fillRect(cutout_bitmapdata.rect,"0xff9900");
			
			
			if(TS.numChildren==9){
			TS.addChildAt(tool_cutout_outline,4);
			}
			else if(TS.numChildren==10){
			TS.addChildAt(tool_cutout_outline,5);
			}
			else if(TS.numChildren==11){
			TS.addChildAt(tool_cutout_outline,6);
			}
			else {
			TS.addChildAt(tool_cutout_outline,3);
			}
			
			
			tool_cutout_outline.visible = false;
			
			tool_cutout_outline.graphics.moveTo(TS.mouseX, TS.mouseY);
			
			//cutout_pattern.setPixel32(0,0,0xFF000000);
			//cutout_pattern.setPixel32(1,1,0xFF000000);
			
			tool_cutout_outline.graphics.beginBitmapFill(cutout_pattern,null,true,false);
			
			tool_shape.graphics.beginBitmapFill(cutout_pattern,null,true,TS.MyUser.user_cutout_smoothing); // fill at double click to avoid a bug
			//tool_shape.visible = false;
			
			var begincutoutfill:GraphicsBitmapFill = new GraphicsBitmapFill(cutout_bitmapdata,null, true, true);
			graphicsData.push(begincutoutfill);
			
			
			
			//DisplayUtils.fitIntoRect(tool_button_icon, area, false, Alignment.TOP_LEFT);
			
			}
			
			
			if (ToolType =="stamp" || ToolType =="cutout"){
				
					commands.push(GraphicsPathCommand.MOVE_TO);
					data.push(TS.mouseX, TS.mouseY);
					commandsArray.push(GraphicsPathCommand.MOVE_TO);
					dataArray.push(TS.mouseX, TS.mouseY);
		
			}
			
			
			
			
			TS.Console.msg("tool drawing");
			
				
		
		// set up UI system and multi-tool system - include fitintorect etc etc...
		
		//set mouse states
		//Users[0].MOUSE_MOVE = Users[0].BLANK;
		TS.addEventListener(MouseEvent.MOUSE_MOVE, MYUSER_TOOL_MAKING);  // POSSIBLY MAKE THIS A FRAME LISTENER?
		
	}
	
	var ppoint:Point = new Point(0,0);
	var shapeppoint:Point = new Point(0,0);
	
	 function MYUSER_TOOL_MAKING(e:MouseEvent){
		
		trace("making");
		
		
		if (ToolType !="shape"){
		//TS.MyUser.CURSOR_POSITION(TS.mouseX,TS.mouseY);
		var point:Point = new Point(Users[0].UserCursorX, Users[0].UserCursorY);
		var poin:Point =  new Point(TS.mouseX,TS.mouseY);
		
		
			tool_shape.graphics.lineTo(poin.x, poin.y);
			commands.push(GraphicsPathCommand.LINE_TO); 
			data.push(TS.mouseX, TS.mouseY);
			commandsArray.push(GraphicsPathCommand.LINE_TO);
			dataArray.push(TS.mouseX, TS.mouseY);
			
			if(ToolType == "cutout"||isCutout==true){
		
			tool_cutout_outline.graphics.lineTo(poin.x,poin.y);
			
			
			var r:int = new int((Math.random()*180)+75);
  			var g:int = new int((Math.random()*180)+75);
  			var b:int = new int((Math.random()*180)+75);
  			var rgb:String = "0xFF"+ r.toString(16)+g.toString(16)+b.toString(16);
			var rC:uint = uint(rgb);
			trace(rgb);
			cutout_pattern.setPixel32(0,0,rC);
			cutout_pattern.setPixel32(1,1,rC);
			
			//tool_cutout_outline.blendMode = BlendMode.DIFFERENCE;
			
			
			TS.SessionSupport.Support_Overlay.mouseEnabled = false;
			TS.SessionSupport.Support_Overlay.mouseChildren = false;
		}
			
		
		
				ppoint = poin;
		
		
		
		}
		
		/*if (ToolType =="shape"){
		TS.MyUser.CURSOR_POSITION(TS.mouseX,TS.mouseY);
		var points:Point = new Point(TS.mouseX,TS.mouseY);
		var pointy:Point = TS.SessionSupport.globalToLocal(points);
		
		if(shapeppoint.x > 799 && pointy.x < 1){
		tool_shape.graphics.clear();
		
		}
		else if(shapeppoint.x < 1 && pointy.x > 799){
		tool_shape.graphics.clear();
		}
		
		else if(shapeppoint.y > 599 && pointy.y < 1){
		tool_shape.graphics.clear();
		}
		else if(shapeppoint.y < 1 && pointy.y > 599){
		tool_shape.graphics.clear();
		}
		else {
		tool_shape.graphics.lineTo(pointy.x, pointy.y);
		}
		
				shapeppoint = pointy;
		
		
		
		
		
		}
		*/
		
		
		
		
	
		
		
		
	}
	
	
	
	function MYUSER_TOOL_MAKING_STOP(e:MouseEvent){
		
		Users[0].tool_is_making=false;
		
		trace("making stop");
		tool_shape.graphics.endFill();
		
		
		//if tool is cutout
		
		if (ToolType=="cutout"||ToolType=="stamp"){
		
		var path:GraphicsPath = new GraphicsPath(commands,data,"evenOdd");
		graphicsData.push(path);
		var endfill:GraphicsEndFill = new GraphicsEndFill();
		graphicsData.push(endfill);
		
		}
		
		if (ToolType =="cutout"||isCutout==true){
			
			
			tool_cutout_outline.graphics.endFill();
			
			
		}
		
		if(ToolType=="shape"){
			
			//TS.SessionSupport.addChild(tool_shape);
			
			//this.addChild(tool_shape);
			//tool_shape.rotation2 = TS.SessionSupport.rotation2;
			//tool_shape.x2 = TS.mouseX;
			//tool_shape.y2 = TS.mouseY;
			
			//var i:int = Users[0].user_container_tools.getChildIndex(this);
			
			tool_bitmap_colorTransform = new ColorTransform();
			
			trace(i + "i");
			
		}
			
			
			
			not_drawing = true;
			drawn_something = true;
			
		
		//set mouse states
		TS.removeEventListener(MouseEvent.MOUSE_MOVE, MYUSER_TOOL_MAKING);
		Users[0].MOUSE_MOVE = TS.MyUserInput.MOUSE_MOVE_NORMAL;
		
		
		
		
	}
	
	
	
	var ptpt:Point;
	
	public function MYUSER_TOOL_MAKING_DONE(){
		
		trace(not_drawing,drawn_something);
		if(not_drawing==true&&drawn_something==true){
	
	//code here
	
		tool_baked=true;
		trace("tool baked!");
		
		TS.Console.msg("tool anchored");
		
		TS.Tutorial.Message(4);
		
		
		if(TS.MyUser.UserCursor.contains(TS.MyUser.UserCursor.colordot)){
		TS.MyUser.UserCursor.removeChild(TS.MyUser.UserCursor.colordot);
		}
											 
		//tool_shape.transform.matrix = TS.SessionSupport.tmatrix;
		
		
		tool_shape.setRegistration(TS.mouseX, TS.mouseY);
		tool_registration = new Point(TS.mouseX, TS.mouseY);
		tool_container.setRegistration(TS.mouseX, TS.mouseY);
		
		
		
		ptpt = new Point(TS.mouseX, TS.mouseY);
		
		//tool_shape.graphics.beginFill(0xFFFFFF,1);
		//tool_shape.graphics.drawCircle(TS.SessionSupport.mouseX, TS.SessionSupport.mouseY, 4);	// FIX THIS SHIT!!!!
		//tool_shape.graphics.endFill();          
		
		//TS.addChildAt(TS.MyUser.user_container_tools,1);
		this.addChild(tool_container);
		tool_container.addChild(tool_shape);
		tool_shape.graphics.clear();
		tool_shape.graphics.drawGraphicsData(graphicsData);
		
		
		
		//tool_shape.rotation2 = TS.SessionSupport.support_rotation;
		//tool_rotation = tool_shape.rotation2;
		trace(this.x, this.y, "this x and y");
		//tool_shape.x2 = TS.SessionSupport.mouseX;
		//tool_shape.y2 = TS.SessionSupport.mouseY;
		
		this.x-=Users[0].UserCursorX;
		this.y-=Users[0].UserCursorY;
		
		trace(TS.SessionSupport_Container.x + "x");
		trace(TS.SessionSupport_Container.y +"y");
		
		//this.x+=TS.SessionSupport_Container.x;
		//this.y+=TS.SessionSupport_Container.y;
		
		
		tool_shape.x2 = TS.mouseX;
		tool_shape.y2 = TS.mouseY;
		
		trace(tool_shape.x);
		trace(tool_shape.y);
		trace(tool_container.x);
		trace(tool_container.y);
		
		
		
		if (ToolType=="cutout"||ToolType=="stamp"){
		
		tool_button_icon.graphics.drawGraphicsData(graphicsData);
		

		var area:Rectangle = new Rectangle(0, 0, 25,25);
		
		DisplayUtils.fitIntoRect(tool_button_icon, area, false, Alignment.TOP_LEFT);
		
		
		var boundsRect:Rectangle;
		boundsRect = tool_button_icon.getBounds(tool_button_icon);
			
		var xx:int = (boundsRect.x+(boundsRect.width/2));
		var yy:int = (boundsRect.y+(boundsRect.height/2));
		
		
		tool_button_icon.setRegistration(xx,yy);
		
		
		
		tool_button_icon.x2 = tool_button_icon.x + 20;
		tool_button_icon.y2 = tool_button_icon.y + 20;
		
		tool_opacity = 1;
		this.alpha = Math.abs(tool_opacity);
		tool_button_icon.alpha = Math.abs(tool_opacity);
		//tool_button_icon.rotation2 = tool_shape.rotation2;
		
		tool_shape_original_width = tool_shape.width;
		tool_shape_original_height = tool_shape.height;
		
		TS.SessionUI.tool_blur_slider_bar.visible=true;
		
		TS.SessionUI.tool_opacity_slider_bar.graphics.clear();
		TS.SessionUI.tool_opacity_slider_bar.graphics.beginFill(0xBBBBBB,1);
		TS.SessionUI.tool_opacity_slider_bar.graphics.drawRect(0,0,Math.abs(TS.MyUser.CurrentTool.tool_opacity)*40,20);
		TS.SessionUI.tool_opacity_slider_bar.graphics.endFill();
		
		if (TS.MyUser.CurrentTool.ToolType != "shape"){
			
			TS.SessionUI.tool_motion_switch.visible = true;
			TS.SessionUI.tool_rotation_wheel.visible = true;
			
		}
		
		}
		

		
		if(ToolType == "cutout"||isCutout==true){
			
			
			
			TS.SessionUI.ui_side_bar.addChildAt(TS.SessionUI.tool_opacity_slider_bar, 1);
			
			TS.SessionSupport.Support_Overlay.visible = false;    //***** is the thing broken??
			
			
			
			tool_cutout_outline.graphics.clear();
			TS.removeChild(tool_cutout_outline);
			
			if(TS.SessionUI.sidebar_toggle==true){
			TS.SessionUI.ui_side_bar.visible = false;
			}
			
			var keyList:Boolean = false;
			
			if(TS.SessionUI.keyList.visible==true){
			TS.SessionUI.keyList.visible=false;
			keyList = true;
			}
			
			var manual:Boolean = false;
			
			if(TS.Manual.visible==true){
			TS.Manual.visible=false;
			manual = true;
			}
			
			TS.MyUser.user_tools_cutout1.tool_cutout_outline.visible=false;
			TS.MyUser.user_tools_cutout2.tool_cutout_outline.visible=false;
			
			TS.CursorsContainer.visible=false;

			//tool_shape.visible=false;
			//TS.cacheAsBitmap = false;
			TS.MyUser.user_container_tools.visible = false;
			cutout_bitmapdata.draw(TS);
			TS.MyUser.user_container_tools.visible = true;
			//tool_shape.visible=true;
			TS.CursorsContainer.visible=true;
			TS.MyUser.user_tools_cutout1.tool_cutout_outline.visible=true;
			TS.MyUser.user_tools_cutout2.tool_cutout_outline.visible=true;
			
			if(TS.SessionUI.sidebar_toggle==true){
			TS.SessionUI.ui_side_bar.visible = true;
			}
			
			if(keyList == true){
			TS.SessionUI.keyList.visible=true;
			}
			
			if(manual == true){
			TS.Manual.visible=true;
			}
			
			
			TS.SessionSupport.Support_Overlay.visible = true;
			
			
			tool_shape.visible = true;
			cutout_color = cutout_bitmapdata.getPixel(mouseX,mouseY);
			tool_colorTransform.color = cutout_color;
			tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
			}
			
			
		tool_original_color = tool_color;
		
		if(ToolType!="cutout"){
		tool_colorTransform.color = tool_original_color;
		}
		tool_button.getChildAt(1).transform.colorTransform = tool_colorTransform;
		
		
		
		//set mouse states
		TS.removeEventListener(Event.ENTER_FRAME, MYUSER_TOOL_MAKING);
		trace("removed!!!!!");
		
		TS.removeEventListener(MouseEvent.MOUSE_DOWN, MYUSER_TOOL_MAKING_START);
		TS.removeEventListener(MouseEvent.MOUSE_UP, MYUSER_TOOL_MAKING_STOP);
		Users[0].MOUSE_DOUBLE_CLICK = TS.MyUserInput.MOUSE_DOUBLE_CLICK_NORMAL;
		Users[0].MOUSE_MOVE = TS.MyUserInput.MOUSE_MOVE_NORMAL;
		Users[0].MOUSE_DOWN = TS.MyUserInput.MOUSE_DOWN_NORMAL;
		Users[0].MOUSE_UP = TS.MyUserInput.MOUSE_UP_NORMAL;
		
	
	
	
	
		}
	
	}





		
	public function TOOL_ROTATE(u:USER){
		
			if(this == Users[uID].CurrentTool&&tool_baked==true){
		
			var tool_rotation_newx = TS.PMouseX;
			
			if(tool_rotation_oldx - tool_rotation_newx > 0){
			tool_rotation_velocity-=0.31;
			}
			
			else if (tool_rotation_oldx - tool_rotation_newx < 0){
			tool_rotation_velocity+=0.31;
			}

			tool_rotation_oldx = tool_rotation_newx;
			
			}
			
			
			var p:Number = Math.abs(tool_rotation_velocity);
			
			if (tool_toggle_b == true && p <= 2){
				
			var n:int;
			n = tool_shape.rotation2;
			if(tool_shape.rotation2 < 0){
			n = 360 - Math.abs(tool_shape.rotation2);
			}
			
			TS.Console.msg(ToolType + " #"+toolnumber+" angle "+n+"˚");
			
			}
			else if (tool_toggle_b == true && p >= 2){
			var s:String = (Math.abs(tool_rotation_velocity)-2).toString();
			s = s.slice(0,4);
			TS.Console.msg(ToolType + " #"+toolnumber+" rotational velocity "+s);
			}
			
			
			
		
	}
	
	
	
	public function TOOL_SPIN(u:USER){
		
			//if(this == Users[uID].CurrentTool){
		
		    var pv:Number = Math.abs(tool_rotation_velocity);
			
			
			if (tool_rotation_velocity != 0) {
			tool_rotation_velocity *= tool_rotation_drag;
			tool_rotation+=tool_rotation_velocity; 
			TS.SessionUI.tool_rotation_wheel.rotation = tool_rotation;
			}
			
			if (Math.abs(tool_rotation_velocity) >= 2 && tool_rotation_drag < 1.0) {    
			tool_rotation_drag += 0.001;
			}
			
			if (Math.abs(tool_rotation_velocity) <= 2 && tool_rotation_drag > 0.92) {
			tool_rotation_drag -= 0.001;
			
			}
			
			if(tool_rotation_drag < 0.92){
			tool_rotation_drag = 0.92;
			}
			
			trace(tool_rotation_drag);
			
			
			if (tool_rotation_velocity == 0){
				tool_rotation_velocity = 0.0;
			}
			
			if (tool_rotation > 360 || tool_rotation < -360){
			
			tool_rotation = 0;
				
			}
			
			if (tool_shape.rotation > 360){
			
			tool_shape.rotation -= 360;
				
			} else if (tool_shape.rotation < -360){
			
			tool_shape.rotation += 360;
				
			}
			
			var tool_shape_rotation:int = tool_rotation;
			
			tool_shape.rotation2 = tool_shape_rotation;
			
			tool_shape.x2 = ptpt.x;
			tool_shape.y2 = ptpt.y;
			
			
			
			//button stuff
			
			
			//var area:Rectangle = new Rectangle(0, 0, 25,25);
		
		    //DisplayUtils.fitIntoRect(tool_button_icon, area, false, Alignment.TOP_LEFT);
			
			tool_button_icon.x2 = 20;
			tool_button_icon.y2 = 20;
			
			tool_button_icon.rotation2 = tool_shape.rotation2;
			
			trace(tool_shape.rotation2);
			
			
			
			
			if (u.user_is_drawing==true){
			u.TOOLS_ARE_DRAWING();
			}
			
			//}
		
	}
	
	var nodot:Boolean = false;
	var tool_shape_original_width:Number;
	var tool_shape_original_height:Number;
	var w:Number;
	var h:Number;
	
	public function TOOL_SIZER(u:USER){
		
			if(this == Users[uID].CurrentTool && ToolType!="shape" &&tool_baked==true){
			
			if (tool_size_bigorsmall == true){
			
			
			tool_size+=1;
			
			//tool_shape.width+=1;
			//tool_shape.height+=1;
			
			
			
			
			}
			
			if (tool_size_bigorsmall == false){
			//tool_shape.width-=1;
			//tool_shape.height-=1;
			
			tool_size-=1;
			
			
			}
			
			
			if (tool_shape.width < 10 || tool_shape.height < 10){
				
				Users[0].UserCursor.noDotCursor();
				nodot=true;
			
			}
			
			if (nodot==true){
				if (tool_shape.width > 10 || tool_shape.height > 10){
				
					Users[0].UserCursor.DotCursor();
					nodot==false;
			
				}
			}
			
			
			
			//tool_shape.scaleX2 = (tool_shape.width + tool_size)/100;
			//tool_shape.scaleY2 = (tool_shape.height + tool_size)/100;
			
			
			var w=tool_shape.width;
			var h=tool_shape.height;
			
			//trace(w,h);
			
			//tool_shape.width = tool_size;
			//tool_shape.height = tool_size;
				
				
			
			//tool_shape.scaleX2 = tool_shape.scaleX2 * ((w+tool_size;
			//tool_shape.scaleY2 = tool_shape.scaleY2 * ((h+tool_size);
			
			tool_shape.scaleX2 = 1 + ((tool_size / tool_shape_original_width) - ((10/64)/100));
			tool_shape.scaleY2 = 1 + ((tool_size / tool_shape_original_width) - ((10/64)/100));
			
			trace(tool_shape.scaleX2,tool_shape.scaleY2);
			
			//tool_shape.width  = tool_size;
			//tool_shape.height = tool_size;
			
			
			
			
			
			//tool_shape.x2 = ptpt.x;
			//tool_shape.y2 = ptpt.y;
			
			
			//slider stuff
			
			
			trace(tool_shape.width +"toolshape x");
			trace(tool_shape.height +"toolshape y");
			
			
			TS.Console.msg(ToolType + " #"+toolnumber+" size "+tool_shape.width);
			
			//set tool_shape x to normal
			
			
			}
	
	}
	
	
	
	public function TOOL_OPACIFIER(u:USER){
		
			if(this == Users[uID].CurrentTool){
		
			if(TS.MyUser.tool_opacifier_increase==true){
			tool_opacity+=0.01;
			}
			else if(TS.MyUser.tool_opacifier_increase==false){
			tool_opacity-=0.01;
			}
			
			if (tool_opacity > 1) {
			tool_opacity = 1;
			}
			
			if (tool_opacity < 0) {
			tool_opacity = 0;
			}
			
			
			TS.Console.msg(ToolType + " #"+toolnumber+" opacity "+Math.round(tool_opacity*100));
			
			
			if (this.ToolType=="shape"){
			tool_colorTransform.alphaMultiplier = tool_opacity;
			tool_shape.transform.colorTransform = tool_colorTransform;
			
			
			//TS.session_opacity = tool_opacity;
			
			TS.SessionUI.support_opacity_slider_bar.graphics.clear();
			TS.SessionUI.support_opacity_slider_bar.graphics.beginFill(0xBBBBBB,Math.abs(tool_opacity));
			TS.SessionUI.support_opacity_slider_bar.graphics.drawRect(0,0,Math.abs(tool_opacity)*40,20);
			TS.SessionUI.support_opacity_slider_bar.graphics.endFill();
			
			tool_shape.alpha = Math.abs(tool_opacity);
			tool_button_icon.alpha = Math.abs(tool_opacity);
			
			}
			
			if(this.ToolType!="shape"){
			this.alpha = Math.abs(tool_opacity);
			tool_button_icon.alpha = Math.abs(tool_opacity);
			}
			
			
			
			
			TS.SessionUI.tool_opacity_slider_bar.graphics.clear();
			TS.SessionUI.tool_opacity_slider_bar.graphics.beginFill(0xBBBBBB,Math.abs(tool_opacity));
			TS.SessionUI.tool_opacity_slider_bar.graphics.drawRect(0,0,Math.abs(tool_opacity)*40,20);
			TS.SessionUI.tool_opacity_slider_bar.graphics.endFill();
			
			
			//set canvasobject alpha
			tool_bitmap_colorTransform = new ColorTransform();
			tool_bitmap_colorTransform.alphaMultiplier = Math.abs(tool_opacity);
			
			
			
			if (tool_baked==false){
			TS.MyUser.UserCursor.sidebarColor();
			}
			
			
			}
	
	}
	
	var backer:Shape = new Shape();
	
	
	public function TOOL_BLURIFIER(u:USER){
		
			if(this == Users[uID].CurrentTool){
		
			backer.graphics.clear();
			
			tool_blur+=0.3;
			
			if (tool_blur > 20) {
			tool_blur = -20;
			}
			
			if (tool_blur < -20) {
			tool_blur = 20;
			}
			
			tool_blur_filter = new BlurFilter(Math.abs(tool_blur),Math.abs(tool_blur),2);
			this.filters = [tool_blur_filter];
			
			if (ToolType=="shape"){
			tool_shape.filters = [tool_blur_filter];
			}
			
			tool_button_icon.filters = [tool_blur_filter];
			
			
			TS.SessionUI.tool_blur_slider_bar.graphics.clear();
			TS.SessionUI.tool_blur_slider_bar.graphics.beginFill(0xBBBBBB,1);
			TS.SessionUI.tool_blur_slider_bar.graphics.drawRect(0,0,(Math.abs(tool_blur)/20)*40,6);
			TS.SessionUI.tool_blur_slider_bar.graphics.endFill();

			
			// remove blur on reset etc.
			
			tool_shape.addChildAt(backer, 0);
			
			backer.graphics.drawRect(tool_shape.x2-this.width, tool_shape.y2-this.height, this.width*2, this.height*2);
			backer.visible = false;
			this.cacheAsBitmap = true;
			
			if(tool_shape.width > 250){
				
				tool_shape.removeChild(backer);
				backer.graphics.clear();
			}
			
			}
	
	}
	
	
	public function TOOL_UI_CONTROLS_SETUP() {
		
		/*TS.SessionUI.tool_blur_slider_bar.graphics.clear();
		TS.SessionUI.tool_blur_slider_bar.graphics.beginFill(0xBBBBBB,1);
		TS.SessionUI.tool_blur_slider_bar.graphics.drawRect(0,0,(Math.abs(TS.MyUser.CurrentTool.tool_blur)/20)*40,6);
		TS.SessionUI.tool_blur_slider_bar.graphics.endFill();*/
		
		
	
	if (Users[uID].CurrentTool.ToolType == "stamp"){
	trace("added");
	TS.SessionUI.ui_side_bar.addChildAt(TS.SessionUI.tool_opacity_slider_bar, 1);
	}
	
	if (Users[uID].CurrentTool.ToolType == "cutout" && Users[uID].CurrentTool.tool_baked == true){
	TS.SessionUI.ui_side_bar.addChildAt(TS.SessionUI.tool_opacity_slider_bar, 1);
	} else  if (Users[uID].CurrentTool.ToolType == "cutout" && Users[uID].CurrentTool.tool_baked == false && TS.SessionUI.ui_side_bar.contains(TS.SessionUI.tool_opacity_slider_bar))
				
				{ TS.SessionUI.ui_side_bar.removeChild(TS.SessionUI.tool_opacity_slider_bar); }
		
		
		TS.SessionUI.tool_opacity_slider_bar.graphics.clear();
		TS.SessionUI.tool_opacity_slider_bar.graphics.beginFill(0xBBBBBB,1);
		TS.SessionUI.tool_opacity_slider_bar.graphics.drawRect(0,0,Math.abs(TS.MyUser.CurrentTool.tool_opacity)*40,20);
		TS.SessionUI.tool_opacity_slider_bar.graphics.endFill();
		
		//TS.SessionUI.tool_rotation_wheel.rotation = TS.MyUser.CurrentTool.tool_rotation;
		
		/*if (TS.MyUser.CurrentTool.tool_motion_reverse==true){TS.SessionUI.tool_motion_switch.alpha = 1;}
		if (TS.MyUser.CurrentTool.tool_motion_reverse==false){TS.SessionUI.tool_motion_switch.alpha = 0.3;}*/
		
		
		TS.SessionUI.ui_side_bar_tool_marker.graphics.clear();
		TS.SessionUI.ui_side_bar_tool_marker.graphics.lineStyle(1,0x666666,0.3);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.moveTo(15,TS.MyUser.CurrentTool.tool_button.y+20);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.lineTo(10,TS.MyUser.CurrentTool.tool_button.y+20);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.moveTo(56,TS.MyUser.CurrentTool.tool_button.y+20);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.lineTo(61,TS.MyUser.CurrentTool.tool_button.y+20);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.moveTo(35,TS.MyUser.CurrentTool.tool_button.y);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.lineTo(35,TS.MyUser.CurrentTool.tool_button.y-6);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.moveTo(35,TS.MyUser.CurrentTool.tool_button.y+41);
		TS.SessionUI.ui_side_bar_tool_marker.graphics.lineTo(35,TS.MyUser.CurrentTool.tool_button.y+46);
		
		
		if (TS.MyUser.CurrentTool.ToolType =="shape"){
			
			//TS.SessionUI.tool_opacity_slider_bar.visible=true;
			
			//TS.SessionUI.support_opacity_slider_bar.graphics.clear();
			//TS.SessionUI.support_opacity_slider_bar.graphics.beginFill(0xBBBBBB,1);
			//TS.SessionUI.support_opacity_slider_bar.graphics.drawRect(0,0,Math.abs(TS.MyUser.CurrentTool.tool_opacity)*40,20);
			//TS.SessionUI.support_opacity_slider_bar.graphics.endFill();
			
			/*TS.SessionUI.tool_motion_switch.visible = false;
			TS.SessionUI.tool_rotation_wheel.visible = false;*/
			
		}
		
		
	}
	
	
	public var tool_blur_filter:BlurFilter;
	
	
	
		public function TOOL_COLORIZER(color:int){
			
			tool_color = color;
		
			var a:Shape = tool_button.getChildAt(0) as Shape;
			var colorarray:Array = TS.SessionUI.HexToRGB(color);
			var hsvarray:Array = TS.SessionUI.RGBtoHSV(colorarray[0],colorarray[1],colorarray[2]);
		
			if (tool_baked==true){
				
			tool_colorTransform.color = color;
			tool_shape.transform.colorTransform = tool_colorTransform;
			tool_button.getChildAt(1).transform.colorTransform = tool_colorTransform;
			tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
			
			if(ToolType=="cutout"){
			tool_button.getChildAt(3).transform.colorTransform = tool_colorTransform;
			}
			//trace(color);
			
			}
			
			if (ToolType=="shape"){
			tool_colorTransform = new ColorTransform();
			tool_colorTransform.alphaMultiplier = Math.abs(tool_opacity);
			tool_colorTransform.color = tool_color;
			
			tool_shape.transform.colorTransform = tool_colorTransform;
			tool_shape.alpha = Math.abs(tool_opacity);
			tool_button.getChildAt(2).transform.colorTransform = tool_colorTransform;
			}
			
			
			if(hsvarray[1] < 50 && hsvarray[2]>50){
				
			a.graphics.clear();
			a.graphics.beginFill(0x000000,0.5);
			a.graphics.drawRect(0,0,40,40);
			a.graphics.endFill();
				
			}
			
			if(hsvarray[1] > 50 || hsvarray[2]<50){
			a.graphics.clear();
			}
			
			trace(hsvarray[2]);
			
			
			
			
			
			
			
	}
	
	
	// first custom cutout tool not functioning (doesnt stick??)
	// reset rotation on pressing 5
	
	
	
	public function COLOR_PICKER(){
	
	var nm:Matrix = new Matrix();
	
	//nm.translate(TS.SessionSupport_Container_Container.x,TS.SessionSupport_Container_Container.y);
	
	if (tool_baked==true){
		
	TS.MyUserInput.COMBINE_SUPPORT_BUFFER();
	
	var bmd:BitmapData = new BitmapData(HEARTWORKS.APPLICATION_WIDTH, HEARTWORKS.APPLICATION_HEIGHT,false,TS.background_color);
	
	TS.MyUser.user_container_tools.visible = false;
	bmd.draw(TS,nm);
	TS.MyUser.user_container_tools.visible = true;
	
	tool_color = bmd.getPixel(TS.mouseX, TS.mouseY);
	TOOL_COLORIZER(tool_color);
	TS.current_color = tool_color;
	}
	
	else if (tool_baked==false) {
	
	//TS.MyUserInput.COMBINE_SUPPORT_BUFFER();
	var bmd:BitmapData = new BitmapData(HEARTWORKS.APPLICATION_WIDTH, HEARTWORKS.APPLICATION_HEIGHT,false,TS.background_color);
	TS.MyUser.user_container_tools.visible = false;
	bmd.draw(TS,nm);
	TS.MyUser.user_container_tools.visible = true;
	bmd.draw(tool_shape);
	tool_color = bmd.getPixel(TS.mouseX, TS.mouseY);
	TOOL_COLORIZER(tool_color);
	TS.current_color = tool_color;
	TS.MyUser.UserCursor.sidebarColor();

	
		
	}
		
	}
	
	
	
	public function TOOL_MOTION_START_DRAWING(u:USER){
		
		if(tool_baked==false || ToolType=="shape"){trace("nothing");}
		
		else if(tool_baked==true){
		
		//if(u.user_tools_container_box.getChildIndex(this) == 3){
		trace("33333333333333333");
				
		if (tool_motion_check==true){
			graphix.lineTo(TS.mouseX, TS.mouseY);
			//Coords.push(new Point(TS.mouseX,TS.mouseY));
			Coords.push(new Point(TS.mouseX,TS.mouseY));
		}
		
		
		if (tool_motion_check==false){
			
		tool_container.setRegistration(TS.mouseX, TS.mouseY);
		Coords.length = 0;
		playPosition = 0;
		TS.removeEventListener(Event.ENTER_FRAME, Playback);
		graphix = TS.motionLine.graphics;
		TS.addChildAt(TS.motionLine,TS.numChildren);
		//TS.motionLine.rotation=u.user_tools_container_box.rotation2;
		graphix.lineStyle(3,0x9965ff,1);
		graphix.moveTo(TS.mouseX, TS.mouseY);
		//Coords.push(new Point(u.user_tools_container_box.mouseX,u.user_tools_container_box.mouseY));
		Coords.push(new Point(TS.mouseX, TS.mouseY));
		tool_motion_check=true;
		
		TS.Console.msg(ToolType + " #"+toolnumber+" recording path");
			
		}
				
		}
		//}
	}


		
	public function TOOL_MOTION_IS_FINISHED(){
		
		if (tool_baked==false){trace("nothing");}
					
		else if (tool_baked==true){

		tool_motion_check=false;
		if (tool_motion_playback==true){tool_motion_playback=false;}
		if (tool_motion_playback==false){tool_motion_playback=true;}
		TS.motionLine.graphics.clear();
		i = Coords.length-1;
				
		TS.addEventListener(Event.ENTER_FRAME, Playback);
		
		TS.Console.msg(ToolType + " #"+toolnumber+" path recorded");
		
					
		}
					
		}
		
		
		
		
		
		var qqq:Point = new Point(0,0);
		
		var tool_registration:Point = new Point(0,0);
		
		
	public function Playback(event:Event):void {		
	
		
		if (TS.MyUser.user_is_drawing==true){
			
			TS.MyUser.TOOLS_ARE_DRAWING();
			
		}
			

	
			if (tool_motion_playback == true){
		
				trace(playPosition + "  playPosition");
				trace(Coords.length + "  coordslength");
				
				
						if (Coords.length < 8){
							
							
							tool_motion_playback = false;
							TS.MyUser.disablePos = false;
							TS.removeEventListener(Event.ENTER_FRAME, Playback);
							TS.Console.msg(ToolType + " #"+toolnumber+" path removed");
							
						}
				
						
		
						if (playPosition == Coords.length-1 && tool_motion_reverse==true && tool_motion_playback==true) {
							
							trace(i);
							//graphix.lineStyle(3,0xffff00);
							
							//var ppp:Point = new Point(Coords[i].x,Coords[i].y);
							
							var ppp:Point = new Point(Coords[i].x,Coords[i].y);
							
							
							
							trace(ppp.x);
							
							
							trace(ppp);
							
							tool_container.x2 = ppp.x;
							tool_container.y2 = ppp.y;
							
							
							//trace(ppp.x,ppp.y);
							
							var f:Point = new Point(TS.MyUser.user_tools_container_box.x - tool_registration.x, TS.MyUser.user_tools_container_box.y - tool_registration.y);
							
							ppp = this.localToGlobal(ppp);
							
							
							
							
							//graphix.lineTo(ppp.x,ppp.y);	
							
							ppp.x = (ppp.x - f.x);
							ppp.y = (ppp.y - f.y);
							
							
							if (TS.MyUser.user_line_mode==true){
							n = Point.distance(ppp,qqq);
							motion_line(ppp,qqq);
							}
							
							
							i--;
							qqq = ppp;
							
							
							
							
							if (i < 0){playPosition = 0; i = Coords.length-1;}
							else{
								
								
							}
							
						}
						
						if (playPosition == Coords.length-1 && tool_motion_reverse==false) {
							
							playPosition = 0;
							
							
						}
						
						
						
						else if (playPosition != Coords.length-1 &&Coords.length!=0) {
		
						
						
						
						var ppp:Point = new Point(Coords[playPosition].x,Coords[playPosition].y);
						
						
						
						
							
						trace(ppp);
						
						
						
						tool_container.x2 = ppp.x;
						tool_container.y2 = ppp.y;
						
						var f:Point = new Point(TS.MyUser.user_tools_container_box.x - tool_registration.x, TS.MyUser.user_tools_container_box.y - tool_registration.y);
						
						ppp = this.localToGlobal(ppp);
						
						
						
		
						
						
						
						ppp.x = (ppp.x - f.x);
						ppp.y = (ppp.y - f.y);
						
						
						
						
						
						
						
						if (TS.MyUser.user_line_mode==true && playPosition > 0){
						n = Point.distance(ppp,qqq);
						motion_line(ppp,qqq);
						}
						
						playPosition++;
						qqq = ppp;
						
						
						
					}
					
					
					
					
					
					}
					
					
					
					
					
					
		






	var n:Number;
	var nP:Point;
	
	
	
	function motion_line(a:Point,b:Point){
		
		
		if (Users[0].user_is_drawing==true){
		
		a = TS.globalToLocal(a);
		b = TS.globalToLocal(b);
			
			
		
			if (n > 0) {
			
			trace(n + "n");
			trace("HI!");
			
			for(var e:int = (n/1); e > 0; e--){
				
			nP = Point.interpolate(b,a,e/(n/1));
			
			
			tool_container.x2 = nP.x;
			tool_container.y2 = nP.y;
			TS.SessionSupport.support_1_bitmap_content.draw(TS.MyUser.user_container_tools, TS.MyUser.scalematrix, null, null, null);
			
		}
		
		
			}
			
			}
		
		
		
	}
	
	
	
	}
	
	
	
	function MYUSER_TOOL_SET_ROTATION_POINT(){
		
	}
	
	
	
	
	
	
	
	
	
	
	
	function TOOL_DRAW_START(){}
	function TOOL_DRAWING(){}
	function TOOL_DRAW_STOP(){}
	function TOOL_SET_ROTATION_POINT(){}
	
	function TOOL_MAKING_START(){}
	function TOOL_MAKING(){}
	function TOOL_MAKING_STOP(){}
	function TOOL_MAKING_DONE(){}
	
	
	
//end package and class	
}	
}