/*
 * Decompiled with CFR 0.152.
 */
package jace;

import jace.Emulator;
import jace.apple2e.MOS65C02;
import jace.config.InvokableAction;
import jace.core.CPU;
import jace.core.Computer;
import jace.core.Debugger;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.core.Utility;
import jace.ui.AbstractEmulatorFrame;
import jace.ui.DebuggerPanel;
import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EmulatorUILogic {
    static Debugger debugger = new Debugger(){

        @Override
        public void updateStatus() {
            EmulatorUILogic.enableDebug(true);
            MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
            EmulatorUILogic.updateCPURegisters(cpu);
        }
    };
    public static List<RAMListener> watches = new ArrayList<RAMListener>();

    public static void updateCPURegisters(MOS65C02 cpu) {
        DebuggerPanel debuggerPanel = Emulator.getFrame().getDebuggerPanel();
        debuggerPanel.valueA.setText(Integer.toHexString(cpu.A));
        debuggerPanel.valueX.setText(Integer.toHexString(cpu.X));
        debuggerPanel.valueY.setText(Integer.toHexString(cpu.Y));
        debuggerPanel.valuePC.setText(Integer.toHexString(cpu.getProgramCounter()));
        debuggerPanel.valueSP.setText(Integer.toHexString(cpu.getSTACK()));
        debuggerPanel.valuePC2.setText(cpu.getFlags());
        debuggerPanel.valueINST.setText(cpu.disassemble());
    }

    public static void enableDebug(boolean b) {
        DebuggerPanel debuggerPanel = Emulator.getFrame().getDebuggerPanel();
        debugger.setActive(b);
        debuggerPanel.enableDebug.setSelected(b);
        debuggerPanel.setBackground(b ? Color.RED : new Color(0, 0, 64));
    }

    public static void enableTrace(boolean b) {
        Computer.getComputer().getCpu().setTraceEnabled(b);
    }

    public static void stepForward() {
        EmulatorUILogic.debugger.step = true;
    }

    static void registerDebugger() {
        Computer.getComputer().getCpu().setDebug(debugger);
    }

    public static Integer getValidAddress(String s) {
        try {
            int addr = Integer.parseInt(s.toUpperCase(), 16);
            if (addr >= 0 && addr < 65536) {
                return addr;
            }
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void updateWatchList(final DebuggerPanel panel) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RAMListener oldWatch : watches) {
                    Computer.getComputer().getMemory().removeListener(oldWatch);
                }
                if (panel == null) {
                    return;
                }
                EmulatorUILogic.addWatch(panel.textW1, panel.valueW1);
                EmulatorUILogic.addWatch(panel.textW2, panel.valueW2);
                EmulatorUILogic.addWatch(panel.textW3, panel.valueW3);
                EmulatorUILogic.addWatch(panel.textW4, panel.valueW4);
            }
        });
    }

    private static void addWatch(JTextField watch, final JLabel watchValue) {
        final Integer address = EmulatorUILogic.getValidAddress(watch.getText());
        if (address != null) {
            RAMListener newListener = new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

                @Override
                protected void doConfig() {
                    this.setScopeStart(address);
                }

                @Override
                protected void doEvent(RAMEvent e) {
                    watchValue.setText(Integer.toHexString(e.getNewValue() & 0xFF));
                }
            };
            Computer.getComputer().getMemory().addListener(newListener);
            watches.add(newListener);
            byte b = Computer.getComputer().getMemory().readRaw(address);
            watchValue.setText(Integer.toString(b & 0xFF, 16));
        } else {
            watchValue.setText("00");
        }
    }

    public static void updateBreakpointList(final DebuggerPanel panel) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                debugger.getBreakpoints().clear();
                if (panel == null) {
                    return;
                }
                Integer address = EmulatorUILogic.getValidAddress(panel.textBP1.getText());
                if (address != null) {
                    debugger.getBreakpoints().add(address);
                }
                if ((address = EmulatorUILogic.getValidAddress(panel.textBP2.getText())) != null) {
                    debugger.getBreakpoints().add(address);
                }
                if ((address = EmulatorUILogic.getValidAddress(panel.textBP3.getText())) != null) {
                    debugger.getBreakpoints().add(address);
                }
                if ((address = EmulatorUILogic.getValidAddress(panel.textBP4.getText())) != null) {
                    debugger.getBreakpoints().add(address);
                }
                debugger.updateBreakpoints();
            }
        });
    }

    @InvokableAction(name="BRUN file", category="file", description="Loads a binary file in memory and executes it. File should end with #06xxxx, where xxxx is the start address in hex", alternatives="Execute program;load binary;load program;load rom;play single-load game")
    public static void runFile() {
        Computer.pause();
        JFileChooser select = new JFileChooser();
        select.showDialog(Emulator.getFrame(), "Execute binary file");
        File binary = select.getSelectedFile();
        if (binary == null) {
            Computer.resume();
            return;
        }
        EmulatorUILogic.runFile(binary);
    }

    public static void runFile(File binary) {
        String fileName = binary.getName().toLowerCase();
        try {
            if (fileName.contains("#06")) {
                String addressStr = fileName.substring(fileName.length() - 4);
                int address = Integer.parseInt(addressStr, 16);
                EmulatorUILogic.brun(binary, address);
            } else if (fileName.contains("#fc")) {
                Utility.gripe("BASIC not supported yet");
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Computer.getComputer().getCpu().resume();
    }

    public static void brun(File binary, int address) throws FileNotFoundException, IOException {
        Computer.pause();
        FileInputStream in = new FileInputStream(binary);
        byte[] data = new byte[in.available()];
        in.read(data);
        RAM ram = Computer.getComputer().getMemory();
        for (int i = 0; i < data.length; ++i) {
            ram.write(address + i, data[i], false, true);
        }
        CPU cpu = Computer.getComputer().getCpu();
        Computer.getComputer().getCpu().setProgramCounter(address);
        Computer.resume();
    }

    @InvokableAction(name="Adjust display", category="display", description="Adjusts window size to 1:1 aspect ratio for optimal viewing.", alternatives="Adjust screen;Adjust window size;Adjust aspect ratio;Fix screen;Fix window size;Fix aspect ratio;Correct aspect ratio;")
    public static void scaleIntegerRatio() {
        AbstractEmulatorFrame frame = Emulator.getFrame();
        if (frame == null) {
            return;
        }
        Computer.pause();
        frame.enforceIntegerRatio();
        Computer.resume();
    }

    public static void toggleDebugPanel() {
        AbstractEmulatorFrame frame = Emulator.getFrame();
        if (frame == null) {
            return;
        }
        frame.setShowDebug(!frame.isShowDebug());
        frame.reconfigure();
        Emulator.resizeVideo();
    }

    public static void toggleFullscreen() {
        AbstractEmulatorFrame frame = Emulator.getFrame();
        if (frame == null) {
            return;
        }
        Computer.pause();
        frame.toggleFullscreen();
        Computer.resume();
    }
}

