/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.Emulator;
import jace.apple2e.MOS65C02;
import jace.apple2e.RAM128k;
import jace.apple2e.SoftSwitches;
import jace.apple2e.VideoDHGR;
import jace.apple2e.VideoNTSC;
import jace.cheat.Cheats;
import jace.config.ClassSelection;
import jace.config.ConfigurableField;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.core.Video;
import jace.hardware.CardDiskII;
import jace.hardware.CardExt80Col;
import jace.hardware.ConsoleProbe;
import jace.hardware.Joystick;
import jace.hardware.massStorage.CardMassStorage;
import java.awt.Graphics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Apple2e
extends Computer {
    static int IRQ_VECTOR = 1010;
    public Motherboard motherboard;
    @ConfigurableField(name="Slot 1", shortName="s1card")
    public ClassSelection card1 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 2", shortName="s2card")
    public ClassSelection card2 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 3", shortName="s3card")
    public ClassSelection card3 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 4", shortName="s4card")
    public ClassSelection card4 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 5", shortName="s5card")
    public ClassSelection card5 = new ClassSelection(Card.class, null);
    @ConfigurableField(name="Slot 6", shortName="s6card")
    public ClassSelection card6 = new ClassSelection(Card.class, CardDiskII.class);
    @ConfigurableField(name="Slot 7", shortName="s7card")
    public ClassSelection card7 = new ClassSelection(Card.class, CardMassStorage.class);
    @ConfigurableField(name="Debug rom", shortName="debugRom", description="Use debugger //e rom")
    public boolean useDebugRom = false;
    @ConfigurableField(name="Console probe", description="Enable console redirection (experimental!)")
    public boolean useConsoleProbe = false;
    private ConsoleProbe probe = new ConsoleProbe();
    @ConfigurableField(name="Helpful hints", shortName="hints")
    public boolean enableHints = true;
    @ConfigurableField(name="Renderer", shortName="video", description="Video rendering implementation")
    public ClassSelection videoRenderer = new ClassSelection(Video.class, VideoNTSC.class);
    @ConfigurableField(name="Aux Ram", shortName="ram", description="Aux ram card")
    public ClassSelection ramCard = new ClassSelection(RAM128k.class, CardExt80Col.class);
    public Joystick joystick1;
    public Joystick joystick2;
    @ConfigurableField(name="Activate Cheats", shortName="cheat", defaultValue="")
    public ClassSelection cheatEngine = new ClassSelection(Cheats.class, null);
    public Cheats activeCheatEngine = null;
    private List<RAMListener> hints = new ArrayList<RAMListener>();

    public Apple2e() {
        try {
            this.reconfigure();
            this.joystick1 = new Joystick(0);
            this.joystick2 = new Joystick(1);
            this.setCpu(new MOS65C02());
            this.reinitMotherboard();
        }
        catch (Throwable t) {
            System.err.println("Unable to initalize virtual machine");
            t.printStackTrace(System.err);
        }
    }

    @Override
    public String getName() {
        return "Computer (Apple //e)";
    }

    private void reinitMotherboard() {
        if (this.motherboard != null && this.motherboard.isRunning()) {
            this.motherboard.suspend();
        }
        this.motherboard = new Motherboard();
        this.motherboard.reconfigure();
        Motherboard.miscDevices.add(this.joystick1);
        Motherboard.miscDevices.add(this.joystick2);
    }

    @Override
    public void coldStart() {
        Computer.pause();
        this.reinitMotherboard();
        this.reboot();
        for (SoftSwitches softSwitches : SoftSwitches.values()) {
            softSwitches.getSwitch().reset();
        }
        this.getMemory().configureActiveMemory();
        this.getVideo().configureVideoMode();
        this.getCpu().reset();
        for (Card card : this.getMemory().getAllCards()) {
            if (card == null) continue;
            card.reset();
        }
        Computer.resume();
    }

    public void reboot() {
        RAM r = this.getMemory();
        r.write(IRQ_VECTOR, (byte)0, false, true);
        r.write(IRQ_VECTOR + 1, (byte)0, false, true);
        r.write(IRQ_VECTOR + 2, (byte)0, false, true);
        this.warmStart();
    }

    @Override
    public void warmStart() {
        boolean restart = Computer.pause();
        for (SoftSwitches softSwitches : SoftSwitches.values()) {
            softSwitches.getSwitch().reset();
        }
        this.getMemory().configureActiveMemory();
        this.getVideo().configureVideoMode();
        this.getCpu().reset();
        for (Card card : this.getMemory().getAllCards()) {
            if (card == null) continue;
            card.reset();
        }
        this.getCpu().resume();
        Computer.resume();
    }

    private void insertCard(Class<? extends Card> type, int slot) {
        if (this.getMemory().getCard(slot) != null) {
            if (this.getMemory().getCard(slot).getClass().equals(type)) {
                return;
            }
            this.getMemory().removeCard(slot);
        }
        if (type != null) {
            try {
                this.getMemory().addCard(type.newInstance(), slot);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void reconfigure() {
        boolean restart;
        block32: {
            restart = Computer.pause();
            RAM128k currentMemory = (RAM128k)this.getMemory();
            if (currentMemory != null && !currentMemory.getClass().equals(this.ramCard.getValue())) {
                try {
                    System.out.println("Attempting to preserve existing memory state");
                    RAM128k newMemory = (RAM128k)((Class)this.ramCard.getValue()).newInstance();
                    newMemory.copyFrom(currentMemory);
                    this.setMemory(newMemory);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (this.getMemory() == null) {
                try {
                    currentMemory = (RAM128k)((Class)this.ramCard.getValue()).newInstance();
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    this.setMemory(currentMemory);
                    for (SoftSwitches s : SoftSwitches.values()) {
                        s.getSwitch().register();
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            currentMemory.reconfigure();
            try {
                if (this.useConsoleProbe) {
                    this.probe.init(this);
                } else {
                    this.probe.shutdown();
                }
                if (this.useDebugRom) {
                    this.loadRom("jace/data/apple2e_debug.rom");
                } else {
                    this.loadRom("jace/data/apple2e.rom");
                }
                if (this.getVideo() == null || this.getVideo().getClass() != this.videoRenderer.getValue()) {
                    Graphics g = null;
                    if (this.getVideo() != null) {
                        this.getVideo().suspend();
                        g = this.getVideo().getScreen();
                    }
                    try {
                        this.setVideo((Video)((Class)this.videoRenderer.getValue()).newInstance());
                        this.getVideo().configureVideoMode();
                        this.getVideo().reconfigure();
                        this.getVideo().setScreen(g);
                        Emulator.resizeVideo();
                        this.getVideo().resume();
                    }
                    catch (InstantiationException ex) {
                        Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.insertCard((Class)this.card1.getValue(), 1);
                this.insertCard((Class)this.card2.getValue(), 2);
                this.insertCard((Class)this.card3.getValue(), 3);
                this.insertCard((Class)this.card4.getValue(), 4);
                this.insertCard((Class)this.card5.getValue(), 5);
                this.insertCard((Class)this.card6.getValue(), 6);
                this.insertCard((Class)this.card7.getValue(), 7);
                if (this.enableHints) {
                    this.enableHints();
                } else {
                    this.disableHints();
                }
                this.getMemory().configureActiveMemory();
                if (this.cheatEngine.getValue() == null) {
                    if (this.activeCheatEngine != null) {
                        this.activeCheatEngine.detach();
                    }
                    this.activeCheatEngine = null;
                    break block32;
                }
                boolean startCheats = true;
                if (this.activeCheatEngine != null) {
                    if (this.activeCheatEngine.getClass().equals(this.cheatEngine.getValue())) {
                        startCheats = false;
                    } else {
                        this.activeCheatEngine.detach();
                        this.activeCheatEngine = null;
                    }
                }
                if (!startCheats) break block32;
                try {
                    this.activeCheatEngine = (Cheats)((Class)this.cheatEngine.getValue()).newInstance();
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.activeCheatEngine.attach();
            }
            catch (IOException ex) {
                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (restart) {
            Computer.resume();
        }
    }

    @Override
    protected void doPause() {
        if (this.motherboard == null) {
            return;
        }
        this.motherboard.pause();
    }

    @Override
    protected void doResume() {
        if (this.motherboard == null) {
            return;
        }
        this.motherboard.resume();
    }

    @Override
    protected boolean isRunning() {
        if (this.motherboard == null) {
            return false;
        }
        return this.motherboard.isRunning() && !this.motherboard.isPaused;
    }

    private void enableHints() {
        if (this.hints.isEmpty()) {
            this.hints.add(new RAMListener(RAMEvent.TYPE.EXECUTE, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

                @Override
                protected void doConfig() {
                    this.setScopeStart(64355);
                }

                @Override
                protected void doEvent(RAMEvent e) {
                    if (Apple2e.this.getCpu().getProgramCounter() != this.getScopeStart()) {
                        return;
                    }
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                                if (Apple2e.this.getCpu().getProgramCounter() >> 8 != 198) {
                                    return;
                                }
                                int row = 2;
                                for (String s : new String[]{"              Welcome to", "         _    __    ___   ____ ", "        | |  / /\\  / / ` | |_  ", "      \\_|_| /_/--\\ \\_\\_, |_|__ ", "", "    Java Apple Computer Emulator", "", "        Presented by BLuRry", "        http://goo.gl/SnzqG", "", "Press F1 to insert disk in Slot 6, D1", "Press F2 to insert disk in Slot 6, D2", "Press F3 to insert HDV or 2MG in slot 7", "Press F4 to open configuration", "Press F5 to run raw binary program", "Press F8 to correct the aspect ratio", "Press F9 to toggle fullscreen", "Press F10 to open/close the debugger", "", "      If metacheat is enabled:", "Press HOME to activate memory heatmap", "Press END to activate metacheat search"}) {
                                    int addr = 1025 + VideoDHGR.calculateTextOffset(row++);
                                    for (char c : s.toCharArray()) {
                                        Apple2e.this.getMemory().write(addr++, (byte)(c | 0x80), false, true);
                                    }
                                }
                                while (Apple2e.this.getCpu().getProgramCounter() >> 8 == 198) {
                                    int x = (int)(Math.random() * 26.0) + 7;
                                    int y = (int)(Math.random() * 4.0) + 3;
                                    int addr = 1024 + VideoDHGR.calculateTextOffset(y) + x;
                                    byte old = Apple2e.this.getMemory().readRaw(addr);
                                    for (char c : "+xX*+".toCharArray()) {
                                        if (Apple2e.this.getCpu().getProgramCounter() >> 8 != 198) break;
                                        Apple2e.this.getMemory().write(addr, (byte)(c | 0x80), true, true);
                                        Thread.sleep(100L);
                                    }
                                    Apple2e.this.getMemory().write(addr, old, true, true);
                                }
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Apple2e.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    });
                    t.setName("Startup Animation");
                    t.start();
                }
            });
        }
        for (RAMListener hint : this.hints) {
            this.getMemory().addListener(hint);
        }
    }

    private void disableHints() {
        for (RAMListener hint : this.hints) {
            this.getMemory().removeListener(hint);
        }
    }

    @Override
    public String getShortName() {
        return "computer";
    }
}

