/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.config.ConfigurableField;
import jace.core.CPU;
import jace.core.Computer;
import jace.core.RAM;
import jace.core.RAMEvent;

public class MOS65C02
extends CPU {
    public static boolean readAddressTriggersEvent = true;
    private static MOS65C02 cpu;
    static int RESET_VECTOR;
    static int INT_VECTOR;
    public int A = 255;
    public int X = 255;
    public int Y = 255;
    public int C = 1;
    public boolean interruptSignalled = false;
    public boolean Z = true;
    public boolean I = true;
    public boolean D = true;
    public boolean B = true;
    public boolean V = true;
    public boolean N = true;
    public int STACK = 255;
    @ConfigurableField(name="BRK on bad opcode", description="If on, unrecognized opcodes will be treated as BRK.  Otherwise, they will be NOP")
    public boolean breakOnBadOpcode = false;
    @ConfigurableField(name="Ext. opcode warnings", description="If on, uses of 65c02 extended opcodes (or undocumented 6502 opcodes -- which will fail) will be logged to stdout for debugging purposes")
    public boolean warnAboutExtendedOpcodes = false;
    private static OPCODE[] opcodes;
    private boolean pageBoundaryPenalty = false;

    private static RAM getMemory() {
        return Computer.getComputer().getMemory();
    }

    @Override
    public void reconfigure() {
    }

    public MOS65C02() {
        cpu = this;
    }

    @Override
    protected void executeOpcode() {
        if (this.interruptSignalled) {
            this.processInterrupt();
        }
        int pc = this.getProgramCounter();
        int op = 0xFF & MOS65C02.getMemory().read(pc, RAMEvent.TYPE.EXECUTE, true, false);
        OPCODE opcode = opcodes[op];
        if (this.isTraceEnabled() || this.isLogEnabled() || this.warnAboutExtendedOpcodes && opcode != null && opcode.isExtendedOpcode) {
            String t = this.getState().toUpperCase() + "  " + Integer.toString(pc, 16) + " : " + this.disassemble();
            if (this.warnAboutExtendedOpcodes && opcode != null && opcode.isExtendedOpcode) {
                System.out.println(">>EXTENDED OPCODE DETECTED " + Integer.toHexString(opcode.code) + "<<");
                System.out.println(t);
                if (this.isLogEnabled()) {
                    this.log(">>EXTENDED OPCODE DETECTED " + Integer.toHexString(opcode.code) + "<<");
                    this.log(t);
                }
            } else {
                if (this.isTraceEnabled()) {
                    System.out.println(t);
                }
                if (this.isLogEnabled()) {
                    this.log(t);
                }
            }
        }
        if (opcode == null) {
            int wait = 0;
            int bytes = 2;
            int n = op & 0xF;
            if (n == 2) {
                wait = 2;
            } else if (n == 3 || n == 7 || n == 11 || n == 15) {
                wait = 1;
                bytes = 1;
            } else if (n == 4) {
                bytes = 2;
                wait = (op & 0xF0) == 64 ? 3 : 4;
            } else if (n == 12) {
                bytes = 3;
                wait = (op & 0xF0) == 80 ? 8 : 4;
            }
            this.incrementProgramCounter(bytes);
            this.addWaitCycles(wait);
            if (this.isLogEnabled() || this.breakOnBadOpcode) {
                System.out.println("Unrecognized opcode " + Integer.toHexString(op) + " at " + Integer.toHexString(pc));
            }
            if (this.isLogEnabled()) {
                this.dumpTrace();
            }
            if (this.breakOnBadOpcode) {
                OPCODE.BRK.execute();
            }
        } else {
            opcode.fetch();
            this.incrementProgramCounter(opcode.getMode().getSize());
            opcode.execute();
            this.addWaitCycles(opcode.getWaitCycles());
        }
    }

    private void setNZ(int value) {
        this.N = (value & 0x80) != 0;
        this.Z = (value & 0xFF) == 0;
    }

    public void pushWord(int val) {
        this.push((byte)(val >> 8));
        this.push((byte)(val & 0xFF));
    }

    public int popWord() {
        return 0xFF & this.pop() | 0xFF00 & this.pop() << 8;
    }

    public void push(byte val) {
        MOS65C02.getMemory().write(256 + this.STACK, val, true, false);
        this.STACK = this.STACK - 1 & 0xFF;
    }

    public byte pop() {
        this.STACK = this.STACK + 1 & 0xFF;
        byte val = MOS65C02.getMemory().read(256 + this.STACK, RAMEvent.TYPE.READ_DATA, true, false);
        return val;
    }

    private byte getStatus() {
        return (byte)((this.N ? 128 : 0) | (this.V ? 64 : 0) | 0x20 | (this.B ? 16 : 0) | (this.D ? 8 : 0) | (this.I ? 4 : 0) | (this.Z ? 2 : 0) | (this.C > 0 ? 1 : 0));
    }

    private void setStatus(byte b) {
        this.N = (b & 0x80) != 0;
        this.V = (b & 0x40) != 0;
        this.D = (b & 8) != 0;
        this.I = (b & 4) != 0;
        this.Z = (b & 2) != 0;
        this.C = (char)(b & 1);
    }

    private void returnFromInterrupt() {
        this.setStatus(this.pop());
        this.setProgramCounter(this.popWord());
    }

    private void waitForInterrupt() {
        this.I = true;
        this.suspend();
    }

    public void BRK() {
        if (this.isLogEnabled()) {
            System.out.println("BRK at $" + Integer.toString(this.getProgramCounter(), 16));
            this.dumpTrace();
        }
        this.B = true;
        this.D = false;
        this.interruptSignalled = true;
    }

    @Override
    public void generateInterrupt() {
        this.B = false;
        this.interruptSignalled = true;
        this.resume();
    }

    private void processInterrupt() {
        if (!this.interruptSignalled) {
            return;
        }
        this.interruptSignalled = false;
        if (!this.I || this.B) {
            this.I = false;
            this.pushWord(this.getProgramCounter());
            this.push(this.getStatus());
            this.I = true;
            int newPC = MOS65C02.getMemory().readWord(INT_VECTOR, RAMEvent.TYPE.READ_DATA, true, false);
            this.setProgramCounter(newPC);
        }
    }

    public int getSTACK() {
        return this.STACK;
    }

    @Override
    public void reset() {
        boolean restart = Computer.pause();
        this.pushWord(this.getProgramCounter());
        this.push(this.getStatus());
        this.B = true;
        this.D = false;
        int newPC = MOS65C02.getMemory().readWord(RESET_VECTOR, RAMEvent.TYPE.READ_DATA, true, false);
        System.out.println("Reset called, setting PC to (" + Integer.toString(RESET_VECTOR, 16) + ") = " + Integer.toString(newPC, 16));
        this.setProgramCounter(newPC);
        if (restart) {
            Computer.resume();
        }
    }

    @Override
    protected String getDeviceName() {
        return "65C02 Processor";
    }

    private static String byte2(int b) {
        String out = Integer.toString(b & 0xFF, 16);
        if (out.length() == 1) {
            return "0" + out;
        }
        return out;
    }

    private static String wordString(int w) {
        String out = Integer.toHexString(w);
        if (out.length() == 1) {
            return "000" + out;
        }
        if (out.length() == 2) {
            return "00" + out;
        }
        if (out.length() == 3) {
            return "0" + out;
        }
        return out;
    }

    public String getState() {
        StringBuilder out = new StringBuilder();
        out.append(MOS65C02.byte2(this.A)).append(" ");
        out.append(MOS65C02.byte2(this.X)).append(" ");
        out.append(MOS65C02.byte2(this.Y)).append(" ");
        out.append("01").append(MOS65C02.byte2(this.STACK)).append(" ");
        out.append(this.getFlags());
        return out.toString();
    }

    public String getFlags() {
        StringBuilder out = new StringBuilder();
        out.append(this.N ? "N" : ".");
        out.append(this.V ? "V" : ".");
        out.append("R");
        out.append(this.B ? "B" : ".");
        out.append(this.D ? "D" : ".");
        out.append(this.I ? "I" : ".");
        out.append(this.Z ? "Z" : ".");
        out.append(this.C != 0 ? "C" : ".");
        return out.toString();
    }

    public String disassemble() {
        int pc = this.getProgramCounter();
        byte op = MOS65C02.getMemory().readRaw(pc);
        OPCODE o = opcodes[op & 0xFF];
        if (o == null) {
            return "???";
        }
        String format = o.getMode().formatMode(pc);
        StringBuilder out = new StringBuilder(o.getCommand().toString());
        out.append(" ").append(format);
        return out.toString();
    }

    private void setPageBoundaryPenalty(boolean b) {
        this.pageBoundaryPenalty = b;
    }

    @Override
    public void pushPC() {
        cpu.pushWord(cpu.getProgramCounter() - 1);
    }

    static {
        RESET_VECTOR = 65532;
        INT_VECTOR = 65534;
        opcodes = new OPCODE[256];
        OPCODE[] arr$ = OPCODE.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            OPCODE o;
            MOS65C02.opcodes[o.getCode()] = o = arr$[i$];
        }
    }

    private static enum COMMAND {
        ADC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int w = 0;
                boolean bl = cpu.V = ((cpu.A ^ value) & 0x80) == 0;
                if (cpu.D) {
                    w = (cpu.A & 0xF) + (value & 0xF) + cpu.C;
                    if (w >= 10) {
                        w = 0x10 | w + 6 & 0xF;
                    }
                    if ((w += (cpu.A & 0xF0) + (value & 0xF0)) >= 160) {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                        w += 96;
                    } else {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                    }
                } else {
                    w = cpu.A + value + cpu.C;
                    if (w >= 256) {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                    } else {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                    }
                }
                cpu.A = w & 0xFF;
                cpu.setNZ(cpu.A);
            }
        }),
        AND(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A &= value;
                cpu.setNZ(cpu.A);
            }
        }),
        ASL(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = (value & 0x80) != 0 ? 1 : 0;
                value = 0xFE & value << 1;
                cpu.setNZ(value);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
            }
        }),
        ASL_A(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = cpu.A >> 7;
                cpu.A = 0xFE & cpu.A << 1;
                cpu.setNZ(cpu.A);
            }
        }),
        BBR0(new BBRCommand(0)),
        BBR1(new BBRCommand(1)),
        BBR2(new BBRCommand(2)),
        BBR3(new BBRCommand(3)),
        BBR4(new BBRCommand(4)),
        BBR5(new BBRCommand(5)),
        BBR6(new BBRCommand(6)),
        BBR7(new BBRCommand(7)),
        BBS0(new BBSCommand(0)),
        BBS1(new BBSCommand(1)),
        BBS2(new BBSCommand(2)),
        BBS3(new BBSCommand(3)),
        BBS4(new BBSCommand(4)),
        BBS5(new BBSCommand(5)),
        BBS6(new BBSCommand(6)),
        BBS7(new BBSCommand(7)),
        BCC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.C == 0) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BCS(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.C != 0) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BEQ(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.Z) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BIT(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int result = cpu.A & value;
                cpu.Z = result == 0;
                boolean bl = cpu.N = (value & 0x80) != 0;
                if (addressMode != MODE.IMMEDIATE) {
                    cpu.V = (value & 0x40) != 0;
                }
            }
        }),
        BMI(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.N) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BNE(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (!cpu.Z) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BPL(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (!cpu.N) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BRA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(address);
                cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 1 : 0);
            }
        }),
        BRK(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.BRK();
            }
        }),
        BVC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (!cpu.V) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BVS(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.V) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        CLC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = 0;
            }
        }),
        CLD(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.D = false;
            }
        }),
        CLI(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.I = false;
                cpu.interruptSignalled = false;
            }
        }),
        CLV(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.V = false;
            }
        }),
        CMP(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int val = cpu.A - value;
                cpu.C = val >= 0 ? 1 : 0;
                cpu.setNZ(val);
            }
        }),
        CPX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int val = cpu.X - value;
                cpu.C = val >= 0 ? 1 : 0;
                cpu.setNZ(val);
            }
        }),
        CPY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int val = cpu.Y - value;
                cpu.C = val >= 0 ? 1 : 0;
                cpu.setNZ(val);
            }
        }),
        DEC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                value = 0xFF & value - 1;
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                cpu.setNZ(value);
            }
        }),
        DEA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & cpu.A - 1;
                cpu.setNZ(cpu.A);
            }
        }),
        DEX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = 0xFF & cpu.X - 1;
                cpu.setNZ(cpu.X);
            }
        }),
        DEY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = 0xFF & cpu.Y - 1;
                cpu.setNZ(cpu.Y);
            }
        }),
        EOR(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & (cpu.A ^ value);
                cpu.setNZ(cpu.A);
            }
        }),
        INC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                value = 0xFF & value + 1;
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                cpu.setNZ(value);
            }
        }),
        INA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & cpu.A + 1;
                cpu.setNZ(cpu.A);
            }
        }),
        INX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = 0xFF & cpu.X + 1;
                cpu.setNZ(cpu.X);
            }
        }),
        INY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = 0xFF & cpu.Y + 1;
                cpu.setNZ(cpu.Y);
            }
        }),
        JMP(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(address);
            }
        }),
        JSR(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.pushWord(cpu.getProgramCounter() - 1);
                cpu.setProgramCounter(address);
            }
        }),
        LDA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = value;
                cpu.setNZ(cpu.A);
            }
        }),
        LDX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = value;
                cpu.setNZ(cpu.X);
            }
        }),
        LDY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = value;
                cpu.setNZ(cpu.Y);
            }
        }),
        LSR(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = value & 1;
                value = value >> 1 & 0x7F;
                cpu.setNZ(value);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
            }
        }),
        LSR_A(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = cpu.A & 1;
                cpu.A = cpu.A >> 1 & 0x7F;
                cpu.setNZ(cpu.A);
            }
        }),
        NOP(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
            }
        }),
        ORA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A |= value;
                cpu.setNZ(cpu.A);
            }
        }),
        PHA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push((byte)cpu.A);
            }
        }),
        PHP(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push(cpu.getStatus());
            }
        }),
        PHX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push((byte)cpu.X);
            }
        }),
        PHY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push((byte)cpu.Y);
            }
        }),
        PLA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & cpu.pop();
                cpu.setNZ(cpu.A);
            }
        }),
        PLP(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setStatus(cpu.pop());
            }
        }),
        PLX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = 0xFF & cpu.pop();
                cpu.setNZ(cpu.X);
            }
        }),
        PLY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = 0xFF & cpu.pop();
                cpu.setNZ(cpu.Y);
            }
        }),
        RMB0(new RMBCommand(0)),
        RMB1(new RMBCommand(1)),
        RMB2(new RMBCommand(2)),
        RMB3(new RMBCommand(3)),
        RMB4(new RMBCommand(4)),
        RMB5(new RMBCommand(5)),
        RMB6(new RMBCommand(6)),
        RMB7(new RMBCommand(7)),
        ROL(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C;
                cpu.C = value >> 7;
                value = 0xFF & (value << 1 | oldC);
                cpu.setNZ(value);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
            }
        }),
        ROL_A(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C;
                cpu.C = cpu.A >> 7;
                cpu.A = 0xFF & (cpu.A << 1 | oldC);
                cpu.setNZ(cpu.A);
            }
        }),
        ROR(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C << 7;
                cpu.C = value & 1;
                value = 0xFF & (value >> 1 | oldC);
                cpu.setNZ(value);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
                MOS65C02.getMemory().write(address, (byte)value, true, false);
            }
        }),
        ROR_A(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C << 7;
                cpu.C = cpu.A & 1;
                cpu.A = 0xFF & (cpu.A >> 1 | oldC);
                cpu.setNZ(cpu.A);
            }
        }),
        RTI(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.returnFromInterrupt();
            }
        }),
        RTS(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(cpu.popWord() + 1);
            }
        }),
        SBC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.V = ((cpu.A ^ value) & 0x80) != 0;
                int w = 0;
                if (cpu.D) {
                    int temp = 15 + (cpu.A & 0xF) - (value & 0xF) + cpu.C;
                    if (temp < 16) {
                        w = 0;
                        temp -= 6;
                    } else {
                        w = 16;
                        temp -= 16;
                    }
                    if ((w += 240 + (cpu.A & 0xF0) - (value & 0xF0)) < 256) {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                        w -= 96;
                    } else {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                    }
                    w += temp;
                } else {
                    w = 255 + cpu.A - value + cpu.C;
                    if (w < 256) {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                    } else {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                    }
                }
                cpu.A = w & 0xFF;
                cpu.setNZ(cpu.A);
            }
        }),
        SEC(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = 1;
            }
        }),
        SED(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.D = true;
            }
        }),
        SEI(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.I = true;
            }
        }),
        SMB0(new SMBCommand(0)),
        SMB1(new SMBCommand(1)),
        SMB2(new SMBCommand(2)),
        SMB3(new SMBCommand(3)),
        SMB4(new SMBCommand(4)),
        SMB5(new SMBCommand(5)),
        SMB6(new SMBCommand(6)),
        SMB7(new SMBCommand(7)),
        STA(true, new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                MOS65C02.getMemory().write(address, (byte)cpu.A, true, false);
            }
        }),
        STP(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.suspend();
            }
        }),
        STX(true, new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                MOS65C02.getMemory().write(address, (byte)cpu.X, true, false);
            }
        }),
        STY(true, new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                MOS65C02.getMemory().write(address, (byte)cpu.Y, true, false);
            }
        }),
        STZ(true, new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                MOS65C02.getMemory().write(address, (byte)0, true, false);
            }
        }),
        TAX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = cpu.A;
                cpu.setNZ(cpu.X);
            }
        }),
        TAY(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = cpu.A;
                cpu.setNZ(cpu.Y);
            }
        }),
        TRB(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = (value & cpu.A) != 0 ? 1 : 0;
                MOS65C02.getMemory().write(address, (byte)(value &= ~cpu.A), true, false);
            }
        }),
        TSB(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = (value & cpu.A) != 0 ? 1 : 0;
                MOS65C02.getMemory().write(address, (byte)(value |= cpu.A), true, false);
            }
        }),
        TSX(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = cpu.STACK;
                cpu.setNZ(cpu.STACK);
            }
        }),
        TXA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = cpu.X;
                cpu.setNZ(cpu.X);
            }
        }),
        TXS(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.STACK = cpu.X;
            }
        }),
        TYA(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = cpu.Y;
                cpu.setNZ(cpu.Y);
            }
        }),
        WAI(new CommandProcessor(){

            @Override
            public void processCommand(int address, int value, MODE addressMode) {
                cpu.waitForInterrupt();
            }
        });

        private CommandProcessor processor;
        private boolean storeOnly;

        public CommandProcessor getProcessor() {
            return this.processor;
        }

        public boolean isStoreOnly() {
            return this.storeOnly;
        }

        private COMMAND(CommandProcessor processor) {
            this(false, processor);
        }

        private COMMAND(boolean storeOnly, CommandProcessor processor) {
            this.storeOnly = storeOnly;
            this.processor = processor;
        }
    }

    private static class SMBCommand
    implements CommandProcessor {
        int bit;

        public SMBCommand(int bit) {
            this.bit = bit;
        }

        @Override
        public void processCommand(int address, int value, MODE addressMode) {
            int mask = 1 << this.bit;
            MOS65C02.getMemory().write(address, (byte)(value |= mask), true, false);
        }
    }

    private static class RMBCommand
    implements CommandProcessor {
        int bit;

        public RMBCommand(int bit) {
            this.bit = bit;
        }

        @Override
        public void processCommand(int address, int value, MODE addressMode) {
            int mask = 0xFF ^ 1 << this.bit;
            MOS65C02.getMemory().write(address, (byte)(value &= mask), true, false);
        }
    }

    private static class BBSCommand
    implements CommandProcessor {
        int bit;

        public BBSCommand(int bit) {
            this.bit = bit;
        }

        @Override
        public void processCommand(int address, int value, MODE addressMode) {
            if ((value >> this.bit & 1) == 0) {
                return;
            }
            if (cpu.C != 0) {
                cpu.setProgramCounter(address);
                cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
            }
        }
    }

    private static class BBRCommand
    implements CommandProcessor {
        int bit;

        public BBRCommand(int bit) {
            this.bit = bit;
        }

        @Override
        public void processCommand(int address, int value, MODE addressMode) {
            if ((value >> this.bit & 1) != 0) {
                return;
            }
            if (cpu.C != 0) {
                cpu.setProgramCounter(address);
                cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
            }
        }
    }

    private static interface CommandProcessor {
        public void processCommand(int var1, int var2, MODE var3);
    }

    private static enum MODE {
        IMPLIED(1, "", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                return -1;
            }
        }),
        RELATIVE(2, "$R", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int pc = cpu.getProgramCounter();
                int address = pc + 2 + MOS65C02.getMemory().read(pc + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                cpu.setPageBoundaryPenalty((address & 0xFF00) != (pc & 0xFF00));
                return address;
            }
        }),
        IMMEDIATE(2, "#$~1", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                return cpu.getProgramCounter() + 1;
            }
        }),
        ZEROPAGE(2, "$~1", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                return MOS65C02.getMemory().read(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false) & 0xFF;
            }
        }),
        ZEROPAGE_X(2, "$~1,X", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                return 0xFF & MOS65C02.getMemory().read(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false) + cpu.X;
            }
        }),
        ZEROPAGE_Y(2, "$~1,Y", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                return 0xFF & MOS65C02.getMemory().read(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false) + cpu.Y;
            }
        }),
        INDIRECT(3, "$(~2~1)", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int address = MOS65C02.getMemory().readWord(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                return MOS65C02.getMemory().readWord(address, RAMEvent.TYPE.READ_DATA, true, false);
            }
        }),
        INDIRECT_X(3, "$(~2~1,X)", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int address = MOS65C02.getMemory().readWord(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false) + cpu.X;
                return MOS65C02.getMemory().readWord(address & 0xFFFF, RAMEvent.TYPE.READ_DATA, true, false);
            }
        }),
        INDIRECT_ZP(2, "$(~1)", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                byte address = MOS65C02.getMemory().read(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                return MOS65C02.getMemory().readWord(address & 0xFF, RAMEvent.TYPE.READ_DATA, true, false);
            }
        }),
        INDIRECT_ZP_X(2, "$(~1,X)", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int address = MOS65C02.getMemory().read(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false) + cpu.X;
                return MOS65C02.getMemory().readWord(address & 0xFF, RAMEvent.TYPE.READ_DATA, true, false);
            }
        }),
        INDIRECT_ZP_Y(2, "$(~1),Y", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int address = 0xFF & MOS65C02.getMemory().read(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                address = MOS65C02.getMemory().readWord(address, RAMEvent.TYPE.READ_DATA, true, false) + cpu.Y;
                if ((address & 0xFF00) > 0) {
                    cpu.addWaitCycles(1);
                }
                return address;
            }
        }),
        ABSOLUTE(3, "$~2~1", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                return MOS65C02.getMemory().readWord(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
            }
        }),
        ABSOLUTE_X(3, "$~2~1,X", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int address2 = MOS65C02.getMemory().readWord(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                int address = 0xFFFF & address2 + cpu.X;
                if ((address & 0xFF00) != (address2 & 0xFF00)) {
                    cpu.addWaitCycles(1);
                }
                return address;
            }
        }),
        ABSOLUTE_Y(3, "$~2~1,Y", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int address2 = MOS65C02.getMemory().readWord(cpu.getProgramCounter() + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                int address = 0xFFFF & address2 + cpu.Y;
                if ((address & 0xFF00) != (address2 & 0xFF00)) {
                    cpu.addWaitCycles(1);
                }
                return address;
            }
        }),
        ZP_REL(2, "$~1,$R", new AddressCalculator(){

            @Override
            public int calculateAddress() {
                int pc = cpu.getProgramCounter();
                int address = pc + 2 + MOS65C02.getMemory().read(pc + 2, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                cpu.setPageBoundaryPenalty((address & 0xFF00) != (pc & 0xFF00));
                return address;
            }

            @Override
            int getValue(boolean isRead) {
                int pc = cpu.getProgramCounter();
                byte address = MOS65C02.getMemory().read(pc + 1, RAMEvent.TYPE.READ_OPERAND, readAddressTriggersEvent, false);
                return MOS65C02.getMemory().read(address, RAMEvent.TYPE.READ_DATA, true, false);
            }
        });

        private int size;
        private AddressCalculator calculator;
        private boolean indirect;
        String f1;
        String f2;
        boolean twoByte = false;
        boolean relative = false;
        boolean implied = true;

        public int getSize() {
            return this.size;
        }

        public int calcAddress() {
            return this.calculator.calculateAddress();
        }

        public boolean isIndirect() {
            return this.indirect;
        }

        private MODE(int size, String fmt, AddressCalculator calc) {
            this.size = size;
            if (fmt.contains("~")) {
                this.f1 = fmt.substring(0, fmt.indexOf(126));
                this.f2 = fmt.substring(fmt.indexOf("~1") + 2);
                if (fmt.contains("~2")) {
                    this.twoByte = true;
                }
                this.implied = false;
            } else if (fmt.contains("R")) {
                this.f1 = fmt.substring(0, fmt.indexOf("R"));
                this.f2 = "";
                this.relative = true;
                this.implied = false;
            }
            this.calculator = calc;
            this.indirect = this.toString().startsWith("INDIRECT");
        }

        public AddressCalculator getCalculator() {
            return this.calculator;
        }

        public String formatMode(int pc) {
            if (this.implied) {
                return "";
            }
            int b1 = 0xFF & MOS65C02.getMemory().readRaw(pc + 1 & 0xFFFF);
            if (this.relative) {
                String R = MOS65C02.wordString(pc + 2 + (byte)b1);
                return this.f1 + R;
            }
            if (this.twoByte) {
                int b2 = 0xFF & MOS65C02.getMemory().readRaw(pc + 2 & 0xFFFF);
                return this.f1 + MOS65C02.byte2(b2) + MOS65C02.byte2(b1) + this.f2;
            }
            return this.f1 + MOS65C02.byte2(b1) + this.f2;
        }
    }

    private static abstract class AddressCalculator {
        private AddressCalculator() {
        }

        abstract int calculateAddress();

        int getValue(boolean isRead) {
            int address = this.calculateAddress();
            return address > -1 ? 0xFF & MOS65C02.getMemory().read(address, RAMEvent.TYPE.READ_DATA, isRead, false) : 0;
        }
    }

    private static enum OPCODE {
        ADC_IMM(105, COMMAND.ADC, MODE.IMMEDIATE, 2),
        ADC_ZP(101, COMMAND.ADC, MODE.ZEROPAGE, 3),
        ADC_ZP_X(117, COMMAND.ADC, MODE.ZEROPAGE_X, 4),
        ADC_AB(109, COMMAND.ADC, MODE.ABSOLUTE, 4),
        ADC_IND_ZP(114, COMMAND.ADC, MODE.INDIRECT_ZP, 5, true),
        ADC_IND_ZP_X(97, COMMAND.ADC, MODE.INDIRECT_ZP_X, 6),
        ADC_AB_X(125, COMMAND.ADC, MODE.ABSOLUTE_X, 4),
        ADC_AB_Y(121, COMMAND.ADC, MODE.ABSOLUTE_Y, 4),
        ADC_IND_ZP_Y(113, COMMAND.ADC, MODE.INDIRECT_ZP_Y, 5),
        AND_IMM(41, COMMAND.AND, MODE.IMMEDIATE, 2),
        AND_ZP(37, COMMAND.AND, MODE.ZEROPAGE, 3),
        AND_ZP_X(53, COMMAND.AND, MODE.ZEROPAGE_X, 4),
        AND_AB(45, COMMAND.AND, MODE.ABSOLUTE, 4),
        AND_IND_ZP(50, COMMAND.AND, MODE.INDIRECT_ZP, 5, true),
        AND_IND_ZP_X(33, COMMAND.AND, MODE.INDIRECT_ZP_X, 6),
        AND_AB_X(61, COMMAND.AND, MODE.ABSOLUTE_X, 4),
        AND_AB_Y(57, COMMAND.AND, MODE.ABSOLUTE_Y, 4),
        AND_IND_ZP_Y(49, COMMAND.AND, MODE.INDIRECT_ZP_Y, 5),
        ASL(10, COMMAND.ASL_A, MODE.IMPLIED, 2),
        ASL_ZP(6, COMMAND.ASL, MODE.ZEROPAGE, 5),
        ASL_ZP_X(22, COMMAND.ASL, MODE.ZEROPAGE_X, 6),
        ASL_AB(14, COMMAND.ASL, MODE.ABSOLUTE, 6),
        ASL_AB_X(30, COMMAND.ASL, MODE.ABSOLUTE_X, 7),
        BCC_REL(144, COMMAND.BCC, MODE.RELATIVE, 2),
        BCS_REL(176, COMMAND.BCS, MODE.RELATIVE, 2),
        BBR0(15, COMMAND.BBR0, MODE.ZP_REL, 5, true),
        BBR1(31, COMMAND.BBR1, MODE.ZP_REL, 5, true),
        BBR2(47, COMMAND.BBR2, MODE.ZP_REL, 5, true),
        BBR3(63, COMMAND.BBR3, MODE.ZP_REL, 5, true),
        BBR4(79, COMMAND.BBR4, MODE.ZP_REL, 5, true),
        BBR5(95, COMMAND.BBR5, MODE.ZP_REL, 5, true),
        BBR6(111, COMMAND.BBR6, MODE.ZP_REL, 5, true),
        BBR7(127, COMMAND.BBR7, MODE.ZP_REL, 5, true),
        BBS0(143, COMMAND.BBS0, MODE.ZP_REL, 5, true),
        BBS1(159, COMMAND.BBS1, MODE.ZP_REL, 5, true),
        BBS2(175, COMMAND.BBS2, MODE.ZP_REL, 5, true),
        BBS3(191, COMMAND.BBS3, MODE.ZP_REL, 5, true),
        BBS4(207, COMMAND.BBS4, MODE.ZP_REL, 5, true),
        BBS5(223, COMMAND.BBS5, MODE.ZP_REL, 5, true),
        BBS6(239, COMMAND.BBS6, MODE.ZP_REL, 5, true),
        BBS7(255, COMMAND.BBS7, MODE.ZP_REL, 5, true),
        BEQ_REL0(240, COMMAND.BEQ, MODE.RELATIVE, 2),
        BIT_IMM(137, COMMAND.BIT, MODE.IMMEDIATE, 3, true),
        BIT_ZP(36, COMMAND.BIT, MODE.ZEROPAGE, 3),
        BIT_ZP_X(52, COMMAND.BIT, MODE.ZEROPAGE_X, 3, true),
        BIT_AB(44, COMMAND.BIT, MODE.ABSOLUTE, 4),
        BIT_AB_X(60, COMMAND.BIT, MODE.ABSOLUTE_X, 4, true),
        BMI_REL(48, COMMAND.BMI, MODE.RELATIVE, 2),
        BNE_REL(208, COMMAND.BNE, MODE.RELATIVE, 2),
        BPL_REL(16, COMMAND.BPL, MODE.RELATIVE, 2),
        BRA_REL(128, COMMAND.BRA, MODE.RELATIVE, 2, true),
        BRK(0, COMMAND.BRK, MODE.IMMEDIATE, 7),
        BVC_REL(80, COMMAND.BVC, MODE.RELATIVE, 2),
        BVS_REL(112, COMMAND.BVS, MODE.RELATIVE, 2),
        CLC(24, COMMAND.CLC, MODE.IMPLIED, 2),
        CLD(216, COMMAND.CLD, MODE.IMPLIED, 2),
        CLI(88, COMMAND.CLI, MODE.IMPLIED, 2),
        CLV(184, COMMAND.CLV, MODE.IMPLIED, 2),
        CMP_IMM(201, COMMAND.CMP, MODE.IMMEDIATE, 2),
        CMP_ZP(197, COMMAND.CMP, MODE.ZEROPAGE, 3),
        CMP_ZP_X(213, COMMAND.CMP, MODE.ZEROPAGE_X, 4),
        CMP_AB(205, COMMAND.CMP, MODE.ABSOLUTE, 4),
        CMP_IND_ZP_X(193, COMMAND.CMP, MODE.INDIRECT_ZP_X, 6),
        CMP_AB_X(221, COMMAND.CMP, MODE.ABSOLUTE_X, 4),
        CMP_AB_Y(217, COMMAND.CMP, MODE.ABSOLUTE_Y, 4),
        CMP_IND_ZP_Y(209, COMMAND.CMP, MODE.INDIRECT_ZP_Y, 5),
        CMP_IND_ZP(210, COMMAND.CMP, MODE.INDIRECT_ZP, 5, true),
        CPX_IMM(224, COMMAND.CPX, MODE.IMMEDIATE, 2),
        CPX_ZP(228, COMMAND.CPX, MODE.ZEROPAGE, 3),
        CPX_AB(236, COMMAND.CPX, MODE.ABSOLUTE, 4),
        CPY_IMM(192, COMMAND.CPY, MODE.IMMEDIATE, 2),
        CPY_ZP(196, COMMAND.CPY, MODE.ZEROPAGE, 3),
        CPY_AB(204, COMMAND.CPY, MODE.ABSOLUTE, 4),
        DEC(58, COMMAND.DEA, MODE.IMPLIED, 2, true),
        DEC_ZP(198, COMMAND.DEC, MODE.ZEROPAGE, 5),
        DEC_ZP_X(214, COMMAND.DEC, MODE.ZEROPAGE_X, 6),
        DEC_AB(206, COMMAND.DEC, MODE.ABSOLUTE, 6),
        DEC_AB_X(222, COMMAND.DEC, MODE.ABSOLUTE_X, 7),
        DEX(202, COMMAND.DEX, MODE.IMPLIED, 2),
        DEY(136, COMMAND.DEY, MODE.IMPLIED, 2),
        EOR_IMM(73, COMMAND.EOR, MODE.IMMEDIATE, 2),
        EOR_ZP(69, COMMAND.EOR, MODE.ZEROPAGE, 3),
        EOR_ZP_X(85, COMMAND.EOR, MODE.ZEROPAGE_X, 4),
        EOR_AB(77, COMMAND.EOR, MODE.ABSOLUTE, 4),
        EOR_IND_ZP(82, COMMAND.EOR, MODE.INDIRECT_ZP, 5, true),
        EOR_IND_ZP_X(65, COMMAND.EOR, MODE.INDIRECT_ZP_X, 6),
        EOR_AB_X(93, COMMAND.EOR, MODE.ABSOLUTE_X, 4),
        EOR_AB_Y(89, COMMAND.EOR, MODE.ABSOLUTE_Y, 4),
        EOR_IND_ZP_Y(81, COMMAND.EOR, MODE.INDIRECT_ZP_Y, 5),
        INC(26, COMMAND.INA, MODE.IMPLIED, 2, true),
        INC_ZP(230, COMMAND.INC, MODE.ZEROPAGE, 5),
        INC_ZP_X(246, COMMAND.INC, MODE.ZEROPAGE_X, 6),
        INC_AB(238, COMMAND.INC, MODE.ABSOLUTE, 6),
        INC_AB_X(254, COMMAND.INC, MODE.ABSOLUTE_X, 7),
        INX(232, COMMAND.INX, MODE.IMPLIED, 2),
        INY(200, COMMAND.INY, MODE.IMPLIED, 2),
        JMP_AB(76, COMMAND.JMP, MODE.ABSOLUTE, 3),
        JMP_IND(108, COMMAND.JMP, MODE.INDIRECT, 5),
        JMP_IND_X(124, COMMAND.JMP, MODE.INDIRECT_X, 6, true),
        JSR_AB(32, COMMAND.JSR, MODE.ABSOLUTE, 6),
        LDA_IMM(169, COMMAND.LDA, MODE.IMMEDIATE, 2),
        LDA_ZP(165, COMMAND.LDA, MODE.ZEROPAGE, 3),
        LDA_ZP_X(181, COMMAND.LDA, MODE.ZEROPAGE_X, 4),
        LDA_AB(173, COMMAND.LDA, MODE.ABSOLUTE, 4),
        LDA_IND_ZP_X(161, COMMAND.LDA, MODE.INDIRECT_ZP_X, 6),
        LDA_AB_X(189, COMMAND.LDA, MODE.ABSOLUTE_X, 4),
        LDA_AB_Y(185, COMMAND.LDA, MODE.ABSOLUTE_Y, 4),
        LDA_IND_ZP_Y(177, COMMAND.LDA, MODE.INDIRECT_ZP_Y, 5),
        LDA_IND_ZP(178, COMMAND.LDA, MODE.INDIRECT_ZP, 5, true),
        LDX_IMM(162, COMMAND.LDX, MODE.IMMEDIATE, 2),
        LDX_ZP(166, COMMAND.LDX, MODE.ZEROPAGE, 3),
        LDX_ZP_Y(182, COMMAND.LDX, MODE.ZEROPAGE_Y, 4),
        LDX_AB(174, COMMAND.LDX, MODE.ABSOLUTE, 4),
        LDX_AB_Y(190, COMMAND.LDX, MODE.ABSOLUTE_Y, 4),
        LDY_IMM(160, COMMAND.LDY, MODE.IMMEDIATE, 2),
        LDY_ZP(164, COMMAND.LDY, MODE.ZEROPAGE, 3),
        LDY_ZP_X(180, COMMAND.LDY, MODE.ZEROPAGE_X, 4),
        LDY_AB(172, COMMAND.LDY, MODE.ABSOLUTE, 4),
        LDY_AB_X(188, COMMAND.LDY, MODE.ABSOLUTE_X, 4),
        LSR(74, COMMAND.LSR_A, MODE.IMPLIED, 2),
        LSR_ZP(70, COMMAND.LSR, MODE.ZEROPAGE, 5),
        LSR_ZP_X(86, COMMAND.LSR, MODE.ZEROPAGE_X, 6),
        LSR_AB(78, COMMAND.LSR, MODE.ABSOLUTE, 6),
        LSR_AB_X(94, COMMAND.LSR, MODE.ABSOLUTE_X, 7),
        NOP(234, COMMAND.NOP, MODE.IMPLIED, 2),
        ORA_IMM(9, COMMAND.ORA, MODE.IMMEDIATE, 2),
        ORA_ZP(5, COMMAND.ORA, MODE.ZEROPAGE, 3),
        ORA_ZP_X(21, COMMAND.ORA, MODE.ZEROPAGE_X, 4),
        ORA_AB(13, COMMAND.ORA, MODE.ABSOLUTE, 4),
        ORA_IND_ZP(18, COMMAND.ORA, MODE.INDIRECT_ZP, 5, true),
        ORA_IND_ZP_X(1, COMMAND.ORA, MODE.INDIRECT_ZP_X, 6),
        ORA_AB_X(29, COMMAND.ORA, MODE.ABSOLUTE_X, 4),
        ORA_AB_Y(25, COMMAND.ORA, MODE.ABSOLUTE_Y, 4),
        ORA_IND_ZP_Y(17, COMMAND.ORA, MODE.INDIRECT_ZP_Y, 5),
        PHA(72, COMMAND.PHA, MODE.IMPLIED, 3),
        PHP(8, COMMAND.PHP, MODE.IMPLIED, 3),
        PHX(218, COMMAND.PHX, MODE.IMPLIED, 3, true),
        PHY(90, COMMAND.PHY, MODE.IMPLIED, 3, true),
        PLA(104, COMMAND.PLA, MODE.IMPLIED, 4),
        PLP(40, COMMAND.PLP, MODE.IMPLIED, 4),
        PLX(250, COMMAND.PLX, MODE.IMPLIED, 4, true),
        PLY(122, COMMAND.PLY, MODE.IMPLIED, 4, true),
        RMB0(7, COMMAND.RMB0, MODE.ZEROPAGE, 5, true),
        RMB1(23, COMMAND.RMB1, MODE.ZEROPAGE, 5, true),
        RMB2(39, COMMAND.RMB2, MODE.ZEROPAGE, 5, true),
        RMB3(55, COMMAND.RMB3, MODE.ZEROPAGE, 5, true),
        RMB4(71, COMMAND.RMB4, MODE.ZEROPAGE, 5, true),
        RMB5(87, COMMAND.RMB5, MODE.ZEROPAGE, 5, true),
        RMB6(103, COMMAND.RMB6, MODE.ZEROPAGE, 5, true),
        RMB7(119, COMMAND.RMB7, MODE.ZEROPAGE, 5, true),
        ROL(42, COMMAND.ROL_A, MODE.IMPLIED, 2),
        ROL_ZP(38, COMMAND.ROL, MODE.ZEROPAGE, 5),
        ROL_ZP_X(54, COMMAND.ROL, MODE.ZEROPAGE_X, 6),
        ROL_AB(46, COMMAND.ROL, MODE.ABSOLUTE, 6),
        ROL_AB_X(62, COMMAND.ROL, MODE.ABSOLUTE_X, 7),
        ROR(106, COMMAND.ROR_A, MODE.IMPLIED, 2),
        ROR_ZP(102, COMMAND.ROR, MODE.ZEROPAGE, 5),
        ROR_ZP_X(118, COMMAND.ROR, MODE.ZEROPAGE_X, 6),
        ROR_AB(110, COMMAND.ROR, MODE.ABSOLUTE, 6),
        ROR_AB_X(126, COMMAND.ROR, MODE.ABSOLUTE_X, 7),
        RTI(64, COMMAND.RTI, MODE.IMPLIED, 6),
        RTS(96, COMMAND.RTS, MODE.IMPLIED, 6),
        SBC_IMM(233, COMMAND.SBC, MODE.IMMEDIATE, 2),
        SBC_ZP(229, COMMAND.SBC, MODE.ZEROPAGE, 3),
        SBC_ZP_X(245, COMMAND.SBC, MODE.ZEROPAGE_X, 4),
        SBC_AB(237, COMMAND.SBC, MODE.ABSOLUTE, 4),
        SBC_IND_ZP(242, COMMAND.SBC, MODE.INDIRECT_ZP, 5, true),
        SBC_IND_ZP_X(225, COMMAND.SBC, MODE.INDIRECT_ZP_X, 6),
        SBC_AB_X(253, COMMAND.SBC, MODE.ABSOLUTE_X, 4),
        SBC_AB_Y(249, COMMAND.SBC, MODE.ABSOLUTE_Y, 4),
        SBC_IND_ZP_Y(241, COMMAND.SBC, MODE.INDIRECT_ZP_Y, 5),
        SEC(56, COMMAND.SEC, MODE.IMPLIED, 2),
        SED(248, COMMAND.SED, MODE.IMPLIED, 2),
        SEI(120, COMMAND.SEI, MODE.IMPLIED, 2),
        SMB0(135, COMMAND.SMB0, MODE.ZEROPAGE, 5, true),
        SMB1(151, COMMAND.SMB1, MODE.ZEROPAGE, 5, true),
        SMB2(167, COMMAND.SMB2, MODE.ZEROPAGE, 5, true),
        SMB3(183, COMMAND.SMB3, MODE.ZEROPAGE, 5, true),
        SMB4(199, COMMAND.SMB4, MODE.ZEROPAGE, 5, true),
        SMB5(215, COMMAND.SMB5, MODE.ZEROPAGE, 5, true),
        SMB6(231, COMMAND.SMB6, MODE.ZEROPAGE, 5, true),
        SMB7(247, COMMAND.SMB7, MODE.ZEROPAGE, 5, true),
        STA_ZP(133, COMMAND.STA, MODE.ZEROPAGE, 3),
        STA_ZP_X(149, COMMAND.STA, MODE.ZEROPAGE_X, 4),
        STA_AB(141, COMMAND.STA, MODE.ABSOLUTE, 4),
        STA_AB_X(157, COMMAND.STA, MODE.ABSOLUTE_X, 5),
        STA_AB_Y(153, COMMAND.STA, MODE.ABSOLUTE_Y, 5),
        STA_IND_ZP(146, COMMAND.STA, MODE.INDIRECT_ZP, 5, true),
        STA_IND_ZP_X(129, COMMAND.STA, MODE.INDIRECT_ZP_X, 6),
        STA_IND_ZP_Y(145, COMMAND.STA, MODE.INDIRECT_ZP_Y, 6),
        STP(219, COMMAND.STP, MODE.IMPLIED, 3, true),
        STX_ZP(134, COMMAND.STX, MODE.ZEROPAGE, 3),
        STX_ZP_Y(150, COMMAND.STX, MODE.ZEROPAGE_Y, 4),
        STX_AB(142, COMMAND.STX, MODE.ABSOLUTE, 4),
        STY_ZP(132, COMMAND.STY, MODE.ZEROPAGE, 3),
        STY_ZP_X(148, COMMAND.STY, MODE.ZEROPAGE_X, 4),
        STY_AB(140, COMMAND.STY, MODE.ABSOLUTE, 4),
        STZ_ZP(100, COMMAND.STZ, MODE.ZEROPAGE, 3, true),
        STZ_ZP_X(116, COMMAND.STZ, MODE.ZEROPAGE_X, 4, true),
        STZ_AB(156, COMMAND.STZ, MODE.ABSOLUTE, 4, true),
        STZ_AB_X(158, COMMAND.STZ, MODE.ABSOLUTE_X, 5, true),
        TAX(170, COMMAND.TAX, MODE.IMPLIED, 2),
        TAY(168, COMMAND.TAY, MODE.IMPLIED, 2),
        TRB_ZP(20, COMMAND.TRB, MODE.ZEROPAGE, 5, true),
        TRB_AB(28, COMMAND.TRB, MODE.ABSOLUTE, 6, true),
        TSB_ZP(4, COMMAND.TSB, MODE.ZEROPAGE, 5, true),
        TSB_AB(12, COMMAND.TSB, MODE.ABSOLUTE, 6, true),
        TSX(186, COMMAND.TSX, MODE.IMPLIED, 2),
        TXA(138, COMMAND.TXA, MODE.IMPLIED, 2),
        TXS(154, COMMAND.TXS, MODE.IMPLIED, 2),
        TYA(152, COMMAND.TYA, MODE.IMPLIED, 2),
        WAI(203, COMMAND.WAI, MODE.IMPLIED, 3, true);

        private int code;
        private boolean isExtendedOpcode;
        private int waitCycles;
        private COMMAND command;
        private MODE addressingMode;
        int address = 0;
        int value = 0;

        public int getCode() {
            return this.code;
        }

        public int getWaitCycles() {
            return this.waitCycles;
        }

        public COMMAND getCommand() {
            return this.command;
        }

        public MODE getMode() {
            return this.addressingMode;
        }

        private void fetch() {
            this.address = this.getMode().calculator.calculateAddress();
            this.value = this.getMode().calculator.getValue(!this.command.isStoreOnly());
        }

        public void execute() {
            this.command.getProcessor().processCommand(this.address, this.value, this.addressingMode);
        }

        private OPCODE(int val, COMMAND c, MODE m, int wait) {
            this(val, c, m, wait, false);
        }

        private OPCODE(int val, COMMAND c, MODE m, int wait, boolean extended) {
            this.code = val;
            this.waitCycles = wait - 1;
            this.command = c;
            this.addressingMode = m;
            this.isExtendedOpcode = extended;
        }
    }
}

