/*
 * Decompiled with CFR 0.152.
 */
package jace.applesoft;

import java.util.ArrayList;
import java.util.List;

public class Command {
    List<ByteOrToken> parts = new ArrayList<ByteOrToken>();

    public String toString() {
        String out = "";
        for (ByteOrToken p : this.parts) {
            out = out + p.toString();
        }
        return out;
    }

    public static class ByteOrToken {
        byte b;
        TOKEN t;
        boolean isToken = false;

        public ByteOrToken(byte b) {
            TOKEN t = TOKEN.fromByte(b);
            if (t != null) {
                this.isToken = true;
                this.t = t;
            } else {
                this.isToken = false;
                this.b = b;
            }
        }

        public String toString() {
            return this.isToken ? " " + this.t.toString() + " " : String.valueOf((char)this.b);
        }
    }

    public static enum TOKEN {
        END(-128, "END"),
        FOR(-127, "FOR"),
        NEXT(-126, "NEXT"),
        DATA(-125, "DATA"),
        INPUT(-124, "INPUT"),
        DEL(-123, "DEL"),
        DIM(-122, "DIM"),
        READ(-121, "READ"),
        GR(-120, "GR"),
        TEXT(-119, "TEXT"),
        PR(-118, "PR#"),
        IN(-117, "IN#"),
        CALL(-116, "CALL"),
        PLOT(-115, "PLOT"),
        HLIN(-114, "HLIN"),
        VLIN(-113, "VLIN"),
        HGR2(-112, "HGR2"),
        HGR(-111, "HGR"),
        HCOLOR(-110, "HCOLOR="),
        HPLOT(-109, "HPLOT"),
        DRAW(-108, "DRAW"),
        XDRAW(-107, "XDRAW"),
        HTAB(-106, "HTAB"),
        HOME(-105, "HOME"),
        ROT(-104, "ROT="),
        SCALE(-103, "SCALE="),
        SHLOAD(-102, "SHLOAD"),
        TRACE(-101, "TRACE"),
        NOTRACE(-100, "NOTRACE"),
        NORMAL(-99, "NORMAL"),
        INVERSE(-98, "INVERSE"),
        FLASH(-97, "FLASH"),
        COLOR(-96, "COLOR="),
        POP(-95, "POP"),
        VTAB(-94, "VTAB"),
        HIMEM(-93, "HIMEM:"),
        LOMEM(-92, "LOMEM:"),
        ONERR(-91, "ONERR"),
        RESUME(-90, "RESUME"),
        RECALL(-89, "RECALL"),
        STORE(-88, "STORE"),
        SPEED(-87, "SPEED="),
        LET(-86, "LET"),
        GOTO(-85, "GOTO"),
        RUN(-84, "RUN"),
        IF(-83, "IF"),
        RESTORE(-82, "RESTORE"),
        AMPERSAND(-81, "&"),
        GOSUB(-80, "GOSUB"),
        RETURN(-79, "RETURN"),
        REM(-78, "REM"),
        STOP(-77, "STOP"),
        ONGOTO(-76, "ON"),
        WAIT(-75, "WAIT"),
        LOAD(-74, "LOAD"),
        SAVE(-73, "SAVE"),
        DEF(-72, "DEF"),
        POKE(-71, "POKE"),
        PRINT(-70, "PRINT"),
        CONT(-69, "CONT"),
        LIST(-68, "LIST"),
        CLEAR(-67, "CLEAR"),
        GET(-66, "GET"),
        NEW(-65, "NEW"),
        TAB(-64, "TAB("),
        TO(-63, "TO"),
        FN(-62, "FN"),
        SPC(-61, "SPC"),
        THEN(-60, "THEN"),
        AT(-59, "AT"),
        NOT(-58, "NOT"),
        STEP(-57, "STEP"),
        PLUS(-56, "+"),
        MINUS(-55, "-"),
        MULTIPLY(-54, "*"),
        DIVIDE(-53, "/"),
        POWER(-52, "^"),
        AND(-51, "AND"),
        OR(-50, "OR"),
        GREATER(-49, ">"),
        EQUAL(-48, "="),
        LESS(-47, "<"),
        SGN(-46, "SGN"),
        INT(-45, "INT"),
        ABS(-44, "ABS"),
        USR(-43, "USR"),
        FRE(-42, "FRE"),
        SCREEN(-41, "SCRN("),
        PDL(-40, "PDL"),
        POS(-39, "POS"),
        SQR(-38, "SQR"),
        RND(-37, "RND"),
        LOG(-36, "LOG"),
        EXP(-35, "EXP"),
        COS(-34, "COS"),
        SIN(-33, "SIN"),
        TAN(-32, "TAN"),
        ATN(-31, "ATN"),
        PEEK(-30, "PEEK"),
        LEN(-29, "LEN"),
        STR(-28, "STR$"),
        VAL(-27, "VAL"),
        ASC(-26, "ASC"),
        CHR(-25, "CHR$"),
        LEFT(-24, "LEFT$"),
        RIGHT(-23, "RIGHT$"),
        MID(-22, "MID$");

        private String str;
        private byte b;

        private TOKEN(byte b, String str) {
            this.b = b;
            this.str = str;
        }

        public String toString() {
            return this.str;
        }

        public static TOKEN fromByte(byte b) {
            for (TOKEN t : TOKEN.values()) {
                if (t.b != b) continue;
                return t;
            }
            return null;
        }
    }
}

