/*
 * Decompiled with CFR 0.152.
 */
package jace.cheat;

import jace.cheat.MemorySpyGrid;
import jace.core.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemorySpy
extends JFrame {
    static MemorySpy singleton = null;
    long lastRefresh = -1L;
    long refreshDelay = 1000L;
    private JPanel controlPanel;
    private JTextField endAddress;
    private JLabel endLabel;
    private JCheckBox fastFadeCheckbox;
    private JRadioButton mapActivityMode;
    private ButtonGroup mapType;
    private JRadioButton mapValueMode;
    private MemorySpyGrid memorySpyGrid;
    private JLabel showLabel;
    private JTextField startAddress;
    private JLabel startLabel;
    public JLabel statusLabel;
    private JButton updateAddressButton;
    private JCheckBox useColorCheckbox;
    private JScrollPane viewScroll;
    private JSlider zoomAmount;
    private JLabel zoomLabel;

    public MemorySpy() {
        this.initComponents();
        this.setDefaultCloseOperation(1);
        singleton = this;
    }

    private void initComponents() {
        this.mapType = new ButtonGroup();
        this.viewScroll = new JScrollPane();
        this.memorySpyGrid = new MemorySpyGrid();
        this.controlPanel = new JPanel();
        this.showLabel = new JLabel();
        this.zoomAmount = new JSlider();
        this.mapActivityMode = new JRadioButton();
        this.mapValueMode = new JRadioButton();
        this.zoomLabel = new JLabel();
        this.startAddress = new JTextField();
        this.startLabel = new JLabel();
        this.endAddress = new JTextField();
        this.statusLabel = new JLabel();
        this.endLabel = new JLabel();
        this.updateAddressButton = new JButton();
        this.useColorCheckbox = new JCheckBox();
        this.fastFadeCheckbox = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MemorySpy.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                MemorySpy.this.formComponentShown(evt);
            }

            @Override
            public void componentHidden(ComponentEvent evt) {
                MemorySpy.this.formComponentHidden(evt);
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
                MemorySpy.this.formAncestorResized(evt);
            }
        });
        this.viewScroll.setPreferredSize(new Dimension(640, 480));
        this.memorySpyGrid.setPreferredSize(new Dimension(580, 480));
        GroupLayout memorySpyGridLayout = new GroupLayout(this.memorySpyGrid);
        this.memorySpyGrid.setLayout(memorySpyGridLayout);
        memorySpyGridLayout.setHorizontalGroup(memorySpyGridLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 631, Short.MAX_VALUE));
        memorySpyGridLayout.setVerticalGroup(memorySpyGridLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 490, Short.MAX_VALUE));
        this.viewScroll.setViewportView(this.memorySpyGrid);
        this.controlPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.showLabel.setText("Show");
        this.zoomAmount.setMaximum(15);
        this.zoomAmount.setMinimum(1);
        this.zoomAmount.setPaintTicks(true);
        this.zoomAmount.setSnapToTicks(true);
        this.zoomAmount.setValue(5);
        this.zoomAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MemorySpy.this.zoomAmountStateChanged(evt);
            }
        });
        this.mapType.add(this.mapActivityMode);
        this.mapActivityMode.setSelected(true);
        this.mapActivityMode.setText("Activity");
        this.mapActivityMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemorySpy.this.mapActivityModeActionPerformed(evt);
            }
        });
        this.mapType.add(this.mapValueMode);
        this.mapValueMode.setText("Value");
        this.mapValueMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemorySpy.this.mapValueModeActionPerformed(evt);
            }
        });
        this.zoomLabel.setText("Zoom");
        this.startAddress.setText("$0000");
        this.startLabel.setText("Start");
        this.endAddress.setText("$FFFF");
        this.statusLabel.setFont(new Font("Courier New", 0, 14));
        this.statusLabel.setText(" ");
        this.statusLabel.setBorder(BorderFactory.createEtchedBorder(0));
        this.endLabel.setText("End");
        this.updateAddressButton.setText("Update");
        this.updateAddressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemorySpy.this.updateAddressButtonActionPerformed(evt);
            }
        });
        this.useColorCheckbox.setText("Color Gradient");
        this.useColorCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemorySpy.this.useColorCheckboxActionPerformed(evt);
            }
        });
        this.fastFadeCheckbox.setText("Fast Fade");
        this.fastFadeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemorySpy.this.fastFadeCheckboxActionPerformed(evt);
            }
        });
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.showLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mapActivityMode).addComponent(this.fastFadeCheckbox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(controlPanelLayout.createSequentialGroup().addComponent(this.mapValueMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.zoomLabel)).addComponent(this.useColorCheckbox)).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(controlPanelLayout.createSequentialGroup().addGap(144, 144, 144).addComponent(this.endLabel)).addGroup(controlPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoomAmount, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.startLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.endAddress, -1, 60, Short.MAX_VALUE).addComponent(this.startAddress)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateAddressButton).addContainerGap(28, Short.MAX_VALUE)).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zoomAmount, -2, 0, Short.MAX_VALUE).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startLabel).addComponent(this.startAddress, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endAddress, -2, -1, -2).addComponent(this.endLabel).addComponent(this.updateAddressButton).addComponent(this.useColorCheckbox).addComponent(this.fastFadeCheckbox))).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mapActivityMode, -2, 22, -2).addComponent(this.showLabel)).addGroup(GroupLayout.Alignment.LEADING, controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zoomLabel).addComponent(this.mapValueMode)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewScroll, -1, 633, Short.MAX_VALUE).addComponent(this.controlPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.viewScroll, -1, 492, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.controlPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void mapActivityModeActionPerformed(ActionEvent evt) {
        this.memorySpyGrid.setDisplayMode(MemorySpyGrid.Modes.ACTIVITY);
    }

    private void mapValueModeActionPerformed(ActionEvent evt) {
        this.memorySpyGrid.setDisplayMode(MemorySpyGrid.Modes.VALUE);
    }

    private void zoomAmountStateChanged(ChangeEvent evt) {
        if (!this.zoomAmount.getValueIsAdjusting()) {
            this.memorySpyGrid.setZoomAmount(this.zoomAmount.getValue());
        }
    }

    private void updateAddressButtonActionPerformed(ActionEvent evt) {
        int startAddr = Utility.parseHexInt(this.startAddress.getText());
        int endAddr = Utility.parseHexInt(this.endAddress.getText());
        if (startAddr < 0 || startAddr > 65535) {
            Utility.gripe("Start address is out of range!");
            return;
        }
        if (endAddr < 0 || endAddr > 65535) {
            Utility.gripe("End address is out of range!");
            return;
        }
        if (startAddr > endAddr) {
            Utility.gripe("Start address must be smaller than end address");
            return;
        }
        this.memorySpyGrid.updateRange(startAddr, endAddr);
    }

    @Override
    public void validate() {
        super.validate();
        this.memorySpyGrid.adjustSize();
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.memorySpyGrid.stopDisplay();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.memorySpyGrid.startDisplay();
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void formAncestorResized(HierarchyEvent evt) {
    }

    private void useColorCheckboxActionPerformed(ActionEvent evt) {
        this.memorySpyGrid.setColorGradient(this.useColorCheckbox.isSelected());
    }

    private void fastFadeCheckboxActionPerformed(ActionEvent evt) {
        this.memorySpyGrid.setFastFade(this.fastFadeCheckbox.isSelected());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MemorySpy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MemorySpy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MemorySpy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MemorySpy.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MemorySpy().setVisible(true);
            }
        });
    }
}

