/*
 * Decompiled with CFR 0.152.
 */
package jace.cheat;

import jace.cheat.MetaCheats;
import jace.core.Utility;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableModel;

public class MetaCheatForm
extends JFrame {
    public JLabel activeCheatsLabel;
    public JScrollPane activeCheatsScroll;
    public JTable activeCheatsTable;
    public JTextField addAddressField;
    public JLabel addAddressLabel;
    public JButton addByteValueButton;
    public JLabel addEndLabel;
    public JTextField addEndNumber;
    public JLabel addNewCheatLabel;
    public JButton addSelected;
    public JLabel addStartLabel;
    public JTextField addStartNumber;
    public JTextField addValueField;
    public JLabel addValueLabel;
    public JLabel addWatchLabel;
    public JButton addWatchesButton;
    public JButton addWordValueButton;
    public JPanel cheatPanel;
    public JButton disableCheatButton;
    public JButton enableCheatButton;
    public JSeparator jSeparator1;
    public JButton removeSelectedButton;
    public JButton resetButton;
    public JScrollPane resultsScroll;
    public JLabel resultsStatusLabel;
    public JTable resultsTable;
    public JButton searchButton;
    public JRadioButton searchForByte;
    public JRadioButton searchForChange;
    public JLabel searchForLabel;
    public JRadioButton searchForValue;
    public JRadioButton searchForWord;
    public JTextField searchNumber;
    public JPanel searchPanel;
    public ButtonGroup searchTypes;
    public JTabbedPane tabs;
    public JLabel valueLabel;
    public ButtonGroup valueTypes;

    public MetaCheatForm() {
        this.initComponents();
        this.setDefaultCloseOperation(1);
    }

    private void initComponents() {
        this.searchTypes = new ButtonGroup();
        this.valueTypes = new ButtonGroup();
        this.tabs = new JTabbedPane();
        this.cheatPanel = new JPanel();
        this.activeCheatsLabel = new JLabel();
        this.activeCheatsScroll = new JScrollPane();
        this.activeCheatsTable = new JTable();
        this.removeSelectedButton = new JButton();
        this.addNewCheatLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.addValueLabel = new JLabel();
        this.addAddressLabel = new JLabel();
        this.addByteValueButton = new JButton();
        this.addWordValueButton = new JButton();
        this.addAddressField = new JTextField();
        this.addValueField = new JTextField();
        this.disableCheatButton = new JButton();
        this.enableCheatButton = new JButton();
        this.searchPanel = new JPanel();
        this.searchForValue = new JRadioButton();
        this.searchForLabel = new JLabel();
        this.searchForChange = new JRadioButton();
        this.searchNumber = new JTextField();
        this.valueLabel = new JLabel();
        this.resetButton = new JButton();
        this.searchButton = new JButton();
        this.resultsStatusLabel = new JLabel();
        this.resultsScroll = new JScrollPane();
        this.resultsTable = new JTable();
        this.addSelected = new JButton();
        this.searchForByte = new JRadioButton();
        this.searchForWord = new JRadioButton();
        this.addWatchLabel = new JLabel();
        this.addStartLabel = new JLabel();
        this.addStartNumber = new JTextField();
        this.addEndNumber = new JTextField();
        this.addEndLabel = new JLabel();
        this.addWatchesButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.activeCheatsLabel.setText("Active Cheats");
        this.activeCheatsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Address", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.activeCheatsScroll.setViewportView(this.activeCheatsTable);
        this.removeSelectedButton.setText("Remove Selected");
        this.removeSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.removeSelectedButtonActionPerformed(evt);
            }
        });
        this.addNewCheatLabel.setText("Add a new cheat:");
        this.addValueLabel.setText("Value");
        this.addAddressLabel.setText("Address");
        this.addByteValueButton.setText("Add Byte Value");
        this.addByteValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.addByteValueButtonActionPerformed(evt);
            }
        });
        this.addWordValueButton.setText("Add Word Value");
        this.addWordValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.addWordValueButtonActionPerformed(evt);
            }
        });
        this.disableCheatButton.setText("Disable Selected");
        this.disableCheatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.disableCheatButtonActionPerformed(evt);
            }
        });
        this.enableCheatButton.setText("Enable Selected");
        this.enableCheatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.enableCheatButtonActionPerformed(evt);
            }
        });
        GroupLayout cheatPanelLayout = new GroupLayout(this.cheatPanel);
        this.cheatPanel.setLayout(cheatPanelLayout);
        cheatPanelLayout.setHorizontalGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cheatPanelLayout.createSequentialGroup().addContainerGap().addGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activeCheatsScroll, -1, 569, Short.MAX_VALUE).addComponent(this.jSeparator1).addGroup(cheatPanelLayout.createSequentialGroup().addGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activeCheatsLabel).addComponent(this.addNewCheatLabel).addGroup(cheatPanelLayout.createSequentialGroup().addComponent(this.addByteValueButton).addGap(18, 18, 18).addComponent(this.addWordValueButton)).addGroup(cheatPanelLayout.createSequentialGroup().addComponent(this.addValueLabel, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addValueField, -2, 79, -2)).addGroup(cheatPanelLayout.createSequentialGroup().addComponent(this.addAddressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addAddressField, -2, 79, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(cheatPanelLayout.createSequentialGroup().addComponent(this.disableCheatButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableCheatButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.removeSelectedButton))).addContainerGap()));
        cheatPanelLayout.setVerticalGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cheatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.activeCheatsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activeCheatsScroll, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeSelectedButton).addComponent(this.disableCheatButton).addComponent(this.enableCheatButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addNewCheatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addAddressLabel).addComponent(this.addAddressField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addValueLabel).addComponent(this.addValueField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(cheatPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addByteValueButton).addComponent(this.addWordValueButton)).addContainerGap()));
        this.tabs.addTab("Cheats", this.cheatPanel);
        this.searchTypes.add(this.searchForValue);
        this.searchForValue.setSelected(true);
        this.searchForValue.setText("Value");
        this.searchForValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.searchForValueActionPerformed(evt);
            }
        });
        this.searchForLabel.setText("Search for:");
        this.searchTypes.add(this.searchForChange);
        this.searchForChange.setText("Change");
        this.searchForChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.searchForChangeActionPerformed(evt);
            }
        });
        this.searchNumber.setText("0");
        this.searchNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.searchNumberActionPerformed(evt);
            }
        });
        this.valueLabel.setText("Value:");
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.resetButtonActionPerformed(evt);
            }
        });
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.searchButtonActionPerformed(evt);
            }
        });
        this.resultsStatusLabel.setText("No results");
        this.resultsStatusLabel.setVerticalAlignment(1);
        this.resultsStatusLabel.setBorder(new SoftBevelBorder(0));
        this.resultsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Address", "Last Search", "Current Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.resultsTable.getTableHeader().setResizingAllowed(false);
        this.resultsScroll.setViewportView(this.resultsTable);
        this.resultsTable.getColumnModel().getColumn(0).setResizable(false);
        this.resultsTable.getColumnModel().getColumn(1).setResizable(false);
        this.resultsTable.getColumnModel().getColumn(2).setResizable(false);
        this.addSelected.setText("Add Selected");
        this.addSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.addSelectedActionPerformed(evt);
            }
        });
        this.valueTypes.add(this.searchForByte);
        this.searchForByte.setSelected(true);
        this.searchForByte.setText("Byte");
        this.valueTypes.add(this.searchForWord);
        this.searchForWord.setText("Word");
        this.addWatchLabel.setText("Add Watches:");
        this.addStartLabel.setText("Start");
        this.addEndLabel.setText("End");
        this.addWatchesButton.setText("Add");
        this.addWatchesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaCheatForm.this.addWatchesButtonActionPerformed(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultsScroll, -1, 569, Short.MAX_VALUE).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.addSelected).addGap(18, 18, 18).addComponent(this.resultsStatusLabel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.searchForLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchForChange).addComponent(this.searchForValue)).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.searchForByte)).addGroup(searchPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.searchForWord)))).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.valueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchNumber, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 158, Short.MAX_VALUE).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addComponent(this.addWatchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addWatchesButton)).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addStartLabel).addComponent(this.addEndLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addEndNumber).addComponent(this.addStartNumber)))))).addContainerGap()));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchForLabel).addComponent(this.searchForValue).addComponent(this.searchForByte)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchForChange).addComponent(this.searchForWord).addComponent(this.addStartLabel).addComponent(this.addStartNumber, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchNumber, -2, -1, -2).addComponent(this.valueLabel).addComponent(this.resetButton).addComponent(this.searchButton).addComponent(this.addEndLabel).addComponent(this.addEndNumber, -2, -1, -2))).addGroup(searchPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addWatchesButton, -2, 24, -2).addComponent(this.addWatchLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsScroll, -1, 194, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addSelected).addComponent(this.resultsStatusLabel)).addContainerGap()));
        this.tabs.addTab("Search", this.searchPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabs).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabs).addContainerGap()));
        this.pack();
    }

    private void searchForValueActionPerformed(ActionEvent evt) {
    }

    private void searchForChangeActionPerformed(ActionEvent evt) {
    }

    private void searchNumberActionPerformed(ActionEvent evt) {
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        MetaCheats.singleton.resetSearch();
        this.resultsStatusLabel.setText("Results cleared.");
    }

    private void addSelectedActionPerformed(ActionEvent evt) {
        ArrayList<Integer> addr = new ArrayList<Integer>(MetaCheats.singleton.results.keySet());
        int val = Utility.parseHexInt(this.searchNumber.getText());
        for (int i : this.resultsTable.getSelectedRows()) {
            if (this.searchForByte.isSelected()) {
                MetaCheats.singleton.addByteCheat((Integer)addr.get(i), val);
                continue;
            }
            MetaCheats.singleton.addWordCheat((Integer)addr.get(i), val);
        }
    }

    private void removeSelectedButtonActionPerformed(ActionEvent evt) {
        HashSet<Integer> remove = new HashSet<Integer>();
        for (int i : this.activeCheatsTable.getSelectedRows()) {
            String s = String.valueOf(this.activeCheatsTable.getModel().getValueAt(i, 0));
            remove.add(Utility.parseHexInt(s));
        }
        Iterator i$ = remove.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            MetaCheats.singleton.removeCheat(i);
        }
    }

    private void addByteValueButtonActionPerformed(ActionEvent evt) {
        try {
            int addr = Utility.parseHexInt(this.addAddressField.getText());
            int val = Utility.parseHexInt(this.addValueField.getText());
            MetaCheats.singleton.addByteCheat(addr, val);
        }
        catch (NullPointerException e) {
            Utility.gripe("Please enure that the address and value fields are correctly filled in.");
        }
    }

    private void addWordValueButtonActionPerformed(ActionEvent evt) {
        try {
            int addr = Utility.parseHexInt(this.addAddressField.getText());
            int val = Utility.parseHexInt(this.addValueField.getText());
            MetaCheats.singleton.addWordCheat(addr, val);
        }
        catch (NullPointerException e) {
            Utility.gripe("Please enure that the address and value fields are correctly filled in.");
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (this.searchForChange.isSelected() == this.searchForValue.isSelected()) {
            Utility.gripe("Please select if you want to search for a fixed value or a delta change");
            return;
        }
        if (this.searchForByte.isSelected() == this.searchForWord.isSelected()) {
            Utility.gripe("Please select if you want to search for a byte or a word value");
            return;
        }
        try {
            int val = Utility.parseHexInt(this.searchNumber.getText());
            MetaCheats.singleton.performSearch(this.searchForChange.isSelected(), this.searchForByte.isSelected(), val);
        }
        catch (NullPointerException e) {
            Utility.gripe("Please enter a value");
        }
    }

    private void disableCheatButtonActionPerformed(ActionEvent evt) {
        for (int i : this.activeCheatsTable.getSelectedRows()) {
            String s = String.valueOf(this.activeCheatsTable.getModel().getValueAt(i, 0));
            MetaCheats.singleton.disableCheat(Utility.parseHexInt(s));
        }
    }

    private void enableCheatButtonActionPerformed(ActionEvent evt) {
        for (int i : this.activeCheatsTable.getSelectedRows()) {
            String s = String.valueOf(this.activeCheatsTable.getModel().getValueAt(i, 0));
            MetaCheats.singleton.enableCheat(Utility.parseHexInt(s));
        }
    }

    private void addWatchesButtonActionPerformed(ActionEvent evt) {
        try {
            int addrStart = Utility.parseHexInt(this.addStartNumber.getText());
            int addrEnd = Utility.parseHexInt(this.addEndNumber.getText());
            if (addrStart > addrEnd) {
                Utility.gripe("Start address must be smaller than end address!");
                return;
            }
            MetaCheats.singleton.addWatches(addrStart, addrEnd);
            this.resultsStatusLabel.setText("Added range to watch list.");
        }
        catch (NullPointerException e) {
            Utility.gripe("Please enure that the start and end fields are correctly filled in.");
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MetaCheatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MetaCheatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MetaCheatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MetaCheatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MetaCheatForm().setVisible(true);
            }
        });
    }
}

