/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.config.DynamicSelection;
import jace.config.Name;
import jace.core.Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassSelection
extends DynamicSelection<Class> {
    Class template = null;

    public ClassSelection(Class supertype, Class defaultValue) {
        super(defaultValue);
        this.template = supertype;
    }

    @Override
    public LinkedHashMap<Class, String> getSelections() {
        LinkedHashMap<Class, String> selections = new LinkedHashMap<Class, String>();
        List<Class> allClasses = Utility.findAllSubclasses(this.template);
        if (!allClasses.contains(null)) {
            allClasses.add(null);
        }
        ArrayList<Map.Entry<Class, String>> values = new ArrayList<Map.Entry<Class, String>>();
        if (this.allowNull()) {
            values.add(new Map.Entry<Class, String>(){

                @Override
                public Class getKey() {
                    return null;
                }

                @Override
                public String getValue() {
                    return "***Empty***";
                }

                @Override
                public String setValue(String v) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            });
        }
        for (final Class clazz : allClasses) {
            Map.Entry<Class, String> entry = new Map.Entry<Class, String>(){

                @Override
                public Class getKey() {
                    return clazz;
                }

                @Override
                public String getValue() {
                    if (clazz == null) {
                        return "**Empty**";
                    }
                    if (clazz.isAnnotationPresent(Name.class)) {
                        return clazz.getAnnotation(Name.class).value();
                    }
                    return clazz.getSimpleName();
                }

                @Override
                public String setValue(String value) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public String toString() {
                    return this.getValue();
                }

                @Override
                public boolean equals(Object obj) {
                    return super.equals(obj) || obj == this.getKey() || this.getKey() != null && this.getKey().equals(obj);
                }
            };
            values.add(entry);
        }
        Collections.sort(values, new Comparator<Map.Entry<? extends Class, String>>(){

            @Override
            public int compare(Map.Entry<? extends Class, String> o1, Map.Entry<? extends Class, String> o2) {
                if (o1.getKey() == null) {
                    return -1;
                }
                if (o2.getKey() == null) {
                    return 1;
                }
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry entry : values) {
            Class key = (Class)entry.getKey();
            selections.put(key, (String)entry.getValue());
        }
        return selections;
    }

    @Override
    public boolean allowNull() {
        return false;
    }

    @Override
    public void setValue(Class value) {
        Class v = value;
        if (v != null && v instanceof String) {
            super.setValueByMatch((String)((Object)v));
            return;
        }
        super.setValue(value);
    }
}

